package com.autonavi.indooroutdoordetectorsdk;

import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.amap.location.g.b.a;
import com.amap.location.g.b.b;
import com.amap.location.g.b.c;
import com.amap.location.g.b.d;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.util.L;
import java.util.List;

/* loaded from: classes.dex */
public class GpsDetector {
    public Configuration mConfiguration;
    public a locationManager = null;
    public Handler mHandler = null;
    public boolean isAvailable = true;
    public boolean isStarted = false;
    public long mGpsLastTime = 0;
    public final b nmeaListener = new b() { // from class: com.autonavi.indooroutdoordetectorsdk.GpsDetector.1
        @Override // com.amap.location.g.b.b
        public void onNmeaReceived(long j, String str) {
            try {
                if (GpsDetector.this.mGpsLastTime == 0) {
                    if (L.isLogging) {
                        L.d("onNmeaReceived, GPS Enabled");
                    }
                    GpsDetector.this.mHandler.sendEmptyMessage(1006);
                }
                GpsDetector.this.mGpsLastTime = System.currentTimeMillis();
                if (!GpsDetector.this.isStarted) {
                    if (L.isLogging) {
                        L.d(Boolean.valueOf(GpsDetector.this.isStarted));
                    }
                } else {
                    String trim = str.trim();
                    if (trim.startsWith("$GPGSA") || trim.startsWith("$GPGSV")) {
                        GeoFenceHelper.logFile("nmea", trim);
                    }
                    JNIWrapper.jniSetNemaData(GpsDetector.this.mGpsLastTime, trim);
                    GpsDetector.this.mHandler.sendEmptyMessage(802);
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    };
    public int mCountSatellite = 0;
    public int mLastCountSatellite = 0;
    public final d statusListener = new d() { // from class: com.autonavi.indooroutdoordetectorsdk.GpsDetector.2
        @Override // com.amap.location.g.b.d
        public void onFirstFix(int i) {
        }

        @Override // com.amap.location.g.b.d
        public void onGpsStatusListener(int i, int i2, float f, List<c> list) {
            try {
                if (GpsDetector.this.mGpsLastTime == 0) {
                    if (L.isLogging) {
                        L.d("onGpsStatusChanged, GPS Enabled");
                    }
                    GpsDetector.this.mHandler.sendEmptyMessage(1006);
                }
                GpsDetector.this.mGpsLastTime = System.currentTimeMillis();
                if (GpsDetector.this.locationManager != null && GpsDetector.this.isStarted) {
                    GpsDetector.this.mCountSatellite = i;
                    if (L.isLogging) {
                        L.d("mCountSatellite=" + GpsDetector.this.mCountSatellite);
                    }
                    if (GpsDetector.this.mLastCountSatellite != GpsDetector.this.mCountSatellite) {
                        GeoFenceHelper.logFile("Satellite:" + GpsDetector.this.mCountSatellite);
                        GpsDetector.this.mLastCountSatellite = GpsDetector.this.mCountSatellite;
                    }
                    GeoFenceHelper.logFile("gpsn", "" + GpsDetector.this.mCountSatellite);
                    JNIWrapper.jniSetGPSState(GpsDetector.this.mGpsLastTime, GpsDetector.this.mCountSatellite, (double) (((float) i) * f));
                    GpsDetector.this.mHandler.sendEmptyMessage(802);
                    return;
                }
                if (L.isLogging) {
                    L.d("locationManager == null, " + GpsDetector.this.isStarted);
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }

        @Override // com.amap.location.g.b.d
        public void onStarted() {
        }

        @Override // com.amap.location.g.b.d
        public void onStopped() {
        }
    };
    public final LocationListener locationListener = new LocationListener() { // from class: com.autonavi.indooroutdoordetectorsdk.GpsDetector.3
        @Override // android.location.LocationListener
        public void onLocationChanged(Location location) {
            try {
                if (GpsDetector.this.mGpsLastTime == 0) {
                    if (L.isLogging) {
                        L.d("on onLocationChanged, GPS Enabled");
                    }
                    GpsDetector.this.mHandler.sendEmptyMessage(1006);
                }
                GpsDetector.this.mGpsLastTime = System.currentTimeMillis();
                if (L.isLogging) {
                    L.d("onLocationChanged");
                }
                if (!GpsDetector.this.isStarted) {
                    if (L.isLogging) {
                        L.d(Boolean.valueOf(GpsDetector.this.isStarted));
                        return;
                    }
                    return;
                }
                GpsDetector.this.mHandler.sendEmptyMessage(802);
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }

        @Override // android.location.LocationListener
        public void onProviderDisabled(String str) {
            if ("gps".equals(str)) {
                if (L.isLogging) {
                    L.d("on GPS_PROVIDER Disabled");
                }
                GpsDetector.this.mHandler.sendEmptyMessage(IndoorOutdoorDetector.MSG_GPS_DISABLED);
            }
        }

        @Override // android.location.LocationListener
        public void onProviderEnabled(String str) {
            if ("gps".equals(str)) {
                if (L.isLogging) {
                    L.d("on GPS_PROVIDER Enabled");
                }
                GpsDetector.this.mHandler.sendEmptyMessage(1006);
            }
        }

        @Override // android.location.LocationListener
        public void onStatusChanged(String str, int i, Bundle bundle) {
        }
    };

    public void initDetect(Configuration configuration) {
        this.mConfiguration = configuration;
        this.mGpsLastTime = 0L;
        this.locationManager = a.a(configuration.context);
    }

    public boolean startDetect() {
        if (L.isLogging) {
            L.d("try to start gps");
        }
        this.isAvailable = this.locationManager.a("gps");
        if (this.isStarted && this.mGpsLastTime != 0 && System.currentTimeMillis() - this.mGpsLastTime > 5000) {
            if (this.isAvailable) {
                if (L.isLogging) {
                    L.d("GPS is no more useable, client should stop pdr.  MSG_GPS_DISABLED");
                }
                this.mHandler.sendEmptyMessage(IndoorOutdoorDetector.MSG_GPS_DISABLED);
            }
            this.isAvailable = false;
            if (L.isLogging) {
                L.d("GPS is timeout!");
            }
        }
        if (this.isAvailable && !this.isStarted) {
            try {
                try {
                    GeoFenceHelper.logFile("GpsStart");
                    JNIWrapper.jniSetFlag(System.currentTimeMillis(), "GpsStart");
                    this.locationManager.a("gps", 1000L, 0.0f, this.locationListener, null);
                    try {
                        if (this.mConfiguration.context.checkPermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid()) != 0) {
                            if (L.isLogging) {
                                L.d("Permssion rejected by user");
                            }
                            return false;
                        }
                    } catch (Exception e) {
                        if (L.isLogging) {
                            L.d((Throwable) e);
                        }
                    }
                    this.locationManager.a(this.statusListener, (Looper) null);
                    this.locationManager.a(this.nmeaListener, (Looper) null);
                    JNIWrapper.jniSetFlag(System.currentTimeMillis(), "GpsStarted");
                    this.isStarted = true;
                    GeoFenceHelper.logFile("GpsStarted");
                    this.mGpsLastTime = 0L;
                } catch (SecurityException unused) {
                    if (L.isLogging) {
                        L.d("Missing Permissions");
                    }
                }
            } catch (Throwable th) {
                this.isAvailable = false;
                this.isStarted = false;
                if (L.isLogging) {
                    L.d("start GPS detector failed.");
                }
                if (L.isLogging) {
                    L.d(th);
                }
            }
        } else if (!this.isAvailable) {
            if (L.isLogging) {
                L.d("GPS is not available");
            }
            return false;
        }
        return this.isStarted;
    }

    public void stopDetect() {
        try {
            if (this.isStarted) {
                GeoFenceHelper.logFile("GpsStop");
                JNIWrapper.jniSetFlag(System.currentTimeMillis(), "GpsStop");
                this.locationManager.a(this.statusListener);
                this.locationManager.a(this.nmeaListener);
                this.locationManager.a(this.locationListener);
            }
        } catch (SecurityException e) {
            if (L.isLogging) {
                L.d("Missing Permissions:" + e);
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        this.isStarted = false;
    }

    public String toString() {
        String str;
        if (!this.isAvailable) {
            return "用户没有打开GPS";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("GPS");
        if (this.isStarted) {
            str = "Running , " + this.mCountSatellite + "个卫星";
        } else {
            str = "未工作";
        }
        sb.append(str);
        return sb.toString();
    }
}
