package com.autonavi.indooroutdoordetectorsdk;

import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.pdr.JniMagCaliResult;
import com.autonavi.indoor.pdr.MatStepData;
import com.autonavi.indoor.pdr.PedProvider;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.PermissionUtil;
import com.autonavi.indooroutdoordetectorsdk.GeoFenceDetector;
import com.autonavi.indooroutdoordetectorsdk.GeoFenceHelper;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;

/* loaded from: classes.dex */
public class IndoorOutdoorDetector {
    public static final int MSG_GPS_DISABLED = 1005;
    public static final int MSG_GPS_ENABLED = 1006;
    public static volatile IndoorOutdoorDetector instance;
    public Handler mWorkingHandler;
    public HandlerThread mWorkingThread;
    public GeoFenceDetector mGeofenceDetector = new GeoFenceDetector();
    public GpsDetector mGPSDetector = new GpsDetector();
    public BuildingLocator mIndoorlocationDetector = new BuildingLocator();
    public LightDetector mLightDetector = new LightDetector();
    public PdrDetector mMagnetDetector = new PdrDetector();
    public final int MSG_DETECT_INIT = 1000;
    public final int MSG_DETECT_START = 1001;
    public final int MSG_DETECT_STOP = 1002;
    public final int MSG_DETECT_OUTDOORLOCATION = 1003;
    public final int MSG_DETECT_INDOORSTATUS = SecExceptionCode.SEC_ERROR_ATLAS_ENC_INCORRECT_DATA_FILE;
    public GeoFenceHelper.TimeStatus mIODetectResult = new GeoFenceHelper.TimeStatus();
    public GeoFenceHelper.TimeStatus mIsIndoorlocateRunning = new GeoFenceHelper.TimeStatus();
    public String mBuildingId = "";
    public Configuration mConfiguration = null;
    public GeoFenceHelper.Coord mLastOutdoorCoord = null;
    public long mLastOutdoorCoordTime = 0;
    public JniSwitchResult mAlgoResult = null;
    public GeoFenceHelper.TimeStatus mAlgoResultTime = new GeoFenceHelper.TimeStatus();
    public JniSwitchResult mLastAlgoResult = null;
    public long mLastAlgoResultTime = 0;
    public boolean isWorking = false;
    public int mLastStep = 0;
    public HashSet<DetectListener> mDetectListeners = new HashSet<>();
    public boolean mIsFirstIndoorLocation = true;
    public boolean mIsInGeoFence = false;
    public IIndoorFeedback mIIndoorFeedback = null;
    public String sensorStatus = null;
    public Handler.Callback mWorkingCallback = new Handler.Callback() { // from class: com.autonavi.indooroutdoordetectorsdk.IndoorOutdoorDetector.1
        @Override // android.os.Handler.Callback
        public boolean handleMessage(Message message) {
            int i;
            try {
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
            if (IndoorOutdoorDetector.instance == null) {
                if (L.isLogging) {
                    L.d("instance==null");
                }
                return false;
            }
            int i2 = message.what;
            if (i2 == 105) {
                JniMagCaliResult jniMagCaliResult = (JniMagCaliResult) message.obj;
                GeoFenceHelper.logFile("magn", "" + jniMagCaliResult.mX + " " + jniMagCaliResult.mY + " " + jniMagCaliResult.mZ);
                JNIWrapper.jniSetMagData(jniMagCaliResult.mTime, jniMagCaliResult.mX, jniMagCaliResult.mY, jniMagCaliResult.mZ);
                IndoorOutdoorDetector.this.mWorkingHandler.sendEmptyMessage(802);
            } else if (i2 == 111) {
                MatStepData matStepData = (MatStepData) message.obj;
                if (matStepData.step_ != IndoorOutdoorDetector.this.mLastStep) {
                    IndoorOutdoorDetector.this.mLastStep = matStepData.step_;
                    if (L.isLogging) {
                        L.d("Step=" + IndoorOutdoorDetector.this.mLastStep);
                    }
                }
                GeoFenceHelper.logFile("pedd", "" + matStepData.step_ + " " + matStepData.angle_);
                JNIWrapper.jniSetPedData(matStepData.timestamp_, matStepData.step_, matStepData.angle_);
            } else if (i2 != 208 && i2 != 210) {
                if (i2 != 508) {
                    if (i2 == 802) {
                        IndoorOutdoorDetector.this.reportAlgoResult();
                    } else if (i2 == 212 || i2 == 213) {
                        if (L.isLogging) {
                            L.d(message);
                        }
                    } else if (i2 != 215 && i2 != 216) {
                        if (i2 == 1201) {
                            IndoorOutdoorDetector.this.mIndoorlocationDetector.mWifiFailed = false;
                        } else if (i2 != 1202) {
                            switch (i2) {
                                case 501:
                                case 502:
                                case 503:
                                    break;
                                case 504:
                                case 505:
                                case MessageCode.MSG_BLE_NO_SCAN /* 506 */:
                                    if (L.isLogging) {
                                        L.d(message);
                                        break;
                                    }
                                    break;
                                default:
                                    switch (i2) {
                                        case 1000:
                                            IndoorOutdoorDetector.this.onInitDetectWorking((Configuration) message.obj);
                                            break;
                                        case 1001:
                                            IndoorOutdoorDetector.this.startDetectWorking();
                                            break;
                                        case 1002:
                                            IndoorOutdoorDetector.this.stopDetectWorking();
                                            break;
                                        case 1003:
                                            Object[] objArr = (Object[]) message.obj;
                                            IndoorOutdoorDetector.this.onSetOutdoorLocation(((Boolean) objArr[0]).booleanValue(), ((Double) objArr[1]).doubleValue(), ((Double) objArr[2]).doubleValue());
                                            break;
                                        case SecExceptionCode.SEC_ERROR_ATLAS_ENC_INCORRECT_DATA_FILE /* 1004 */:
                                            IndoorOutdoorDetector.this.onSetIndoorOutdoorState(((Integer) message.obj).intValue());
                                            break;
                                        case IndoorOutdoorDetector.MSG_GPS_DISABLED /* 1005 */:
                                            if (L.isLogging) {
                                                L.d("mMagnetDetector.startDetect for MSG_GPS_DISABLED");
                                            }
                                            IndoorOutdoorDetector.this.mMagnetDetector.startDetect();
                                            break;
                                        case 1006:
                                            if (L.isLogging) {
                                                L.d("mMagnetDetector.stopDetect for MSG_GPS_ENABLED");
                                            }
                                            IndoorOutdoorDetector.this.mMagnetDetector.stopDetect();
                                            break;
                                    }
                            }
                        }
                        IndoorOutdoorDetector.this.mIndoorlocationDetector.detect((ScanData) message.obj);
                    } else {
                        if (L.isLogging) {
                            L.d(message);
                        }
                        IndoorOutdoorDetector.this.mBuildingId = (String) message.obj;
                    }
                }
                if (L.isLogging) {
                    L.d(message);
                }
                if (L.isLogging) {
                    L.d("WIFI_NO_SCAN, we are goning to start ble");
                }
                IndoorOutdoorDetector.this.mIndoorlocationDetector.mWifiFailed = true;
                if (IndoorOutdoorDetector.this.mIsIndoorlocateRunning.status) {
                    IndoorOutdoorDetector.this.mIsIndoorlocateRunning.changeStatus(IndoorOutdoorDetector.this.mIndoorlocationDetector.startDetect());
                }
            } else {
                BuildingLocationResult buildingLocationResult = (BuildingLocationResult) message.obj;
                IndoorOutdoorDetector.this.setFlag(buildingLocationResult.toString().substring(20));
                if (!MapUtils.isEmpty(buildingLocationResult.bid)) {
                    IndoorOutdoorDetector.this.mBuildingId = buildingLocationResult.bid;
                } else {
                    buildingLocationResult.bid = IndoorOutdoorDetector.this.mBuildingId;
                }
                if (buildingLocationResult.z > -100 && buildingLocationResult.z != 0) {
                    if (buildingLocationResult.d == 1) {
                        IndoorOutdoorDetector.this.mIndoorlocationDetector.mWifiFailed = false;
                    }
                    Iterator<GeoFenceDetector.Building> it = IndoorOutdoorDetector.this.mGeofenceDetector.mNearBuildings.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            i = 0;
                            break;
                        }
                        GeoFenceDetector.Building next = it.next();
                        if (next.buildingId.equals(IndoorOutdoorDetector.this.mBuildingId)) {
                            i = next.support;
                            break;
                        }
                    }
                    int i3 = i & buildingLocationResult.d;
                    if (i3 != 0) {
                        if (!IndoorOutdoorDetector.this.mIODetectResult.status) {
                            if (L.isLogging) {
                                L.d("Got reportIndoor location, sent to client. and stop indoorlocation");
                            }
                            IndoorOutdoorDetector.this.reportIndoor(IndoorOutdoorDetector.this.mBuildingId, buildingLocationResult.d, buildingLocationResult);
                            IndoorOutdoorDetector.this.mIsFirstIndoorLocation = false;
                        } else if (L.isLogging) {
                            L.d("mIODetectResult.status=" + IndoorOutdoorDetector.this.mIODetectResult.status + ", currentTimeMillis=" + System.currentTimeMillis() + ", IndoorLocatingResult.t=" + buildingLocationResult.t + ", diff=" + (System.currentTimeMillis() - buildingLocationResult.t));
                        }
                        IndoorOutdoorDetector.this.mIndoorlocationDetector.stopDetect();
                        IndoorOutdoorDetector.this.mIsIndoorlocateRunning.changeStatus(false);
                    } else {
                        if (L.isLogging) {
                            L.d(Integer.valueOf(i3));
                        }
                        if (L.isLogging) {
                            L.d(buildingLocationResult);
                        }
                    }
                }
            }
            return false;
        }
    };

    /* loaded from: classes.dex */
    public interface DetectListener {
        void detectorStatus(boolean z, String str, int i, BuildingLocationResult buildingLocationResult);
    }

    public IndoorOutdoorDetector() {
        this.mWorkingThread = null;
        this.mWorkingHandler = null;
        HandlerThread handlerThread = new HandlerThread("IndoorOutdoorDetector");
        this.mWorkingThread = handlerThread;
        handlerThread.start();
        this.mWorkingHandler = new Handler(this.mWorkingThread.getLooper(), this.mWorkingCallback);
        PedProvider.getInstance().setSensorHandler(this.mWorkingHandler);
    }

    public static IndoorOutdoorDetector getInstance() {
        if (instance == null) {
            synchronized (IndoorOutdoorDetector.class) {
                if (instance == null) {
                    instance = new IndoorOutdoorDetector();
                }
            }
        }
        return instance;
    }

    public static String getSubVersion() {
        return "20170413";
    }

    public static String getVersion() {
        return "6.9";
    }

    public int getN1() {
        GeoFenceDetector geoFenceDetector = this.mGeofenceDetector;
        if (geoFenceDetector != null) {
            return geoFenceDetector.N1;
        }
        return 10;
    }

    public int getN2() {
        GeoFenceDetector geoFenceDetector = this.mGeofenceDetector;
        if (geoFenceDetector != null) {
            return geoFenceDetector.N2;
        }
        return 30;
    }

    public String getSensorStatus() {
        StringBuilder sb = new StringBuilder();
        try {
            SensorManager sensorManager = (SensorManager) this.mConfiguration.context.getSystemService("sensor");
            String str = "1";
            sb.append(sensorManager.getDefaultSensor(1) != null ? "1" : "0");
            sb.append(",");
            sb.append(sensorManager.getDefaultSensor(9) != null ? "1" : "0");
            sb.append(",");
            sb.append(sensorManager.getDefaultSensor(4) != null ? "1" : "0");
            sb.append(",");
            if (sensorManager.getDefaultSensor(2) == null) {
                str = "0";
            }
            sb.append(str);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d("Can't getSystemService of SENSOR_SERVICE, PED not work!");
            }
            if (L.isLogging) {
                L.d(th);
            }
        }
        return sb.toString();
    }

    public synchronized int initDetect(Configuration configuration) {
        if (this.mWorkingHandler == null) {
            return -1;
        }
        if (!PermissionUtil.hasSelfPermission(configuration.context, PermissionUtil.permissions)) {
            if (L.isLogging) {
                L.d("hasSelfPermission failed");
            }
            return -1;
        }
        this.mWorkingHandler.obtainMessage(1000, configuration).sendToTarget();
        return 0;
    }

    public int onInitDetectWorking(Configuration configuration) {
        if (configuration != null) {
            try {
                if (this.mConfiguration == null) {
                    if (L.isLogging) {
                        L.d("Initialize ioProvider with mConfiguration");
                    }
                    this.mConfiguration = configuration;
                } else if (L.isLogging) {
                    L.d("Try to initialize ioProvider which had already been initialized before. To re-init ioProvider with new mConfiguration call ioProvider.destroy() at first.");
                }
                this.mGeofenceDetector.initDetect(this.mConfiguration);
                this.mGPSDetector.initDetect(this.mConfiguration);
                this.mMagnetDetector.initDetect(this.mConfiguration);
                this.mIndoorlocationDetector.initDetect(this.mConfiguration);
                this.mLightDetector.mHandler = this.mWorkingHandler;
                this.mLightDetector.initDetect(this.mConfiguration);
                this.mIndoorlocationDetector.mHandler = this.mWorkingHandler;
                this.mGPSDetector.mHandler = this.mWorkingHandler;
                this.mMagnetDetector.mHandler = this.mWorkingHandler;
                return 0;
            } catch (Throwable th) {
                if (!L.isLogging) {
                    return 0;
                }
                L.d(th);
                return 0;
            }
        }
        throw new IllegalArgumentException("ioProvider mConfiguration can not be initialized with null");
    }

    public int onSetIndoorOutdoorState(int i) {
        boolean z = this.isWorking;
        if (!z) {
            if (!L.isLogging) {
                return -1;
            }
            L.d(Boolean.valueOf(z));
            return -1;
        }
        setFlag("indoorError:" + i);
        if (this.mGPSDetector.startDetect()) {
            this.mMagnetDetector.stopDetect();
        }
        reportOutdoor();
        return 0;
    }

    public int onSetOutdoorLocation(boolean z, double d, double d2) {
        boolean z2 = this.isWorking;
        if (!z2) {
            if (!L.isLogging) {
                return -1;
            }
            L.d(Boolean.valueOf(z2));
            return -1;
        }
        if (this.mIODetectResult.status) {
            if (L.isLogging) {
                L.d("\tindoors, ignore outdoor NLP result");
            }
            return 0;
        }
        if (z) {
            if (L.isLogging) {
                L.d("wgs84：longitude=" + d + ", latitude=" + d2);
            }
            GeoFenceHelper.Coord transform = GeoFenceHelper.transform((float) d2, (float) d);
            d = transform.longitude;
            d2 = transform.latitude;
        }
        if (L.isLogging) {
            L.d("MarsCoord:longitude=" + d + ", latitude=" + d2);
        }
        boolean z3 = !this.mIODetectResult.status;
        GeoFenceHelper.Coord coord = this.mLastOutdoorCoord;
        boolean z4 = (coord != null && ((double) coord.longitude) == d && ((double) coord.latitude) == d2) ? false : true;
        if (!z4 && System.currentTimeMillis() - this.mLastOutdoorCoordTime < 5000) {
            return 0;
        }
        float f = (float) d;
        float f2 = (float) d2;
        GeoFenceDetector.Building detect = this.mGeofenceDetector.detect(f, f2);
        if (detect == null) {
            if (L.isLogging) {
                L.d("Detect building failed.");
            }
            return 0;
        }
        if (L.isLogging) {
            L.d("dist=" + detect);
        }
        if (z4) {
            setFlag(detect.buildingId + ":" + this.mGeofenceDetector.mNearBuildings.size() + "," + detect.isNearby + "," + detect.isContained + "," + GeoFenceHelper.round(detect.distance, 2) + "," + GeoFenceHelper.round(d, 6) + "," + GeoFenceHelper.round(d2, 6));
        }
        if (detect.isContained) {
            if (L.isLogging) {
                L.d("Step Into building, Start Sensor Light & GPS. isOutdoor:" + z3 + ", IsIndoorlocateRunning:" + this.mIsIndoorlocateRunning.status + ", mIsFirstIndoorLocation:" + this.mIsFirstIndoorLocation);
            }
            this.mLightDetector.startDetect();
            if (!this.mGPSDetector.startDetect()) {
                if (L.isLogging) {
                    L.d("Start GPS failed, going to start Magnetic");
                }
                this.mMagnetDetector.startDetect();
            }
            if (this.mIsFirstIndoorLocation && z3) {
                GeoFenceHelper.TimeStatus timeStatus = this.mIsIndoorlocateRunning;
                if (!timeStatus.status) {
                    timeStatus.changeStatus(this.mIndoorlocationDetector.startDetect());
                    if (L.isLogging) {
                        L.d("Inside Building, Start IndoorLocation : " + this.mIsIndoorlocateRunning);
                    }
                    this.mIsFirstIndoorLocation = false;
                }
            }
            if (this.mIIndoorFeedback != null && !this.mIsInGeoFence) {
                writeSensorStatus(true);
                this.mIsInGeoFence = true;
            }
        } else if (detect.distance > 500.0d) {
            if (L.isLogging) {
                L.d("Current location is far enough from any building, stop sensor: Light, GPS, Magnetic, indoorlocation:" + this.mIsIndoorlocateRunning);
            }
            this.mLightDetector.stopDetect();
            this.mGPSDetector.stopDetect();
            this.mMagnetDetector.stopDetect();
            this.mIndoorlocationDetector.stopDetect();
            GeoFenceHelper.TimeStatus timeStatus2 = this.mIsIndoorlocateRunning;
            if (timeStatus2.status) {
                timeStatus2.changeStatus(false);
            }
            this.mIsFirstIndoorLocation = true;
            if (this.mIIndoorFeedback != null && this.mIsInGeoFence) {
                writeSensorStatus(false);
                this.mIsInGeoFence = false;
            }
        }
        if (this.mGeofenceDetector.mBuildings.size() > 0) {
            this.mLastOutdoorCoord = new GeoFenceHelper.Coord(f, f2);
            this.mLastOutdoorCoordTime = System.currentTimeMillis();
        }
        return 0;
    }

    public int registerListener(DetectListener detectListener) {
        if (detectListener == null) {
            if (!L.isLogging) {
                return -1;
            }
            L.d("registerListener , listener is null");
            return -1;
        }
        synchronized (this) {
            if (L.isLogging) {
                L.d("registerListener:" + this.mDetectListeners.size());
            }
            if (this.mDetectListeners.size() == 0 && this.mWorkingHandler != null) {
                this.mWorkingHandler.sendEmptyMessage(1001);
            }
            this.mDetectListeners.add(detectListener);
        }
        return 0;
    }

    public void reportAlgoResult() {
        if (!this.isWorking) {
            if (L.isLogging) {
                L.d("don't reportAlgoResult cause of IOD stoped");
                return;
            }
            return;
        }
        if (System.currentTimeMillis() - this.mAlgoResultTime.time < 100) {
            return;
        }
        try {
            this.mAlgoResult = JNIWrapper.jniGetSwitchResult();
            if (L.isLogging) {
                L.d(JNIWrapper.jniGetIndoorSwitchDebugString());
            }
            if (this.mLastAlgoResult == null || this.mLastAlgoResult.confidence != this.mAlgoResult.confidence || System.currentTimeMillis() - this.mLastAlgoResultTime >= 5000) {
                if (L.isLogging) {
                    L.d(";" + this.mAlgoResult);
                }
                this.mLastAlgoResultTime = System.currentTimeMillis();
                if (this.mLastAlgoResult == null || this.mLastAlgoResult.confidence != this.mAlgoResult.confidence) {
                    setFlag("Confidence:" + GeoFenceHelper.round(this.mAlgoResult.confidence, 2));
                }
                GeoFenceHelper.logFile("conf", "" + this.mAlgoResult.confidence);
                this.mAlgoResultTime.time = System.currentTimeMillis();
                if (this.mAlgoResult.confidence < 0.0d) {
                    if (L.isLogging) {
                        L.d("Invalide state, try to start GPS/MAG/Locate. IODetectResult = " + this.mIODetectResult + ", IndoorlocateStatus=" + this.mIsIndoorlocateRunning);
                    }
                    if (!this.mGPSDetector.startDetect() && !this.mMagnetDetector.startDetect() && !this.mIODetectResult.status && !this.mIsIndoorlocateRunning.status && this.mIsIndoorlocateRunning.isTimeout(10000L)) {
                        this.mIsIndoorlocateRunning.changeStatus(this.mIndoorlocationDetector.startDetect());
                    }
                } else if (this.mAlgoResult.confidence <= 0.3d) {
                    if (L.isLogging) {
                        L.d("i'm sure you are at indoor. IODetectResult = " + this.mIODetectResult + ", IndoorlocateStatus=" + this.mIsIndoorlocateRunning);
                    }
                    if (this.mGPSDetector.startDetect()) {
                        this.mMagnetDetector.stopDetect();
                    }
                    if (!this.mIODetectResult.status && !this.mIsIndoorlocateRunning.status && this.mIsIndoorlocateRunning.isTimeout(10000L)) {
                        if (L.isLogging) {
                            L.d("Steped into indoor, start GPS & STOP Magnetic & start indoorlocation");
                        }
                        this.mIsIndoorlocateRunning.changeStatus(this.mIndoorlocationDetector.startDetect());
                    }
                } else if (this.mAlgoResult.confidence < 0.5d) {
                    if (L.isLogging) {
                        L.d("not sure where you're, Start GPS & Magnetic, maybe start indoorlocation. IODetectResult = " + this.mIODetectResult + ", IndoorlocateStatus=" + this.mIsIndoorlocateRunning);
                    }
                    this.mGPSDetector.startDetect();
                    if (!this.mMagnetDetector.startDetect() && !this.mIODetectResult.status && !this.mIsIndoorlocateRunning.status && this.mIsIndoorlocateRunning.isTimeout(10000L)) {
                        if (L.isLogging) {
                            L.d("start indoorlocation");
                        }
                        this.mIsIndoorlocateRunning.changeStatus(this.mIndoorlocationDetector.startDetect());
                    }
                } else if (this.mAlgoResult.confidence < 0.7d) {
                    if (L.isLogging) {
                        L.d("pretty not sure where you're, Start GPS & Magnetic, but don't start indoorlocaion");
                    }
                    this.mGPSDetector.startDetect();
                    this.mMagnetDetector.startDetect();
                } else {
                    if (L.isLogging) {
                        L.d("i am sure you're at Outdoor, start GPS, STOP magnetic. IODetectResult = " + this.mIODetectResult + ", IndoorlocateStatus=" + this.mIsIndoorlocateRunning);
                    }
                    if (this.mGPSDetector.startDetect()) {
                        this.mMagnetDetector.stopDetect();
                    }
                    this.mIndoorlocationDetector.stopDetect();
                    if (this.mIsIndoorlocateRunning.status) {
                        this.mIsIndoorlocateRunning.changeStatus(false);
                    }
                    reportOutdoor();
                }
                this.mLastAlgoResult = this.mAlgoResult;
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public void reportIndoor(String str, int i, BuildingLocationResult buildingLocationResult) {
        GeoFenceHelper.TimeStatus timeStatus = this.mIODetectResult;
        if (timeStatus.status || !timeStatus.isTimeout(5000L)) {
            return;
        }
        GeoFenceDetector.Building detect = this.mGeofenceDetector.detect((float) buildingLocationResult.x, (float) buildingLocationResult.y);
        if (L.isLogging) {
            L.d("dist=" + detect);
        }
        if (detect == null || !detect.isContained) {
            return;
        }
        setFlag("didIndoor");
        if (L.isLogging) {
            L.d("reportIndoor: " + this.mIODetectResult);
        }
        this.mIODetectResult.changeStatus(true);
        writeWeight(true);
        synchronized (this) {
            Iterator<DetectListener> it = this.mDetectListeners.iterator();
            while (it.hasNext()) {
                it.next().detectorStatus(true, str, i, buildingLocationResult);
            }
        }
    }

    public void reportOutdoor() {
        GeoFenceHelper.TimeStatus timeStatus = this.mIODetectResult;
        if (timeStatus.status && timeStatus.isTimeout(5000L)) {
            setFlag("didOutdoor");
            if (L.isLogging) {
                L.d("reportOutdoor: " + this.mIODetectResult);
            }
            this.mIODetectResult.changeStatus(false);
            writeWeight(false);
            synchronized (this) {
                Iterator<DetectListener> it = this.mDetectListeners.iterator();
                while (it.hasNext()) {
                    it.next().detectorStatus(false, "", 0, null);
                }
            }
        }
    }

    public void setFlag(String str) {
        try {
            GeoFenceHelper.logFile("scen", str);
            JNIWrapper.jniSetFlag(System.currentTimeMillis(), str);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public void setIndoorFeedback(IIndoorFeedback iIndoorFeedback) {
        this.mIIndoorFeedback = iIndoorFeedback;
    }

    public int setIndoorOutdoorState(int i) {
        Handler handler = this.mWorkingHandler;
        if (handler == null) {
            return 0;
        }
        handler.obtainMessage(SecExceptionCode.SEC_ERROR_ATLAS_ENC_INCORRECT_DATA_FILE, Integer.valueOf(i)).sendToTarget();
        return 0;
    }

    public int setOutdoorLocation(boolean z, double d, double d2) {
        if (L.isLogging) {
            L.d("setOutdoorLocation: wgs84=" + z + ", longitude=" + d + ", latitude=" + d2);
        }
        Handler handler = this.mWorkingHandler;
        if (handler != null) {
            handler.obtainMessage(1003, new Object[]{Boolean.valueOf(z), Double.valueOf(d), Double.valueOf(d2)}).sendToTarget();
        } else if (L.isLogging) {
            L.d("mWorkingHandler == null");
        }
        return 0;
    }

    public int startDetectWorking() {
        if (L.isLogging) {
            L.d("startDetectWorking");
        }
        try {
            JNIWrapper.jniStartIndoorSwitch();
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        setFlag("startDetect");
        this.mIODetectResult.reset();
        this.mLastOutdoorCoord = null;
        this.mLastStep = 0;
        this.mLastOutdoorCoordTime = 0L;
        this.mLastAlgoResult = null;
        this.mLastAlgoResultTime = 0L;
        this.mAlgoResult = null;
        this.mAlgoResultTime.reset();
        this.mIsIndoorlocateRunning.reset();
        this.mBuildingId = "";
        this.mGeofenceDetector.startDetect();
        this.isWorking = true;
        this.mIsFirstIndoorLocation = true;
        this.mIsInGeoFence = false;
        return 0;
    }

    public int stopDetectWorking() {
        if (L.isLogging) {
            L.d("stopDetectWorking");
        }
        this.isWorking = false;
        setFlag("stopDetect");
        this.mMagnetDetector.stopDetect();
        this.mGPSDetector.stopDetect();
        this.mLightDetector.stopDetect();
        this.mIndoorlocationDetector.stopDetect();
        this.mIsIndoorlocateRunning.changeStatus(false);
        try {
            JNIWrapper.jniStopIndoorSwitch();
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        this.mGeofenceDetector.stopDetect();
        this.mIODetectResult.reset();
        this.mLastOutdoorCoord = null;
        this.mLastStep = 0;
        this.mLastOutdoorCoordTime = 0L;
        this.mLastAlgoResult = null;
        this.mLastAlgoResultTime = 0L;
        this.mAlgoResult = null;
        this.mAlgoResultTime.reset();
        this.mIsIndoorlocateRunning.reset();
        this.mBuildingId = "";
        this.mIsInGeoFence = false;
        return 0;
    }

    public String toString() {
        String str;
        try {
            str = JNIWrapper.jniGetIndoorSwitchDebugString();
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
            str = "JNI Error";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        sb2.append("\nIODetectResult:   ");
        sb2.append(this.mIODetectResult.status ? "室内" : "室外");
        sb.append(sb2.toString());
        sb.append("\nGeofence:   " + this.mGeofenceDetector);
        sb.append("\nGPS:        " + this.mGPSDetector);
        sb.append("\n地磁:     " + this.mMagnetDetector + "  LastStep:" + this.mLastStep + "步");
        StringBuilder sb3 = new StringBuilder();
        sb3.append("\n");
        sb3.append(this.mIndoorlocationDetector);
        sb.append(sb3.toString());
        if (this.mIsIndoorlocateRunning.status) {
            sb.append(" Running......");
        } else {
            sb.append(" Stoped!!!!!!");
        }
        sb.append("\nAlgoResult:" + GeoFenceHelper.timeFormat() + "\n");
        JniSwitchResult jniSwitchResult = this.mAlgoResult;
        if (jniSwitchResult == null) {
            sb.append("NULL");
        } else {
            sb.append(jniSwitchResult);
        }
        sb.append("\nAlgoDetail:" + str);
        sb.append("\nLight:" + this.mLightDetector);
        return sb.toString();
    }

    public int unregisterListener(DetectListener detectListener) {
        if (detectListener == null) {
            if (!L.isLogging) {
                return -1;
            }
            L.d("unregisterListener, listener is null");
            return -1;
        }
        synchronized (this) {
            this.mDetectListeners.remove(detectListener);
            if (L.isLogging) {
                L.d("unregisterListener:" + this.mDetectListeners.size());
            }
            if (this.mDetectListeners.size() == 0 && this.mWorkingHandler != null) {
                this.mWorkingHandler.sendEmptyMessage(1002);
            }
        }
        return 0;
    }

    public void writeSensorStatus(boolean z) {
        if (this.mIIndoorFeedback == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.sensorStatus == null) {
            this.sensorStatus = getSensorStatus();
        }
        sb.append(System.currentTimeMillis());
        sb.append(",");
        sb.append(this.mGPSDetector.isAvailable ? "1" : "0");
        sb.append(",");
        sb.append(this.sensorStatus);
        try {
            this.mIIndoorFeedback.reportData(z ? 700001 : 700002, sb.toString().getBytes("UTF-8"));
        } catch (UnsupportedEncodingException unused) {
            this.mIIndoorFeedback.reportData(z ? 700001 : 700002, sb.toString().getBytes());
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
    }

    public void writeWeight(boolean z) {
        if (this.mIIndoorFeedback == null || !JNIWrapper.jniGetSwitchInfo()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis());
        sb.append(",");
        sb.append(JNIWrapper.mMagMsg);
        sb.append(",");
        sb.append(JNIWrapper.mLightMsg);
        sb.append(",");
        sb.append(JNIWrapper.mGpsMsg);
        try {
            this.mIIndoorFeedback.reportData(z ? 700003 : 700004, sb.toString().getBytes("UTF-8"));
        } catch (UnsupportedEncodingException unused) {
            this.mIIndoorFeedback.reportData(z ? 700003 : 700004, sb.toString().getBytes());
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
    }
}
