package com.autonavi.link.transmit.impl;

import android.bluetooth.BluetoothSocket;
import com.autonavi.link.transmit.inter.Connection;

/* loaded from: classes.dex */
public class BluetoothConnection implements Connection {
    public static final int MAX_SEND_BUF = 512;
    public final BluetoothSocket bluetoothSocket;

    public BluetoothConnection(BluetoothSocket bluetoothSocket) {
        this.bluetoothSocket = bluetoothSocket;
    }

    public boolean isConnected() {
        return true;
    }

    public int read(byte[] bArr, int i, int i2) {
        try {
            return this.bluetoothSocket.getInputStream().read(bArr, i, i2);
        } catch (Exception unused) {
            return -1;
        }
    }

    public int write(byte[] bArr, int i, int i2) {
        int i3;
        try {
            if (i2 > 512) {
                int i4 = 0;
                while (true) {
                    i3 = i2 - i4;
                    if (i3 <= 512) {
                        break;
                    }
                    this.bluetoothSocket.getOutputStream().write(bArr, i + i4, 512);
                    i4 += 512;
                    Thread.sleep(2L);
                }
                this.bluetoothSocket.getOutputStream().write(bArr, i + i4, i3);
            } else {
                this.bluetoothSocket.getOutputStream().write(bArr, i, i2);
            }
            return i2;
        } catch (Exception unused) {
            return -1;
        }
    }
}
