package com.autonavi.wireless;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.wireless.security.open.SecException;
import com.alibaba.wireless.security.open.SecurityGuardManager;
import com.alibaba.wireless.security.open.middletier.IUnifiedSecurityComponent;
import com.alibaba.wireless.security.open.middletier.fc.IFCComponent;
import java.net.URLEncoder;
import java.util.HashMap;

/* loaded from: classes.dex */
public class WirelessSDK {
    public static final String KEY_API = "api";
    public static final String KEY_APPKEY = "appkey";
    public static final String KEY_AUTH_CODE = "authCode";
    public static final String KEY_BIZID = "bizId";
    public static final String KEY_DATA = "data";
    public static final String KEY_ENV = "env";
    public static final String KEY_EXTEND_PARAS = "extendParas";
    public static final String KEY_USE_WUA = "useWua";
    public static final String KEY_WUA = "wua";
    public static final String KEY_X_MINI_WUA = "x-mini-wua";
    public static final String KEY_X_SGEXT = "x-sgext";
    public static final String KEY_X_SIGN = "x-sign";
    public static final String KEY_X_T = "x-t";
    public static final String KEY_X_UMT = "x-umt";
    public static final String MTOP_APPKEY = "23256157";
    public static final String TAG = "WirelessSDK";
    public static String bxVersion = "";
    public static IFCComponent gFCComponent;
    public static IUnifiedSecurityComponent gUnifiedSecurityComp;
    public static Context mContext;

    public static boolean init() {
        Log.d(TAG, "WirelessSDK init start");
        boolean z = false;
        if (mContext == null) {
            Log.e(TAG, "WirelessSDK init context is null");
            return false;
        }
        try {
            SecurityGuardManager.getInitializer().initialize(mContext);
            SecurityGuardManager securityGuardManager = SecurityGuardManager.getInstance(mContext);
            gUnifiedSecurityComp = (IUnifiedSecurityComponent) securityGuardManager.getInterface(IUnifiedSecurityComponent.class);
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put(KEY_AUTH_CODE, "");
            gUnifiedSecurityComp.init(hashMap);
            gFCComponent = (IFCComponent) securityGuardManager.getInterface(IFCComponent.class);
            HashMap hashMap2 = new HashMap();
            hashMap2.put(IFCComponent.KEY_LOGIN_MODULE, true);
            gFCComponent.setUp(mContext, hashMap2);
            bxVersion = gFCComponent.getFCPluginVersion();
            z = true;
        } catch (SecException e) {
            e.printStackTrace();
            Log.e(TAG, "init failed and SecException errorCode = " + e.getErrorCode());
        } catch (Exception e2) {
            e2.printStackTrace();
            Log.d(TAG, "WirelessSDK init except: " + e2.getMessage());
        }
        Log.d(TAG, "WirelessSDK init end");
        return z;
    }

    public static void setContext(Context context) {
        mContext = context;
    }

    public static HashMap<String, String> sign(String str, String str2, boolean z, long j) {
        Log.d(TAG, "=> WirelessSDK sign start networktime:" + j);
        HashMap hashMap = new HashMap();
        try {
            if (gUnifiedSecurityComp == null) {
                Log.d(TAG, "please init first");
                return null;
            }
            String valueOf = String.valueOf((j / 1000) / 1000);
            String str3 = "";
            String format = String.format("%s&%s&%s", MTOP_APPKEY, TextUtils.isEmpty(str2) ? "" : MD5Util.getStringMD5(str2), valueOf);
            HashMap<String, Object> hashMap2 = new HashMap<>();
            hashMap2.put(KEY_DATA, format);
            hashMap2.put(KEY_ENV, 0);
            hashMap2.put(KEY_APPKEY, MTOP_APPKEY);
            hashMap2.put(KEY_API, str);
            hashMap2.put(KEY_EXTEND_PARAS, hashMap);
            hashMap2.put(KEY_USE_WUA, Boolean.valueOf(z));
            HashMap<String, String> securityFactors = gUnifiedSecurityComp.getSecurityFactors(hashMap2);
            if (securityFactors != null && !securityFactors.isEmpty()) {
                String str4 = securityFactors.get(KEY_X_SIGN);
                try {
                    str4 = URLEncoder.encode(str4, "UTF-8");
                    securityFactors.put(KEY_X_SIGN, str4);
                } catch (Exception e) {
                    Log.e(TAG, "KEY_X_SIGN encode error, " + e.getMessage() + "; x_sign: " + str4);
                    e.printStackTrace();
                }
                String str5 = securityFactors.get(KEY_X_MINI_WUA);
                try {
                    str5 = URLEncoder.encode(str5, "UTF-8");
                    securityFactors.put(KEY_X_MINI_WUA, str5);
                } catch (Exception e2) {
                    Log.e(TAG, "KEY_X_MINI_WUA encode error, " + e2.getMessage() + "; x_mini_wua: " + str5);
                    e2.printStackTrace();
                }
                String str6 = securityFactors.get(KEY_X_UMT);
                try {
                    str6 = URLEncoder.encode(str6, "UTF-8");
                    securityFactors.put(KEY_X_UMT, str6);
                } catch (Exception e3) {
                    Log.e(TAG, "KEY_X_UMT encode error, " + e3.getMessage() + "; x_umt: " + str6);
                    e3.printStackTrace();
                }
                String str7 = securityFactors.get(KEY_X_SGEXT);
                try {
                    str7 = URLEncoder.encode(str7, "UTF-8");
                    securityFactors.put(KEY_X_SGEXT, str7);
                } catch (Exception e4) {
                    Log.e(TAG, "KEY_X_SGEXT encode error, " + e4.getMessage() + "; x_sgext: " + str7);
                    e4.printStackTrace();
                }
                if (z) {
                    String str8 = securityFactors.get(KEY_WUA);
                    try {
                        str3 = URLEncoder.encode(str8, "UTF-8");
                        try {
                            securityFactors.put(KEY_WUA, str3);
                        } catch (Exception e5) {
                            e = e5;
                            Log.e(TAG, "KEY_WUA encode error, " + e.getMessage() + "; useWua: " + z);
                            e.printStackTrace();
                            Log.d(TAG, String.format("x-sign=%s, x-mini-wua=%s, x-umt=%s, x-sgext=%s, wua=%s", str4, str5, str6, str7, str3));
                            securityFactors.put("x-appkey", MTOP_APPKEY);
                            securityFactors.put("x-bx-version", bxVersion);
                            securityFactors.put("x-pv", "6.3");
                            securityFactors.put(KEY_X_T, valueOf);
                            return securityFactors;
                        }
                    } catch (Exception e6) {
                        e = e6;
                        str3 = str8;
                    }
                }
                Log.d(TAG, String.format("x-sign=%s, x-mini-wua=%s, x-umt=%s, x-sgext=%s, wua=%s", str4, str5, str6, str7, str3));
                securityFactors.put("x-appkey", MTOP_APPKEY);
                securityFactors.put("x-bx-version", bxVersion);
                securityFactors.put("x-pv", "6.3");
                securityFactors.put(KEY_X_T, valueOf);
                return securityFactors;
            }
            Log.e(TAG, "get security factors failed with no output");
            return null;
        } catch (SecException e7) {
            e7.printStackTrace();
            Log.e(TAG, "get sign failed and SecException errorCode = " + e7.getErrorCode());
            Log.d(TAG, "WirelessSDK sign end");
            return null;
        } catch (Exception e8) {
            e8.printStackTrace();
            Log.e(TAG, "get sign failed Exception: " + e8.getMessage());
            Log.d(TAG, "WirelessSDK sign end");
            return null;
        }
    }
}
