package com.dingtalk.mars.comm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import defpackage.sr0;
import defpackage.tr0;
import defpackage.zr0;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

/* loaded from: classes.dex */
public class Alarm extends BroadcastReceiver {
    public static WakerLock a;
    public static Alarm b;
    public static TreeSet<Object[]> c = new TreeSet<>(new b());

    /* loaded from: classes.dex */
    public static class b implements Comparator<Object[]> {
        public b() {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(Object[] objArr, Object[] objArr2) {
            return (int) (((Long) objArr[c.ID.ordinal()]).longValue() - ((Long) objArr2[c.ID.ordinal()]).longValue());
        }
    }

    /* loaded from: classes.dex */
    public enum c {
        ID,
        WAITTIME,
        PENDINGINTENT
    }

    public static boolean a(long j, int i, Context context) {
        try {
            if (!sr0.a().a()) {
                return false;
            }
            long elapsedRealtime = SystemClock.elapsedRealtime();
            if (i < 0) {
                return false;
            }
            if (context == null) {
                context = tr0.a();
            }
            if (context == null) {
                return false;
            }
            synchronized (c) {
                if (a == null) {
                    a = new WakerLock(context);
                    zr0.c("bifrost.Alarm", "start new wakerlock");
                }
                if (b == null) {
                    Alarm alarm = new Alarm();
                    b = alarm;
                    context.registerReceiver(alarm, new IntentFilter("ALARM_ACTION(" + String.valueOf(Process.myPid()) + ")"));
                }
                Iterator<Object[]> it = c.iterator();
                while (it.hasNext()) {
                    if (((Long) it.next()[c.ID.ordinal()]).longValue() == j) {
                        return false;
                    }
                }
                if (i >= 0) {
                    elapsedRealtime += i;
                }
                PendingIntent a2 = a(j, elapsedRealtime, context);
                if (a2 == null) {
                    return false;
                }
                c.add(new Object[]{Long.valueOf(j), Long.valueOf(elapsedRealtime), a2});
                return true;
            }
        } catch (Throwable th) {
            zr0.a("bifrost.Alarm", "start error", th);
            return false;
        }
    }

    private native void onAlarm(long j);

    @Override // android.content.BroadcastReceiver
    public void onReceive(Context context, Intent intent) {
        if (context == null || intent == null) {
            return;
        }
        try {
            Long valueOf = Long.valueOf(intent.getLongExtra("ID", 0L));
            boolean z = false;
            Integer valueOf2 = Integer.valueOf(intent.getIntExtra("PID", 0));
            if (0 == valueOf.longValue() || valueOf2.intValue() == 0 || valueOf2.intValue() != Process.myPid()) {
                return;
            }
            synchronized (c) {
                Iterator<Object[]> it = c.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        break;
                    }
                    if (((Long) it.next()[c.ID.ordinal()]).equals(valueOf)) {
                        it.remove();
                        z = true;
                        break;
                    }
                }
            }
            if (a != null) {
                a.lock(200L);
            }
            if (z) {
                onAlarm(valueOf.longValue());
            }
        } catch (Throwable th) {
            zr0.a("bifrost.Alarm", "onReceive error", th);
        }
    }

    public static boolean a(long j, Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.Alarm", "stop error", th);
            }
        }
        if (context == null) {
            zr0.b("bifrost.Alarm", "context==null");
            return false;
        }
        synchronized (c) {
            if (a == null) {
                a = new WakerLock(context);
                zr0.c("bifrost.Alarm", "stop new wakerlock");
            }
            if (b == null) {
                b = new Alarm();
                context.registerReceiver(b, new IntentFilter());
                zr0.c("bifrost.Alarm", "stop new Alarm");
            }
            Iterator<Object[]> it = c.iterator();
            while (it.hasNext()) {
                Object[] next = it.next();
                if (((Long) next[c.ID.ordinal()]).longValue() == j) {
                    a(context, (PendingIntent) next[c.PENDINGINTENT.ordinal()]);
                    it.remove();
                    return true;
                }
            }
            return false;
        }
    }

    public static PendingIntent a(long j, long j2, Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.Alarm", "setAlarmMgr error", th);
                return null;
            }
        }
        AlarmManager alarmManager = (AlarmManager) context.getSystemService("alarm");
        if (alarmManager == null) {
            zr0.b("bifrost.Alarm", "am == null");
            return null;
        }
        Intent intent = new Intent();
        intent.setAction("ALARM_ACTION(" + String.valueOf(Process.myPid()) + ")");
        intent.putExtra("ID", j);
        intent.putExtra("PID", Process.myPid());
        PendingIntent broadcast = PendingIntent.getBroadcast(context, (int) j, intent, 268435456);
        if (Build.VERSION.SDK_INT < 19) {
            alarmManager.set(2, j2, broadcast);
        } else {
            alarmManager.setExact(2, j2, broadcast);
        }
        return broadcast;
    }

    public static boolean a(Context context, PendingIntent pendingIntent) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.Alarm", "cancelAlarmMgr error", th);
                return false;
            }
        }
        AlarmManager alarmManager = (AlarmManager) context.getSystemService("alarm");
        if (alarmManager == null) {
            zr0.b("bifrost.Alarm", "am == null");
            return false;
        }
        if (pendingIntent == null) {
            zr0.b("bifrost.Alarm", "pendingIntent == null");
            return false;
        }
        alarmManager.cancel(pendingIntent);
        pendingIntent.cancel();
        return true;
    }
}
