package com.dingtalk.mars.comm;

import android.content.Context;
import android.os.PowerManager;
import defpackage.sr0;
import defpackage.tr0;
import defpackage.zr0;

/* loaded from: classes.dex */
public class WakerLock {
    public static final String TAG = "bifrost.WakerLock";
    public PowerManager.WakeLock wakeLock;

    public WakerLock(Context context) {
        this.wakeLock = null;
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a(TAG, "WakerLock error", th);
                return;
            }
        }
        PowerManager.WakeLock newWakeLock = ((PowerManager) context.getSystemService("power")).newWakeLock(1, TAG);
        this.wakeLock = newWakeLock;
        newWakeLock.setReferenceCounted(false);
    }

    public void finalize() throws Throwable {
        unLock();
    }

    public boolean isLocking() {
        PowerManager.WakeLock wakeLock = this.wakeLock;
        if (wakeLock == null) {
            return false;
        }
        return wakeLock.isHeld();
    }

    public void lock(long j) {
        PowerManager.WakeLock wakeLock;
        if (sr0.a().c() && (wakeLock = this.wakeLock) != null) {
            wakeLock.acquire(j);
        }
    }

    public void unLock() {
        PowerManager.WakeLock wakeLock = this.wakeLock;
        if (wakeLock != null && wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    public void lock() {
        PowerManager.WakeLock wakeLock;
        if (sr0.a().c() && (wakeLock = this.wakeLock) != null) {
            wakeLock.acquire();
        }
    }
}
