package com.google.android.flexbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import defpackage.as0;
import defpackage.bs0;
import defpackage.cs0;
import defpackage.es0;
import defpackage.q9;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/* loaded from: classes.dex */
public class FlexboxLayout extends ViewGroup implements as0 {
    public int a;
    public int c;
    public int d;
    public int e;
    public int f;
    public int g;
    public Drawable h;
    public Drawable i;
    public int j;
    public int k;
    public int l;
    public int m;
    public int[] n;
    public SparseIntArray o;
    public cs0 p;
    public List<bs0> q;
    public cs0.b r;

    /* loaded from: classes.dex */
    public static class LayoutParams extends ViewGroup.MarginLayoutParams implements FlexItem {
        public static final Parcelable.Creator<LayoutParams> CREATOR = new a();
        public int a;
        public float c;
        public float d;
        public int e;
        public float f;
        public int g;
        public int h;
        public int i;
        public int j;
        public boolean k;

        /* loaded from: classes.dex */
        public class a implements Parcelable.Creator<LayoutParams> {
            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public LayoutParams createFromParcel(Parcel parcel) {
                return new LayoutParams(parcel);
            }

            /* JADX WARN: Can't rename method to resolve collision */
            @Override // android.os.Parcelable.Creator
            public LayoutParams[] newArray(int i) {
                return new LayoutParams[i];
            }
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, es0.FlexboxLayout_Layout);
            this.a = obtainStyledAttributes.getInt(es0.FlexboxLayout_Layout_layout_order, 1);
            this.c = obtainStyledAttributes.getFloat(es0.FlexboxLayout_Layout_layout_flexGrow, 0.0f);
            this.d = obtainStyledAttributes.getFloat(es0.FlexboxLayout_Layout_layout_flexShrink, 1.0f);
            this.e = obtainStyledAttributes.getInt(es0.FlexboxLayout_Layout_layout_alignSelf, -1);
            this.f = obtainStyledAttributes.getFraction(es0.FlexboxLayout_Layout_layout_flexBasisPercent, 1, 1, -1.0f);
            this.g = obtainStyledAttributes.getDimensionPixelSize(es0.FlexboxLayout_Layout_layout_minWidth, -1);
            this.h = obtainStyledAttributes.getDimensionPixelSize(es0.FlexboxLayout_Layout_layout_minHeight, -1);
            this.i = obtainStyledAttributes.getDimensionPixelSize(es0.FlexboxLayout_Layout_layout_maxWidth, 16777215);
            this.j = obtainStyledAttributes.getDimensionPixelSize(es0.FlexboxLayout_Layout_layout_maxHeight, 16777215);
            this.k = obtainStyledAttributes.getBoolean(es0.FlexboxLayout_Layout_layout_wrapBefore, false);
            obtainStyledAttributes.recycle();
        }

        @Override // com.google.android.flexbox.FlexItem
        public float a() {
            return this.c;
        }

        @Override // com.google.android.flexbox.FlexItem
        public void b(int i) {
            this.g = i;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int c() {
            return this.e;
        }

        @Override // com.google.android.flexbox.FlexItem
        public float d() {
            return this.d;
        }

        @Override // android.os.Parcelable
        public int describeContents() {
            return 0;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int e() {
            return ((ViewGroup.MarginLayoutParams) this).rightMargin;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int f() {
            return this.h;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int g() {
            return this.g;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int getHeight() {
            return ((ViewGroup.MarginLayoutParams) this).height;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int getOrder() {
            return this.a;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int getWidth() {
            return ((ViewGroup.MarginLayoutParams) this).width;
        }

        @Override // com.google.android.flexbox.FlexItem
        public boolean h() {
            return this.k;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int i() {
            return this.j;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int j() {
            return ((ViewGroup.MarginLayoutParams) this).bottomMargin;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int k() {
            return ((ViewGroup.MarginLayoutParams) this).leftMargin;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int l() {
            return this.i;
        }

        @Override // com.google.android.flexbox.FlexItem
        public int m() {
            return ((ViewGroup.MarginLayoutParams) this).topMargin;
        }

        @Override // android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.a);
            parcel.writeFloat(this.c);
            parcel.writeFloat(this.d);
            parcel.writeInt(this.e);
            parcel.writeFloat(this.f);
            parcel.writeInt(this.g);
            parcel.writeInt(this.h);
            parcel.writeInt(this.i);
            parcel.writeInt(this.j);
            parcel.writeByte(this.k ? (byte) 1 : (byte) 0);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).bottomMargin);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).leftMargin);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).rightMargin);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).topMargin);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).height);
            parcel.writeInt(((ViewGroup.MarginLayoutParams) this).width);
        }

        @Override // com.google.android.flexbox.FlexItem
        public void a(int i) {
            this.h = i;
        }

        @Override // com.google.android.flexbox.FlexItem
        public float b() {
            return this.f;
        }

        public void c(int i) {
            this.e = i;
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams) layoutParams);
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
            this.a = layoutParams.a;
            this.c = layoutParams.c;
            this.d = layoutParams.d;
            this.e = layoutParams.e;
            this.f = layoutParams.f;
            this.g = layoutParams.g;
            this.h = layoutParams.h;
            this.i = layoutParams.i;
            this.j = layoutParams.j;
            this.k = layoutParams.k;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
        }

        public LayoutParams(int i, int i2) {
            super(new ViewGroup.LayoutParams(i, i2));
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
        }

        public LayoutParams(Parcel parcel) {
            super(0, 0);
            this.a = 1;
            this.c = 0.0f;
            this.d = 1.0f;
            this.e = -1;
            this.f = -1.0f;
            this.g = -1;
            this.h = -1;
            this.i = 16777215;
            this.j = 16777215;
            this.a = parcel.readInt();
            this.c = parcel.readFloat();
            this.d = parcel.readFloat();
            this.e = parcel.readInt();
            this.f = parcel.readFloat();
            this.g = parcel.readInt();
            this.h = parcel.readInt();
            this.i = parcel.readInt();
            this.j = parcel.readInt();
            this.k = parcel.readByte() != 0;
            ((ViewGroup.MarginLayoutParams) this).bottomMargin = parcel.readInt();
            ((ViewGroup.MarginLayoutParams) this).leftMargin = parcel.readInt();
            ((ViewGroup.MarginLayoutParams) this).rightMargin = parcel.readInt();
            ((ViewGroup.MarginLayoutParams) this).topMargin = parcel.readInt();
            ((ViewGroup.MarginLayoutParams) this).height = parcel.readInt();
            ((ViewGroup.MarginLayoutParams) this).width = parcel.readInt();
        }
    }

    public FlexboxLayout(Context context) {
        this(context, null);
    }

    @Override // defpackage.as0
    public int a(View view) {
        return 0;
    }

    @Override // defpackage.as0
    public View a(int i) {
        return getChildAt(i);
    }

    @Override // defpackage.as0
    public void a(int i, View view) {
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        if (this.o == null) {
            this.o = new SparseIntArray(getChildCount());
        }
        this.n = this.p.a(view, i, layoutParams, this.o);
        super.addView(view, i, layoutParams);
    }

    @Override // defpackage.as0
    public View b(int i) {
        return d(i);
    }

    public final void c(int i, int i2) {
        this.q.clear();
        this.r.a();
        this.p.a(this.r, i, i2);
        this.q = this.r.a;
        this.p.a(i, i2);
        if (this.e == 3) {
            for (bs0 bs0Var : this.q) {
                int i3 = Integer.MIN_VALUE;
                for (int i4 = 0; i4 < bs0Var.h; i4++) {
                    View d = d(bs0Var.o + i4);
                    if (d != null && d.getVisibility() != 8) {
                        LayoutParams layoutParams = (LayoutParams) d.getLayoutParams();
                        if (this.c != 2) {
                            i3 = Math.max(i3, d.getMeasuredHeight() + Math.max(bs0Var.l - d.getBaseline(), ((ViewGroup.MarginLayoutParams) layoutParams).topMargin) + ((ViewGroup.MarginLayoutParams) layoutParams).bottomMargin);
                        } else {
                            i3 = Math.max(i3, d.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) layoutParams).topMargin + Math.max((bs0Var.l - d.getMeasuredHeight()) + d.getBaseline(), ((ViewGroup.MarginLayoutParams) layoutParams).bottomMargin));
                        }
                    }
                }
                bs0Var.g = i3;
            }
        }
        this.p.a(i, i2, getPaddingTop() + getPaddingBottom());
        this.p.a();
        a(this.a, i, i2, this.r.b);
    }

    @Override // android.view.ViewGroup
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public View d(int i) {
        if (i < 0) {
            return null;
        }
        int[] iArr = this.n;
        if (i >= iArr.length) {
            return null;
        }
        return getChildAt(iArr[i]);
    }

    public final boolean e(int i) {
        if (i < 0 || i >= this.q.size()) {
            return false;
        }
        return c(i) ? a() ? (this.j & 1) != 0 : (this.k & 1) != 0 : a() ? (this.j & 2) != 0 : (this.k & 2) != 0;
    }

    public final boolean f(int i) {
        if (i < 0 || i >= this.q.size()) {
            return false;
        }
        for (int i2 = i + 1; i2 < this.q.size(); i2++) {
            if (this.q.get(i2).b() > 0) {
                return false;
            }
        }
        return a() ? (this.j & 4) != 0 : (this.k & 4) != 0;
    }

    @Override // defpackage.as0
    public int getAlignContent() {
        return this.f;
    }

    @Override // defpackage.as0
    public int getAlignItems() {
        return this.e;
    }

    public Drawable getDividerDrawableHorizontal() {
        return this.h;
    }

    public Drawable getDividerDrawableVertical() {
        return this.i;
    }

    @Override // defpackage.as0
    public int getFlexDirection() {
        return this.a;
    }

    @Override // defpackage.as0
    public int getFlexItemCount() {
        return getChildCount();
    }

    public List<bs0> getFlexLines() {
        ArrayList arrayList = new ArrayList(this.q.size());
        for (bs0 bs0Var : this.q) {
            if (bs0Var.b() != 0) {
                arrayList.add(bs0Var);
            }
        }
        return arrayList;
    }

    @Override // defpackage.as0
    public List<bs0> getFlexLinesInternal() {
        return this.q;
    }

    @Override // defpackage.as0
    public int getFlexWrap() {
        return this.c;
    }

    public int getJustifyContent() {
        return this.d;
    }

    @Override // defpackage.as0
    public int getLargestMainSize() {
        Iterator<bs0> it = this.q.iterator();
        int i = Integer.MIN_VALUE;
        while (it.hasNext()) {
            i = Math.max(i, it.next().e);
        }
        return i;
    }

    @Override // defpackage.as0
    public int getMaxLine() {
        return this.g;
    }

    public int getShowDividerHorizontal() {
        return this.j;
    }

    public int getShowDividerVertical() {
        return this.k;
    }

    @Override // defpackage.as0
    public int getSumOfCrossSize() {
        int i;
        int i2;
        int size = this.q.size();
        int i3 = 0;
        for (int i4 = 0; i4 < size; i4++) {
            bs0 bs0Var = this.q.get(i4);
            if (e(i4)) {
                if (a()) {
                    i2 = this.l;
                } else {
                    i2 = this.m;
                }
                i3 += i2;
            }
            if (f(i4)) {
                if (a()) {
                    i = this.l;
                } else {
                    i = this.m;
                }
                i3 += i;
            }
            i3 += bs0Var.g;
        }
        return i3;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        if (this.i == null && this.h == null) {
            return;
        }
        if (this.j == 0 && this.k == 0) {
            return;
        }
        int i = q9.i(this);
        int i2 = this.a;
        if (i2 == 0) {
            a(canvas, i == 1, this.c == 2);
            return;
        }
        if (i2 == 1) {
            a(canvas, i != 1, this.c == 2);
            return;
        }
        if (i2 == 2) {
            boolean z = i == 1;
            if (this.c == 2) {
                z = !z;
            }
            b(canvas, z, false);
            return;
        }
        if (i2 != 3) {
            return;
        }
        boolean z2 = i == 1;
        if (this.c == 2) {
            z2 = !z2;
        }
        b(canvas, z2, true);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        boolean z2;
        int i5 = q9.i(this);
        int i6 = this.a;
        if (i6 == 0) {
            a(i5 == 1, i, i2, i3, i4);
            return;
        }
        if (i6 == 1) {
            a(i5 != 1, i, i2, i3, i4);
            return;
        }
        if (i6 == 2) {
            z2 = i5 == 1;
            a(this.c == 2 ? !z2 : z2, false, i, i2, i3, i4);
        } else if (i6 == 3) {
            z2 = i5 == 1;
            a(this.c == 2 ? !z2 : z2, true, i, i2, i3, i4);
        } else {
            throw new IllegalStateException("Invalid flex direction is set: " + this.a);
        }
    }

    @Override // android.view.View
    public void onMeasure(int i, int i2) {
        if (this.o == null) {
            this.o = new SparseIntArray(getChildCount());
        }
        if (this.p.b(this.o)) {
            this.n = this.p.a(this.o);
        }
        int i3 = this.a;
        if (i3 == 0 || i3 == 1) {
            c(i, i2);
            return;
        }
        if (i3 != 2 && i3 != 3) {
            throw new IllegalStateException("Invalid value for the flex direction is set: " + this.a);
        }
        d(i, i2);
    }

    public void setAlignContent(int i) {
        if (this.f != i) {
            this.f = i;
            requestLayout();
        }
    }

    public void setAlignItems(int i) {
        if (this.e != i) {
            this.e = i;
            requestLayout();
        }
    }

    public void setDividerDrawable(Drawable drawable) {
        setDividerDrawableHorizontal(drawable);
        setDividerDrawableVertical(drawable);
    }

    public void setDividerDrawableHorizontal(Drawable drawable) {
        if (drawable == this.h) {
            return;
        }
        this.h = drawable;
        if (drawable != null) {
            this.l = drawable.getIntrinsicHeight();
        } else {
            this.l = 0;
        }
        b();
        requestLayout();
    }

    public void setDividerDrawableVertical(Drawable drawable) {
        if (drawable == this.i) {
            return;
        }
        this.i = drawable;
        if (drawable != null) {
            this.m = drawable.getIntrinsicWidth();
        } else {
            this.m = 0;
        }
        b();
        requestLayout();
    }

    public void setFlexDirection(int i) {
        if (this.a != i) {
            this.a = i;
            requestLayout();
        }
    }

    @Override // defpackage.as0
    public void setFlexLines(List<bs0> list) {
        this.q = list;
    }

    public void setFlexWrap(int i) {
        if (this.c != i) {
            this.c = i;
            requestLayout();
        }
    }

    public void setJustifyContent(int i) {
        if (this.d != i) {
            this.d = i;
            requestLayout();
        }
    }

    public void setMaxLine(int i) {
        if (this.g != i) {
            this.g = i;
            requestLayout();
        }
    }

    public void setShowDivider(int i) {
        setShowDividerVertical(i);
        setShowDividerHorizontal(i);
    }

    public void setShowDividerHorizontal(int i) {
        if (i != this.j) {
            this.j = i;
            requestLayout();
        }
    }

    public void setShowDividerVertical(int i) {
        if (i != this.k) {
            this.k = i;
            requestLayout();
        }
    }

    public FlexboxLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public final void a(int i, int i2, int i3, int i4) {
        int sumOfCrossSize;
        int largestMainSize;
        int resolveSizeAndState;
        int resolveSizeAndState2;
        int mode = View.MeasureSpec.getMode(i2);
        int size = View.MeasureSpec.getSize(i2);
        int mode2 = View.MeasureSpec.getMode(i3);
        int size2 = View.MeasureSpec.getSize(i3);
        if (i == 0 || i == 1) {
            sumOfCrossSize = getSumOfCrossSize() + getPaddingTop() + getPaddingBottom();
            largestMainSize = getLargestMainSize();
        } else {
            if (i != 2 && i != 3) {
                throw new IllegalArgumentException("Invalid flex direction: " + i);
            }
            sumOfCrossSize = getLargestMainSize();
            largestMainSize = getSumOfCrossSize() + getPaddingLeft() + getPaddingRight();
        }
        if (mode == Integer.MIN_VALUE) {
            if (size < largestMainSize) {
                i4 = View.combineMeasuredStates(i4, 16777216);
            } else {
                size = largestMainSize;
            }
            resolveSizeAndState = View.resolveSizeAndState(size, i2, i4);
        } else if (mode == 0) {
            resolveSizeAndState = View.resolveSizeAndState(largestMainSize, i2, i4);
        } else if (mode == 1073741824) {
            if (size < largestMainSize) {
                i4 = View.combineMeasuredStates(i4, 16777216);
            }
            resolveSizeAndState = View.resolveSizeAndState(size, i2, i4);
        } else {
            throw new IllegalStateException("Unknown width mode is set: " + mode);
        }
        if (mode2 == Integer.MIN_VALUE) {
            if (size2 < sumOfCrossSize) {
                i4 = View.combineMeasuredStates(i4, 256);
            } else {
                size2 = sumOfCrossSize;
            }
            resolveSizeAndState2 = View.resolveSizeAndState(size2, i3, i4);
        } else if (mode2 == 0) {
            resolveSizeAndState2 = View.resolveSizeAndState(sumOfCrossSize, i3, i4);
        } else if (mode2 == 1073741824) {
            if (size2 < sumOfCrossSize) {
                i4 = View.combineMeasuredStates(i4, 256);
            }
            resolveSizeAndState2 = View.resolveSizeAndState(size2, i3, i4);
        } else {
            throw new IllegalStateException("Unknown height mode is set: " + mode2);
        }
        setMeasuredDimension(resolveSizeAndState, resolveSizeAndState2);
    }

    public final void b(Canvas canvas, boolean z, boolean z2) {
        int i;
        int i2;
        int bottom;
        int top;
        int paddingTop = getPaddingTop();
        int max = Math.max(0, (getHeight() - getPaddingBottom()) - paddingTop);
        int size = this.q.size();
        for (int i3 = 0; i3 < size; i3++) {
            bs0 bs0Var = this.q.get(i3);
            for (int i4 = 0; i4 < bs0Var.h; i4++) {
                int i5 = bs0Var.o + i4;
                View d = d(i5);
                if (d != null && d.getVisibility() != 8) {
                    LayoutParams layoutParams = (LayoutParams) d.getLayoutParams();
                    if (b(i5, i4)) {
                        if (z2) {
                            top = d.getBottom() + ((ViewGroup.MarginLayoutParams) layoutParams).bottomMargin;
                        } else {
                            top = (d.getTop() - ((ViewGroup.MarginLayoutParams) layoutParams).topMargin) - this.l;
                        }
                        a(canvas, bs0Var.a, top, bs0Var.g);
                    }
                    if (i4 == bs0Var.h - 1 && (this.j & 4) > 0) {
                        if (z2) {
                            bottom = (d.getTop() - ((ViewGroup.MarginLayoutParams) layoutParams).topMargin) - this.l;
                        } else {
                            bottom = d.getBottom() + ((ViewGroup.MarginLayoutParams) layoutParams).bottomMargin;
                        }
                        a(canvas, bs0Var.a, bottom, bs0Var.g);
                    }
                }
            }
            if (e(i3)) {
                if (z) {
                    i2 = bs0Var.c;
                } else {
                    i2 = bs0Var.a - this.m;
                }
                b(canvas, i2, paddingTop, max);
            }
            if (f(i3) && (this.k & 4) > 0) {
                if (z) {
                    i = bs0Var.a - this.m;
                } else {
                    i = bs0Var.c;
                }
                b(canvas, i, paddingTop, max);
            }
        }
    }

    @Override // android.view.ViewGroup
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(getContext(), attributeSet);
    }

    public FlexboxLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.g = -1;
        this.p = new cs0(this);
        this.q = new ArrayList();
        this.r = new cs0.b();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, es0.FlexboxLayout, i, 0);
        this.a = obtainStyledAttributes.getInt(es0.FlexboxLayout_flexDirection, 0);
        this.c = obtainStyledAttributes.getInt(es0.FlexboxLayout_flexWrap, 0);
        this.d = obtainStyledAttributes.getInt(es0.FlexboxLayout_justifyContent, 0);
        this.e = obtainStyledAttributes.getInt(es0.FlexboxLayout_alignItems, 0);
        this.f = obtainStyledAttributes.getInt(es0.FlexboxLayout_alignContent, 0);
        this.g = obtainStyledAttributes.getInt(es0.FlexboxLayout_maxLine, -1);
        Drawable drawable = obtainStyledAttributes.getDrawable(es0.FlexboxLayout_dividerDrawable);
        if (drawable != null) {
            setDividerDrawableHorizontal(drawable);
            setDividerDrawableVertical(drawable);
        }
        Drawable drawable2 = obtainStyledAttributes.getDrawable(es0.FlexboxLayout_dividerDrawableHorizontal);
        if (drawable2 != null) {
            setDividerDrawableHorizontal(drawable2);
        }
        Drawable drawable3 = obtainStyledAttributes.getDrawable(es0.FlexboxLayout_dividerDrawableVertical);
        if (drawable3 != null) {
            setDividerDrawableVertical(drawable3);
        }
        int i2 = obtainStyledAttributes.getInt(es0.FlexboxLayout_showDivider, 0);
        if (i2 != 0) {
            this.k = i2;
            this.j = i2;
        }
        int i3 = obtainStyledAttributes.getInt(es0.FlexboxLayout_showDividerVertical, 0);
        if (i3 != 0) {
            this.k = i3;
        }
        int i4 = obtainStyledAttributes.getInt(es0.FlexboxLayout_showDividerHorizontal, 0);
        if (i4 != 0) {
            this.j = i4;
        }
        obtainStyledAttributes.recycle();
    }

    public final void d(int i, int i2) {
        this.q.clear();
        this.r.a();
        this.p.b(this.r, i, i2);
        this.q = this.r.a;
        this.p.a(i, i2);
        this.p.a(i, i2, getPaddingLeft() + getPaddingRight());
        this.p.a();
        a(this.a, i, i2, this.r.b);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams) layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    @Override // defpackage.as0
    public boolean a() {
        int i = this.a;
        return i == 0 || i == 1;
    }

    /* JADX WARN: Removed duplicated region for block: B:23:0x00d4  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x0125  */
    /* JADX WARN: Removed duplicated region for block: B:41:0x01e5  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x01f2  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x0182  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public final void a(boolean r29, int r30, int r31, int r32, int r33) {
        /*
            Method dump skipped, instructions count: 544
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.flexbox.FlexboxLayout.a(boolean, int, int, int, int):void");
    }

    public final void b(Canvas canvas, int i, int i2, int i3) {
        Drawable drawable = this.i;
        if (drawable == null) {
            return;
        }
        drawable.setBounds(i, i2, this.m + i, i3 + i2);
        this.i.draw(canvas);
    }

    public final boolean c(int i) {
        for (int i2 = 0; i2 < i; i2++) {
            if (this.q.get(i2).b() > 0) {
                return false;
            }
        }
        return true;
    }

    @Override // defpackage.as0
    public int b(int i, int i2, int i3) {
        return ViewGroup.getChildMeasureSpec(i, i2, i3);
    }

    public final void b() {
        if (this.h == null && this.i == null) {
            setWillNotDraw(true);
        } else {
            setWillNotDraw(false);
        }
    }

    public final boolean b(int i, int i2) {
        return a(i, i2) ? a() ? (this.k & 1) != 0 : (this.j & 1) != 0 : a() ? (this.k & 2) != 0 : (this.j & 2) != 0;
    }

    /* JADX WARN: Removed duplicated region for block: B:23:0x00d2  */
    /* JADX WARN: Removed duplicated region for block: B:36:0x0125  */
    /* JADX WARN: Removed duplicated region for block: B:40:0x01e1  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x01ee  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x017e  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public final void a(boolean r30, boolean r31, int r32, int r33, int r34, int r35) {
        /*
            Method dump skipped, instructions count: 532
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.flexbox.FlexboxLayout.a(boolean, boolean, int, int, int, int):void");
    }

    public final void a(Canvas canvas, boolean z, boolean z2) {
        int i;
        int i2;
        int right;
        int left;
        int paddingLeft = getPaddingLeft();
        int max = Math.max(0, (getWidth() - getPaddingRight()) - paddingLeft);
        int size = this.q.size();
        for (int i3 = 0; i3 < size; i3++) {
            bs0 bs0Var = this.q.get(i3);
            for (int i4 = 0; i4 < bs0Var.h; i4++) {
                int i5 = bs0Var.o + i4;
                View d = d(i5);
                if (d != null && d.getVisibility() != 8) {
                    LayoutParams layoutParams = (LayoutParams) d.getLayoutParams();
                    if (b(i5, i4)) {
                        if (z) {
                            left = d.getRight() + ((ViewGroup.MarginLayoutParams) layoutParams).rightMargin;
                        } else {
                            left = (d.getLeft() - ((ViewGroup.MarginLayoutParams) layoutParams).leftMargin) - this.m;
                        }
                        b(canvas, left, bs0Var.b, bs0Var.g);
                    }
                    if (i4 == bs0Var.h - 1 && (this.k & 4) > 0) {
                        if (z) {
                            right = (d.getLeft() - ((ViewGroup.MarginLayoutParams) layoutParams).leftMargin) - this.m;
                        } else {
                            right = d.getRight() + ((ViewGroup.MarginLayoutParams) layoutParams).rightMargin;
                        }
                        b(canvas, right, bs0Var.b, bs0Var.g);
                    }
                }
            }
            if (e(i3)) {
                if (z2) {
                    i2 = bs0Var.d;
                } else {
                    i2 = bs0Var.b - this.l;
                }
                a(canvas, paddingLeft, i2, max);
            }
            if (f(i3) && (this.j & 4) > 0) {
                if (z2) {
                    i = bs0Var.b - this.l;
                } else {
                    i = bs0Var.d;
                }
                a(canvas, paddingLeft, i, max);
            }
        }
    }

    public final void a(Canvas canvas, int i, int i2, int i3) {
        Drawable drawable = this.h;
        if (drawable == null) {
            return;
        }
        drawable.setBounds(i, i2, i3 + i, this.l + i2);
        this.h.draw(canvas);
    }

    @Override // defpackage.as0
    public int a(View view, int i, int i2) {
        int i3;
        int i4;
        if (a()) {
            i3 = b(i, i2) ? 0 + this.m : 0;
            if ((this.k & 4) <= 0) {
                return i3;
            }
            i4 = this.m;
        } else {
            i3 = b(i, i2) ? 0 + this.l : 0;
            if ((this.j & 4) <= 0) {
                return i3;
            }
            i4 = this.l;
        }
        return i3 + i4;
    }

    @Override // defpackage.as0
    public void a(bs0 bs0Var) {
        if (a()) {
            if ((this.k & 4) > 0) {
                int i = bs0Var.e;
                int i2 = this.m;
                bs0Var.e = i + i2;
                bs0Var.f += i2;
                return;
            }
            return;
        }
        if ((this.j & 4) > 0) {
            int i3 = bs0Var.e;
            int i4 = this.l;
            bs0Var.e = i3 + i4;
            bs0Var.f += i4;
        }
    }

    @Override // defpackage.as0
    public int a(int i, int i2, int i3) {
        return ViewGroup.getChildMeasureSpec(i, i2, i3);
    }

    @Override // defpackage.as0
    public void a(View view, int i, int i2, bs0 bs0Var) {
        if (b(i, i2)) {
            if (a()) {
                int i3 = bs0Var.e;
                int i4 = this.m;
                bs0Var.e = i3 + i4;
                bs0Var.f += i4;
                return;
            }
            int i5 = bs0Var.e;
            int i6 = this.l;
            bs0Var.e = i5 + i6;
            bs0Var.f += i6;
        }
    }

    public final boolean a(int i, int i2) {
        for (int i3 = 1; i3 <= i2; i3++) {
            View d = d(i - i3);
            if (d != null && d.getVisibility() != 8) {
                return false;
            }
        }
        return true;
    }
}
