package defpackage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.autonavi.indoor.pdr.ErrorCode;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/* compiled from: PatchFileUtil.java */
/* loaded from: classes.dex */
public class ah {
    public static String a = null;
    public static String b = "auto_base_";
    public static String c = ".dex";
    public static String d = ".zip";
    public static String e = "shared_preference_name";
    public static String f = "need_version_path";
    public static String g = "pprevious_version_path";
    public static String h = null;
    public static String i = "classes";

    @SuppressLint({"NewApi"})
    public static void a(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj instanceof Closeable) {
                ((Closeable) obj).close();
            } else if (Build.VERSION.SDK_INT >= 19 && (obj instanceof AutoCloseable)) {
                ((AutoCloseable) obj).close();
            } else if (obj instanceof ZipFile) {
                ((ZipFile) obj).close();
            } else {
                throw new IllegalArgumentException("obj: " + obj + " cannot be closed.");
            }
        } catch (Throwable unused) {
        }
    }

    public static void b(Context context, String str) {
        Log.d("DexTrace.PatchFileUtil", " set need ver path " + str);
        h = str;
        vg.a().a(context).getSharedPreferences(e, 0).edit().putString(f, str).commit();
    }

    public static String c(Context context) {
        List<ApplicationInfo> installedApplications = context.getPackageManager().getInstalledApplications(ErrorCode.SENSOR_MAGNETIC_TIMESTAMP_ERROR);
        for (int i2 = 0; i2 < installedApplications.size(); i2++) {
            ApplicationInfo applicationInfo = installedApplications.get(i2);
            if (applicationInfo.packageName.equals(context.getPackageName())) {
                return applicationInfo.sourceDir;
            }
        }
        return null;
    }

    public static String d(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName + "_" + packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static String b(Context context) {
        if (h == null) {
            h = vg.a().a(context).getSharedPreferences(e, 0).getString(f, null);
        }
        return h;
    }

    public static final boolean a(File file) {
        return file != null && file.exists() && file.canRead() && file.isFile() && file.length() > 0;
    }

    public static String a(File file, File file2) {
        if (Build.VERSION.SDK_INT > 25) {
            try {
                String a2 = a();
                File parentFile = file.getParentFile();
                String name = file.getName();
                int lastIndexOf = name.lastIndexOf(46);
                if (lastIndexOf > 0) {
                    name = name.substring(0, lastIndexOf);
                }
                return parentFile.getAbsolutePath() + "/oat/" + a2 + "/" + name + ".odex";
            } catch (Exception e2) {
                throw new RuntimeException("getCurrentInstructionSet fail:", e2);
            }
        }
        String name2 = file.getName();
        if (!name2.endsWith(".dex")) {
            int lastIndexOf2 = name2.lastIndexOf(".");
            if (lastIndexOf2 < 0) {
                name2 = name2 + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastIndexOf2 + 4);
                sb.append((CharSequence) name2, 0, lastIndexOf2);
                sb.append(".dex");
                name2 = sb.toString();
            }
        }
        return new File(file2, name2).getPath();
    }

    public static String a() throws Exception {
        String str = a;
        if (str != null) {
            return str;
        }
        a = (String) Class.forName("dalvik.system.VMRuntime").getDeclaredMethod("getCurrentInstructionSet", new Class[0]).invoke(null, new Object[0]);
        Log.d("DexTrace.PatchFileUtil", "getCurrentInstructionSet:" + a);
        return a;
    }

    public static String a(Context context) throws IllegalArgumentException, IOException {
        if (context != null) {
            String d2 = d(context);
            Log.d("DexTrace.PatchFileUtil", d2 + " apk path " + c(context));
            File file = new File(c(context));
            if (file.exists()) {
                File file2 = new File(vg.a().a(context).getCacheDir().getAbsolutePath(), b + d2);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                File file3 = new File(file2 + File.separator + i + c);
                String a2 = a(context, g);
                StringBuilder sb = new StringBuilder();
                sb.append("extractedFilePath ");
                sb.append(file3.getAbsolutePath());
                Log.i("DexTrace.PatchFileUtil", sb.toString());
                Log.i("DexTrace.PatchFileUtil", "previouesVersionPath " + a2);
                if (!TextUtils.isEmpty(a2)) {
                    if (a2.equals(file3.getAbsolutePath()) && file3.exists()) {
                        return file2.getAbsolutePath();
                    }
                    File file4 = new File(a2);
                    if (file4.exists()) {
                        file4.delete();
                        Log.i("DexTrace.PatchFileUtil", "delete previouesVersionPath " + a2);
                    }
                }
                ZipFile zipFile = new ZipFile(file);
                a(zipFile, zipFile.getEntry(i + c), file3, file3.getName() + ".classes");
                Log.i("DexTrace.PatchFileUtil", file3.exists() + " out put path " + file3.getAbsolutePath());
                StringBuilder sb2 = new StringBuilder();
                sb2.append("extractedFileFile exists ");
                sb2.append(file3.exists());
                Log.i("DexTrace.PatchFileUtil", sb2.toString());
                if (a2 != null) {
                    Log.i("DexTrace.PatchFileUtil", "previouesVersionFile exists " + new File(a2).exists());
                }
                if (file3.exists()) {
                    a(context, g, file3.getAbsolutePath());
                }
                return file2.getAbsolutePath();
            }
            throw new FileNotFoundException("base apk file no exists");
        }
        throw new IllegalArgumentException("getBaseApkDexPath param context must not be null");
    }

    public static void a(ZipFile zipFile, ZipEntry zipEntry, File file, String str) throws IOException, FileNotFoundException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File createTempFile = File.createTempFile(str, d, file.getParentFile());
        Log.i("DexTrace.PatchFileUtil", "Extracting " + createTempFile.getPath());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(createTempFile);
            try {
                byte[] bArr = new byte[ErrorCode.SENSOR_PRESS_TIMESTAMP_ERROR];
                while (true) {
                    int read = inputStream.read(bArr);
                    if (read == -1) {
                        break;
                    } else {
                        fileOutputStream.write(bArr, 0, read);
                    }
                }
                fileOutputStream.close();
                inputStream.close();
                fileOutputStream.close();
                Log.i("DexTrace.PatchFileUtil", "Renaming to " + file.getPath());
                if (createTempFile.renameTo(file)) {
                    return;
                }
                throw new IOException("Failed to rename \"" + createTempFile.getAbsolutePath() + "\" to \"" + file.getAbsolutePath() + "\"");
            } catch (Throwable th) {
                fileOutputStream.close();
                throw th;
            }
        } finally {
            a(inputStream);
            createTempFile.delete();
            zipFile.close();
        }
    }

    public static void a(Context context, String str, String str2) {
        vg.a().a(context).getSharedPreferences(e, 0).edit().putString(str, str2).commit();
    }

    public static String a(Context context, String str) {
        return vg.a().a(context).getSharedPreferences(e, 0).getString(str, null);
    }
}
