package defpackage;

import android.annotation.TargetApi;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.GnssStatus;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.text.format.Time;
import com.autonavi.amapauto.jni.PosService;
import com.autonavi.amapauto.location.model.LocAcce3d;
import com.autonavi.amapauto.location.model.LocDrPos;
import com.autonavi.amapauto.location.model.LocGnss;
import com.autonavi.amapauto.location.model.LocGpgsv;
import com.autonavi.amapauto.location.model.LocGyro;
import com.autonavi.amapauto.location.model.LocModeType;
import com.autonavi.amapauto.location.model.LocPulse;
import com.autonavi.amapauto.location.model.LocSignData;
import com.autonavi.amapauto.location.model.LocW4M;
import com.autonavi.amapauto.location.model.PosWorkPath;
import com.autonavi.indoor.pdr.ErrorCode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

/* compiled from: LocWrapper.java */
/* loaded from: classes.dex */
public class as {
    public static final String o = "as";
    public static w80 p;
    public static final Object q = new Object();
    public int a;
    public List<GpsSatellite> b;
    public GnssStatus.Callback c;
    public boolean d = false;
    public int e = 0;
    public long f = 0;
    public int g = 0;
    public int h = 0;
    public boolean i = false;
    public Handler j = new Handler(Looper.getMainLooper());
    public Runnable k = new a();
    public Handler l = new Handler(Looper.getMainLooper());
    public Runnable m = new b();
    public long n;

    /* compiled from: LocWrapper.java */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        public a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            as.this.b();
        }
    }

    /* compiled from: LocWrapper.java */
    /* loaded from: classes.dex */
    public class b implements Runnable {
        public b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            as.this.a();
        }
    }

    /* compiled from: LocWrapper.java */
    @TargetApi(24)
    /* loaded from: classes.dex */
    public static class c extends GnssStatus.Callback {
        @Override // android.location.GnssStatus.Callback
        public void onFirstFix(int i) {
            aa0.a(as.o, "第一次定位", new Object[0]);
        }

        @Override // android.location.GnssStatus.Callback
        public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
            aa0.a("Location&DR", "onSatelliteStatusChanged", new Object[0]);
            synchronized (as.q) {
                as.g().a(gnssStatus);
            }
        }

        @Override // android.location.GnssStatus.Callback
        public void onStarted() {
            aa0.a(as.o, "定位启动", new Object[0]);
        }

        @Override // android.location.GnssStatus.Callback
        public void onStopped() {
            aa0.a(as.o, "定位结束", new Object[0]);
        }
    }

    /* compiled from: LocWrapper.java */
    /* loaded from: classes.dex */
    public static final class d implements SensorEventListener, GpsStatus.Listener {
        public SensorManager a;
        public HandlerThread b;
        public long c;

        public d() {
            try {
                this.a = (SensorManager) ee.A().f().getSystemService("sensor");
            } catch (Throwable unused) {
                this.a = null;
            }
        }

        public final void a() {
            if (this.a != null) {
                HandlerThread handlerThread = this.b;
                if (handlerThread == null || !handlerThread.isAlive()) {
                    b();
                    HandlerThread handlerThread2 = new HandlerThread(d.class.getName() + "_SensorThread");
                    this.b = handlerThread2;
                    handlerThread2.start();
                    try {
                        this.a.registerListener(this, this.a.getDefaultSensor(6), 3, new Handler(this.b.getLooper()));
                    } catch (Exception e) {
                        e.printStackTrace();
                        aa0.a("Location&DR", "sensorManager.registerListener Exception,e={?}", e.getMessage());
                    }
                }
            }
        }

        public final void b() {
            SensorManager sensorManager = this.a;
            if (sensorManager != null) {
                sensorManager.unregisterListener(this);
                HandlerThread handlerThread = this.b;
                if (handlerThread != null) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        handlerThread.quitSafely();
                    } else {
                        handlerThread.quit();
                    }
                    this.b = null;
                }
            }
        }

        public void c() {
            aa0.a("Location&DR", "Listener.start() sdk_int={?}", Integer.valueOf(Build.VERSION.SDK_INT));
            aa0.a("Location&DR", "addGpsStatusListener", new Object[0]);
            as.p.a(this);
            a();
        }

        public void d() {
            aa0.a("Location&DR", "Listener.stop()", new Object[0]);
            as.p.removeGpsStatusListener(this);
            b();
        }

        @Override // android.hardware.SensorEventListener
        public void onAccuracyChanged(Sensor sensor, int i) {
        }

        @Override // android.location.GpsStatus.Listener
        public void onGpsStatusChanged(int i) {
            if (i == 1) {
                aa0.a(as.o, "定位启动", new Object[0]);
                return;
            }
            if (i == 2) {
                aa0.a(as.o, "定位结束", new Object[0]);
                return;
            }
            if (i == 3) {
                aa0.a(as.o, "第一次定位", new Object[0]);
            } else {
                if (i != 4) {
                    return;
                }
                as.g().d();
                aa0.a(as.o, "卫星状态改变", new Object[0]);
            }
        }

        @Override // android.hardware.SensorEventListener
        public void onSensorChanged(SensorEvent sensorEvent) {
            Sensor sensor;
            if (sensorEvent == null || (sensor = sensorEvent.sensor) == null || sensor.getType() != 4) {
                return;
            }
            this.c = this.c == 0 ? SystemClock.elapsedRealtime() : SystemClock.elapsedRealtime() - this.c;
            as g = as.g();
            float[] fArr = sensorEvent.values;
            g.a(0, 7, fArr[0], fArr[1], fArr[2], 0.0f, (int) this.c, SystemClock.elapsedRealtime());
        }
    }

    /* compiled from: LocWrapper.java */
    /* loaded from: classes.dex */
    public static class e {
        public static as a = new as();
    }

    public static as g() {
        return e.a;
    }

    public void a(w80 w80Var) {
        p = w80Var;
        PosService.init(new PosWorkPath(), new LocModeType());
        this.d = oq.i().g();
        Handler handler = this.l;
        if (handler != null) {
            this.e = 120000;
            handler.removeCallbacks(this.m);
            this.l.removeCallbacksAndMessages(null);
            this.l.postDelayed(this.m, this.e);
        }
    }

    public void b() {
        LocSignData locSignData = new LocSignData();
        locSignData.dataType = 1;
        LocGpgsv locGpgsv = new LocGpgsv();
        locSignData.gpgsv = locGpgsv;
        locGpgsv.dataType = 64;
        locGpgsv.type = 0;
        locGpgsv.prn = new int[64];
        locGpgsv.prnLocType = new int[64];
        locGpgsv.elevation = new int[64];
        locGpgsv.azimuth = new int[64];
        locGpgsv.snr = new int[64];
        locGpgsv.isUsed = new int[64];
        locGpgsv.num = 0;
        this.h = 0;
        this.g = 0;
        PosService.setSignInfo(locSignData);
    }

    @TargetApi(24)
    public void c() {
        aa0.a("Location&DR", "registerGnssStatusCallback", new Object[0]);
        synchronized (q) {
            if (this.c == null) {
                this.c = new c();
            }
        }
        w80 w80Var = p;
        if (w80Var != null) {
            w80Var.a(this.c);
        }
    }

    public void d() {
        if (p == null) {
            return;
        }
        Handler handler = this.j;
        if (handler != null) {
            handler.removeCallbacks(this.k);
            this.j.removeCallbacksAndMessages(null);
            this.j.postDelayed(this.k, 3000L);
        }
        GpsStatus gpsStatus = p.getGpsStatus(null);
        if (gpsStatus != null) {
            LocSignData locSignData = new LocSignData();
            locSignData.dataType = 1;
            LocGpgsv locGpgsv = new LocGpgsv();
            locSignData.gpgsv = locGpgsv;
            locGpgsv.dataType = 64;
            locGpgsv.type = 0;
            locGpgsv.prn = new int[64];
            locGpgsv.prnLocType = new int[64];
            locGpgsv.elevation = new int[64];
            locGpgsv.azimuth = new int[64];
            locGpgsv.snr = new int[64];
            locGpgsv.isUsed = new int[64];
            int maxSatellites = gpsStatus.getMaxSatellites();
            Iterator<GpsSatellite> it = gpsStatus.getSatellites().iterator();
            this.b = new ArrayList();
            String str = "";
            int i = 0;
            while (it.hasNext() && i <= maxSatellites) {
                GpsSatellite next = it.next();
                if (!next.usedInFix()) {
                    this.b.add(next);
                } else if (i < 64) {
                    locSignData.gpgsv.prnLocType[i] = jp.I().a(next.getPrn());
                    int b2 = jp.I().b(next.getPrn());
                    LocGpgsv locGpgsv2 = locSignData.gpgsv;
                    locGpgsv2.prn[i] = b2;
                    locGpgsv2.elevation[i] = (int) next.getElevation();
                    locSignData.gpgsv.azimuth[i] = (int) next.getAzimuth();
                    locSignData.gpgsv.snr[i] = (int) next.getSnr();
                    locSignData.gpgsv.isUsed[i] = 1;
                    str = str + "{prn=" + b2 + ",getElevation=" + next.getElevation() + ",getAzimuth=" + next.getAzimuth() + ",getSnr=" + next.getSnr() + "}";
                    i++;
                }
            }
            this.g = i;
            aa0.a(o, "start count ={?},logGsvInfo={?}", Integer.valueOf(i), str);
            int size = this.b.size() + i;
            if (size >= 64) {
                size = 64;
            }
            int i2 = 0;
            while (i < size) {
                int i3 = i2 + 1;
                GpsSatellite gpsSatellite = this.b.get(i2);
                locSignData.gpgsv.prnLocType[i] = jp.I().a(gpsSatellite.getPrn());
                locSignData.gpgsv.prn[i] = gpsSatellite.getPrn();
                locSignData.gpgsv.elevation[i] = (int) gpsSatellite.getElevation();
                locSignData.gpgsv.azimuth[i] = (int) gpsSatellite.getAzimuth();
                locSignData.gpgsv.snr[i] = (int) gpsSatellite.getSnr();
                locSignData.gpgsv.isUsed[i] = 0;
                i++;
                i2 = i3;
            }
            this.h = i;
            aa0.a(o, "end count ={?}", Integer.valueOf(i));
            locSignData.gpgsv.num = i < 64 ? size : 64;
            LocGpgsv locGpgsv3 = locSignData.gpgsv;
            if (locGpgsv3.num >= 0) {
                locGpgsv3.tickTime = SystemClock.elapsedRealtime();
                long j = this.f;
                if (j <= 0 || locSignData.gpgsv.tickTime - j >= 500) {
                    this.f = locSignData.gpgsv.tickTime;
                    PosService.setSignInfo(locSignData);
                }
            }
        }
    }

    @TargetApi(24)
    public void e() {
        w80 w80Var = p;
        if (w80Var != null) {
            w80Var.b(this.c);
        }
    }

    public void a(double d2, long j, double[] dArr, double[] dArr2, double[] dArr3) {
        ks ksVar = new ks();
        LocSignData locSignData = new LocSignData();
        locSignData.dataType = ErrorCode.SENSOR_GYRO_TIMESTAMP_ERROR;
        locSignData.driveSig = ksVar;
        PosService.setSignInfo(locSignData);
    }

    public void a(double d2, int i, long j) {
        LocSignData locSignData = new LocSignData();
        LocPulse locPulse = new LocPulse();
        locSignData.pulse = locPulse;
        locPulse.dataType = 8;
        locSignData.dataType = 8;
        locPulse.interval = i;
        locPulse.value = (float) d2;
        locPulse.tickTime = j;
        PosService.setSignInfo(locSignData);
    }

    public void b(d dVar) {
        int h = jp.I().h();
        aa0.a(o, "unRegisterGnssStatus(). type = {?}", Integer.valueOf(h));
        if (1 == h) {
            if (dVar != null) {
                dVar.d();
                return;
            } else {
                ee.A().l().b();
                return;
            }
        }
        if (2 == h) {
            e();
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            e();
        } else if (dVar != null) {
            dVar.d();
        } else {
            ee.A().l().b();
        }
    }

    public void a(LocGpgsv locGpgsv) {
        LocSignData locSignData = new LocSignData();
        locSignData.dataType = 64;
        locSignData.gpgsv = locGpgsv;
        PosService.setSignInfo(locSignData);
    }

    public void a(Location location) {
        if (location == null) {
            return;
        }
        this.i = true;
        LocSignData locSignData = new LocSignData();
        locSignData.dataType = 0;
        locSignData.gnss = new LocGnss();
        String provider = location.getProvider();
        char c2 = 65535;
        int hashCode = provider.hashCode();
        if (hashCode != 102570) {
            if (hashCode == 1843485230 && provider.equals("network")) {
                c2 = 1;
            }
        } else if (provider.equals("gps")) {
            c2 = 0;
        }
        if (c2 == 0) {
            locSignData.gnss.sourType = 0;
        } else if (c2 != 1) {
            return;
        } else {
            locSignData.gnss.sourType = 1;
        }
        Time time = new Time();
        time.set(location.getTime());
        aa0.a("DR", "LocationUtils getLocationInfo zoneId:{?}", TimeZone.getDefault().getID());
        LocGnss locGnss = locSignData.gnss;
        locGnss.year = time.year;
        locGnss.month = time.month + 1;
        locGnss.day = time.monthDay;
        locGnss.hour = time.hour;
        int i = time.minute;
        locGnss.minute = i;
        locGnss.second = time.second;
        if (this.a != i) {
            this.a = i;
            aa0.a(o, "setGpsInfo location.getTime() ={?},hour={?}", Long.valueOf(location.getTime()), Integer.valueOf(time.hour));
        }
        locSignData.gnss.lon = location.getLongitude();
        locSignData.gnss.lat = location.getLatitude();
        locSignData.gnss.accuracy = location.getAccuracy();
        locSignData.gnss.alt = (float) location.getAltitude();
        locSignData.gnss.course = location.getBearing();
        LocGnss locGnss2 = locSignData.gnss;
        double speed = location.getSpeed();
        Double.isNaN(speed);
        locGnss2.speed = (float) (speed * 3.6d);
        locSignData.gnss.tickTime = SystemClock.elapsedRealtime();
        LocGnss locGnss3 = locSignData.gnss;
        locGnss3.isNS = (byte) 78;
        locGnss3.isEW = (byte) 69;
        locGnss3.num = 9;
        locGnss3.hdop = 0.9f;
        locGnss3.vdop = 0.9f;
        locGnss3.pdop = 0.9f;
        locGnss3.status = (byte) 65;
        locGnss3.mode = (byte) 78;
        locGnss3.speedoMeter = jp.I().a(locSignData.gnss.speed);
        long elapsedRealtime = (int) (this.n == 0 ? SystemClock.elapsedRealtime() : SystemClock.elapsedRealtime() - this.n);
        this.n = elapsedRealtime;
        locSignData.gnss.interval = (int) elapsedRealtime;
        this.n = SystemClock.elapsedRealtime();
        if (this.d) {
            locSignData.gnss.isEncrypted = (short) 1;
        }
        String str = "{\"location\":\"" + location + "\"}";
        LocGnss locGnss4 = locSignData.gnss;
        a("LocWrapper", "setGpsInfo", "PosEnum_LocDrTypeGNSS", 0, str, locGnss4.speed, locGnss4.lat, locGnss4.lon);
        PosService.setSignInfo(locSignData);
    }

    public void a(LocDrPos locDrPos) {
        LocSignData locSignData = new LocSignData();
        locSignData.dataType = 512;
        locSignData.drPos = locDrPos;
        a("LocWrapper", "setLocDrPos", "PosEnum_LocDrTypeGNSS", 0, "{\"locDrPos\":\"" + locDrPos + "\"}", locDrPos.speed, locDrPos.stLat, locDrPos.stLon);
        PosService.setSignInfo(locSignData);
    }

    public void a(int i, float f, float f2, float f3, int i2, long j) {
        LocSignData locSignData = new LocSignData();
        LocAcce3d locAcce3d = new LocAcce3d();
        locSignData.acce3D = locAcce3d;
        locAcce3d.dataType = 2;
        locSignData.dataType = 2;
        locAcce3d.axis = i;
        locAcce3d.interval = i2;
        locAcce3d.acceX = f2;
        locAcce3d.acceY = f3;
        locAcce3d.acceZ = f;
        locAcce3d.tickTime = j;
        a("LocWrapper", "setLocAcc3D", "PosEnum_LocDataAcce3D", 2, "{\"axis\":\"" + i + "\", \"yaw\":\"" + f + "\", \"pitch\":\"" + f2 + "\", \"roll\":\"" + f3 + "\", \"interval\":\"" + i2 + "\", \"ticktime\":\"" + j + "\"}", f2, f3, f);
        PosService.setSignInfo(locSignData);
    }

    public void a(float f, float f2, float f3, float f4, float f5, float f6, int i, float f7, float f8, int i2, long j) {
        LocSignData locSignData = new LocSignData();
        LocW4M locW4M = new LocW4M();
        locSignData.locW4M = locW4M;
        locW4M.dataType = 256;
        locW4M.vrl = f;
        locW4M.vrr = f2;
        locW4M.vfl = f3;
        locW4M.vfr = f4;
        locW4M.steerAngle = f5;
        locW4M.yawRate = f6;
        locW4M.lonAcc = f7;
        locW4M.latAcc = f8;
        locW4M.gearState = i;
        locW4M.interval = i2;
        locW4M.tickTime = j;
        PosService.setSignInfo(locSignData);
    }

    @TargetApi(24)
    public int a(int i) {
        if (i == 1) {
            return os.a;
        }
        if (i == 3) {
            return os.c;
        }
        if (i == 5) {
            return os.b;
        }
        if (i != 6) {
            return os.e;
        }
        return os.d;
    }

    /* JADX WARN: Code restructure failed: missing block: B:10:0x007f, code lost:            if (defpackage.os.f == r14) goto L12;     */
    @android.annotation.TargetApi(24)
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public void a(android.location.GnssStatus r18) {
        /*
            Method dump skipped, instructions count: 507
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: defpackage.as.a(android.location.GnssStatus):void");
    }

    public void a(d dVar) {
        int h = jp.I().h();
        aa0.a(o, "registerGnssStatus(). type = {?}", Integer.valueOf(h));
        if (1 == h) {
            if (dVar != null) {
                dVar.c();
                return;
            } else {
                ee.A().l().c();
                return;
            }
        }
        if (2 == h) {
            c();
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            c();
        } else if (dVar != null) {
            dVar.c();
        } else {
            ee.A().l().c();
        }
    }

    public void a(int i, int i2, float f, float f2, float f3, float f4, int i3, long j) {
        LocSignData locSignData = new LocSignData();
        LocGyro locGyro = new LocGyro();
        locSignData.gyro = locGyro;
        locGyro.dataType = 4;
        locSignData.dataType = 4;
        locGyro.axis = i2;
        locGyro.interval = i3;
        locGyro.temperature = f4;
        locGyro.valueX = f3;
        locGyro.valueY = f2;
        locGyro.valueZ = f;
        locGyro.tickTime = j;
        a("LocWrapper", "setGyro", "PosEnum_LocDataGyro", 4, "{\"nType\":\"" + i + "\", \"nAxis\":\"" + i2 + "\", \"yaw\":\"" + f + "\", \"roll\":\"" + f2 + "\", \"pitch\":\"" + f3 + "\", \"nTemperature\":\"" + f4 + "\", \"nInterval\":\"" + i3 + "\", \"ticktime\":\"" + j + "\"}", f3, f2, f);
        PosService.setSignInfo(locSignData);
    }

    public static void a(String str, String str2, String str3, int i, String str4, double d2, double d3, double d4) {
        aa0.a(str, "DR_GNSS_VISUAL_LOG method:{?}, annotation:{?}, lineNumbers:{?}, indrsensortype:{?}, params:{?},realtime:{?} $$$[{?}, {?}, {?}]", str2, str3, 874, Integer.valueOf(i), str4, Long.valueOf(SystemClock.elapsedRealtime()), Double.valueOf(d2), Double.valueOf(d3), Double.valueOf(d4));
    }

    public void a() {
        if (!this.i) {
            int i = this.e;
            if (i == 120000) {
                this.e = 180000;
                this.l.removeCallbacks(this.m);
                this.l.removeCallbacksAndMessages(null);
                this.l.postDelayed(this.m, this.e);
                a(0, 2);
                return;
            }
            if (i == 180000) {
                this.e = 300000;
                this.l.removeCallbacks(this.m);
                this.l.removeCallbacksAndMessages(null);
                this.l.postDelayed(this.m, this.e);
                a(0, 5);
                return;
            }
            if (i == 300000) {
                this.l.removeCallbacks(this.m);
                this.l.removeCallbacksAndMessages(null);
                a(0, 10);
                return;
            }
            return;
        }
        aa0.a(o, "checkLocate hasLocated", new Object[0]);
        this.l.removeCallbacks(this.m);
        this.l.removeCallbacksAndMessages(null);
        a("hasLocated=1");
    }

    public void a(String str) {
        a(0, 0, this.g, this.h, str);
    }

    public void a(int i, int i2) {
        a(i, i2, this.g, this.h, "");
    }

    public void a(int i, int i2, int i3, int i4, String str) {
        String format = String.format("[%d][5][%d][%d][%d][%d][%s]", 100000193, Integer.valueOf(i), Integer.valueOf(i2), Integer.valueOf(i3), Integer.valueOf(i4), str);
        aa0.a(o, "collectLocateData format={?}", format);
        ge.b("AUTO_AL", 100000193, format, 50);
    }
}
