package defpackage;

import android.text.TextUtils;
import com.autonavi.amapauto.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

/* compiled from: OfflineFileUtil.java */
/* loaded from: classes.dex */
public class av {

    /* compiled from: OfflineFileUtil.java */
    /* loaded from: classes.dex */
    public enum a {
        Useable,
        CreateFileError,
        CreateDirError,
        DeleteFileError,
        DeleteDirError,
        OtherError
    }

    static {
        new ReentrantLock();
    }

    public static a a(String str) {
        if (TextUtils.isEmpty(str)) {
            return a.OtherError;
        }
        aa0.a("[offline]OfflineFileUtil", "isPathCanUse path={?}", str);
        return a(new File(FileUtils.replaceIllegalChar(str)));
    }

    public static a a(File file) {
        if (file == null) {
            return a.OtherError;
        }
        aa0.a("[offline]OfflineFileUtil", "isPathCanUse exists={?}, isDir={?}", Boolean.valueOf(file.exists()), Boolean.valueOf(file.isDirectory()));
        if (file.exists() && file.isDirectory()) {
            String str = "AutoPathTempFile" + System.currentTimeMillis();
            File file2 = new File(file, str);
            aa0.a("[offline]OfflineFileUtil", "isPathCanUse testFile={?} exists={?}", str, Boolean.valueOf(file2.exists()));
            if (file2.exists() && !file2.delete()) {
                return a.DeleteFileError;
            }
            try {
                if (!file2.createNewFile()) {
                    aa0.a("[offline]OfflineFileUtil", "isPathCanUse createNewFile=false", new Object[0]);
                    return a.CreateFileError;
                }
                if (!file2.delete()) {
                    aa0.a("[offline]OfflineFileUtil", "isPathCanUse testFile.delete=false", new Object[0]);
                    return a.DeleteFileError;
                }
                File file3 = new File(file, "AutoPathTempDir" + System.currentTimeMillis());
                if (!file3.mkdirs()) {
                    aa0.a("[offline]OfflineFileUtil", "isPathCanUse testFile.mkdirs=false", new Object[0]);
                    return a.CreateDirError;
                }
                if (!file3.delete()) {
                    aa0.a("[offline]OfflineFileUtil", "isPathCanUse testFile.delete=false", new Object[0]);
                    return a.DeleteDirError;
                }
                return a.Useable;
            } catch (IOException e) {
                aa0.a("[offline]OfflineFileUtil", "isPathCanUse createNewFile IOException:{?}", e.toString());
                return a.CreateFileError;
            }
        }
        return a.OtherError;
    }
}
