package defpackage;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import defpackage.c6;
import java.util.Arrays;
import java.util.HashMap;

/* compiled from: ConstraintHelper.java */
/* loaded from: classes.dex */
public abstract class b6 extends View {
    public int[] a;
    public int c;
    public Context d;
    public e5 e;
    public boolean f;
    public String g;
    public String h;
    public HashMap<Integer, String> i;

    public b6(Context context) {
        super(context);
        this.a = new int[32];
        this.f = false;
        this.i = new HashMap<>();
        this.d = context;
        a((AttributeSet) null);
    }

    public void a(AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, k6.ConstraintLayout_Layout);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == k6.ConstraintLayout_Layout_constraint_referenced_ids) {
                    String string = obtainStyledAttributes.getString(index);
                    this.g = string;
                    setIds(string);
                } else if (index == k6.ConstraintLayout_Layout_constraint_referenced_tags) {
                    String string2 = obtainStyledAttributes.getString(index);
                    this.h = string2;
                    setReferenceTags(string2);
                }
            }
            obtainStyledAttributes.recycle();
        }
    }

    public void a(b5 b5Var, boolean z) {
    }

    public void b() {
        if (this.e == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        if (layoutParams instanceof c6.b) {
            ((c6.b) layoutParams).m0 = (b5) this.e;
        }
    }

    public void b(c6 c6Var) {
    }

    public final int c(String str) {
        c6 c6Var = getParent() instanceof c6 ? (c6) getParent() : null;
        int i = 0;
        if (isInEditMode() && c6Var != null) {
            Object a = c6Var.a(0, str);
            if (a instanceof Integer) {
                i = ((Integer) a).intValue();
            }
        }
        if (i == 0 && c6Var != null) {
            i = a(c6Var, str);
        }
        if (i == 0) {
            try {
                i = j6.class.getField(str).getInt(null);
            } catch (Exception unused) {
            }
        }
        return i == 0 ? this.d.getResources().getIdentifier(str, "id", this.d.getPackageName()) : i;
    }

    public void c(c6 c6Var) {
    }

    public void d(c6 c6Var) {
    }

    public void e(c6 c6Var) {
        String str;
        int a;
        if (isInEditMode()) {
            setIds(this.g);
        }
        e5 e5Var = this.e;
        if (e5Var == null) {
            return;
        }
        e5Var.a();
        for (int i = 0; i < this.c; i++) {
            int i2 = this.a[i];
            View b = c6Var.b(i2);
            if (b == null && (a = a(c6Var, (str = this.i.get(Integer.valueOf(i2))))) != 0) {
                this.a[i] = a;
                this.i.put(Integer.valueOf(a), str);
                b = c6Var.b(a);
            }
            if (b != null) {
                this.e.a(c6Var.a(b));
            }
        }
        this.e.a(c6Var.d);
    }

    public int[] getReferencedIds() {
        return Arrays.copyOf(this.a, this.c);
    }

    @Override // android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        String str = this.g;
        if (str != null) {
            setIds(str);
        }
        String str2 = this.h;
        if (str2 != null) {
            setReferenceTags(str2);
        }
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
    }

    @Override // android.view.View
    public void onMeasure(int i, int i2) {
        if (this.f) {
            super.onMeasure(i, i2);
        } else {
            setMeasuredDimension(0, 0);
        }
    }

    public void setIds(String str) {
        this.g = str;
        if (str == null) {
            return;
        }
        int i = 0;
        this.c = 0;
        while (true) {
            int indexOf = str.indexOf(44, i);
            if (indexOf == -1) {
                a(str.substring(i));
                return;
            } else {
                a(str.substring(i, indexOf));
                i = indexOf + 1;
            }
        }
    }

    public void setReferenceTags(String str) {
        this.h = str;
        if (str == null) {
            return;
        }
        int i = 0;
        this.c = 0;
        while (true) {
            int indexOf = str.indexOf(44, i);
            if (indexOf == -1) {
                b(str.substring(i));
                return;
            } else {
                b(str.substring(i, indexOf));
                i = indexOf + 1;
            }
        }
    }

    public void setReferencedIds(int[] iArr) {
        this.g = null;
        this.c = 0;
        for (int i : iArr) {
            a(i);
        }
    }

    @Override // android.view.View
    public void setTag(int i, Object obj) {
        super.setTag(i, obj);
        if (obj == null && this.g == null) {
            a(i);
        }
    }

    public final void b(String str) {
        if (str == null || str.length() == 0 || this.d == null) {
            return;
        }
        String trim = str.trim();
        c6 c6Var = getParent() instanceof c6 ? (c6) getParent() : null;
        if (c6Var == null) {
            Log.w("ConstraintHelper", "Parent not a ConstraintLayout");
            return;
        }
        int childCount = c6Var.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = c6Var.getChildAt(i);
            ViewGroup.LayoutParams layoutParams = childAt.getLayoutParams();
            if ((layoutParams instanceof c6.b) && trim.equals(((c6.b) layoutParams).U)) {
                if (childAt.getId() == -1) {
                    Log.w("ConstraintHelper", "to use ConstraintTag view " + childAt.getClass().getSimpleName() + " must have an ID");
                } else {
                    a(childAt.getId());
                }
            }
        }
    }

    public final void a(int i) {
        if (i == getId()) {
            return;
        }
        int i2 = this.c + 1;
        int[] iArr = this.a;
        if (i2 > iArr.length) {
            this.a = Arrays.copyOf(iArr, iArr.length * 2);
        }
        int[] iArr2 = this.a;
        int i3 = this.c;
        iArr2[i3] = i;
        this.c = i3 + 1;
    }

    public final void a(String str) {
        if (str == null || str.length() == 0 || this.d == null) {
            return;
        }
        String trim = str.trim();
        if (getParent() instanceof c6) {
        }
        int c = c(trim);
        if (c != 0) {
            this.i.put(Integer.valueOf(c), trim);
            a(c);
            return;
        }
        Log.w("ConstraintHelper", "Could not find id of \"" + trim + "\"");
    }

    public final int a(c6 c6Var, String str) {
        Resources resources;
        if (str == null || c6Var == null || (resources = this.d.getResources()) == null) {
            return 0;
        }
        int childCount = c6Var.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = c6Var.getChildAt(i);
            if (childAt.getId() != -1) {
                String str2 = null;
                try {
                    str2 = resources.getResourceEntryName(childAt.getId());
                } catch (Resources.NotFoundException unused) {
                }
                if (str.equals(str2)) {
                    return childAt.getId();
                }
            }
        }
        return 0;
    }

    public void a(c6 c6Var) {
        int visibility = getVisibility();
        float elevation = Build.VERSION.SDK_INT >= 21 ? getElevation() : 0.0f;
        for (int i = 0; i < this.c; i++) {
            View b = c6Var.b(this.a[i]);
            if (b != null) {
                b.setVisibility(visibility);
                if (elevation > 0.0f && Build.VERSION.SDK_INT >= 21) {
                    b.setTranslationZ(b.getTranslationZ() + elevation);
                }
            }
        }
    }

    public void a() {
        ViewParent parent = getParent();
        if (parent == null || !(parent instanceof c6)) {
            return;
        }
        a((c6) parent);
    }
}
