package defpackage;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.amap.location.common.model.AmapLoc;
import com.autonavi.amapauto.ar.camera.ArCameraParam;
import com.autonavi.amapauto.ar.camera.CameraManagerNative;
import com.autonavi.amapauto.ar.camera.model.ArCameraBaseInfo;
import com.autonavi.amapauto.ar.camera.model.ArCameraFrameInfo;
import com.autonavi.amapauto.ar.camera.model.ArImage;
import com.autonavi.amapauto.ar.camera.model.ArPerfInfo;
import com.autonavi.amapauto.ar.camera.model.ImageChannel;
import com.autonavi.amapauto.ar.camera.model.ImageInfo;
import defpackage.kf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

/* compiled from: Camera2.java */
/* loaded from: classes.dex */
public class bf extends ye {
    public HandlerThread D;
    public Handler E;
    public ArCameraParam a;
    public CameraDevice c;
    public ImageReader d;
    public Size f;
    public Surface g;
    public CameraCaptureSession h;
    public ArImage j;
    public kf.a<ArImage> k;
    public ArCameraFrameInfo y;
    public int z;
    public Object e = new Object();
    public kf<ArImage> i = new kf<>(2);
    public ArrayList<Long> l = new ArrayList<>();
    public Object m = new Object();
    public ArrayList<Long> n = new ArrayList<>();
    public ArrayList<Long> o = new ArrayList<>();
    public Object p = new Object();
    public boolean q = false;
    public boolean r = false;
    public long s = 0;
    public long t = 0;
    public long u = 0;
    public long v = 0;
    public ArPerfInfo w = new ArPerfInfo();
    public ArCameraBaseInfo x = new ArCameraBaseInfo();
    public Pattern A = Pattern.compile("\\s*|\t|\r|\n");
    public String B = "";
    public AtomicInteger C = new AtomicInteger();
    public int F = 0;
    public int G = -9;
    public CameraDevice.StateCallback H = new b();
    public CameraManager b = (CameraManager) ee.A().f().getSystemService("camera");

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class a implements Comparator<Size> {
        public a(bf bfVar) {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(Size size, Size size2) {
            return Long.signum((size.getWidth() * size.getHeight()) - (size2.getWidth() * size2.getHeight()));
        }
    }

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class b extends CameraDevice.StateCallback {
        public b() {
        }

        @Override // android.hardware.camera2.CameraDevice.StateCallback
        public void onClosed(CameraDevice cameraDevice) {
            super.onClosed(cameraDevice);
            aa0.a("Camera2", "StateCallback onClosed camera: " + cameraDevice, new Object[0]);
        }

        @Override // android.hardware.camera2.CameraDevice.StateCallback
        public void onDisconnected(CameraDevice cameraDevice) {
            aa0.a("Camera2", "StateCallback onDisconnected camera: " + cameraDevice, new Object[0]);
            bf.this.k();
            bf.this.c = null;
        }

        @Override // android.hardware.camera2.CameraDevice.StateCallback
        public void onError(CameraDevice cameraDevice, int i) {
            aa0.a("Camera2", "StateCallback onError camera: " + cameraDevice + ", error: " + i, new Object[0]);
            bf.this.k();
            bf.this.c = null;
        }

        @Override // android.hardware.camera2.CameraDevice.StateCallback
        public void onOpened(CameraDevice cameraDevice) {
            aa0.a("Camera2", "StateCallback onOpened camera: " + cameraDevice, new Object[0]);
            bf.this.c = cameraDevice;
            bf.this.o();
            bf.this.q = true;
            bf.this.r = false;
        }
    }

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class c extends CameraCaptureSession.StateCallback {
        public final /* synthetic */ CaptureRequest.Builder a;

        public c(CaptureRequest.Builder builder) {
            this.a = builder;
        }

        @Override // android.hardware.camera2.CameraCaptureSession.StateCallback
        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            aa0.a("Camera2", "onConfigureFailed: ", new Object[0]);
            CameraManagerNative.notifyCameraClosed();
            bf.this.closeCamera();
        }

        @Override // android.hardware.camera2.CameraCaptureSession.StateCallback
        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            try {
                aa0.a("Camera2", "onConfigured: session = " + cameraCaptureSession, new Object[0]);
                bf.this.h = cameraCaptureSession;
                CaptureRequest build = this.a.build();
                if (bf.this.h != null) {
                    bf.this.h.setRepeatingRequest(build, null, null);
                }
            } catch (Throwable th) {
                aa0.a("Camera2", "onConfigured: " + Log.getStackTraceString(th), new Object[0]);
            }
        }
    }

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class d implements ImageReader.OnImageAvailableListener {
        public d() {
        }

        @Override // android.media.ImageReader.OnImageAvailableListener
        public void onImageAvailable(ImageReader imageReader) {
            if (aa0.g()) {
                aa0.a("Camera2", "onImageAvailable start", new Object[0]);
            }
            long currentTimeMillis = System.currentTimeMillis();
            if (bf.this.y == null) {
                bf.this.y = new ArCameraFrameInfo();
            }
            bf.this.y.mReceiveImageTimeStamp = currentTimeMillis;
            if (bf.this.u != 0) {
                long j = currentTimeMillis - bf.this.u;
                if (bf.this.w.minIntervalTime > j || bf.this.w.minIntervalTime == 0) {
                    bf.this.w.minIntervalTime = j;
                }
                if (bf.this.w.maxIntervalTime < j || bf.this.w.maxIntervalTime == 0) {
                    bf.this.w.maxIntervalTime = j;
                }
                bf.this.o.add(Long.valueOf(j));
            }
            bf.this.u = currentTimeMillis;
            synchronized (bf.this.e) {
                if (imageReader != null) {
                    Image acquireNextImage = imageReader.acquireNextImage();
                    if (aa0.g()) {
                        aa0.a("Camera2", "onImageAvailable image= " + acquireNextImage, new Object[0]);
                    }
                    if (acquireNextImage != null) {
                        if (bf.this.s == 0) {
                            bf.this.s = System.currentTimeMillis();
                        }
                        if (System.currentTimeMillis() - bf.this.s < 1000) {
                            bf.e(bf.this);
                        } else {
                            aa0.a("Camera2", "onImageAvailable FPS:" + bf.this.t, new Object[0]);
                            bf.this.t = 0L;
                            bf.this.s = 0L;
                            bf.this.h();
                            aa0.a("Camera2", "realReceiveImageFps:" + bf.this.w.realReceiveImageFps + ", realGetImageFps:" + bf.this.w.realGetImageFps, new Object[0]);
                        }
                    }
                    bf.this.a(acquireNextImage);
                    if (acquireNextImage != null) {
                        acquireNextImage.close();
                        bf.this.l.add(Long.valueOf(currentTimeMillis));
                    }
                }
            }
            long currentTimeMillis2 = System.currentTimeMillis();
            if (aa0.g()) {
                aa0.a("Camera2", "onImageAvailable end, startReceiveTimeStamp:" + currentTimeMillis + ", endReceiveTimeStamp:" + currentTimeMillis2 + ", consumeTime:" + (currentTimeMillis2 - currentTimeMillis), new Object[0]);
            }
        }
    }

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class e implements Runnable {
        public e() {
        }

        @Override // java.lang.Runnable
        public void run() {
            if (1 == bf.this.C.get()) {
                bf.this.r = true;
                CameraManagerNative.notifyCameraRestartEnd();
                bf.this.b(0);
            }
        }
    }

    /* compiled from: Camera2.java */
    /* loaded from: classes.dex */
    public class f implements Runnable {
        public f() {
        }

        @Override // java.lang.Runnable
        public void run() {
            if (aa0.g()) {
                aa0.a("Camera2", "notify the consume thread!", new Object[0]);
            }
            synchronized (bf.this.p) {
                bf.this.p.notify();
            }
        }
    }

    public bf() {
        this.z = 0;
        i();
        aa0.a("Camera2", "priority:" + this.F, new Object[0]);
        if (this.F != 0) {
            this.D = new HandlerThread("CameraHandler", this.F);
        } else {
            this.D = new HandlerThread("CameraHandler", this.G);
        }
        this.D.start();
        this.E = new Handler(this.D.getLooper());
        if (new File("/sdcard/amapauto9/normal.txt").exists()) {
            this.z = 1;
        }
        ArCameraBaseInfo arCameraBaseInfo = this.x;
        int i = this.z;
        arCameraBaseInfo.workMode = i;
        this.w.workMode = i;
        aa0.a("Camera2", "mCurrentWorkMode:" + this.z, new Object[0]);
    }

    public static /* synthetic */ long e(bf bfVar) {
        long j = bfVar.t;
        bfVar.t = 1 + j;
        return j;
    }

    @Override // defpackage.ef
    public boolean closeCamera() {
        aa0.a("Camera2", "closeCamera: ", new Object[0]);
        try {
            if (this.h != null) {
                this.h.stopRepeating();
                this.h.abortCaptures();
                this.h.close();
                this.h = null;
            }
        } catch (Exception e2) {
            aa0.a("Camera2", "stopRepeating: stack = " + Log.getStackTraceString(e2), new Object[0]);
        }
        aa0.a("Camera2", "closeCamera", new Object[0]);
        try {
            if (this.c != null) {
                this.c.close();
                this.c = null;
            }
        } catch (Exception e3) {
            aa0.a("Camera2", "closeCamera: stack = " + Log.getStackTraceString(e3), new Object[0]);
        }
        aa0.a("Camera2", "close imageReader", new Object[0]);
        try {
            try {
                synchronized (this.e) {
                    this.s = 0L;
                    this.t = 0L;
                    if (this.d != null) {
                        this.d.close();
                        this.d = null;
                    }
                }
                aa0.a("Camera2", "closeCamera end!", new Object[0]);
                this.q = false;
                this.r = false;
                CameraManagerNative.notifyCameraRestartEnd();
                Handler handler = this.E;
                if (handler != null) {
                    handler.removeCallbacksAndMessages(null);
                }
                synchronized (this.m) {
                    this.n.clear();
                }
                this.l.clear();
                this.o.clear();
                this.u = 0L;
                this.v = 0L;
                synchronized (this.p) {
                    this.i.a();
                    this.p.notify();
                }
                return true;
            } catch (Exception e4) {
                aa0.a("Camera2", "closeImageReader: stack = " + Log.getStackTraceString(e4), new Object[0]);
                this.q = false;
                this.r = false;
                CameraManagerNative.notifyCameraRestartEnd();
                Handler handler2 = this.E;
                if (handler2 != null) {
                    handler2.removeCallbacksAndMessages(null);
                }
                synchronized (this.m) {
                    this.n.clear();
                    this.l.clear();
                    this.o.clear();
                    this.u = 0L;
                    this.v = 0L;
                    synchronized (this.p) {
                        this.i.a();
                        this.p.notify();
                        return true;
                    }
                }
            }
        } catch (Throwable th) {
            this.q = false;
            this.r = false;
            CameraManagerNative.notifyCameraRestartEnd();
            Handler handler3 = this.E;
            if (handler3 != null) {
                handler3.removeCallbacksAndMessages(null);
            }
            synchronized (this.m) {
                this.n.clear();
                this.l.clear();
                this.o.clear();
                this.u = 0L;
                this.v = 0L;
                synchronized (this.p) {
                    this.i.a();
                    this.p.notify();
                    throw th;
                }
            }
        }
    }

    @Override // defpackage.ef
    public boolean d() {
        aa0.a("Camera2", "unInitCamera", new Object[0]);
        this.g = null;
        return false;
    }

    @Override // defpackage.ef
    public ImageInfo e() {
        aa0.a("Camera2", "requestCameraData isCameraOpen:" + this.q, new Object[0]);
        if (!this.q) {
            return null;
        }
        this.v = System.currentTimeMillis();
        synchronized (this.m) {
            this.n.add(Long.valueOf(this.v));
        }
        return m();
    }

    @Override // defpackage.ye, defpackage.ef
    public ArPerfInfo f() {
        return this.w;
    }

    public final void h() {
        this.w.realReceiveImageFps = c(this.l);
        synchronized (this.m) {
            this.w.realGetImageFps = c(this.n);
        }
        this.w.realIntervalTime = b(this.o);
        this.o.clear();
        aa0.a("Camera2", "realIntervalTime:" + this.w.realIntervalTime, new Object[0]);
        ArPerfInfo arPerfInfo = this.w;
        if (arPerfInfo.minReceiveImageFps == 0.0f) {
            arPerfInfo.minReceiveImageFps = arPerfInfo.realReceiveImageFps;
        }
        ArPerfInfo arPerfInfo2 = this.w;
        if (arPerfInfo2.maxReceiveImageFps == 0.0f) {
            arPerfInfo2.maxReceiveImageFps = arPerfInfo2.realReceiveImageFps;
        }
        ArPerfInfo arPerfInfo3 = this.w;
        if (arPerfInfo3.minRealGetImageFps == 0.0f) {
            arPerfInfo3.minRealGetImageFps = arPerfInfo3.realGetImageFps;
        }
        ArPerfInfo arPerfInfo4 = this.w;
        if (arPerfInfo4.maxRealGetImageFps == 0.0f) {
            arPerfInfo4.maxRealGetImageFps = arPerfInfo4.realGetImageFps;
        }
        ArPerfInfo arPerfInfo5 = this.w;
        float f2 = arPerfInfo5.minRealGetImageFps;
        float f3 = arPerfInfo5.realGetImageFps;
        if (f2 > f3) {
            arPerfInfo5.minRealGetImageFps = f3;
        }
        ArPerfInfo arPerfInfo6 = this.w;
        float f4 = arPerfInfo6.maxRealGetImageFps;
        float f5 = arPerfInfo6.realGetImageFps;
        if (f4 < f5) {
            arPerfInfo6.maxRealGetImageFps = f5;
        }
        ArPerfInfo arPerfInfo7 = this.w;
        float f6 = arPerfInfo7.minReceiveImageFps;
        float f7 = arPerfInfo7.realReceiveImageFps;
        if (f6 > f7) {
            arPerfInfo7.minReceiveImageFps = f7;
        }
        ArPerfInfo arPerfInfo8 = this.w;
        float f8 = arPerfInfo8.maxReceiveImageFps;
        float f9 = arPerfInfo8.realReceiveImageFps;
        if (f8 < f9) {
            arPerfInfo8.maxReceiveImageFps = f9;
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r1v5, types: [java.lang.Object[]] */
    /* JADX WARN: Type inference failed for: r1v6, types: [java.lang.Object[]] */
    /* JADX WARN: Type inference failed for: r1v8, types: [java.lang.Object[]] */
    /* JADX WARN: Type inference failed for: r5v13, types: [java.lang.String] */
    public void i() {
        FileInputStream fileInputStream;
        String str = "close stack = ";
        File file = new File("/sdcard/amapauto9/priority.txt");
        if (!file.exists()) {
            return;
        }
        FileInputStream fileInputStream2 = null;
        FileInputStream fileInputStream3 = null;
        FileInputStream fileInputStream4 = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
            } catch (FileNotFoundException e2) {
                e = e2;
            } catch (IOException e3) {
                e = e3;
            }
            try {
                byte[] bArr = new byte[fileInputStream.available()];
                int read = fileInputStream.read(bArr);
                int i = read;
                if (read > 0) {
                    this.F = Integer.parseInt(this.A.matcher(new String(bArr)).replaceAll("").trim());
                    i = "";
                }
                try {
                    fileInputStream.close();
                    str = str;
                    fileInputStream2 = i;
                } catch (Exception e4) {
                    ?? r1 = new Object[0];
                    aa0.a("Camera2", "close stack = " + Log.getStackTraceString(e4), (Object[]) r1);
                    str = r1;
                    fileInputStream2 = i;
                }
            } catch (FileNotFoundException e5) {
                e = e5;
                fileInputStream3 = fileInputStream;
                aa0.a("Camera2", "checkThreadPriortiy stack = " + Log.getStackTraceString(e), new Object[0]);
                str = str;
                fileInputStream2 = fileInputStream3;
                if (fileInputStream3 != null) {
                    try {
                        fileInputStream3.close();
                        str = str;
                        fileInputStream2 = fileInputStream3;
                    } catch (Exception e6) {
                        ?? r12 = new Object[0];
                        aa0.a("Camera2", "close stack = " + Log.getStackTraceString(e6), (Object[]) r12);
                        str = r12;
                        fileInputStream2 = fileInputStream3;
                    }
                }
            } catch (IOException e7) {
                e = e7;
                fileInputStream4 = fileInputStream;
                aa0.a("Camera2", "checkThreadPriortiy stack = " + Log.getStackTraceString(e), new Object[0]);
                str = str;
                fileInputStream2 = fileInputStream4;
                if (fileInputStream4 != null) {
                    try {
                        fileInputStream4.close();
                        str = str;
                        fileInputStream2 = fileInputStream4;
                    } catch (Exception e8) {
                        ?? r13 = new Object[0];
                        aa0.a("Camera2", "close stack = " + Log.getStackTraceString(e8), (Object[]) r13);
                        str = r13;
                        fileInputStream2 = fileInputStream4;
                    }
                }
            } catch (Throwable th) {
                th = th;
                fileInputStream2 = fileInputStream;
                if (fileInputStream2 != null) {
                    try {
                        fileInputStream2.close();
                    } catch (Exception e9) {
                        aa0.a("Camera2", str + Log.getStackTraceString(e9), new Object[0]);
                    }
                }
                throw th;
            }
        } catch (Throwable th2) {
            th = th2;
        }
    }

    public int j() {
        ArCameraParam arCameraParam = this.a;
        if (arCameraParam == null) {
            aa0.a("Camera2", "cameraParam is null!", new Object[0]);
            return 0;
        }
        return c(arCameraParam.format);
    }

    public final void k() {
        if (!this.r) {
            n();
        } else {
            CameraManagerNative.notifyCameraClosed();
            closeCamera();
        }
    }

    @SuppressLint({"MissingPermission"})
    public final boolean l() {
        if (this.b == null) {
            aa0.a("Camera2", "manager is null!", new Object[0]);
            return false;
        }
        try {
            String a2 = oq.i().a(oq.i, AmapLoc.RESULT_TYPE_CELL_ONLY);
            aa0.a("Camera2", "customCameraId:" + a2, new Object[0]);
            if (!AmapLoc.RESULT_TYPE_CELL_ONLY.equalsIgnoreCase(a2)) {
                CameraCharacteristics cameraCharacteristics = this.b.getCameraCharacteristics(a2);
                if (cameraCharacteristics != null) {
                    StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap) cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    if (streamConfigurationMap != null && this.a != null) {
                        this.f = a(streamConfigurationMap.getOutputSizes(j()), this.a.width, this.a.height);
                        aa0.a("Camera2", "previewSize:" + this.f, new Object[0]);
                    }
                    this.B = a2;
                    aa0.a("Camera2", "use the custom Id,  currentCameraId:" + this.B, new Object[0]);
                    this.b.openCamera(a2, this.H, this.E);
                    return true;
                }
                aa0.a("Camera2", "characteristics is null!", new Object[0]);
            }
            String[] cameraIdList = this.b.getCameraIdList();
            int length = cameraIdList.length;
            int i = 0;
            while (true) {
                if (i >= length) {
                    break;
                }
                String str = cameraIdList[i];
                CameraCharacteristics cameraCharacteristics2 = this.b.getCameraCharacteristics(str);
                if (cameraCharacteristics2 != null) {
                    StreamConfigurationMap streamConfigurationMap2 = (StreamConfigurationMap) cameraCharacteristics2.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    if (streamConfigurationMap2 != null && this.a != null) {
                        this.f = a(streamConfigurationMap2.getOutputSizes(j()), this.a.width, this.a.height);
                        aa0.a("Camera2", "previewSize:" + this.f, new Object[0]);
                    }
                    if (g() != null) {
                        str = g();
                    }
                    this.x.cameraId = str;
                    aa0.a("Camera2", "cameraId:" + str, new Object[0]);
                    this.b.openCamera(str, this.H, this.E);
                } else {
                    aa0.a("Camera2", "characteristics is null!", new Object[0]);
                    i++;
                }
            }
        } catch (CameraAccessException e2) {
            aa0.a("Camera2", "CameraAccessException:" + Log.getStackTraceString(e2), new Object[0]);
        } catch (Exception e3) {
            aa0.a("Camera2", "exception:" + Log.getStackTraceString(e3), new Object[0]);
        }
        return true;
    }

    public final ImageInfo m() {
        long j;
        if (this.z == 0) {
            if (this.i.a(1) == null) {
                aa0.a("Camera2", "curImageInfo is null!", new Object[0]);
                j = System.currentTimeMillis();
                synchronized (this.p) {
                    try {
                        this.p.wait(300L);
                    } catch (InterruptedException e2) {
                        aa0.a("Camera2", e2.toString(), e2, new Object[0]);
                    }
                }
            } else {
                j = 0;
            }
            if (j != 0) {
                aa0.a("Camera2", "wait time:" + (System.currentTimeMillis() - j), new Object[0]);
            }
            kf.a<ArImage> a2 = this.i.a(1);
            this.k = a2;
            if (a2 == null) {
                aa0.a("Camera2", "after wait, get the null image", new Object[0]);
                return null;
            }
            ArImage a3 = a2.a();
            this.j = a3;
            if (a3 == null) {
                return null;
            }
            a3.mFrameInfo.mDequeueTimeStamp = System.currentTimeMillis();
            this.w.frameInfos.add(this.j.mFrameInfo);
            if (this.w.frameInfos.size() > 30) {
                this.w.frameInfos.remove(0);
            }
            this.k.a(2);
            aa0.a("Camera2", "readImage: imageInfo = " + this.j, new Object[0]);
            return this.j.imageInfo;
        }
        synchronized (this.e) {
            if (this.d != null) {
                Image acquireNextImage = this.d.acquireNextImage();
                aa0.a("Camera2", "requestImage image= " + acquireNextImage, new Object[0]);
                if (acquireNextImage != null) {
                    if (this.s == 0) {
                        this.s = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - this.s < 1000) {
                        this.t++;
                    } else {
                        aa0.a("Camera2", "onImageAvailable FPS:" + this.t, new Object[0]);
                        this.t = 0L;
                        this.s = 0L;
                        h();
                        aa0.a("Camera2", "realGetImageFps:" + this.w.realGetImageFps, new Object[0]);
                    }
                    ImageInfo a4 = a(acquireNextImage);
                    acquireNextImage.close();
                    return a4;
                }
            }
            return null;
        }
    }

    public void n() {
        aa0.a("Camera2", "restartCamera start", new Object[0]);
        if (1 == this.C.get()) {
            closeCamera();
            CameraManagerNative.notifyCameraRestartBegin();
            this.E.postDelayed(new e(), 10000L);
        }
    }

    public final void o() {
        ImageReader imageReader;
        aa0.a("Camera2", "startPreview: ", new Object[0]);
        try {
        } catch (Exception e2) {
            aa0.a("Camera2", "startPreview: stack = {?}", Log.getStackTraceString(e2));
        }
        if (this.c == null) {
            aa0.a("Camera2", "curCamera is null", new Object[0]);
            return;
        }
        if (this.f == null) {
            aa0.a("Camera2", "previewSize is null", new Object[0]);
            return;
        }
        this.x.outWidth = this.f.getWidth();
        this.x.outHeight = this.f.getHeight();
        this.x.outFormat = j();
        this.d = ImageReader.newInstance(this.f.getWidth(), this.f.getHeight(), j(), 5);
        aa0.a("Camera2", "startPreview: imageReader = " + this.d, new Object[0]);
        if (this.d == null) {
            aa0.a("Camera2", "imageReader is null", new Object[0]);
            return;
        }
        CaptureRequest.Builder createCaptureRequest = this.c.createCaptureRequest(1);
        if (createCaptureRequest == null) {
            aa0.a("Camera2", "builder is null", new Object[0]);
            return;
        }
        a(createCaptureRequest);
        createCaptureRequest.addTarget(this.g == null ? this.d.getSurface() : this.g);
        this.c.createCaptureSession(Arrays.asList(this.d.getSurface()), new c(createCaptureRequest), this.E);
        if (this.z != 0 || (imageReader = this.d) == null) {
            return;
        }
        imageReader.setOnImageAvailableListener(new d(), this.E);
    }

    @Override // defpackage.ef
    public boolean c() {
        aa0.a("Camera2", "isCameraOpen:" + this.q, new Object[0]);
        return this.q;
    }

    @Override // defpackage.ef
    public boolean b(int i) {
        aa0.a("Camera2", "openCamera isCameraOpen:" + this.q, new Object[0]);
        if (this.q) {
            return true;
        }
        return l();
    }

    public final int c(int i) {
        aa0.a("Camera2", "convertCustomCameraFormat: format = " + i, new Object[0]);
        if (i == 33554483) {
            return 1;
        }
        if (i == 33554482) {
            return 3;
        }
        return i;
    }

    public float c(ArrayList<Long> arrayList) {
        int i;
        long currentTimeMillis = System.currentTimeMillis() - 1000;
        int size = arrayList.size();
        int i2 = 0;
        aa0.a("Camera2", "timeCount:" + size, new Object[0]);
        if (size >= 2) {
            int i3 = size - 1;
            if (arrayList.get(i3).longValue() >= currentTimeMillis) {
                Long l = arrayList.get(i3);
                long longValue = l != null ? l.longValue() : 0L;
                int i4 = size - 2;
                long j = 0;
                int i5 = 0;
                while (true) {
                    if (i4 >= 0) {
                        Long l2 = arrayList.get(i4);
                        long longValue2 = l2 != null ? l2.longValue() : 0L;
                        if (longValue2 < currentTimeMillis) {
                            i = i4 + 1;
                            break;
                        }
                        i5++;
                        i4--;
                        j = longValue2;
                    } else {
                        i = 0;
                        break;
                    }
                }
                aa0.a("Camera2", "firstValid:" + longValue + ", fpsCount:" + i5 + ", lastValid:" + j + ", validIndex:" + i, new Object[0]);
                if (i > 0) {
                    Iterator<Long> it = arrayList.iterator();
                    while (it.hasNext()) {
                        it.next();
                        i2++;
                        if (i2 >= i) {
                            break;
                        }
                        it.remove();
                    }
                }
                if (i5 == 0) {
                    return 1.0f;
                }
                long j2 = longValue - j;
                if (j2 == 0) {
                    return 1.0f;
                }
                double d2 = i5;
                Double.isNaN(d2);
                double d3 = j2;
                Double.isNaN(d3);
                return (float) ((d2 * 1000.0d) / d3);
            }
        }
        aa0.a("Camera2", "have no enough time", new Object[0]);
        return 0.0f;
    }

    public long b(ArrayList<Long> arrayList) {
        int size;
        long j = 0;
        if (arrayList == null || (size = arrayList.size()) <= 0) {
            return 0L;
        }
        for (int i = 0; i < size; i++) {
            j += arrayList.get(i).longValue();
        }
        return j / size;
    }

    @Override // defpackage.ef
    public boolean a(ArCameraParam arCameraParam) {
        this.a = arCameraParam;
        aa0.a("Camera2", "initCamera:", new Object[0]);
        if (arCameraParam == null) {
            return true;
        }
        ArCameraBaseInfo arCameraBaseInfo = this.x;
        arCameraBaseInfo.inFormat = arCameraParam.format;
        arCameraBaseInfo.inWidth = arCameraParam.width;
        arCameraBaseInfo.inHeight = arCameraParam.height;
        aa0.a("Camera2", "initCamera:" + arCameraParam, new Object[0]);
        return true;
    }

    @Override // defpackage.ye, defpackage.ef
    public void b() {
        kf.a<ArImage> aVar = this.k;
        if (aVar != null && aVar.b() == 2) {
            this.k.a(0);
        }
        aa0.a("Camera2", "releaseImageInfo! curImageInfo:" + this.j + ", reqConsumeTime:" + (System.currentTimeMillis() - this.v), new Object[0]);
    }

    public void a(CaptureRequest.Builder builder) {
        aa0.a("Camera2", "camera2 initImageReaderBuilder", new Object[0]);
    }

    public Size a(Size[] sizeArr, int i, int i2) {
        int length = sizeArr == null ? 0 : sizeArr.length;
        aa0.a("Camera2", "length:" + length + ",sizeMap:" + sizeArr + ",width:" + i + ",height:" + i2, new Object[0]);
        if (sizeArr != null && length > 0) {
            ArrayList arrayList = new ArrayList();
            for (Size size : sizeArr) {
                if (i > i2) {
                    if (size.getWidth() >= i && size.getHeight() >= i2) {
                        arrayList.add(size);
                    }
                } else if (size.getWidth() >= i2 && size.getHeight() >= i) {
                    arrayList.add(size);
                }
            }
            aa0.a("Camera2", "size:" + arrayList.size(), new Object[0]);
            if (arrayList.size() > 0) {
                return (Size) Collections.min(arrayList, new a(this));
            }
            return sizeArr[0];
        }
        return new Size(i, i2);
    }

    @Override // defpackage.ye, defpackage.ef
    public void a(SurfaceTexture surfaceTexture) {
        this.g = new Surface(surfaceTexture);
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r10v3, types: [java.lang.StringBuilder] */
    /* JADX WARN: Type inference failed for: r1v1 */
    /* JADX WARN: Type inference failed for: r1v12 */
    /* JADX WARN: Type inference failed for: r1v13 */
    /* JADX WARN: Type inference failed for: r1v14 */
    /* JADX WARN: Type inference failed for: r1v2 */
    /* JADX WARN: Type inference failed for: r1v21 */
    /* JADX WARN: Type inference failed for: r1v22 */
    /* JADX WARN: Type inference failed for: r1v3, types: [int] */
    /* JADX WARN: Type inference failed for: r1v5, types: [boolean] */
    /* JADX WARN: Type inference failed for: r1v6 */
    @Override // defpackage.ye, defpackage.ef
    public int a(ArrayList<Integer> arrayList) {
        ?? r1;
        StreamConfigurationMap streamConfigurationMap;
        int[] outputFormats;
        StreamConfigurationMap streamConfigurationMap2;
        int[] outputFormats2;
        aa0.a("Camera2", "getCameraSupportFormat: start", new Object[0]);
        try {
            r1 = TextUtils.isEmpty(this.B);
        } catch (CameraAccessException e2) {
            e = e2;
            r1 = 0;
        }
        try {
        } catch (CameraAccessException e3) {
            e = e3;
            aa0.a("Camera2", Log.getStackTraceString(e), e, new Object[0]);
            aa0.a("Camera2", "getCameraSupportFormat: supportNums = " + r1, new Object[0]);
            return r1;
        }
        if (r1 == 0) {
            CameraCharacteristics cameraCharacteristics = this.b.getCameraCharacteristics(this.B);
            if (cameraCharacteristics != null && (streamConfigurationMap2 = (StreamConfigurationMap) cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) != null && (outputFormats2 = streamConfigurationMap2.getOutputFormats()) != null && outputFormats2.length > 0) {
                aa0.a("Camera2", "getCameraSupportFormat: target formats = " + outputFormats2, new Object[0]);
                int a2 = a(outputFormats2, arrayList);
                aa0.a("Camera2", "getCameraSupportFormat: formats = " + arrayList, new Object[0]);
                r1 = a2;
                break;
                aa0.a("Camera2", "getCameraSupportFormat: supportNums = " + r1, new Object[0]);
                return r1;
            }
            r1 = 0;
            aa0.a("Camera2", "getCameraSupportFormat: supportNums = " + r1, new Object[0]);
            return r1;
        }
        for (String str : this.b.getCameraIdList()) {
            CameraCharacteristics cameraCharacteristics2 = this.b.getCameraCharacteristics(str);
            if (cameraCharacteristics2 != null && (streamConfigurationMap = (StreamConfigurationMap) cameraCharacteristics2.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) != null && (outputFormats = streamConfigurationMap.getOutputFormats()) != null && outputFormats.length > 0) {
                aa0.a("Camera2", "getCameraSupportFormat: target formats = " + outputFormats, new Object[0]);
                int a3 = a(outputFormats, arrayList);
                aa0.a("Camera2", "getCameraSupportFormat: formats = " + arrayList, new Object[0]);
                r1 = a3;
                break;
            }
        }
        r1 = 0;
        aa0.a("Camera2", "getCameraSupportFormat: supportNums = " + r1, new Object[0]);
        return r1;
    }

    public final int a(int[] iArr, ArrayList<Integer> arrayList) {
        int i;
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(17);
        arrayList2.add(35);
        arrayList2.add(39);
        arrayList2.add(Integer.valueOf(ArCameraParam.IMAGE_TYPE_YV_12));
        arrayList2.add(1);
        arrayList2.add(3);
        if (iArr != null && iArr.length > 0) {
            aa0.a("Camera2", "getCameraSupportFormat: length = " + iArr.length, new Object[0]);
            i = 0;
            for (int i2 : iArr) {
                if (arrayList2.contains(Integer.valueOf(i2)) && i < 5) {
                    arrayList.add(Integer.valueOf(i2));
                    i++;
                }
            }
        } else {
            aa0.a("Camera2", "no srcFormats!", new Object[0]);
            i = 0;
        }
        aa0.a("Camera2", "nums:" + i, new Object[0]);
        return i;
    }

    @Override // defpackage.ye, defpackage.ef
    public void a(int i) {
        this.C.set(i);
    }

    public final ImageInfo a(Image image) {
        ImageChannel imageChannel;
        if (image == null) {
            return null;
        }
        kf.a<ArImage> a2 = this.i.a(0);
        if (a2 == null) {
            synchronized (this.p) {
                aa0.a("Camera2", "arImage is null!", new Object[0]);
                a2 = this.i.a(1);
                if (a2 == null) {
                    aa0.a("Camera2", "have no usable cache data!", new Object[0]);
                    return null;
                }
                a2.a(0);
            }
        }
        ArImage a3 = a2.a();
        if (a3 == null) {
            a3 = new ArImage();
            a2.a((kf.a<ArImage>) a3);
        }
        ImageInfo imageInfo = a3.imageInfo;
        imageInfo.format = image.getFormat();
        imageInfo.width = image.getWidth();
        imageInfo.height = image.getHeight();
        imageInfo.timestamp = System.currentTimeMillis();
        a2.a(System.currentTimeMillis());
        if (aa0.g()) {
            aa0.a("Camera2", "format:" + imageInfo.format + ", width:" + imageInfo.width + ", height:" + imageInfo.height + ",timestamp:" + imageInfo.timestamp + ", curTimestamp:" + System.currentTimeMillis(), new Object[0]);
        }
        Image.Plane[] planes = image.getPlanes();
        if (aa0.g()) {
            aa0.a("Camera2", "readImage: planes = " + planes, new Object[0]);
        }
        if (planes == null) {
            aa0.a("Camera2", "planes is null!", new Object[0]);
            return null;
        }
        int length = planes.length;
        if (aa0.g()) {
            aa0.a("Camera2", "readImage: planes count= " + length, new Object[0]);
        }
        for (int i = 0; i < length; i++) {
            if (i < imageInfo.data.size()) {
                imageChannel = imageInfo.data.get(i);
            } else {
                imageChannel = new ImageChannel();
                imageInfo.data.add(imageChannel);
            }
            if (imageChannel == null) {
                aa0.a("Camera2", "error:channel is null!", new Object[0]);
                return null;
            }
            Image.Plane plane = planes[i];
            ByteBuffer buffer = plane.getBuffer();
            if (buffer.hasArray()) {
                imageChannel.data = buffer.array();
            } else {
                byte[] bArr = imageChannel.data;
                if (bArr == null || bArr.length != buffer.remaining()) {
                    imageChannel.data = new byte[buffer.remaining()];
                }
                buffer.get(imageChannel.data);
            }
            imageChannel.rowStride = plane.getRowStride();
            imageChannel.pixelStride = plane.getPixelStride();
            imageChannel.dataSize = imageChannel.data.length;
            if (aa0.g()) {
                aa0.a("Camera2", "readImage: channel.rowStride={?},channel.pixelStride={?},channel.dataSize={?}", Integer.valueOf(imageChannel.rowStride), Integer.valueOf(imageChannel.pixelStride), Integer.valueOf(imageChannel.dataSize));
            }
        }
        a2.a(1);
        if (this.z == 0) {
            ArCameraFrameInfo arCameraFrameInfo = this.y;
            a3.mFrameInfo = arCameraFrameInfo;
            arCameraFrameInfo.mEnqueueTimeStamp = System.currentTimeMillis();
            this.y = null;
            this.E.post(new f());
        }
        if (aa0.g()) {
            aa0.a("Camera2", "convertImageData! arImage:" + a3, new Object[0]);
        }
        return imageInfo;
    }

    @Override // defpackage.ye, defpackage.ef
    public ArCameraBaseInfo a() {
        return this.x;
    }
}
