package defpackage;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.autonavi.common.tool.dumpcrash;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/* compiled from: SoCollector.java */
/* loaded from: classes.dex */
public class bj0 {
    public static String c = "";
    public static String d = "";
    public static final String[] a = {"/system/lib/libEGL.so", "/system/lib/libc.so", "/system/lib/libc++.so", "/system/lib/libandroid_runtime.so", "/system/lib/libui.so", "/system/lib/libhwui.so", "/system/lib/libgui.so", "/system/lib/libdvm.so", "/system/lib/libart.so", "/system/lib/libandroid.so", "/system/bin/linker", "/system/lib/libhwaps.so", "/system/lib/egl/libEGL_VIVANTE.so"};
    public static final String[] b = {"/system/vendor/lib/egl/"};
    public static List<String> e = new ArrayList();

    /* compiled from: SoCollector.java */
    /* loaded from: classes.dex */
    public class a implements FilenameFilter {
        @Override // java.io.FilenameFilter
        public boolean accept(File file, String str) {
            return str.endsWith(".so");
        }
    }

    /* compiled from: SoCollector.java */
    /* loaded from: classes.dex */
    public static class b {
        public String a;
        public File b;
        public long c;
        public long d;

        public boolean equals(Object obj) {
            return false;
        }

        public String toString() {
            return "SoFile:" + this.b + "\tSoFileLength:" + this.c + "\tSoFileCrc32:" + this.d;
        }
    }

    /* compiled from: SoCollector.java */
    /* loaded from: classes.dex */
    public interface c {
        void a(int i);
    }

    public static Map<String, b> a(Context context) {
        int lastIndexOf;
        HashMap hashMap = new HashMap();
        try {
            long currentTimeMillis = System.currentTimeMillis();
            sj0.a("start dumpInApkLibsByJava");
            String str = context.getApplicationInfo().sourceDir;
            ZipFile zipFile = new ZipFile(str);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextElement = entries.nextElement();
                if (!nextElement.isDirectory()) {
                    String name = nextElement.getName();
                    if (!name.startsWith("..") && !name.startsWith(".") && name.length() >= 4 && name.endsWith(".so") && name.startsWith("lib/") && (lastIndexOf = name.lastIndexOf(47)) >= 0) {
                        int i = lastIndexOf + 1;
                        if (name.regionMatches(i, "lib", 0, 3)) {
                            String substring = name.substring(i);
                            b bVar = new b();
                            bVar.a = substring;
                            bVar.c = nextElement.getSize();
                            bVar.d = nextElement.getCrc();
                            bVar.b = new File(str, substring);
                            hashMap.put(substring, bVar);
                        }
                    }
                }
            }
            long currentTimeMillis2 = System.currentTimeMillis();
            zipFile.close();
            sj0.a("end dumpInApkLibsByJava time :" + (currentTimeMillis2 - currentTimeMillis));
        } catch (Exception e2) {
            sj0.a("dumpInApkLibsByJava error " + e2.getMessage());
        }
        return hashMap;
    }

    public static String b(Context context) {
        c(context);
        if (TextUtils.isEmpty(c) || TextUtils.isEmpty(d)) {
            return "";
        }
        return d + File.separator + c;
    }

    public static synchronized void c(Context context) {
        synchronized (bj0.class) {
            if (TextUtils.isEmpty(c)) {
                if (context == null) {
                    Application h = vi0.h();
                    if (h == null) {
                        return;
                    } else {
                        context = h.getApplicationContext();
                    }
                }
                try {
                    c = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
                    d = context.getDir("version", 0).getAbsolutePath();
                } catch (PackageManager.NameNotFoundException unused) {
                    sj0.a("get version name error");
                }
            }
        }
    }

    public static synchronized void d(Context context) {
        synchronized (bj0.class) {
            c(context);
            sj0.a("BASE_APK_VERSION = " + c + ",BASE_LIB_PATH" + d);
            if (!TextUtils.isEmpty(c) && !TextUtils.isEmpty(d)) {
                File file = new File(d);
                if (file.exists()) {
                    File[] listFiles = file.listFiles();
                    if (listFiles == null) {
                        return;
                    }
                    for (File file2 : listFiles) {
                        if (!c.equals(file2.getName())) {
                            qj0.a(file2);
                        }
                    }
                }
            }
        }
    }

    public static boolean b(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        return str.contains("UnsatisfiedLinkError") || str.contains("NoSuchMethodError") || str.contains("NoClassDefFoundError");
    }

    /* JADX WARN: Unreachable blocks removed: 1, instructions: 2 */
    public static String a(Application application, boolean[] zArr) {
        boolean z;
        boolean z2;
        boolean z3;
        Iterator<b> it;
        String str;
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("\nSOCrc32:\n");
            Map<String, b> a2 = a(application);
            String str2 = application.getApplicationInfo().nativeLibraryDir + File.separator;
            Iterator<b> it2 = a2.values().iterator();
            boolean z4 = false;
            while (it2.hasNext()) {
                try {
                    b next = it2.next();
                    String findLibrary = ((PathClassLoader) application.getClassLoader()).findLibrary(next.a);
                    if (TextUtils.isEmpty(findLibrary)) {
                        findLibrary = str2 + next.a;
                    }
                    Iterator<String> it3 = e.iterator();
                    while (true) {
                        if (!it3.hasNext()) {
                            z3 = false;
                            break;
                        }
                        File file = new File(it3.next() + File.separator + next.a);
                        if (file.exists()) {
                            b bVar = new b();
                            bVar.b = file;
                            bVar.a = file.getName();
                            bVar.d = cj0.a(file);
                            bVar.c = file.length();
                            sb.append("\t");
                            sb.append("SORight.");
                            sb.append("file=");
                            sb.append(bVar.b);
                            sb.append("\t len=");
                            sb.append(bVar.c);
                            sb.append("\t crc32=");
                            sb.append(cj0.a(bVar.d));
                            sb.append("\n");
                            z3 = true;
                            break;
                        }
                    }
                    if (!z3) {
                        File file2 = new File(findLibrary);
                        b bVar2 = new b();
                        if (file2.exists()) {
                            bVar2.b = file2;
                            bVar2.a = file2.getName();
                            bVar2.d = cj0.a(file2);
                            bVar2.c = file2.length();
                            String a3 = cj0.a(bVar2.d);
                            String a4 = cj0.a(next.d);
                            it = it2;
                            str = str2;
                            try {
                                if (bVar2.c == next.c && a3.equals(a4)) {
                                    sb.append("\t");
                                    sb.append("SORight.");
                                    sb.append("file=");
                                    sb.append(bVar2.b);
                                    sb.append("\t len=");
                                    sb.append(bVar2.c);
                                    sb.append("\t crc32=");
                                    sb.append(a3);
                                    sb.append("\n");
                                    str2 = str;
                                    it2 = it;
                                }
                                sb.append("\t");
                                sb.append("SOCorrupt.");
                                sb.append("file=");
                                sb.append(bVar2.b);
                                sb.append("\t rightLen=");
                                sb.append(next.c);
                                sb.append("\t curLen=");
                                sb.append(bVar2.c);
                                sb.append("\t rightCrc32=");
                                sb.append(a4);
                                sb.append("\t curCrc32=");
                                sb.append(a3);
                                sb.append("\n");
                            } catch (Exception unused) {
                                z2 = true;
                                if (zArr != null) {
                                    zArr[0] = z2;
                                }
                                sb.append(a());
                                sj0.a("finish getSoInfo");
                                return sb.toString();
                            } catch (Throwable th) {
                                th = th;
                                z = true;
                                if (zArr != null) {
                                    zArr[0] = z;
                                }
                                throw th;
                            }
                        } else {
                            it = it2;
                            str = str2;
                            sb.append("\t");
                            sb.append("SOLose.");
                            sb.append("file=");
                            sb.append(next.b);
                            sb.append("\t len=");
                            sb.append(next.c);
                            sb.append("\t crc32=");
                            sb.append(cj0.a(next.d));
                            sb.append("\n");
                        }
                        z4 = true;
                        str2 = str;
                        it2 = it;
                    }
                } catch (Exception unused2) {
                    z2 = z4;
                } catch (Throwable th2) {
                    th = th2;
                    z = z4;
                }
            }
            if (zArr != null) {
                zArr[0] = z4;
            }
        } catch (Exception unused3) {
            z2 = false;
        } catch (Throwable th3) {
            th = th3;
            z = false;
        }
        sb.append(a());
        sj0.a("finish getSoInfo");
        return sb.toString();
    }

    public static boolean a(Throwable th) {
        if (th == null) {
            return false;
        }
        return cj0.a(th, (Class<?>) UnsatisfiedLinkError.class) || cj0.a(th, (Class<?>) NoClassDefFoundError.class) || cj0.a(th, (Class<?>) NoSuchMethodError.class);
    }

    public static boolean a(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        return str.contains("Lcom/autonavi/common/tool/dumpcrash") || str.contains(dumpcrash.LIB_DUMPCRASH_FULL_NAME);
    }

    /* JADX WARN: Code restructure failed: missing block: B:41:0x00c5, code lost:            r10 = new bj0.b();        r10.b = r5;        r10.a = r5.getName();     */
    /* JADX WARN: Code restructure failed: missing block: B:42:0x00d2, code lost:            r19 = r7;        r20 = r8;     */
    /* JADX WARN: Code restructure failed: missing block: B:44:0x00d6, code lost:            r10.d = defpackage.cj0.a(r5);        r10.c = r5.length();        r2.append("\t");        r2.append("SORight.");        r2.append("file=");        r2.append(r10.b);        r2.append("\t len=");        r2.append(r10.c);        r2.append("\t crc32=");        r2.append(defpackage.cj0.a(r10.d));        r2.append("\n");        r5 = true;     */
    /* JADX WARN: Code restructure failed: missing block: B:71:0x0216, code lost:            r0 = e;     */
    /* JADX WARN: Code restructure failed: missing block: B:72:0x0217, code lost:            r7 = r19;     */
    /* JADX WARN: Code restructure failed: missing block: B:74:0x0237, code lost:            defpackage.sj0.a("getSoInfo error" + r0.getMessage());     */
    /* JADX WARN: Code restructure failed: missing block: B:75:0x0253, code lost:            if (a(r0) != false) goto L85;     */
    /* JADX WARN: Code restructure failed: missing block: B:76:0x0255, code lost:            defpackage.sj0.a("dump in apk error so mark soCorrupt as true");     */
    /* JADX WARN: Code restructure failed: missing block: B:77:0x025a, code lost:            r3 = true;     */
    /* JADX WARN: Code restructure failed: missing block: B:78:0x025d, code lost:            if (r21 != null) goto L89;     */
    /* JADX WARN: Code restructure failed: missing block: B:79:0x025f, code lost:            r21[0] = r3;     */
    /* JADX WARN: Code restructure failed: missing block: B:83:0x025c, code lost:            r3 = r7;     */
    /* JADX WARN: Code restructure failed: missing block: B:84:0x0273, code lost:            r0 = th;     */
    /* JADX WARN: Code restructure failed: missing block: B:85:0x0274, code lost:            r3 = r7;     */
    /* JADX WARN: Code restructure failed: missing block: B:86:0x0214, code lost:            r0 = th;     */
    /* JADX WARN: Code restructure failed: missing block: B:87:0x0225, code lost:            r3 = r19;     */
    /* JADX WARN: Removed duplicated region for block: B:26:0x0277  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static java.lang.String a(java.lang.Throwable r17, java.lang.String r18, android.app.Application r19, boolean r20, boolean[] r21) {
        /*
            Method dump skipped, instructions count: 637
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: defpackage.bj0.a(java.lang.Throwable, java.lang.String, android.app.Application, boolean, boolean[]):java.lang.String");
    }

    public static String a() {
        sj0.a("getSysLibSoInfo");
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; i++) {
            File file = new File(a[i]);
            if (file.exists()) {
                sj0.a(a[i] + " exists");
                a(sb, file);
            } else {
                sb.append("\tfile=");
                sb.append(a[i]);
                sb.append(" no exists");
                sb.append("\n");
            }
        }
        int length2 = b.length;
        for (int i2 = 0; i2 < length2; i2++) {
            File file2 = new File(b[i2]);
            if (file2.exists() && file2.isDirectory()) {
                File[] listFiles = file2.listFiles(new a());
                if (listFiles != null) {
                    for (File file3 : listFiles) {
                        if (file3.exists() && file3.isFile()) {
                            a(sb, file3);
                        }
                    }
                }
            } else {
                sb.append("\tpath=");
                sb.append(b[i2]);
                sb.append(" no exists");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static void a(StringBuilder sb, File file) {
        try {
            long length = file.length();
            String a2 = cj0.a(cj0.a(file));
            sb.append("\tfile=");
            sb.append(file.getAbsolutePath());
            sb.append("\tlen=");
            sb.append(length);
            sb.append("\tcrc_value=");
            sb.append(a2);
            sb.append("\n");
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void a(c cVar, Context context, long j) {
        a(cVar, context, j, "");
    }

    public static void a(c cVar, Context context, long j, String str) {
        if (context == null) {
            Application h = vi0.h();
            if (h == null) {
                sj0.a("dumpInApkLibs error as application = null");
                cVar.a(1);
                return;
            }
            context = h.getApplicationContext();
        }
        c(context);
        if (!TextUtils.isEmpty(c) && !TextUtils.isEmpty(d)) {
            File file = new File(d);
            if (!file.exists()) {
                file.mkdir();
            }
            File file2 = new File(file, c);
            if (file2.exists()) {
                sj0.a("has filedir and delete");
                qj0.a(file2);
            }
            file2.mkdirs();
            try {
                long usableSpace = file2.getUsableSpace();
                sj0.a("libpath = " + file2 + ",usableSpace = " + usableSpace);
                if (usableSpace < j) {
                    cVar.a(2);
                    return;
                }
                boolean a2 = a(context.getApplicationInfo().nativeLibraryDir, true, context, str);
                if (!a2) {
                    a2 = a(file2.getAbsolutePath(), false, context, str);
                }
                if (!a2) {
                    cVar.a(3);
                    return;
                } else {
                    cVar.a(0);
                    return;
                }
            } catch (Exception unused) {
                sj0.a("dumpInApkLibs error as usableSpace exception");
                cVar.a(2);
                return;
            }
        }
        sj0.a("dumpInApkLibs error as application = null");
        cVar.a(1);
    }

    public static boolean a(String str, boolean z, Context context, String str2) {
        String str3;
        boolean z2;
        ZipFile zipFile;
        FileOutputStream fileOutputStream;
        int lastIndexOf;
        boolean z3 = false;
        if (context == null) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (TextUtils.isEmpty(str2)) {
            str3 = "";
            z2 = true;
        } else {
            str3 = System.mapLibraryName(str2);
            z2 = false;
        }
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(context.getApplicationInfo().sourceDir);
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                fileOutputStream = null;
                while (true) {
                    try {
                        try {
                            if (!entries.hasMoreElements()) {
                                break;
                            }
                            ZipEntry nextElement = entries.nextElement();
                            if (!nextElement.isDirectory()) {
                                String name = nextElement.getName();
                                if (!name.startsWith("..") && !name.startsWith(".") && name.length() >= 4 && name.endsWith(".so") && name.startsWith("lib/") && (lastIndexOf = name.lastIndexOf(47)) >= 0) {
                                    int i = lastIndexOf + 1;
                                    if (name.regionMatches(i, "lib", 0, 3)) {
                                        String substring = name.substring(i);
                                        if (z2 || TextUtils.isEmpty(str3) || str3.equals(substring)) {
                                            inputStream = zipFile.getInputStream(nextElement);
                                            File file = new File(str, URLEncoder.encode(substring, "UTF-8"));
                                            if (!file.exists()) {
                                                File parentFile = file.getParentFile();
                                                if (!parentFile.exists()) {
                                                    parentFile.mkdirs();
                                                }
                                            }
                                            FileOutputStream fileOutputStream2 = new FileOutputStream(file);
                                            try {
                                                byte[] bArr = new byte[1048576];
                                                for (int read = inputStream.read(bArr); read != -1; read = inputStream.read(bArr)) {
                                                    fileOutputStream2.write(bArr, 0, read);
                                                }
                                                fileOutputStream2.close();
                                                inputStream.close();
                                                if (!z2 && !TextUtils.isEmpty(str3) && str3.equals(substring)) {
                                                    fileOutputStream = fileOutputStream2;
                                                    break;
                                                }
                                                fileOutputStream = fileOutputStream2;
                                            } catch (Exception e2) {
                                                e = e2;
                                                fileOutputStream = fileOutputStream2;
                                                sj0.a("dump file error " + e.getMessage());
                                                if (inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    } catch (Exception unused) {
                                                    }
                                                }
                                                if (fileOutputStream != null) {
                                                    fileOutputStream.close();
                                                }
                                                if (zipFile != null) {
                                                    zipFile.close();
                                                }
                                                sj0.a("all copy time = " + (System.currentTimeMillis() - currentTimeMillis));
                                                return z3;
                                            } catch (Throwable th) {
                                                th = th;
                                                fileOutputStream = fileOutputStream2;
                                                if (inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    } catch (Exception unused2) {
                                                        throw th;
                                                    }
                                                }
                                                if (fileOutputStream != null) {
                                                    fileOutputStream.close();
                                                }
                                                if (zipFile != null) {
                                                    zipFile.close();
                                                }
                                                throw th;
                                            }
                                        }
                                    }
                                }
                            }
                        } catch (Throwable th2) {
                            th = th2;
                        }
                    } catch (Exception e3) {
                        e = e3;
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (Exception unused3) {
                    }
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                zipFile.close();
                z3 = true;
            } catch (Exception e4) {
                e = e4;
                fileOutputStream = null;
            } catch (Throwable th3) {
                th = th3;
                fileOutputStream = null;
            }
        } catch (Exception e5) {
            e = e5;
            zipFile = null;
            fileOutputStream = null;
        } catch (Throwable th4) {
            th = th4;
            zipFile = null;
            fileOutputStream = null;
        }
        sj0.a("all copy time = " + (System.currentTimeMillis() - currentTimeMillis));
        return z3;
    }
}
