package defpackage;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/* compiled from: HttpResponse.java */
/* loaded from: classes.dex */
public abstract class bl0<T> {
    public byte[] mBodyData;
    public rk0 mImpl;
    public xk0 mRequest;
    public T mResult;

    public InputStream getBodyInputStream() {
        return this.mImpl.getBodyInputStream();
    }

    public long getContentLength() {
        return this.mImpl.getContentLength();
    }

    public String getHeader(String str) {
        return this.mImpl.getHeader(str);
    }

    public Map<String, List<String>> getHeaders() {
        return this.mImpl.getHeaders();
    }

    public xk0 getRequest() {
        return this.mRequest;
    }

    public byte[] getResponseBodyData() {
        InputStream bodyInputStream;
        if (this.mBodyData == null && (bodyInputStream = getBodyInputStream()) != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(bodyInputStream);
            byte[] bArr = new byte[512];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                try {
                    try {
                        int read = bufferedInputStream.read(bArr);
                        if (read == -1) {
                            break;
                        }
                        byteArrayOutputStream.write(bArr, 0, read);
                    } catch (IOException unused) {
                        this.mBodyData = null;
                    }
                } finally {
                    ok0.a(bufferedInputStream);
                }
            }
            this.mBodyData = byteArrayOutputStream.toByteArray();
        }
        return this.mBodyData;
    }

    public String getResponseBodyString() {
        byte[] responseBodyData = getResponseBodyData();
        if (responseBodyData == null) {
            return null;
        }
        try {
            return new String(responseBodyData, ll0.a(getHeaders()));
        } catch (UnsupportedEncodingException unused) {
            return new String(responseBodyData);
        }
    }

    public T getResult() {
        return this.mResult;
    }

    public int getStatusCode() {
        return this.mImpl.getStatusCode();
    }

    public long getTtl() {
        try {
            return Date.parse(getHeader("Expires"));
        } catch (Exception unused) {
            return Long.MAX_VALUE;
        }
    }

    public void parse() {
        this.mResult = parseResult();
    }

    public abstract T parseResult();

    public void setImpl(rk0 rk0Var) {
        this.mImpl = rk0Var;
    }

    public void setRequest(xk0 xk0Var) {
        this.mRequest = xk0Var;
    }
}
