package defpackage;

import android.content.Intent;
import com.autonavi.amapauto.jni.protocol.data.TmcInfoData;
import com.autonavi.amapauto.jni.protocol.data.TmcSegmentData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.service.TmcItemInfo;
import com.autonavi.amapauto.protocol.model.service.TmcSegmentModel;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: TmcSegmentDispatchAction.java */
/* loaded from: classes.dex */
public class bz extends dx implements t50, s50 {
    public TmcSegmentData d;

    public bz(TmcSegmentData tmcSegmentData) {
        this.d = tmcSegmentData;
    }

    @Override // defpackage.s50
    public ProtocolBaseModel a() {
        TmcSegmentModel tmcSegmentModel = new TmcSegmentModel();
        tmcSegmentModel.g(this.d.isTmcEnabled ? 1 : 0);
        tmcSegmentModel.f(this.d.size);
        tmcSegmentModel.h(this.d.totalDistance);
        tmcSegmentModel.d(this.d.resiDistance);
        tmcSegmentModel.c(this.d.finishDstance);
        tmcSegmentModel.i(this.d.totalTime);
        tmcSegmentModel.e(this.d.remainTime);
        ArrayList arrayList = new ArrayList();
        if (this.d.getTmcinfos() != null && !this.d.getTmcinfos().isEmpty()) {
            for (TmcInfoData tmcInfoData : this.d.getTmcinfos()) {
                TmcItemInfo tmcItemInfo = new TmcItemInfo();
                tmcItemInfo.d(tmcInfoData.status);
                tmcItemInfo.setDistance(tmcInfoData.distance);
                tmcItemInfo.e(tmcInfoData.travelTime);
                tmcItemInfo.a(Math.round(tmcInfoData.percent * 100.0f));
                tmcItemInfo.c(tmcInfoData.number);
                arrayList.add(tmcItemInfo);
            }
        }
        tmcSegmentModel.a(arrayList);
        return tmcSegmentModel;
    }

    @Override // defpackage.t50
    public Intent b() {
        Intent intent = new Intent();
        intent.putExtra(StandardProtocolKey.KEY_TYPE, 13011);
        intent.putExtra(StandardProtocolKey.EXTRA_TMC_SEGMENT, f());
        return intent;
    }

    public final String f() {
        if (this.d != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("tmc_segment_enabled", this.d.isTmcEnabled);
                jSONObject.put("total_distance", this.d.totalDistance);
                jSONObject.put("residual_distance", this.d.resiDistance);
                jSONObject.put("finish_distance", this.d.finishDstance);
                jSONObject.put("tmc_segment_size", this.d.size);
                if (this.d.getTmcinfos() != null && this.d.getTmcinfos().size() > 0) {
                    JSONArray jSONArray = new JSONArray();
                    int size = this.d.getTmcinfos().size();
                    for (int i = 0; i < size; i++) {
                        TmcInfoData tmcInfoData = this.d.getTmcinfos().get(i);
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("tmc_segment_number", tmcInfoData.number);
                        jSONObject2.put("tmc_status", String.valueOf(tmcInfoData.status));
                        jSONObject2.put("tmc_segment_distance", String.valueOf(tmcInfoData.distance));
                        jSONObject2.put("tmc_traveltime", tmcInfoData.travelTime);
                        jSONObject2.put("tmc_segment_percent", String.valueOf(Math.round(tmcInfoData.percent * 100.0f)));
                        jSONArray.put(jSONObject2);
                    }
                    jSONObject.put("tmc_info", jSONArray);
                }
                return jSONObject.toString();
            } catch (JSONException e) {
                aa0.a("TmcSegmentDispatchAction", e.getMessage(), e, new Object[0]);
            }
        }
        return "";
    }
}
