package defpackage;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import java.lang.reflect.Method;

/* compiled from: ListPopupWindow.java */
/* loaded from: classes.dex */
public class d3 implements s1 {
    public static Method G;
    public static Method H;
    public static Method I;
    public final c A;
    public final Handler B;
    public final Rect C;
    public Rect D;
    public boolean E;
    public PopupWindow F;
    public Context a;
    public ListAdapter c;
    public z2 d;
    public int e;
    public int f;
    public int g;
    public int h;
    public int i;
    public boolean j;
    public boolean k;
    public boolean l;
    public int m;
    public boolean n;
    public boolean o;
    public int p;
    public View q;
    public int r;
    public DataSetObserver s;
    public View t;
    public Drawable u;
    public AdapterView.OnItemClickListener v;
    public AdapterView.OnItemSelectedListener w;
    public final g x;
    public final f y;
    public final e z;

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        public a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            View j = d3.this.j();
            if (j == null || j.getWindowToken() == null) {
                return;
            }
            d3.this.c();
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class b implements AdapterView.OnItemSelectedListener {
        public b() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
            z2 z2Var;
            if (i == -1 || (z2Var = d3.this.d) == null) {
                return;
            }
            z2Var.setListSelectionHidden(false);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView<?> adapterView) {
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class c implements Runnable {
        public c() {
        }

        @Override // java.lang.Runnable
        public void run() {
            d3.this.i();
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class d extends DataSetObserver {
        public d() {
        }

        @Override // android.database.DataSetObserver
        public void onChanged() {
            if (d3.this.a()) {
                d3.this.c();
            }
        }

        @Override // android.database.DataSetObserver
        public void onInvalidated() {
            d3.this.dismiss();
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class e implements AbsListView.OnScrollListener {
        public e() {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScroll(AbsListView absListView, int i, int i2, int i3) {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScrollStateChanged(AbsListView absListView, int i) {
            if (i != 1 || d3.this.l() || d3.this.F.getContentView() == null) {
                return;
            }
            d3 d3Var = d3.this;
            d3Var.B.removeCallbacks(d3Var.x);
            d3.this.x.run();
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class f implements View.OnTouchListener {
        public f() {
        }

        @Override // android.view.View.OnTouchListener
        public boolean onTouch(View view, MotionEvent motionEvent) {
            PopupWindow popupWindow;
            int action = motionEvent.getAction();
            int x = (int) motionEvent.getX();
            int y = (int) motionEvent.getY();
            if (action == 0 && (popupWindow = d3.this.F) != null && popupWindow.isShowing() && x >= 0 && x < d3.this.F.getWidth() && y >= 0 && y < d3.this.F.getHeight()) {
                d3 d3Var = d3.this;
                d3Var.B.postDelayed(d3Var.x, 250L);
                return false;
            }
            if (action != 1) {
                return false;
            }
            d3 d3Var2 = d3.this;
            d3Var2.B.removeCallbacks(d3Var2.x);
            return false;
        }
    }

    /* compiled from: ListPopupWindow.java */
    /* loaded from: classes.dex */
    public class g implements Runnable {
        public g() {
        }

        @Override // java.lang.Runnable
        public void run() {
            z2 z2Var = d3.this.d;
            if (z2Var == null || !q9.q(z2Var) || d3.this.d.getCount() <= d3.this.d.getChildCount()) {
                return;
            }
            int childCount = d3.this.d.getChildCount();
            d3 d3Var = d3.this;
            if (childCount <= d3Var.p) {
                d3Var.F.setInputMethodMode(2);
                d3.this.c();
            }
        }
    }

    static {
        if (Build.VERSION.SDK_INT <= 28) {
            try {
                G = PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", Boolean.TYPE);
            } catch (NoSuchMethodException unused) {
                Log.i("ListPopupWindow", "Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
            try {
                I = PopupWindow.class.getDeclaredMethod("setEpicenterBounds", Rect.class);
            } catch (NoSuchMethodException unused2) {
                Log.i("ListPopupWindow", "Could not find method setEpicenterBounds(Rect) on PopupWindow. Oh well.");
            }
        }
        if (Build.VERSION.SDK_INT <= 23) {
            try {
                H = PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, Integer.TYPE, Boolean.TYPE);
            } catch (NoSuchMethodException unused3) {
                Log.i("ListPopupWindow", "Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
            }
        }
    }

    public d3(Context context, AttributeSet attributeSet, int i) {
        this(context, attributeSet, i, 0);
    }

    public void a(ListAdapter listAdapter) {
        DataSetObserver dataSetObserver = this.s;
        if (dataSetObserver == null) {
            this.s = new d();
        } else {
            ListAdapter listAdapter2 = this.c;
            if (listAdapter2 != null) {
                listAdapter2.unregisterDataSetObserver(dataSetObserver);
            }
        }
        this.c = listAdapter;
        if (listAdapter != null) {
            listAdapter.registerDataSetObserver(this.s);
        }
        z2 z2Var = this.d;
        if (z2Var != null) {
            z2Var.setAdapter(this.c);
        }
    }

    public int b() {
        return this.g;
    }

    public void c(int i) {
        this.g = i;
    }

    public Drawable d() {
        return this.F.getBackground();
    }

    @Override // defpackage.s1
    public void dismiss() {
        this.F.dismiss();
        n();
        this.F.setContentView(null);
        this.d = null;
        this.B.removeCallbacks(this.x);
    }

    public void e(int i) {
        Drawable background = this.F.getBackground();
        if (background != null) {
            background.getPadding(this.C);
            Rect rect = this.C;
            this.f = rect.left + rect.right + i;
            return;
        }
        j(i);
    }

    public int f() {
        if (this.j) {
            return this.h;
        }
        return 0;
    }

    public void g(int i) {
        this.F.setInputMethodMode(i);
    }

    public void h(int i) {
        this.r = i;
    }

    public void i(int i) {
        z2 z2Var = this.d;
        if (!a() || z2Var == null) {
            return;
        }
        z2Var.setListSelectionHidden(false);
        z2Var.setSelection(i);
        if (z2Var.getChoiceMode() != 0) {
            z2Var.setItemChecked(i, true);
        }
    }

    public View j() {
        return this.t;
    }

    public int k() {
        return this.f;
    }

    public boolean l() {
        return this.F.getInputMethodMode() == 2;
    }

    public boolean m() {
        return this.E;
    }

    public final void n() {
        View view = this.q;
        if (view != null) {
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(this.q);
            }
        }
    }

    public d3(Context context, AttributeSet attributeSet, int i, int i2) {
        this.e = -2;
        this.f = -2;
        this.i = 1002;
        this.m = 0;
        this.n = false;
        this.o = false;
        this.p = Integer.MAX_VALUE;
        this.r = 0;
        this.x = new g();
        this.y = new f();
        this.z = new e();
        this.A = new c();
        this.C = new Rect();
        this.a = context;
        this.B = new Handler(context.getMainLooper());
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, b0.ListPopupWindow, i, i2);
        this.g = obtainStyledAttributes.getDimensionPixelOffset(b0.ListPopupWindow_android_dropDownHorizontalOffset, 0);
        int dimensionPixelOffset = obtainStyledAttributes.getDimensionPixelOffset(b0.ListPopupWindow_android_dropDownVerticalOffset, 0);
        this.h = dimensionPixelOffset;
        if (dimensionPixelOffset != 0) {
            this.j = true;
        }
        obtainStyledAttributes.recycle();
        l2 l2Var = new l2(context, attributeSet, i, i2);
        this.F = l2Var;
        l2Var.setInputMethodMode(1);
    }

    public void b(boolean z) {
        this.l = true;
        this.k = z;
    }

    @Override // defpackage.s1
    public void c() {
        int h = h();
        boolean l = l();
        la.a(this.F, this.i);
        if (this.F.isShowing()) {
            if (q9.q(j())) {
                int i = this.f;
                if (i == -1) {
                    i = -1;
                } else if (i == -2) {
                    i = j().getWidth();
                }
                int i2 = this.e;
                if (i2 == -1) {
                    if (!l) {
                        h = -1;
                    }
                    if (l) {
                        this.F.setWidth(this.f == -1 ? -1 : 0);
                        this.F.setHeight(0);
                    } else {
                        this.F.setWidth(this.f == -1 ? -1 : 0);
                        this.F.setHeight(-1);
                    }
                } else if (i2 != -2) {
                    h = i2;
                }
                this.F.setOutsideTouchable((this.o || this.n) ? false : true);
                this.F.update(j(), this.g, this.h, i < 0 ? -1 : i, h < 0 ? -1 : h);
                return;
            }
            return;
        }
        int i3 = this.f;
        if (i3 == -1) {
            i3 = -1;
        } else if (i3 == -2) {
            i3 = j().getWidth();
        }
        int i4 = this.e;
        if (i4 == -1) {
            h = -1;
        } else if (i4 != -2) {
            h = i4;
        }
        this.F.setWidth(i3);
        this.F.setHeight(h);
        c(true);
        this.F.setOutsideTouchable((this.o || this.n) ? false : true);
        this.F.setTouchInterceptor(this.y);
        if (this.l) {
            la.a(this.F, this.k);
        }
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = I;
            if (method != null) {
                try {
                    method.invoke(this.F, this.D);
                } catch (Exception e2) {
                    Log.e("ListPopupWindow", "Could not invoke setEpicenterBounds on PopupWindow", e2);
                }
            }
        } else {
            this.F.setEpicenterBounds(this.D);
        }
        la.a(this.F, j(), this.g, this.h, this.m);
        this.d.setSelection(-1);
        if (!this.E || this.d.isInTouchMode()) {
            i();
        }
        if (this.E) {
            return;
        }
        this.B.post(this.A);
    }

    public void d(int i) {
        this.F.setAnimationStyle(i);
    }

    public final int h() {
        int i;
        int i2;
        int makeMeasureSpec;
        int i3;
        if (this.d == null) {
            Context context = this.a;
            new a();
            z2 a2 = a(context, !this.E);
            this.d = a2;
            Drawable drawable = this.u;
            if (drawable != null) {
                a2.setSelector(drawable);
            }
            this.d.setAdapter(this.c);
            this.d.setOnItemClickListener(this.v);
            this.d.setFocusable(true);
            this.d.setFocusableInTouchMode(true);
            this.d.setOnItemSelectedListener(new b());
            this.d.setOnScrollListener(this.z);
            AdapterView.OnItemSelectedListener onItemSelectedListener = this.w;
            if (onItemSelectedListener != null) {
                this.d.setOnItemSelectedListener(onItemSelectedListener);
            }
            View view = this.d;
            View view2 = this.q;
            if (view2 != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                ViewGroup.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                int i4 = this.r;
                if (i4 == 0) {
                    linearLayout.addView(view2);
                    linearLayout.addView(view, layoutParams);
                } else if (i4 != 1) {
                    Log.e("ListPopupWindow", "Invalid hint position " + this.r);
                } else {
                    linearLayout.addView(view, layoutParams);
                    linearLayout.addView(view2);
                }
                int i5 = this.f;
                if (i5 >= 0) {
                    i3 = Integer.MIN_VALUE;
                } else {
                    i5 = 0;
                    i3 = 0;
                }
                view2.measure(View.MeasureSpec.makeMeasureSpec(i5, i3), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) view2.getLayoutParams();
                i = view2.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                view = linearLayout;
            } else {
                i = 0;
            }
            this.F.setContentView(view);
        } else {
            View view3 = this.q;
            if (view3 != null) {
                LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams) view3.getLayoutParams();
                i = view3.getMeasuredHeight() + layoutParams3.topMargin + layoutParams3.bottomMargin;
            } else {
                i = 0;
            }
        }
        Drawable background = this.F.getBackground();
        if (background != null) {
            background.getPadding(this.C);
            Rect rect = this.C;
            int i6 = rect.top;
            i2 = rect.bottom + i6;
            if (!this.j) {
                this.h = -i6;
            }
        } else {
            this.C.setEmpty();
            i2 = 0;
        }
        int a3 = a(j(), this.h, this.F.getInputMethodMode() == 2);
        if (this.n || this.e == -1) {
            return a3 + i2;
        }
        int i7 = this.f;
        if (i7 == -2) {
            int i8 = this.a.getResources().getDisplayMetrics().widthPixels;
            Rect rect2 = this.C;
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i8 - (rect2.left + rect2.right), Integer.MIN_VALUE);
        } else if (i7 != -1) {
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i7, 1073741824);
        } else {
            int i9 = this.a.getResources().getDisplayMetrics().widthPixels;
            Rect rect3 = this.C;
            makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i9 - (rect3.left + rect3.right), 1073741824);
        }
        int a4 = this.d.a(makeMeasureSpec, 0, -1, a3 - i, -1);
        if (a4 > 0) {
            i += i2 + this.d.getPaddingTop() + this.d.getPaddingBottom();
        }
        return a4 + i;
    }

    public void j(int i) {
        this.f = i;
    }

    public void f(int i) {
        this.m = i;
    }

    @Override // defpackage.s1
    public ListView e() {
        return this.d;
    }

    public void i() {
        z2 z2Var = this.d;
        if (z2Var != null) {
            z2Var.setListSelectionHidden(true);
            z2Var.requestLayout();
        }
    }

    public void a(boolean z) {
        this.E = z;
        this.F.setFocusable(z);
    }

    public void a(Drawable drawable) {
        this.F.setBackgroundDrawable(drawable);
    }

    public void a(View view) {
        this.t = view;
    }

    public void a(int i) {
        this.h = i;
        this.j = true;
    }

    public void a(Rect rect) {
        this.D = rect != null ? new Rect(rect) : null;
    }

    public void a(AdapterView.OnItemClickListener onItemClickListener) {
        this.v = onItemClickListener;
    }

    public void a(PopupWindow.OnDismissListener onDismissListener) {
        this.F.setOnDismissListener(onDismissListener);
    }

    @Override // defpackage.s1
    public boolean a() {
        return this.F.isShowing();
    }

    public z2 a(Context context, boolean z) {
        return new z2(context, z);
    }

    public final int a(View view, int i, boolean z) {
        if (Build.VERSION.SDK_INT <= 23) {
            Method method = H;
            if (method != null) {
                try {
                    return ((Integer) method.invoke(this.F, view, Integer.valueOf(i), Boolean.valueOf(z))).intValue();
                } catch (Exception unused) {
                    Log.i("ListPopupWindow", "Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
                }
            }
            return this.F.getMaxAvailableHeight(view, i);
        }
        return this.F.getMaxAvailableHeight(view, i, z);
    }

    public final void c(boolean z) {
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = G;
            if (method != null) {
                try {
                    method.invoke(this.F, Boolean.valueOf(z));
                    return;
                } catch (Exception unused) {
                    Log.i("ListPopupWindow", "Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
                    return;
                }
            }
            return;
        }
        this.F.setIsClippedToScreen(z);
    }
}
