package defpackage;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.text.format.Time;
import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.jni.PosService;
import com.autonavi.amapauto.location.model.GPSDatetime;
import com.autonavi.amapauto.location.model.LocDrPos;
import com.autonavi.amapauto.location.model.LocMMFeedbackInfo;
import com.autonavi.amapauto.location.model.LocViaductValid;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: LocationFrontEndFusion.java */
/* loaded from: classes.dex */
public class ds extends cs {
    public ds(Context context) {
        super(context);
    }

    @Override // defpackage.fs
    public void a(int i, long j, float f, LocationListener locationListener) {
        if (this.a) {
            if (this.c) {
                aa0.a("LocationFrontEndFusion", "LocationFrontEndFusion isModeFrontEndFusionPlayback", new Object[0]);
                return;
            }
            aa0.a("LocationFrontEndFusion", "LocationFrontEndFusion requestLocationUpdates,provider={?}", Integer.valueOf(i));
            if (!oq.i().a(oq.n, false)) {
                this.g.requestLocationUpdates(1, j, f, locationListener);
            } else {
                aa0.a("LocationFrontEndFusion", "LocationFrontEndFusion,provider={?}", Integer.valueOf(i));
                this.g.requestLocationUpdates(i, j, f, locationListener);
            }
        }
    }

    public final void b(String str) {
        if (str == null) {
            return;
        }
        LocDrPos locDrPos = new LocDrPos();
        try {
            JSONObject jSONObject = new JSONObject(str);
            double optDouble = jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LON);
            double optDouble2 = jSONObject.optDouble(LocationParams.PARA_FLP_AUTONAVI_LAT);
            float optDouble3 = (float) jSONObject.optDouble("course");
            long optLong = jSONObject.optLong(StandardProtocolKey.TIME);
            double optDouble4 = (float) jSONObject.optDouble("alt");
            float optDouble5 = (float) jSONObject.optDouble(StandardProtocolKey.SPEED);
            int optInt = jSONObject.optInt("satnum");
            String optString = jSONObject.optString("gpsStatus", "A");
            long j = optLong + (this.m * 3600000);
            long optLong2 = jSONObject.optLong("ticktime64", SystemClock.elapsedRealtime());
            String optString2 = jSONObject.optString("ns");
            aa0.a("====zwb LocationFrontEndFusion ns = {?}", optString2);
            byte a = a(optString2, (byte) 78);
            aa0.a("====zwb LocationFrontEndFusion nsByte = {?}", Byte.valueOf(a));
            byte a2 = a(jSONObject.optString("ew"), (byte) 69);
            float optDouble6 = (float) jSONObject.optDouble("hdop", -1.0d);
            float optDouble7 = (float) jSONObject.optDouble("vdop", -1.0d);
            float optDouble8 = (float) jSONObject.optDouble("pdop", -1.0d);
            byte a3 = a(optString, (byte) 65);
            float optDouble9 = (float) jSONObject.optDouble("posAcc");
            float optDouble10 = (float) jSONObject.optDouble("courseAcc");
            float optDouble11 = (float) jSONObject.optDouble("altAcc");
            float optDouble12 = (float) jSONObject.optDouble("speedAcc");
            int optInt2 = jSONObject.optInt("DRStatus");
            int optInt3 = jSONObject.optInt("moveStatus", 0);
            boolean optBoolean = jSONObject.optBoolean("isDeltaAltValid");
            float optDouble13 = (float) jSONObject.optDouble("deltaAlt");
            boolean optBoolean2 = jSONObject.optBoolean("isDeltaAltAccValid", false);
            float optDouble14 = (float) jSONObject.optDouble("deltaAltAcc");
            boolean optBoolean3 = jSONObject.optBoolean("isSlopeValueValid", false);
            float optDouble15 = (float) jSONObject.optDouble(StandardProtocolKey.SLOPE_VALUE);
            boolean optBoolean4 = jSONObject.optBoolean("isSlopeAccValid", false);
            float optDouble16 = (float) jSONObject.optDouble("slopeAcc");
            boolean optBoolean5 = jSONObject.optBoolean("isMoveDistValid", false);
            double optDouble17 = jSONObject.optDouble("moveDist");
            Location location = new Location("gps");
            location.setLongitude(optDouble);
            location.setLatitude(optDouble2);
            location.setTime(j);
            location.setAltitude(optDouble4);
            location.setBearing(optDouble15);
            location.setProvider("gps");
            location.setSpeed(optDouble5);
            this.l = location;
            Time time = new Time();
            time.set(j);
            GPSDatetime gPSDatetime = new GPSDatetime();
            gPSDatetime.year = time.year;
            gPSDatetime.month = time.month + 1;
            gPSDatetime.day = time.monthDay;
            gPSDatetime.hour = time.hour;
            gPSDatetime.minute = time.minute;
            gPSDatetime.second = time.second;
            locDrPos.dateTime = gPSDatetime;
            locDrPos.dataType = 512;
            locDrPos.stLat = optDouble2;
            locDrPos.stLon = optDouble;
            locDrPos.alt = (float) optDouble4;
            locDrPos.slopeValue = optDouble15;
            locDrPos.speed = optDouble5;
            locDrPos.tickTime = optLong2;
            locDrPos.NS = a;
            locDrPos.EW = a2;
            locDrPos.satNum = optInt;
            locDrPos.hdop = optDouble6;
            locDrPos.vdop = optDouble7;
            locDrPos.pdop = optDouble8;
            locDrPos.gpsStatus = a3;
            locDrPos.moveStatus = optInt3;
            locDrPos.drType = optInt2;
            LocViaductValid locViaductValid = new LocViaductValid();
            locViaductValid.deltaAlt = optBoolean;
            locViaductValid.deltaAltAcc = optBoolean2;
            locViaductValid.slopeValue = optBoolean3;
            locViaductValid.slopeAcc = optBoolean4;
            locViaductValid.moveDist = optBoolean5;
            locDrPos.validField = locViaductValid;
            locDrPos.deltaAlt = optDouble13;
            locDrPos.deltaAltAcc = optDouble14;
            locDrPos.slopeValue = optDouble15;
            locDrPos.slopeAcc = optDouble16;
            locDrPos.moveDist = optDouble17;
            locDrPos.posAcc = optDouble9;
            locDrPos.courseAcc = optDouble10;
            locDrPos.altAcc = optDouble11;
            locDrPos.speedAcc = optDouble12;
            locDrPos.course = optDouble3;
            as.g().a(locDrPos);
            if (this.l == null || this.k == null) {
                return;
            }
            this.k.setProvider(this.l.getProvider());
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override // defpackage.fs
    public void h() {
        super.h();
        j();
    }

    public final void j() {
    }

    public final void k() {
        LocDrPos a = jp.I().a(this.l);
        int i = 0;
        if (a == null) {
            aa0.a("DRS setLocDRPos locationInfo is null", new Object[0]);
            return;
        }
        aa0.a("DRS setLocDRPos elapsedRealtime = {?} ticktime = {?} moveStatus = {?}", Long.valueOf(SystemClock.elapsedRealtime()), Long.valueOf(a.tickTime), Integer.valueOf(a.moveStatus));
        Location location = new Location(this.l.getProvider());
        location.setLongitude(this.l.getLongitude());
        location.setLatitude(this.l.getLatitude());
        location.setTime(this.l.getTime());
        location.setAltitude(this.l.getAltitude());
        location.setBearing(this.l.getBearing());
        location.setProvider(this.l.getProvider());
        location.setSpeed(a.speed);
        int i2 = a.drType;
        if ("network".equals(this.l.getProvider())) {
            as.g().a(this.l);
            i2 = 0;
        } else {
            a.speedoMeter = jp.I().a(a.speed);
            long elapsedRealtime = (int) (this.n == 0 ? SystemClock.elapsedRealtime() : SystemClock.elapsedRealtime() - this.n);
            this.n = elapsedRealtime;
            a.interval = (int) elapsedRealtime;
            this.n = SystemClock.elapsedRealtime();
            as.g().a(a);
        }
        aa0.a("LocationFrontEndFusion", "handleCalibration calibrationStatus = {?},{?},", Integer.valueOf(i2));
        if (i2 != 2 && i2 != 1) {
            i = 1;
        }
        PosService.drCalibration(i);
        this.l = location;
    }

    @Override // defpackage.fs, android.location.LocationListener
    public void onLocationChanged(Location location) {
        Location location2;
        if (this.c || location == null) {
            return;
        }
        if (location.getLatitude() == 0.0d && location.getLongitude() == 0.0d) {
            return;
        }
        aa0.a("LocationFrontEndFusion", "onLocationChanged: longitude and latitude is {?},{?},", Double.valueOf(location.getLongitude()), Double.valueOf(location.getLatitude()));
        aa0.a("LocationFrontEndFusion", "onLocationChanged: time={?}, direction={?}, speed={?}, isGPS={?}", Long.valueOf(location.getTime()), Float.valueOf(location.getBearing()), Float.valueOf(location.getSpeed()), Boolean.valueOf("gps".equals(location.getProvider())));
        if ("gps".equals(location.getProvider())) {
            location.setTime(location.getTime() + (this.m * 3600000));
            synchronized (this) {
                this.v.obtainMessage(243).sendToTarget();
            }
            b(0);
        }
        u90.d(ee.A().f()).a((int) (location.getLongitude() * 1000000.0d), (int) (location.getLatitude() * 1000000.0d), (int) location.getAccuracy());
        Location location3 = this.l;
        if (location3 != null && (location2 = this.k) != null) {
            location2.setProvider(location3.getProvider());
        }
        if ("gps".equals(location.getProvider())) {
            this.v.obtainMessage(242).sendToTarget();
        }
        this.l = location;
        k();
    }

    @Override // defpackage.fs, defpackage.w80
    public void onMapMatchFeedbackUpdate(LocMMFeedbackInfo locMMFeedbackInfo) {
        super.onMapMatchFeedbackUpdate(locMMFeedbackInfo);
        aa0.a("====zwb LocationFrontEndFusion onMapMatchFeedbackUpdate locMMFeedbackInfo = {?}", locMMFeedbackInfo);
        b(locMMFeedbackInfo);
    }

    @Override // defpackage.fs, defpackage.v80
    public void a(String str) {
        if (this.c) {
            aa0.a("LocationFrontEndFusion", "DR LocationFrontEndFusion notifyLocDrPos drPos = {?}", str);
            b(str);
        }
    }

    public final byte a(String str, byte b) {
        byte[] bytes;
        return (TextUtils.isEmpty(str) || (bytes = str.getBytes()) == null || bytes.length <= 0) ? b : bytes[0];
    }

    public final void b(LocMMFeedbackInfo locMMFeedbackInfo) {
        aa0.a("====zwb LocationFrontEndFusion sendMapMatchFeedback locMMFeedback = {?}", locMMFeedbackInfo);
        if (locMMFeedbackInfo == null) {
            return;
        }
        aa0.a("DRS sendMapMatchFeedback elapsedRealtime = {?} ticktime = {?}", Long.valueOf(SystemClock.elapsedRealtime()), Long.valueOf(locMMFeedbackInfo.ticktime));
        String a = jp.I().a(locMMFeedbackInfo);
        if (TextUtils.isEmpty(a)) {
            return;
        }
        aa0.a("====zwb LocationFrontEndFusion sendMapMatchFeedback json = {?}", a);
        Bundle bundle = new Bundle();
        bundle.putString("AmapAutoMMF", a);
        ((LocationManager) ee.A().f().getSystemService("location")).sendExtraCommand("gps", "AmapAutoMMF", bundle);
    }
}
