package defpackage;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.autonavi.amapauto.jni.GAdaAndroid;
import com.autonavi.indoor.util.DeviceUtils;
import java.util.LinkedHashMap;
import java.util.Map;

/* compiled from: PermissionUtils.java */
/* loaded from: classes.dex */
public class ea0 {
    public static String[] a = {"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};

    public static boolean a(Activity activity) {
        if (da0.a() || Build.VERSION.SDK_INT < 23) {
            return true;
        }
        try {
            if (activity.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                return true;
            }
            activity.requestPermissions(a, 1);
            return false;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean a() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String str : a) {
            String a2 = s6.a(str);
            Log.i("PermissionUtils", "permission:{?}" + str + " && op:{?}" + a2);
            if (!TextUtils.isEmpty(a2)) {
                if (e7.a(ee.A().f(), str) != 0 || ee.A().f().checkSelfPermission(str) == -1) {
                    return false;
                }
                int a3 = s6.a(ee.A().f(), a2, ee.A().o());
                if (a3 != 0 && a3 != 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Map<String, String> a(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return null;
        }
        aa0.a("PermissionUtils", "lackOfPermissions", new Object[0]);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("定位", "android.permission.ACCESS_FINE_LOCATION");
        if (!da0.a()) {
            linkedHashMap.put("电话", DeviceUtils.PHONESTATE);
            linkedHashMap.put("存储", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
        linkedHashMap.put("麦克风", "android.permission.RECORD_AUDIO");
        if (Build.VERSION.SDK_INT >= 33) {
            linkedHashMap.put("通知", GAdaAndroid.PERMISSION_POST_NOTIFICATIONS);
        }
        if ((oq.i().a(oq.h, false) || oq.i().a(oq.j, false)) && !vd.k()) {
            linkedHashMap.put("摄像头", "android.permission.CAMERA");
        }
        if (jp.I().l(10017)) {
            linkedHashMap.put("车速", "android.car.permission.CAR_SPEED");
            linkedHashMap.put("新能源", GAdaAndroid.CAR_ENERGY);
        }
        if (jp.I().l(10046)) {
            linkedHashMap.put("车速", "android.car.permission.CAR_SPEED");
        }
        if (jp.I().l(10060) && Build.VERSION.SDK_INT >= 29) {
            linkedHashMap.put("后台定位", "android.permission.ACCESS_BACKGROUND_LOCATION");
        }
        Map<String, String> A = jp.I().A();
        if (A != null) {
            aa0.a("PermissionUtils", "specPermissionsMap not null", new Object[0]);
            for (Map.Entry<String, String> entry : A.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                aa0.a("PermissionUtils", "permissionName = {?}; permission = {?}", key, value);
                Log.i("PermissionUtils", "lackOfPermissions permissionName = " + key + "; permission = {?}" + value);
                linkedHashMap.put(key, value);
            }
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry2 : linkedHashMap.entrySet()) {
            String str = (String) entry2.getKey();
            String str2 = (String) entry2.getValue();
            if (!vd.i() || jp.I().l(10033) || !"android.permission.RECORD_AUDIO".equals(str2)) {
                if (jp.I().l(10041) || !DeviceUtils.PHONESTATE.equals(str2)) {
                    if (context.checkSelfPermission(str2) == -1) {
                        aa0.a("PermissionUtils", "permission denied lack " + str2, new Object[0]);
                        Log.i("PermissionUtils", "lackOfPermissions permission denied lack " + str2);
                        linkedHashMap2.put(str, str2);
                    }
                }
            }
        }
        return linkedHashMap2;
    }

    public static boolean a(Context context, String... strArr) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        boolean z = Binder.getCallingPid() != Process.myPid();
        if (!jp.I().j(60001).b()) {
            z = false;
        }
        aa0.a("PermissionUtils", "checkPermissions isFromOtherPid " + z + " getCallingPid " + Binder.getCallingPid() + " myPid " + Process.myPid(), new Object[0]);
        long clearCallingIdentity = z ? Binder.clearCallingIdentity() : 0L;
        for (String str : strArr) {
            if (ee.A().s() && GAdaAndroid.CAR_ENERGY.equals(str)) {
                Log.i("PermissionUtils", "checkPermissions:android.car.permission.CAR_ENERGY");
                if (z) {
                    Binder.restoreCallingIdentity(clearCallingIdentity);
                }
                return true;
            }
            if (da0.a() && ("android.permission.WRITE_EXTERNAL_STORAGE".equals(str) || DeviceUtils.PHONESTATE.equals(str))) {
                Log.i("PermissionUtils", "checkPermissions:disableStoragePhoneStatePermisions");
                if (z) {
                    Binder.restoreCallingIdentity(clearCallingIdentity);
                }
                return true;
            }
            String a2 = s6.a(str);
            aa0.a("PermissionUtils", "permission:{?} && op:{?}", str, a2);
            Log.i("PermissionUtils", "checkPermissions, permission:" + str + ",op:" + a2);
            if (!TextUtils.isEmpty(a2)) {
                int a3 = e7.a(ee.A().f(), str);
                if (a3 != 0) {
                    Log.i("PermissionUtils", "checkPermissions, checkSelfPermission1,result:" + a3);
                    if (z) {
                        Binder.restoreCallingIdentity(clearCallingIdentity);
                    }
                    return false;
                }
                if (context != null && context.checkSelfPermission(str) == -1) {
                    Log.i("PermissionUtils", "checkPermissions, checkSelfPermission2,result:" + a3);
                    if (z) {
                        Binder.restoreCallingIdentity(clearCallingIdentity);
                    }
                    return false;
                }
                try {
                    int a4 = s6.a(ee.A().f(), a2, ee.A().o());
                    Log.i("PermissionUtils", "checkPermissions, noteProxyOp,result:" + a4);
                    if (a4 != 0 && a4 != 1) {
                        if (z) {
                            Binder.restoreCallingIdentity(clearCallingIdentity);
                        }
                        return false;
                    }
                } catch (Exception e) {
                    aa0.b("PermissionUtils", "checkPermissions, noteProxyOp exception~", e, new Object[0]);
                    if (z) {
                        Binder.restoreCallingIdentity(clearCallingIdentity);
                    }
                    return false;
                }
            }
        }
        if (z) {
            Binder.restoreCallingIdentity(clearCallingIdentity);
        }
        return true;
    }
}
