package defpackage;

import android.text.TextUtils;
import android.util.Log;
import com.autonavi.amapauto.framework.OnNativePerformanceBridgeCallBack;
import com.autonavi.amapauto.framework.PerformanceBridge;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/* compiled from: ProcessMonitor.java */
/* loaded from: classes.dex */
public class ev {
    public String a;
    public HashMap<String, dv> b;

    /* compiled from: ProcessMonitor.java */
    /* loaded from: classes.dex */
    public class a implements OnNativePerformanceBridgeCallBack {

        /* compiled from: ProcessMonitor.java */
        /* renamed from: ev$a$a, reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public class RunnableC0067a implements Runnable {
            public final /* synthetic */ int a;
            public final /* synthetic */ int c;
            public final /* synthetic */ int d;

            public RunnableC0067a(int i, int i2, int i3) {
                this.a = i;
                this.c = i2;
                this.d = i3;
            }

            @Override // java.lang.Runnable
            public void run() {
                Log.i("ProcessMonitor", "onDispatch");
                ev.this.a = null;
                ev.this.a(this.a, this.c, this.d);
                PerformanceBridge.nativeOnPerformanceResult(ev.this.b());
            }
        }

        public a() {
        }

        @Override // com.autonavi.amapauto.framework.OnNativePerformanceBridgeCallBack
        public boolean onDispatch(int i, int i2, int i3) {
            ev.this.b = new HashMap();
            new Thread(new RunnableC0067a(i, i2, i3)).start();
            return true;
        }
    }

    /* compiled from: ProcessMonitor.java */
    /* loaded from: classes.dex */
    public class b implements Comparator<Map.Entry<String, dv>> {
        public b(ev evVar) {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(Map.Entry<String, dv> entry, Map.Entry<String, dv> entry2) {
            return Float.compare(Float.parseFloat(entry2.getValue().c), Float.parseFloat(entry.getValue().c));
        }
    }

    /* compiled from: ProcessMonitor.java */
    /* loaded from: classes.dex */
    public static class c {
        public static ev a = new ev(null);
    }

    public /* synthetic */ ev(a aVar) {
        this();
    }

    public static ev c() {
        return c.a;
    }

    public static boolean d(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        int length = str.length();
        do {
            length--;
            if (length < 0) {
                return true;
            }
        } while (Character.isDigit(str.charAt(length)));
        return false;
    }

    public final boolean b(String str) {
        if (str.contains("Tasks") && str.contains("total") && str.contains("running")) {
            return true;
        }
        return str.contains("User") && str.contains("System") && str.contains("IOW");
    }

    public ev() {
        this.a = null;
    }

    public final boolean c(String str) {
        if (str.contains("PID") && str.contains("%CPU") && str.contains("ARGS")) {
            return true;
        }
        return str.contains("PID") && str.contains("CPU%") && str.contains("Name");
    }

    public final String b() {
        StringBuilder sb = new StringBuilder();
        if (TextUtils.isEmpty(this.a)) {
            ArrayList arrayList = new ArrayList(this.b.entrySet());
            Collections.sort(arrayList, new b(this));
            Iterator it = arrayList.iterator();
            int i = 10;
            while (it.hasNext() && i > 0) {
                i--;
                dv dvVar = (dv) ((Map.Entry) it.next()).getValue();
                sb.append(dvVar.a + "," + String.format("%.2f", Float.valueOf(Float.parseFloat(dvVar.c))) + "," + String.format("%.2f", Float.valueOf(Float.parseFloat(dvVar.b))) + "," + dvVar.d + ";");
            }
            return sb.toString();
        }
        return this.a;
    }

    public void a() {
        PerformanceBridge.a(new a());
    }

    public final void a(int i, int i2, int i3) {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("top -n " + i + " -d " + i2).getInputStream()));
            boolean z = false;
            int i4 = 0;
            while (true) {
                String readLine = bufferedReader.readLine();
                if (readLine == null || System.currentTimeMillis() - currentTimeMillis >= i3 * 1000) {
                    return;
                }
                if (readLine.trim().length() > 1) {
                    if (b(readLine)) {
                        z = true;
                    } else if (c(readLine)) {
                        i4 = a(readLine);
                        z = false;
                    }
                    if (!z && !c(readLine)) {
                        a(readLine, i4);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            this.a = "CollectFail";
        }
    }

    public final int a(String str) {
        if ((str.contains("PID") && str.contains("%CPU") && str.contains("ARGS")) || (str.contains("PID") && str.contains("CPU%") && str.contains("Name"))) {
            String[] split = str.trim().replaceAll(" +", " ").split(" ");
            for (int i = 0; i < split.length; i++) {
                if (split[i].contains("CPU")) {
                    return i;
                }
            }
        }
        return 0;
    }

    public final void a(String str, int i) {
        dv dvVar;
        String[] split = str.trim().replaceAll(" +", " ").split(" ");
        String[] strArr = new String[split.length - 1];
        if (!d(split[0])) {
            System.arraycopy(split, 1, strArr, 0, split.length - 1);
            split = strArr;
        }
        int length = split.length - 1;
        if (length <= 0 || split.length <= i || length <= i) {
            return;
        }
        String replace = split[i].replace("%", "");
        if (!this.b.containsKey(split[length])) {
            dvVar = new dv();
            dvVar.a = split[length];
            dvVar.c = replace;
            dvVar.b = replace;
            dvVar.d = 1;
        } else {
            dv dvVar2 = this.b.get(split[length]);
            float parseFloat = Float.parseFloat(dvVar2.c);
            float parseFloat2 = Float.parseFloat(dvVar2.b);
            float parseFloat3 = Float.parseFloat(replace);
            if (parseFloat3 > parseFloat2) {
                dvVar2.b = replace;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(((parseFloat * dvVar2.d) + parseFloat3) / (r5 + 1));
            sb.append("");
            dvVar2.c = sb.toString();
            dvVar2.d++;
            dvVar = dvVar2;
        }
        if (TextUtils.isEmpty(dvVar.c) || TextUtils.isEmpty(dvVar.b)) {
            return;
        }
        this.b.put(split[length], dvVar);
    }
}
