package defpackage;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.transition.Transition;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import androidx.appcompat.view.menu.ListMenuItemView;
import java.lang.reflect.Method;

/* compiled from: MenuPopupWindow.java */
/* loaded from: classes.dex */
public class f3 extends d3 implements e3 {
    public static Method K;
    public e3 J;

    /* compiled from: MenuPopupWindow.java */
    /* loaded from: classes.dex */
    public static class a extends z2 {
        public final int p;
        public final int q;
        public e3 r;
        public MenuItem s;

        public a(Context context, boolean z) {
            super(context, z);
            Configuration configuration = context.getResources().getConfiguration();
            if (Build.VERSION.SDK_INT >= 17 && 1 == configuration.getLayoutDirection()) {
                this.p = 21;
                this.q = 22;
            } else {
                this.p = 22;
                this.q = 21;
            }
        }

        @Override // defpackage.z2, android.view.View
        public boolean onHoverEvent(MotionEvent motionEvent) {
            int i;
            i1 i1Var;
            int pointToPosition;
            int i2;
            if (this.r != null) {
                ListAdapter adapter = getAdapter();
                if (adapter instanceof HeaderViewListAdapter) {
                    HeaderViewListAdapter headerViewListAdapter = (HeaderViewListAdapter) adapter;
                    i = headerViewListAdapter.getHeadersCount();
                    i1Var = (i1) headerViewListAdapter.getWrappedAdapter();
                } else {
                    i = 0;
                    i1Var = (i1) adapter;
                }
                l1 l1Var = null;
                if (motionEvent.getAction() != 10 && (pointToPosition = pointToPosition((int) motionEvent.getX(), (int) motionEvent.getY())) != -1 && (i2 = pointToPosition - i) >= 0 && i2 < i1Var.getCount()) {
                    l1Var = i1Var.getItem(i2);
                }
                MenuItem menuItem = this.s;
                if (menuItem != l1Var) {
                    j1 b = i1Var.b();
                    if (menuItem != null) {
                        this.r.b(b, menuItem);
                    }
                    this.s = l1Var;
                    if (l1Var != null) {
                        this.r.a(b, l1Var);
                    }
                }
            }
            return super.onHoverEvent(motionEvent);
        }

        @Override // android.widget.ListView, android.widget.AbsListView, android.view.View, android.view.KeyEvent.Callback
        public boolean onKeyDown(int i, KeyEvent keyEvent) {
            ListMenuItemView listMenuItemView = (ListMenuItemView) getSelectedView();
            if (listMenuItemView != null && i == this.p) {
                if (listMenuItemView.isEnabled() && listMenuItemView.getItemData().hasSubMenu()) {
                    performItemClick(listMenuItemView, getSelectedItemPosition(), getSelectedItemId());
                }
                return true;
            }
            if (listMenuItemView != null && i == this.q) {
                setSelection(-1);
                ((i1) getAdapter()).b().a(false);
                return true;
            }
            return super.onKeyDown(i, keyEvent);
        }

        public void setHoverListener(e3 e3Var) {
            this.r = e3Var;
        }

        @Override // defpackage.z2, android.widget.AbsListView
        public /* bridge */ /* synthetic */ void setSelector(Drawable drawable) {
            super.setSelector(drawable);
        }
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 28) {
                K = PopupWindow.class.getDeclaredMethod("setTouchModal", Boolean.TYPE);
            }
        } catch (NoSuchMethodException unused) {
            Log.i("MenuPopupWindow", "Could not find method setTouchModal() on PopupWindow. Oh well.");
        }
    }

    public f3(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
    }

    @Override // defpackage.d3
    public z2 a(Context context, boolean z) {
        a aVar = new a(context, z);
        aVar.setHoverListener(this);
        return aVar;
    }

    public void b(Object obj) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.F.setExitTransition((Transition) obj);
        }
    }

    public void d(boolean z) {
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = K;
            if (method != null) {
                try {
                    method.invoke(this.F, Boolean.valueOf(z));
                    return;
                } catch (Exception unused) {
                    Log.i("MenuPopupWindow", "Could not invoke setTouchModal() on PopupWindow. Oh well.");
                    return;
                }
            }
            return;
        }
        this.F.setTouchModal(z);
    }

    public void a(Object obj) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.F.setEnterTransition((Transition) obj);
        }
    }

    @Override // defpackage.e3
    public void b(j1 j1Var, MenuItem menuItem) {
        e3 e3Var = this.J;
        if (e3Var != null) {
            e3Var.b(j1Var, menuItem);
        }
    }

    public void a(e3 e3Var) {
        this.J = e3Var;
    }

    @Override // defpackage.e3
    public void a(j1 j1Var, MenuItem menuItem) {
        e3 e3Var = this.J;
        if (e3Var != null) {
            e3Var.a(j1Var, menuItem);
        }
    }
}
