package defpackage;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.data.ALResponeData;
import com.autonavi.amapauto.jni.protocol.data.SearchData;
import com.autonavi.amapauto.jni.protocol.data.SearchResultData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.client.search.AroundSearchModel;
import com.autonavi.amapauto.protocol.model.client.search.HomeCompanyAroundSearchModel;

/* compiled from: AroudSearchAction.java */
/* loaded from: classes.dex */
public class f40 extends g40 implements t50, s50 {
    public boolean l;

    public f40() {
        this.l = false;
    }

    @Override // defpackage.s50
    public ProtocolBaseModel a() {
        ALResponeData g = g();
        if (g != null && g.isNewJsonResult) {
            return o80.a(g.jsonString, this.d);
        }
        SearchResultData searchResultData = (SearchResultData) g();
        if (searchResultData != null) {
            aa0.a("AroudSearchAction", "parseToAidlModel resultCode:{?},isHomeCompanyAroundSearch:{?}", Integer.valueOf(searchResultData.resultCode), Boolean.valueOf(this.l));
        } else {
            aa0.a("AroudSearchAction", "parseToAidlModel SearchResultData is null", new Object[0]);
        }
        return o80.a(searchResultData);
    }

    @Override // defpackage.t50
    public Intent b() {
        if (p().searchType == 0) {
            b(10042);
        } else {
            b(10043);
        }
        return o();
    }

    @Override // defpackage.ov
    public boolean j() {
        return true;
    }

    public f40(Intent intent) {
        this.l = false;
        SearchData p = p();
        p.requestType = 0;
        Bundle extras = intent.getExtras();
        if (extras != null) {
            if (extras.getInt(StandardProtocolKey.EXTRA_SEARCHTYPE) == 1) {
                p.searchType = 1;
            } else {
                p.searchType = 0;
            }
            p.keyword = extras.getString(StandardProtocolKey.EXTRA_KEYWORD);
            p.lat = extras.getDouble(StandardProtocolKey.EXTRA_MYLOCLAT);
            p.lon = extras.getDouble(StandardProtocolKey.EXTRA_MYLOCLON);
            p.dev = extras.getInt("EXTRA_DEV");
            p.city = extras.getString(StandardProtocolKey.EXTRA_SEARCHCITY);
            p.maxCount = extras.getInt(StandardProtocolKey.EXTRA_MAXCOUNT);
            p.radius = extras.getInt(StandardProtocolKey.EXTRA_RANGE);
            p.centerLat = extras.getDouble(StandardProtocolKey.EXTRA_CENTERLAT);
            p.centerLon = extras.getDouble(StandardProtocolKey.EXTRA_CENTERLON);
            p.sortOrder = extras.getInt(StandardProtocolKey.EXTRA_SORTORDER);
        }
    }

    public f40(AroundSearchModel aroundSearchModel) {
        this.l = false;
        SearchData p = p();
        p.searchType = 1;
        if (aroundSearchModel == null) {
            return;
        }
        int requestType = aroundSearchModel.getRequestType();
        p.requestType = requestType;
        if (1 == requestType || 2 == requestType) {
            a(true);
        }
        aa0.a("AroudSearchAction", "aroundSearchModel ={?}", aroundSearchModel.toString());
        p.keyword = aroundSearchModel.getKeywords();
        p.lat = aroundSearchModel.getMylocLat();
        p.lon = aroundSearchModel.getMylocLon();
        p.dev = aroundSearchModel.getDev();
        p.maxCount = aroundSearchModel.getMaxMount();
        if (!TextUtils.isEmpty(aroundSearchModel.getLocation())) {
            String[] split = aroundSearchModel.getLocation().split(",");
            if (split.length == 2) {
                try {
                    p.centerLon = Double.parseDouble(split[0]);
                    p.centerLat = Double.parseDouble(split[1]);
                } catch (Exception unused) {
                    aa0.a("AroudSearchAction", "locationSpit wrong={?}", aroundSearchModel.getLocation());
                }
            }
        }
        p.radius = aroundSearchModel.getRadius();
        p.sortOrder = aroundSearchModel.getSortrule();
        p.needClassify = aroundSearchModel.getNeedClassify();
        p.needSort = aroundSearchModel.getNeedSort();
        p.needRange = aroundSearchModel.getNeedRange();
        p.needCharge = aroundSearchModel.getNeedCharge();
        p.needChildPoi = aroundSearchModel.getNeedChildPoi();
        p.classify = aroundSearchModel.getClassify();
        p.sort = aroundSearchModel.getSort();
        p.range = aroundSearchModel.getRange();
        p.charge = aroundSearchModel.getCharge();
    }

    public f40(HomeCompanyAroundSearchModel homeCompanyAroundSearchModel) {
        this.l = false;
        if (homeCompanyAroundSearchModel == null) {
            return;
        }
        this.l = true;
        SearchData p = p();
        p.searchType = 1;
        p.requestType = 0;
        p.searchCenter = homeCompanyAroundSearchModel.getSearchCenter();
        p.keyword = homeCompanyAroundSearchModel.getKeyWord();
        p.radius = homeCompanyAroundSearchModel.getRadius();
        p.sortOrder = homeCompanyAroundSearchModel.getSortrule();
        p.maxCount = homeCompanyAroundSearchModel.getMaxCount();
    }
}
