package defpackage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import libcore.io.IoUtils;

/* compiled from: UploadX509TrustManager.java */
/* loaded from: classes.dex */
public class fj0 implements X509TrustManager {
    public boolean a;
    public String b;
    public File c;
    public final Object d = new Object();
    public CertificateFactory e;
    public Set<X509Certificate> f;

    public fj0(boolean z, String str) {
        this.a = false;
        this.b = "";
        this.a = z;
        if (z) {
            this.b = str;
            this.c = new File(this.b);
            try {
                this.e = CertificateFactory.getInstance("X.509");
                this.f = b();
            } catch (CertificateException unused) {
                sj0.a("Failed to obtain X.509 CertificateFactory");
            }
        }
    }

    /* JADX WARN: Not initialized variable reg: 1, insn: 0x004d: MOVE (r0 I:??[OBJECT, ARRAY]) = (r1 I:??[OBJECT, ARRAY]), block:B:17:0x004d */
    public final X509Certificate a(String str) {
        BufferedInputStream bufferedInputStream;
        AutoCloseable autoCloseable;
        AutoCloseable autoCloseable2 = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.c, str)));
                try {
                    X509Certificate x509Certificate = (X509Certificate) this.e.generateCertificate(bufferedInputStream);
                    IoUtils.closeQuietly(bufferedInputStream);
                    return x509Certificate;
                } catch (IOException e) {
                    e = e;
                    sj0.a("Failed to read certificate from " + str + "exception :" + e.getMessage());
                    IoUtils.closeQuietly(bufferedInputStream);
                    return null;
                } catch (CertificateException e2) {
                    e = e2;
                    sj0.a("Failed to read certificate from " + str + "exception :" + e.getMessage());
                    IoUtils.closeQuietly(bufferedInputStream);
                    return null;
                }
            } catch (IOException e3) {
                e = e3;
                bufferedInputStream = null;
                sj0.a("Failed to read certificate from " + str + "exception :" + e.getMessage());
                IoUtils.closeQuietly(bufferedInputStream);
                return null;
            } catch (CertificateException e4) {
                e = e4;
                bufferedInputStream = null;
                sj0.a("Failed to read certificate from " + str + "exception :" + e.getMessage());
                IoUtils.closeQuietly(bufferedInputStream);
                return null;
            } catch (Throwable th) {
                th = th;
                IoUtils.closeQuietly(autoCloseable2);
                throw th;
            }
        } catch (Throwable th2) {
            th = th2;
            autoCloseable2 = autoCloseable;
            IoUtils.closeQuietly(autoCloseable2);
            throw th;
        }
    }

    public final Set<X509Certificate> b() {
        synchronized (this.d) {
            if (this.f != null) {
                return this.f;
            }
            HashSet hashSet = new HashSet();
            if (this.c.isDirectory()) {
                for (String str : this.c.list()) {
                    X509Certificate a = a(str);
                    if (a != null) {
                        hashSet.add(a);
                    }
                }
            }
            this.f = hashSet;
            return hashSet;
        }
    }

    @Override // javax.net.ssl.X509TrustManager
    public void checkClientTrusted(X509Certificate[] x509CertificateArr, String str) throws CertificateException {
    }

    @Override // javax.net.ssl.X509TrustManager
    public void checkServerTrusted(X509Certificate[] x509CertificateArr, String str) throws CertificateException {
        if (this.a) {
            for (X509Certificate x509Certificate : x509CertificateArr) {
                Iterator<X509Certificate> it = this.f.iterator();
                while (it.hasNext()) {
                    try {
                        x509Certificate.verify(it.next().getPublicKey());
                        return;
                    } catch (Exception e) {
                        sj0.a("Failed to verify with message" + e.getMessage());
                    }
                }
            }
            sj0.a("Failed to verify with custom certs");
            X509TrustManager a = a();
            if (a != null) {
                a.checkServerTrusted(x509CertificateArr, str);
                return;
            }
            throw new CertificateException();
        }
    }

    @Override // javax.net.ssl.X509TrustManager
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public final X509TrustManager a() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore) null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length == 1 && (trustManagers[0] instanceof X509TrustManager)) {
                return (X509TrustManager) trustManagers[0];
            }
            sj0.a("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            return null;
        } catch (GeneralSecurityException e) {
            sj0.a("Unexpected exception" + e.getMessage());
            return null;
        }
    }
}
