package defpackage;

import android.net.Uri;
import android.text.TextUtils;
import defpackage.gq0;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/* compiled from: HttpServe.java */
/* loaded from: classes.dex */
public abstract class fq0 {
    public Map<String, Method> methodMap;

    /* compiled from: HttpServe.java */
    @Target({ElementType.METHOD})
    @Retention(RetentionPolicy.RUNTIME)
    /* loaded from: classes.dex */
    public @interface a {
        String path() default "";
    }

    private void checkInit() {
        if (this.methodMap == null) {
            synchronized (fq0.class) {
                jq0.a("HttpServe", "checkInit", new Object[0]);
                if (this.methodMap == null) {
                    this.methodMap = new HashMap();
                    Method[] declaredMethods = getClass().getDeclaredMethods();
                    if (declaredMethods == null) {
                        jq0.a("HttpServe", "methods is null", new Object[0]);
                    } else {
                        jq0.a("HttpServe", "methods size = " + declaredMethods.length, new Object[0]);
                    }
                    for (Method method : declaredMethods) {
                        if (method != null) {
                            jq0.a("HttpServe", "method name is:" + method.getName(), new Object[0]);
                            a aVar = (a) method.getAnnotation(a.class);
                            jq0.a("HttpServe", "method name is:" + method.getName() + " path is :" + aVar, new Object[0]);
                            if (aVar != null && !TextUtils.isEmpty(aVar.path()) && gq0.o.class.isAssignableFrom(method.getReturnType())) {
                                jq0.a("HttpServe", "method name is:" + method.getName() + " path is :" + aVar.path(), new Object[0]);
                                this.methodMap.put(aVar.path(), method);
                                method.setAccessible(true);
                            }
                        }
                    }
                }
            }
        }
    }

    public gq0.o invoke(gq0.m mVar) {
        checkInit();
        Uri parse = Uri.parse(mVar.c());
        jq0.a("HttpServe", "uri is:" + parse, new Object[0]);
        if (parse == null) {
            return null;
        }
        Method method = this.methodMap.get(parse.getPath());
        jq0.a("HttpServe", "method is:" + method, new Object[0]);
        if (method != null) {
            try {
                return (gq0.o) method.invoke(this, mVar);
            } catch (Exception e) {
                jq0.a("HttpServe", "exception is:" + e.getMessage(), new Object[0]);
                e.printStackTrace();
            }
        }
        return null;
    }
}
