package defpackage;

import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.OnNmeaMessageListener;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.amap.location.sdk.fusion.ILocationExternalProvider;
import com.amap.location.sdk.fusion.LocationManagerProxy;
import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.amapauto.encrypt.Encrypt;
import com.autonavi.amapauto.jni.PosService;
import com.autonavi.amapauto.location.model.LocGpgsv;
import com.autonavi.amapauto.location.model.LocMMFeedbackInfo;
import com.autonavi.amapauto.protocol.model.service.RspGpsStatusNotifyModel;
import defpackage.as;
import defpackage.w80;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: LocationInstrument.java */
/* loaded from: classes.dex */
public abstract class fs implements LocationListener, w80 {
    public volatile boolean a;
    public long d;
    public LocationManagerProxy g;
    public js j;
    public Location k;
    public Location l;
    public int m;
    public long n;
    public final Object r;
    public volatile as.d s;
    public boolean b = false;
    public boolean c = false;
    public float e = 0.0f;
    public int f = 3;
    public boolean h = false;
    public boolean i = false;
    public boolean o = false;
    public boolean p = false;
    public long q = 0;
    public volatile List<g> t = new ArrayList();
    public HashSet<is<w80.b>> u = new HashSet<>();
    public Handler v = new e(Looper.getMainLooper());

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public class a implements GpsStatus.NmeaListener {
        public a(fs fsVar) {
        }

        @Override // android.location.GpsStatus.NmeaListener
        public void onNmeaReceived(long j, String str) {
            aa0.a("LocationInstrument", "onNmeaReceived timestamp:{?}, len:{?}, NMEA:{?}", Long.valueOf(j), Integer.valueOf(str.length()), str);
            PosService.nativeSetNmeaInfo(str, j);
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public class b implements OnNmeaMessageListener {
        public b(fs fsVar) {
        }

        @Override // android.location.OnNmeaMessageListener
        public void onNmeaMessage(String str, long j) {
            aa0.a("LocationInstrument", "onNmeaReceived timestamp:{?}, len:{?}, NMEA:{?}", Long.valueOf(j), Integer.valueOf(str.length()), str);
            PosService.nativeSetNmeaInfo(str, j);
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public class c implements Runnable {
        public final /* synthetic */ Context a;

        public c(Context context) {
            this.a = context;
        }

        @Override // java.lang.Runnable
        public void run() {
            fs.this.a(this.a);
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public class d implements Runnable {
        public d() {
        }

        @Override // java.lang.Runnable
        public void run() {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("ca", oq.i().a(oq.D, false));
                jSONObject.put("path", oq.i().a(oq.E, ""));
                aa0.a("LocationInstrument", "setNetworkParams jsonObject={?}", jSONObject.toString());
                fs.this.g.setParams(9, jSONObject);
            } catch (JSONException e) {
                aa0.a("LocationInstrument", Log.getStackTraceString(e), new Object[0]);
            }
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public class e extends Handler {
        public e(Looper looper) {
            super(looper);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            int i = message.what;
            if (i == 241) {
                fs.this.h = false;
                synchronized (fs.this.u) {
                    Iterator it = fs.this.u.iterator();
                    while (it.hasNext()) {
                        is isVar = (is) it.next();
                        if (isVar != null) {
                            isVar.a(w80.b.ON_LOCATION_GPS_FAIl);
                        }
                    }
                }
                return;
            }
            if (i == 243) {
                if (fs.this.h) {
                    return;
                }
                fs.this.h = true;
                fs.this.f = 1;
                fs fsVar = fs.this;
                fsVar.a(fsVar.f, fs.this.d, fs.this.e, fs.this);
                return;
            }
            if (i != 240 && i == 242) {
                synchronized (fs.this.u) {
                    Iterator it2 = fs.this.u.iterator();
                    while (it2.hasNext()) {
                        is isVar2 = (is) it2.next();
                        if (isVar2 != null) {
                            isVar2.a(w80.b.ON_LOCATION_OK);
                        }
                    }
                }
            }
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public static class f implements ILocationExternalProvider {
        public f() {
        }

        @Override // com.amap.location.sdk.fusion.ILocationExternalProvider
        public String aosEncrypt(String str) {
            if (str == null) {
                return null;
            }
            aa0.a("LocationInstrument", "EncryptProvider, aosEncrypt string", new Object[0]);
            return Encrypt.amapEncodeV2(str);
        }

        public /* synthetic */ f(a aVar) {
            this();
        }

        @Override // com.amap.location.sdk.fusion.ILocationExternalProvider
        public byte[] aosEncrypt(byte[] bArr) {
            if (bArr == null) {
                return null;
            }
            aa0.a("LocationInstrument", "EncryptProvider, aosEncrypt binary", new Object[0]);
            return Encrypt.amapEncodeBinaryV2(bArr);
        }
    }

    /* compiled from: LocationInstrument.java */
    /* loaded from: classes.dex */
    public interface g {
        void a(LocMMFeedbackInfo locMMFeedbackInfo);
    }

    public fs(Context context) {
        this.a = false;
        this.d = 1000L;
        e();
        LocationManagerProxy locationManagerProxy = LocationManagerProxy.getInstance();
        this.g = locationManagerProxy;
        locationManagerProxy.init(context);
        if (Build.VERSION.SDK_INT < 24) {
            this.r = new a(this);
        } else {
            this.r = new b(this);
        }
        this.g.setLocationExternalImpl(new f(null));
        as.g().a(this);
        this.s = new as.d();
        int c2 = oq.i().c();
        this.m = oq.i().a();
        this.a = false;
        long j = c2 > 0 ? c2 : this.d;
        this.d = j;
        aa0.a("LocationInstrument", "inteval = {?}", Long.valueOf(j));
        bb0.b(new c(context));
    }

    @Override // defpackage.v80
    public void a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int i, int i2, long j) {
    }

    @Override // defpackage.v80
    public void a(int i, double d2, double d3, double d4, int i2, long j) {
    }

    @Override // defpackage.v80
    public void a(int i, float f2, float f3, float f4, double d2, int i2, long j) {
    }

    public abstract void a(int i, long j, float f2, LocationListener locationListener);

    @Override // defpackage.v80
    public void a(Location location) {
    }

    @Override // defpackage.v80
    public void a(LocGpgsv locGpgsv) {
    }

    public void a(String str) {
    }

    public void d() {
    }

    public void f() {
        if (this.a) {
            return;
        }
        this.a = true;
        this.b = t90.e();
        this.c = t90.f();
        this.q = SystemClock.elapsedRealtime();
        if (oq.i().d() == 1) {
            this.f = 1;
        }
        int i = this.i ? 1 : 0;
        if (a(w80.a.PROVIDER_NETWORK, this.f)) {
            i |= 2;
        }
        int i2 = i;
        this.f = i2;
        Log.d("LocationInstrument", "doStartLocate: requestLocationUpdates");
        aa0.a("LocationInstrument", "doStartLocate: requestLocationUpdates", new Object[0]);
        a(i2, this.d, this.e, this);
        js jsVar = this.j;
        if (jsVar != null) {
            jsVar.a();
        }
        js jsVar2 = new js();
        this.j = jsVar2;
        jsVar2.b();
        if (oq.i().a(oq.e, -1) == 1) {
            aa0.a("LocationInstrument", "doStartLocate addNmeaListener", new Object[0]);
            LocationManager locationManager = (LocationManager) ee.A().f().getSystemService("location");
            if (Build.VERSION.SDK_INT < 24) {
                try {
                    LocationManager.class.getMethod("addNmeaListener", GpsStatus.NmeaListener.class).invoke(locationManager, (GpsStatus.NmeaListener) this.r);
                    return;
                } catch (Exception e2) {
                    aa0.a("LocationInstrument", "ocuur an Exception!!!", e2, new Object[0]);
                    return;
                }
            }
            try {
                locationManager.addNmeaListener((OnNmeaMessageListener) this.r);
            } catch (Exception e3) {
                aa0.a("LocationInstrument", "addNmeaListener ocuur an Exception upper N!!!", e3, new Object[0]);
            }
        }
    }

    public void g() {
        this.a = false;
        as.g().b(this.s);
        LocationManagerProxy locationManagerProxy = this.g;
        if (locationManagerProxy != null) {
            locationManagerProxy.removeUpdates(this);
        }
        synchronized (this) {
            if (this.j != null) {
                this.j.a();
                this.j = null;
            }
        }
        if (oq.i().a(oq.e, -1) == 1) {
            LocationManager locationManager = (LocationManager) ee.A().f().getSystemService("location");
            if (Build.VERSION.SDK_INT < 24) {
                try {
                    LocationManager.class.getMethod("removeNmeaListener", GpsStatus.NmeaListener.class).invoke(locationManager, (GpsStatus.NmeaListener) this.r);
                    return;
                } catch (Exception e2) {
                    aa0.a("LocationInstrument", "ocuur an Exception!!!", e2, new Object[0]);
                    return;
                }
            }
            try {
                locationManager.removeNmeaListener((OnNmeaMessageListener) this.r);
            } catch (Exception e3) {
                aa0.a("LocationInstrument", "removeNmeaListener ocuur an Exception upper N!!!", e3, new Object[0]);
            }
        }
    }

    @Override // defpackage.w80
    public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
        LocationManagerProxy locationManagerProxy = this.g;
        return locationManagerProxy != null ? locationManagerProxy.getGpsStatus(gpsStatus) : gpsStatus;
    }

    public void h() {
    }

    public void i() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = null;
        try {
            jSONObject = new JSONObject();
        } catch (Throwable unused) {
        }
        try {
            jSONObject.put(LocationParams.PARA_COMMON_DIP, URLEncoder.encode(rq.A(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIV, URLEncoder.encode(rq.E(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_AUTODIV, URLEncoder.encode(rq.q(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIBV, URLEncoder.encode(rq.y(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIE, "Unknown");
            jSONObject.put(LocationParams.PARA_COMMON_DID, "Unknown");
            jSONObject.put(LocationParams.PARA_COMMON_DIC, URLEncoder.encode(rq.z(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIU, URLEncoder.encode(rq.B(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIU2, URLEncoder.encode(r90.a(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_DIU3, URLEncoder.encode(rq.H(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_CIFA, rq.w());
            jSONObject.put(LocationParams.PARA_COMMON_CHANNEL, URLEncoder.encode(rq.v(), "UTF-8"));
            jSONObject.put(LocationParams.PARA_COMMON_FROM, "Unknown");
            jSONObject.put(LocationParams.PARA_COMMON_TID, rq.N());
            jSONObject.put("session", rq.L());
            jSONObject.put("spm", URLEncoder.encode(rq.M(), "UTF-8"));
            jSONObject.put("stepid", rq.j());
            String c2 = da0.c();
            if (!TextUtils.isEmpty(c2)) {
                jSONObject.put(LocationParams.PARA_AUTO_LOG_PATH, c2 + "location/");
            }
            aa0.a("LocationInstrument", "setNetworkParams jo={?}", jSONObject.toString());
            if (!TextUtils.isEmpty(rq.l())) {
                jSONObject.put(LocationParams.PARA_COMMON_ADIU, rq.l());
            }
        } catch (Throwable unused2) {
            jSONObject2 = jSONObject;
            jSONObject = jSONObject2;
            this.g.setParams(1, jSONObject);
            bb0.a(new d(), 1000L);
            if (t90.e()) {
                return;
            } else {
                return;
            }
        }
        this.g.setParams(1, jSONObject);
        bb0.a(new d(), 1000L);
        if (t90.e() || t90.f()) {
            return;
        }
        this.s = new as.d();
        as.g().a(this.s);
    }

    @Override // android.location.LocationListener
    public void onLocationChanged(Location location) {
        Location location2;
        Bundle extras;
        if (location == null) {
            aa0.a("LocationInstrument", "onLocationChanged location is null", new Object[0]);
            return;
        }
        aa0.a("LocationInstrument", "onLocationChanged getLongitude = " + location.getLongitude() + " getLatitude = " + location.getLatitude() + " getSpeed = " + location.getSpeed() + " getBearing = " + location.getBearing() + " isGPS = " + "gps".equals(location.getProvider()) + "location.getTime()=" + location.getTime(), new Object[0]);
        if ("gps".equals(location.getProvider())) {
            location.setTime(location.getTime() + (this.m * 3600000));
            synchronized (this) {
                this.v.obtainMessage(243).sendToTarget();
            }
            if (oq.i().a(oq.m, 1) == 1) {
                b(0);
            }
            if (!this.o && (extras = location.getExtras()) != null) {
                if (!TextUtils.isEmpty(extras.getString("AmapAutoDRPos"))) {
                    as.g().a(2, 0);
                }
                this.o = true;
            }
        }
        as.g().a(location);
        u90.d(ee.A().f()).a((int) (location.getLongitude() * 1000000.0d), (int) (location.getLatitude() * 1000000.0d), (int) location.getAccuracy());
        u90.d(ee.A().f()).a(location.getSpeed());
        Location location3 = this.l;
        if (location3 != null && (location2 = this.k) != null) {
            location2.setProvider(location3.getProvider());
        }
        if ("gps".equals(location.getProvider())) {
            this.v.obtainMessage(242).sendToTarget();
        }
    }

    public void onMapMatchFeedbackUpdate(LocMMFeedbackInfo locMMFeedbackInfo) {
        a(locMMFeedbackInfo);
    }

    @Override // android.location.LocationListener
    public void onProviderDisabled(String str) {
    }

    @Override // android.location.LocationListener
    public void onProviderEnabled(String str) {
    }

    @Override // android.location.LocationListener
    public void onStatusChanged(String str, int i, Bundle bundle) {
    }

    @Override // defpackage.w80
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        LocationManagerProxy locationManagerProxy = this.g;
        if (locationManagerProxy != null) {
            locationManagerProxy.removeGpsStatusListener(listener);
        }
    }

    @Override // defpackage.w80
    public void b() {
        if (this.s != null) {
            this.s.d();
        }
    }

    @Override // defpackage.w80
    public void c() {
        if (this.s != null) {
            this.s.c();
        }
    }

    public final void e() {
        try {
            ((LocationManager) ee.A().f().getSystemService("location")).isProviderEnabled("gps");
            this.i = true;
        } catch (Throwable unused) {
            Log.d("LocationInstrument", "GPS模块不存在或没有添加GPS使用权限或用户关闭了当前应用的GPS使用权限.");
            this.i = false;
        }
    }

    public void b(int i) {
        fv.e().a((dx) new zx(new RspGpsStatusNotifyModel(i)));
    }

    public final void a(Context context) {
        boolean isProviderEnabled = this.g.isProviderEnabled(1);
        boolean isProviderEnabled2 = this.g.isProviderEnabled(2);
        int i = e7.a(context, "android.permission.ACCESS_FINE_LOCATION") == 0 ? 1 : 0;
        boolean f2 = n90.f(context);
        as.g().a("isGpsOpen=" + (isProviderEnabled ? 1 : 0) + ",isNetLocateOpen=" + (isProviderEnabled2 ? 1 : 0) + ",hasGpsPermission=" + i + ",isNetAvailable=" + (f2 ? 1 : 0));
        String format = String.format(Locale.US, "[%s][11][%d][%d][%d][%d][%s][%s][%s][%s][%s][%s][%d]", 10040003, Integer.valueOf(isProviderEnabled ? 1 : 0), Integer.valueOf(isProviderEnabled2 ? 1 : 0), Integer.valueOf(i), Integer.valueOf(f2 ? 1 : 0), "", "", "", "", "", "", 0);
        aa0.a("requestGpsStartInfo", "collectionInfo = {?}", format);
        ge.b("mod_pos", 10040003, format, 1);
    }

    @Override // defpackage.w80
    public void b(GnssStatus.Callback callback) {
        try {
            ((LocationManager) ee.A().f().getSystemService("location")).unregisterGnssStatusCallback(callback);
        } catch (Exception e2) {
            aa0.a("LocationInstrument", "unRegisterGnssStatusCallback e = {?}", e2.getMessage());
        }
    }

    public final boolean a(w80.a aVar, int i) {
        return (aVar.a() & i) > 0;
    }

    @Override // defpackage.v80
    public void a(double d2, int i, long j) {
        as.g().a(d2, i, j);
    }

    @Override // defpackage.w80
    public void a(GpsStatus.Listener listener) {
        LocationManagerProxy locationManagerProxy = this.g;
        if (locationManagerProxy != null) {
            locationManagerProxy.addGpsStatusListener(listener, Looper.getMainLooper());
        }
    }

    @Override // defpackage.w80
    public void a(GnssStatus.Callback callback) {
        try {
            aa0.a("LocationInstrument", "registerGnssStatusCallback result = {?}", Boolean.valueOf(((LocationManager) ee.A().f().getSystemService("location")).registerGnssStatusCallback(callback)));
        } catch (Exception e2) {
            aa0.a("LocationInstrument", "registerGnssStatusCallback e = {?}", e2.getMessage());
        }
    }

    @Override // defpackage.w80
    public void a() {
        aa0.a("LocationInstrument", "feedBackLog enter!", new Object[0]);
        if (this.g != null) {
            aa0.a("LocationInstrument", "feedBackLog locationManager != null!", new Object[0]);
            JSONObject jSONObject = new JSONObject();
            try {
                long currentTimeMillis = System.currentTimeMillis();
                jSONObject.put(LocationParams.PARA_FEEDBAK_TIME, currentTimeMillis);
                aa0.a("LocationInstrument", "feedBackLog locationManager PARA_FEEDBAK_TIME:{?}", Long.valueOf(currentTimeMillis));
                this.g.setParams(3, jSONObject);
            } catch (JSONException e2) {
                aa0.a("LocationInstrument", Log.getStackTraceString(e2), new Object[0]);
            }
        }
        aa0.a("LocationInstrument", "feedBackLog end!", new Object[0]);
    }

    @Override // defpackage.w80
    public void a(String str, String str2, String str3) {
        if (this.g != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(LocationParams.PARA_ATUO_PROXY_SET, str);
                jSONObject.put(LocationParams.PARA_ATUO_PROXY_HOST, str2);
                jSONObject.put(LocationParams.PARA_ATUO_PROXY_PORT, str3);
                this.g.setParams(9, jSONObject);
            } catch (JSONException e2) {
                aa0.a("LocationInstrument", Log.getStackTraceString(e2), new Object[0]);
            }
        }
    }

    public void a(w80.a... aVarArr) {
        aa0.a("LocationInstrument", "setProvider:providers={?}", Arrays.toString(aVarArr));
        if (this.g == null) {
            return;
        }
        if (aVarArr != null && aVarArr.length > 0) {
            int i = 0;
            for (w80.a aVar : aVarArr) {
                if (aVar != null) {
                    i = aVar.a() | i;
                }
            }
            this.f = i;
            a(i, this.d, this.e, this);
            return;
        }
        this.g.removeUpdates(this);
        this.f = 0;
    }

    @Override // defpackage.w80
    public boolean a(int i) {
        if (i != 0) {
            if (i != 1) {
                if (i == 2 && this.g.isProviderEnabled(2) && this.g.isProviderEnabled(1)) {
                    a(w80.a.PROVIDER_GPS, w80.a.PROVIDER_NETWORK);
                }
            } else if (this.g.isProviderEnabled(2)) {
                a(w80.a.PROVIDER_NETWORK);
            }
        } else if (this.g.isProviderEnabled(1)) {
            a(w80.a.PROVIDER_GPS);
        }
        return true;
    }

    public final void a(LocMMFeedbackInfo locMMFeedbackInfo) {
        aa0.a("LocationInstrument", "notifyMapMatchFeedbackChanged size " + this.t.size(), new Object[0]);
        for (int size = this.t.size() + (-1); size >= 0; size--) {
            this.t.get(size).a(locMMFeedbackInfo);
        }
    }
}
