package defpackage;

import android.content.Intent;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.data.ChargeInfoData;
import com.autonavi.amapauto.jni.protocol.data.CitysuggestionData;
import com.autonavi.amapauto.jni.protocol.data.DeepInfoData;
import com.autonavi.amapauto.jni.protocol.data.EnteryData;
import com.autonavi.amapauto.jni.protocol.data.OilInfoData;
import com.autonavi.amapauto.jni.protocol.data.ParkInfoData;
import com.autonavi.amapauto.jni.protocol.data.PoiData;
import com.autonavi.amapauto.jni.protocol.data.SearchResultData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.data.PoiInfo;
import com.autonavi.amapauto.protocol.data.RspAlongWaySearchData;
import com.autonavi.amapauto.protocol.data.search.Biz_ext;
import com.autonavi.amapauto.protocol.data.search.Citysuggestion;
import com.autonavi.amapauto.protocol.data.search.EnteryList;
import com.autonavi.amapauto.protocol.data.search.Poi;
import com.autonavi.amapauto.protocol.data.search.SearchPoiResult;
import com.autonavi.amapauto.protocol.data.search.SearchResponseData;
import com.autonavi.amapauto.protocol.data.search.SuggestionCityDetail;
import java.math.BigDecimal;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/* compiled from: SearchUtils.java */
/* loaded from: classes.dex */
public class ja0 {
    public static String a(SearchResultData searchResultData) {
        if (searchResultData == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        List<PoiData> pois = searchResultData.getPois();
        List<CitysuggestionData> cityList = searchResultData.getCityList();
        int i = 0;
        if (cityList != null && cityList.size() > 0) {
            int size = cityList.size();
            while (i < size) {
                JSONObject a = a(cityList.get(i));
                if (a != null) {
                    jSONArray.put(a);
                }
                i++;
            }
        } else if (pois != null) {
            int size2 = pois.size();
            while (i < size2) {
                JSONObject a2 = a(pois.get(i));
                if (a2 != null) {
                    jSONArray.put(a2);
                }
                i++;
            }
        }
        return jSONArray.toString();
    }

    public static String b(int i, List<PoiData> list) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_TYPE, i);
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_RESULT_SIZE, list.size());
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < list.size(); i2++) {
                JSONObject jSONObject2 = new JSONObject();
                PoiData poiData = list.get(i2);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_NAME, poiData.name);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_DISTANCE, poiData.distance);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_ADDR, poiData.address);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_LONGITUDE, String.valueOf(poiData.longitude));
                jSONObject2.put(StandardProtocolKey.ALONG_POI_LATITUDE, String.valueOf(poiData.latitude));
                jSONObject2.put(StandardProtocolKey.POICATEGORY, poiData.poitype);
                o80.a(jSONObject2, poiData);
                jSONArray.put(jSONObject2);
            }
            jSONObject.put(StandardProtocolKey.ALONG_POI_INFO, jSONArray);
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e);
        }
        return jSONObject.toString();
    }

    public static String a(SearchResponseData searchResponseData) {
        if (searchResponseData == null || searchResponseData.a == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        SearchPoiResult searchPoiResult = searchResponseData.a;
        List<Poi> list = searchPoiResult.c;
        Citysuggestion citysuggestion = searchPoiResult.e;
        List<SuggestionCityDetail> list2 = citysuggestion != null ? citysuggestion.c : null;
        int i = 0;
        if (list2 != null && list2.size() > 0) {
            int size = list2.size();
            while (i < size) {
                JSONObject a = a(list2.get(i));
                if (a != null) {
                    jSONArray.put(a);
                }
                i++;
            }
        } else if (list != null) {
            int size2 = list.size();
            while (i < size2) {
                JSONObject a2 = a(list.get(i));
                if (a2 != null) {
                    jSONArray.put(a2);
                }
                i++;
            }
        }
        return jSONArray.toString();
    }

    public static JSONObject a(SuggestionCityDetail suggestionCityDetail) {
        if (suggestionCityDetail == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.CITY_SUGGESTION_NAME, suggestionCityDetail.a);
            jSONObject.put(StandardProtocolKey.CITY_SUGGESTION_NUM, suggestionCityDetail.c);
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(Poi poi) {
        if (poi == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.POIID, poi.m);
            jSONObject.put(StandardProtocolKey.NAME, poi.d);
            jSONObject.put(StandardProtocolKey.POI_ADDRESS, poi.j);
            double doubleValue = new BigDecimal(poi.k).setScale(6, 4).doubleValue();
            double doubleValue2 = new BigDecimal(poi.g).setScale(6, 4).doubleValue();
            jSONObject.put("latitude", doubleValue);
            jSONObject.put("longitude", doubleValue2);
            List<EnteryList> list = poi.a;
            if (list != null && list.size() > 0) {
                double doubleValue3 = new BigDecimal(list.get(0).c).setScale(6, 4).doubleValue();
                double doubleValue4 = new BigDecimal(list.get(0).a).setScale(6, 4).doubleValue();
                jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue3);
                jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, doubleValue4);
            } else {
                jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, 0.0d);
                jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, 0.0d);
            }
            jSONObject.put(StandardProtocolKey.POI_DISTANCE, poi.e);
            jSONObject.put(StandardProtocolKey.TEL, poi.l == null ? "" : poi.l);
            jSONObject.put(StandardProtocolKey.POITYPE, poi.n);
            jSONObject.put(StandardProtocolKey.POICATEGORY, poi.f);
            Biz_ext biz_ext = poi.c;
            if (biz_ext != null) {
                jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, biz_ext.c);
                jSONObject.put(StandardProtocolKey.POIDEEPINFO, a(biz_ext));
            }
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(Biz_ext biz_ext) {
        if (biz_ext == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAG, biz_ext.d);
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, biz_ext.c);
            if (!TextUtils.isEmpty(biz_ext.a)) {
                Object nextValue = new JSONTokener(biz_ext.a).nextValue();
                if (nextValue instanceof JSONObject) {
                    jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO, (JSONObject) nextValue);
                } else if (nextValue instanceof JSONArray) {
                    jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO, (JSONArray) nextValue);
                }
            }
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(CitysuggestionData citysuggestionData) {
        if (citysuggestionData == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.CITY_SUGGESTION_NAME, citysuggestionData.cityname);
            jSONObject.put(StandardProtocolKey.CITY_SUGGESTION_NUM, citysuggestionData.citynum);
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(PoiData poiData) {
        if (poiData == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.POIID, poiData.getPoiid());
            jSONObject.put(StandardProtocolKey.NAME, poiData.name);
            jSONObject.put(StandardProtocolKey.POI_ADDRESS, poiData.address);
            double doubleValue = new BigDecimal(poiData.latitude).setScale(6, 4).doubleValue();
            double doubleValue2 = new BigDecimal(poiData.longitude).setScale(6, 4).doubleValue();
            jSONObject.put("latitude", doubleValue);
            jSONObject.put("longitude", doubleValue2);
            List<EnteryData> enteryList = poiData.getEnteryList();
            if (enteryList != null && enteryList.size() > 0) {
                double doubleValue3 = new BigDecimal(enteryList.get(0).latitude).setScale(6, 4).doubleValue();
                double doubleValue4 = new BigDecimal(enteryList.get(0).longitude).setScale(6, 4).doubleValue();
                jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue3);
                jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, doubleValue4);
            } else {
                jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, 0.0d);
                jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, 0.0d);
            }
            jSONObject.put(StandardProtocolKey.POI_DISTANCE, poiData.distance);
            jSONObject.put(StandardProtocolKey.TEL, poiData.getTel());
            jSONObject.put(StandardProtocolKey.POITYPE, poiData.homecopType);
            jSONObject.put(StandardProtocolKey.POICATEGORY, String.valueOf(poiData.poitype));
            DeepInfoData poideepinfo = poiData.getPoideepinfo();
            if (poideepinfo != null) {
                jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, poideepinfo.category);
                jSONObject.put(StandardProtocolKey.POIDEEPINFO, a(poideepinfo));
            }
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(DeepInfoData deepInfoData) {
        if (deepInfoData == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAG, deepInfoData.tag);
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_CATEGORY, deepInfoData.category);
            ParkInfoData parkinfo = deepInfoData.getParkinfo();
            if (parkinfo != null) {
                jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO, a(parkinfo));
            }
            List<OilInfoData> taginfoList = deepInfoData.getTaginfoList();
            if (taginfoList != null && taginfoList.size() > 0) {
                jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO, a(taginfoList));
            }
            ChargeInfoData chargeInfoData = deepInfoData.chargeInfo;
            if (chargeInfoData != null) {
                jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO, a(chargeInfoData));
            }
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONObject a(ChargeInfoData chargeInfoData) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_TOTAL_QUICK, chargeInfoData.totalQuick);
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_IDEL_QUICK, chargeInfoData.idleQuick);
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_TOTAL_SLOW, chargeInfoData.totalSlow);
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_IDEL_SLOW, chargeInfoData.idleSlow);
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_BRAND_DESC, chargeInfoData.brand_desc);
        jSONObject.put(StandardProtocolKey.POIDEEPINFO_CHARGE_CSCF_TYPE, chargeInfoData.cscf_type);
        return jSONObject;
    }

    public static JSONObject a(ParkInfoData parkInfoData) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO_PARKINGINFO, parkInfoData.parkinginfo);
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICEINFO, parkInfoData.priceinfo);
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static JSONArray a(List<OilInfoData> list) {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < list.size(); i++) {
            JSONObject a = a(list.get(i));
            if (a != null) {
                jSONArray.put(a);
            }
        }
        return jSONArray;
    }

    public static JSONObject a(OilInfoData oilInfoData) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", oilInfoData.type);
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICE, oilInfoData.price);
            jSONObject.put(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICETAG, oilInfoData.pricetag);
            return jSONObject;
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
            return null;
        }
    }

    public static void a(int i, RspAlongWaySearchData rspAlongWaySearchData, int i2, Intent intent) {
        if (rspAlongWaySearchData == null) {
            intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, 1);
            intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, a(i));
            return;
        }
        if (rspAlongWaySearchData.getPoiResult() != null && rspAlongWaySearchData.getPoiResult().n() != null && rspAlongWaySearchData.getPoiResult().n().size() > 0) {
            List<PoiInfo> n = rspAlongWaySearchData.getPoiResult().n();
            aa0.a("SearchUtils", "poi list size:{?}", Integer.valueOf(n.size()));
            intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, a(i, n));
            intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, 0);
            return;
        }
        int a = g40.a(i2, null);
        intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, a != 2 ? a : 1);
        intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, a(i));
    }

    public static void a(int i, SearchResultData searchResultData, Intent intent) {
        if (searchResultData == null) {
            intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, 1);
            intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, a(i));
        } else if (searchResultData.getPois() != null && searchResultData.getPois().size() > 0) {
            aa0.a("SearchUtils", "poi list size:{?}", Integer.valueOf(searchResultData.getPois().size()));
            intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, b(i, searchResultData.getPois()));
            intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, 0);
        } else {
            int a = g40.a(searchResultData);
            intent.putExtra(StandardProtocolKey.SEARCH_RESULT_CODE, a != 2 ? a : 1);
            intent.putExtra(StandardProtocolKey.EXTRA_SEARCH_ALONG_THE_WAY, a(i));
        }
    }

    public static String a(int i) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_TYPE, i);
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_RESULT_SIZE, 0);
            jSONObject.put(StandardProtocolKey.ALONG_POI_INFO, (Object) null);
            jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, 0);
            jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, 0);
        } catch (JSONException e) {
            aa0.a("SearchUtils", e.getMessage(), e);
        }
        return jSONObject.toString();
    }

    public static String a(int i, List<PoiInfo> list) {
        int i2;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_TYPE, i);
            jSONObject.put(StandardProtocolKey.ALONG_SEARCH_RESULT_SIZE, list.size());
            JSONArray jSONArray = new JSONArray();
            for (int i3 = 0; i3 < list.size(); i3++) {
                JSONObject jSONObject2 = new JSONObject();
                PoiInfo poiInfo = list.get(i3);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_NAME, poiInfo.a);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_DISTANCE, poiInfo.d);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_ADDR, poiInfo.c);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_LONGITUDE, String.valueOf(poiInfo.i));
                jSONObject2.put(StandardProtocolKey.ALONG_POI_LATITUDE, String.valueOf(poiInfo.h));
                try {
                    i2 = Integer.parseInt(poiInfo.j);
                } catch (Exception e) {
                    aa0.a("SearchUtils", e.getMessage(), e, new Object[0]);
                    i2 = 0;
                }
                jSONObject2.put(StandardProtocolKey.POICATEGORY, i2);
                jSONObject2.put(StandardProtocolKey.ENTRY_LONGITUDE, poiInfo.g);
                jSONObject2.put(StandardProtocolKey.ENTRY_LATITUDE, poiInfo.f);
                jSONObject2.put(StandardProtocolKey.POIID, poiInfo.e);
                jSONArray.put(jSONObject2);
            }
            jSONObject.put(StandardProtocolKey.ALONG_POI_INFO, jSONArray);
        } catch (JSONException e2) {
            aa0.a("SearchUtils", e2.getMessage(), e2);
        }
        return jSONObject.toString();
    }
}
