package defpackage;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.autonavi.amapauto.alink.IAlinkSencorListener;
import com.autonavi.amapauto.ar.camera.ArSensorManagerNative;
import com.autonavi.amapauto.ar.camera.model.ArSensorInfo;
import java.util.Arrays;

/* compiled from: CustomSensorListener.java */
/* loaded from: classes.dex */
public class jf implements SensorEventListener, IAlinkSencorListener {
    public static long i;
    public HandlerThread e;
    public Handler f;
    public final String a = jf.class.getSimpleName();
    public ArSensorInfo b = new ArSensorInfo();
    public boolean c = false;
    public boolean d = false;
    public Runnable g = new a();
    public Runnable h = new b();

    /* compiled from: CustomSensorListener.java */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        public a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            jf.this.c = false;
            aa0.a(jf.this.a, "onSensorDataReceived: timeout!", new Object[0]);
        }
    }

    /* compiled from: CustomSensorListener.java */
    /* loaded from: classes.dex */
    public class b implements Runnable {
        public b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            jf.this.c = false;
            aa0.a(jf.this.a, "onSensorDataReceived: timeout!", new Object[0]);
        }
    }

    public jf() {
        HandlerThread handlerThread = new HandlerThread("CustomSensorThread");
        this.e = handlerThread;
        handlerThread.start();
        this.f = new Handler(this.e.getLooper());
    }

    @Override // android.hardware.SensorEventListener
    public void onAccuracyChanged(Sensor sensor, int i2) {
        aa0.a(this.a, "onAccuracyChanged: accuracy = {?}", Integer.valueOf(i2));
    }

    @Override // android.hardware.SensorEventListener
    public void onSensorChanged(SensorEvent sensorEvent) {
        Sensor sensor;
        if (sensorEvent == null || (sensor = sensorEvent.sensor) == null) {
            return;
        }
        aa0.a(this.a, "onSensorChanged chenged, type:{?}", Integer.valueOf(sensor.getType()));
        long currentTimeMillis = System.currentTimeMillis();
        int type = sensorEvent.sensor.getType();
        if (type != 1) {
            if (type == 2) {
                ArSensorInfo arSensorInfo = this.b;
                float[] fArr = arSensorInfo.geoMagneticValues;
                float[] fArr2 = sensorEvent.values;
                fArr[0] = fArr2[0];
                fArr[1] = fArr2[1];
                fArr[2] = fArr2[2];
                arSensorInfo.geoMagneticValid = true;
            } else if (type != 4) {
                if (type == 9) {
                    float[] fArr3 = this.b.grivityData;
                    float[] fArr4 = sensorEvent.values;
                    fArr3[0] = fArr4[0] / 9.80665f;
                    fArr3[1] = fArr4[1] / 9.80665f;
                    fArr3[2] = fArr4[2] / 9.80665f;
                } else if (type == 15) {
                    int i2 = 0;
                    while (true) {
                        float[] fArr5 = this.b.orientations;
                        if (i2 >= fArr5.length) {
                            break;
                        }
                        fArr5[i2] = sensorEvent.values[i2];
                        i2++;
                    }
                }
            } else if (!this.c) {
                ArSensorInfo arSensorInfo2 = this.b;
                float[] fArr6 = arSensorInfo2.gyroscopeValues;
                float[] fArr7 = sensorEvent.values;
                fArr6[0] = fArr7[0];
                fArr6[1] = fArr7[1];
                fArr6[2] = fArr7[2];
                arSensorInfo2.gyroscopeValid = true;
            }
        } else if (!this.d) {
            ArSensorInfo arSensorInfo3 = this.b;
            float[] fArr8 = arSensorInfo3.accValues;
            float[] fArr9 = sensorEvent.values;
            fArr8[0] = fArr9[0];
            fArr8[1] = fArr9[1];
            fArr8[2] = fArr9[2];
            arSensorInfo3.accValid = true;
        }
        long j = i;
        long j2 = currentTimeMillis - j;
        if (j == 0 || j2 >= 97) {
            ArSensorInfo arSensorInfo4 = new ArSensorInfo();
            ArSensorInfo arSensorInfo5 = this.b;
            arSensorInfo4.accValid = arSensorInfo5.accValid;
            arSensorInfo4.gyroscopeValid = arSensorInfo5.gyroscopeValid;
            arSensorInfo4.geoMagneticValid = arSensorInfo5.geoMagneticValid;
            arSensorInfo4.accValues = (float[]) arSensorInfo5.accValues.clone();
            arSensorInfo4.gyroscopeValues = (float[]) this.b.gyroscopeValues.clone();
            arSensorInfo4.geoMagneticValues = (float[]) this.b.geoMagneticValues.clone();
            arSensorInfo4.grivityData = (float[]) this.b.grivityData.clone();
            arSensorInfo4.rotationMatrix = (float[]) this.b.rotationMatrix.clone();
            arSensorInfo4.remappedRotationMatrix = (float[]) this.b.remappedRotationMatrix.clone();
            arSensorInfo4.orientations = (float[]) this.b.orientations.clone();
            i = currentTimeMillis;
            aa0.a(this.a, "onSensorChanged:sensorInfo = {?} ", arSensorInfo4);
            ArSensorManagerNative.notifySensorEvent(arSensorInfo4);
        }
    }

    @Override // com.autonavi.amapauto.alink.IAlinkSencorListener
    public int onSensorDataReceived(int i2, long j, double[] dArr, int i3) {
        aa0.a(this.a, "onSensorDataReceived: category = {?} values = {?}", Integer.valueOf(i2), Arrays.toString(dArr));
        if (i2 == 1) {
            this.f.removeCallbacks(this.h);
            this.f.removeCallbacksAndMessages(null);
            this.f.postDelayed(this.h, 1000L);
            this.d = true;
            ArSensorInfo arSensorInfo = this.b;
            float[] fArr = arSensorInfo.accValues;
            fArr[0] = (float) dArr[0];
            fArr[1] = (float) dArr[1];
            fArr[2] = (float) dArr[2];
            arSensorInfo.accValid = true;
        } else if (i2 == 2) {
            this.f.removeCallbacks(this.g);
            this.f.removeCallbacksAndMessages(null);
            this.f.postDelayed(this.g, 1000L);
            this.c = true;
            ArSensorInfo arSensorInfo2 = this.b;
            float[] fArr2 = arSensorInfo2.gyroscopeValues;
            fArr2[0] = (float) dArr[0];
            fArr2[1] = (float) dArr[1];
            fArr2[2] = (float) dArr[2];
            arSensorInfo2.gyroscopeValid = true;
        }
        return 0;
    }

    public void a() {
        HandlerThread handlerThread = this.e;
        if (handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                handlerThread.quitSafely();
            } else {
                handlerThread.quit();
            }
            this.e = null;
        }
        Handler handler = this.f;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }
}
