package defpackage;

import android.content.Intent;
import com.autonavi.amapauto.jni.protocol.data.NaviParkingData;
import com.autonavi.amapauto.jni.protocol.data.NaviParkingItemData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.ProtocolParkInfo;
import com.autonavi.amapauto.protocol.model.service.ParkInfoModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/* compiled from: ParkingInfoDisAction.java */
/* loaded from: classes.dex */
public class k00 extends dx implements t50, s50 {
    public NaviParkingData d;

    public k00(NaviParkingData naviParkingData) {
        this.d = naviParkingData;
    }

    @Override // defpackage.s50
    public ProtocolBaseModel a() {
        NaviParkingData naviParkingData = this.d;
        if (naviParkingData != null) {
            return a(naviParkingData);
        }
        return null;
    }

    @Override // defpackage.t50
    public Intent b() {
        Intent intent = new Intent();
        intent.putExtra(StandardProtocolKey.KEY_TYPE, 10052);
        intent.putExtra(StandardProtocolKey.EXTRA_PARK_DATA, f());
        return intent;
    }

    public final String f() {
        JSONArray jSONArray = new JSONArray();
        try {
            try {
                if (this.d != null && this.d.getParkingList() != null) {
                    for (NaviParkingItemData naviParkingItemData : this.d.getParkingList()) {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put(StandardProtocolKey.PARK_INDEX, naviParkingItemData.index);
                        jSONObject.put(StandardProtocolKey.PARK_NAME, naviParkingItemData.name);
                        jSONObject.put(StandardProtocolKey.PARK_DISTANCE, naviParkingItemData.distance);
                        jSONObject.put(StandardProtocolKey.PARK_PRICE, naviParkingItemData.price);
                        double doubleValue = new BigDecimal(naviParkingItemData.latitude).setScale(6, 4).doubleValue();
                        double doubleValue2 = new BigDecimal(naviParkingItemData.longitude).setScale(6, 4).doubleValue();
                        jSONObject.put("latitude", doubleValue);
                        jSONObject.put("longitude", doubleValue2);
                        jSONObject.put(StandardProtocolKey.TAG_CATEGORY, naviParkingItemData.category);
                        jSONObject.put(StandardProtocolKey.NUM_SPACE_F, String.valueOf(naviParkingItemData.spaceNum));
                        double doubleValue3 = new BigDecimal(naviParkingItemData.entrylon).setScale(6, 4).doubleValue();
                        double doubleValue4 = new BigDecimal(naviParkingItemData.entrylat).setScale(6, 4).doubleValue();
                        jSONObject.put("latitude", doubleValue);
                        jSONObject.put("longitude", doubleValue2);
                        jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, doubleValue3);
                        jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue4);
                        jSONObject.put(StandardProtocolKey.POIID, naviParkingItemData.poiid);
                        jSONArray.put(jSONObject);
                    }
                }
                return jSONArray.toString();
            } catch (Exception e) {
                aa0.a("ParkingInfoDisAction", e.getMessage(), e);
                return jSONArray.toString();
            }
        } catch (Throwable unused) {
            return jSONArray.toString();
        }
    }

    public static ParkInfoModel a(NaviParkingData naviParkingData) {
        List<NaviParkingItemData> parkingList = naviParkingData.getParkingList();
        if (parkingList == null || parkingList.size() == 0) {
            return null;
        }
        ParkInfoModel parkInfoModel = new ParkInfoModel();
        parkInfoModel.c(naviParkingData.getDialogType());
        parkInfoModel.setCount(parkingList.size());
        ArrayList<ProtocolParkInfo> arrayList = new ArrayList<>();
        for (NaviParkingItemData naviParkingItemData : parkingList) {
            ProtocolParkInfo protocolParkInfo = new ProtocolParkInfo();
            protocolParkInfo.c(naviParkingItemData.index);
            protocolParkInfo.setName(naviParkingItemData.name);
            protocolParkInfo.setDistance(naviParkingItemData.distance);
            protocolParkInfo.b(naviParkingItemData.price);
            double doubleValue = new BigDecimal(naviParkingItemData.latitude).setScale(6, 4).doubleValue();
            double doubleValue2 = new BigDecimal(naviParkingItemData.longitude).setScale(6, 4).doubleValue();
            double doubleValue3 = new BigDecimal(naviParkingItemData.entrylat).setScale(6, 4).doubleValue();
            double doubleValue4 = new BigDecimal(naviParkingItemData.entrylon).setScale(6, 4).doubleValue();
            protocolParkInfo.setLatitude(doubleValue);
            protocolParkInfo.setLongitude(doubleValue2);
            protocolParkInfo.setEntry_latitude(doubleValue3);
            protocolParkInfo.setEntry_longitude(doubleValue4);
            protocolParkInfo.a(naviParkingItemData.category);
            protocolParkInfo.d(naviParkingItemData.spaceNum);
            protocolParkInfo.setPoiid(naviParkingItemData.poiid);
            arrayList.add(protocolParkInfo);
        }
        parkInfoModel.a(arrayList);
        return parkInfoModel;
    }
}
