package defpackage;

import android.os.Bundle;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.amapauto.jni.protocol.data.DriveWayData;
import com.autonavi.amapauto.jni.protocol.data.DriveWayItemData;
import com.autonavi.amapauto.jni.protocol.data.JsonHeader;
import com.autonavi.amapauto.jni.protocol.data.JsonParam;
import com.autonavi.amapauto.jni.protocol.data.JsonResult;
import com.autonavi.amapauto.jni.protocol.data.NaviParkingData;
import com.autonavi.amapauto.jni.protocol.data.NaviParkingItemData;
import com.autonavi.amapauto.jni.protocol.data.TmcInfoData;
import com.autonavi.amapauto.jni.protocol.data.TmcSegmentData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.wireless.WirelessSDK;
import defpackage.g60;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: JsonBuilderUtils.java */
/* loaded from: classes.dex */
public class k80 {
    public static JsonHeader a(g60.a aVar) {
        JsonHeader jsonHeader = new JsonHeader();
        if (aVar != null) {
            jsonHeader.requestCode = aVar.a;
            jsonHeader.responseCode = aVar.b;
            jsonHeader.needResponse = aVar.c;
            jsonHeader.protocolId = aVar.d;
            jsonHeader.versionName = aVar.e;
            jsonHeader.requestAuthor = aVar.f;
            jsonHeader.message = aVar.g;
            jsonHeader.messageType = aVar.h;
            jsonHeader.statusCode = aVar.i;
        }
        return jsonHeader;
    }

    public static TmcInfoData b(JSONObject jSONObject) {
        TmcInfoData tmcInfoData = new TmcInfoData();
        tmcInfoData.number = jSONObject.optInt("number");
        tmcInfoData.status = jSONObject.optInt("status");
        tmcInfoData.distance = jSONObject.optInt(StandardProtocolKey.POI_DISTANCE);
        tmcInfoData.percent = (float) (jSONObject.optDouble("percent") / 100.0d);
        tmcInfoData.travelTime = jSONObject.optInt("travelTime");
        return tmcInfoData;
    }

    public static TmcSegmentData c(String str) {
        TmcSegmentData tmcSegmentData = new TmcSegmentData();
        try {
            JSONObject optJSONObject = new JSONObject(str).optJSONObject(WirelessSDK.KEY_DATA);
            boolean z = true;
            if (optJSONObject.optInt("tmcEnabled") != 1) {
                z = false;
            }
            tmcSegmentData.isTmcEnabled = z;
            tmcSegmentData.size = optJSONObject.optInt("size");
            tmcSegmentData.totalDistance = optJSONObject.optInt("totalDistance");
            tmcSegmentData.resiDistance = optJSONObject.optInt("remainDistance");
            tmcSegmentData.finishDstance = optJSONObject.optInt("finishDistance");
            JSONArray optJSONArray = optJSONObject.optJSONArray("tmcInfoList");
            if (optJSONArray != null) {
                int length = optJSONArray.length();
                ArrayList arrayList = new ArrayList(length);
                for (int i = 0; i < length; i++) {
                    arrayList.add(b(optJSONArray.optJSONObject(i)));
                }
                tmcSegmentData.setTmcinfos(arrayList);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return tmcSegmentData;
    }

    public static NaviParkingData b(String str) {
        NaviParkingData naviParkingData = new NaviParkingData();
        try {
            JSONObject optJSONObject = new JSONObject(str).optJSONObject(WirelessSDK.KEY_DATA);
            JSONArray optJSONArray = optJSONObject.optJSONArray("protocolParkInfos");
            naviParkingData.setDialogType(optJSONObject.optInt("dialogueType"));
            naviParkingData.setCount(optJSONObject.optInt("count"));
            if (optJSONArray != null) {
                int length = optJSONArray.length();
                ArrayList arrayList = new ArrayList(length);
                for (int i = 0; i < length; i++) {
                    arrayList.add(a(optJSONArray.optJSONObject(i)));
                }
                naviParkingData.setParkingList(arrayList);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return naviParkingData;
    }

    public static JsonParam a(g60.a aVar, int i, boolean z) {
        JsonParam jsonParam = new JsonParam();
        jsonParam.requestId = i;
        JsonHeader a = a(aVar);
        jsonParam.jsonHeader = a;
        a.needResponse = z;
        JsonResult jsonResult = new JsonResult();
        jsonParam.jsonResult = jsonResult;
        jsonResult.resultCode = 10000;
        jsonParam.jsonData = aVar.toString();
        return jsonParam;
    }

    public static JsonParam a(int i, ProtocolBaseModel protocolBaseModel, int i2) {
        return a(i, protocolBaseModel, i2, false);
    }

    public static JsonParam a(int i, ProtocolBaseModel protocolBaseModel, int i2, boolean z) {
        JsonParam jsonParam = new JsonParam();
        jsonParam.requestId = i2;
        JsonHeader jsonHeader = new JsonHeader();
        jsonParam.jsonHeader = jsonHeader;
        jsonHeader.protocolId = protocolBaseModel.getProtocolID();
        JsonHeader jsonHeader2 = jsonParam.jsonHeader;
        jsonHeader2.statusCode = SecExceptionCode.SEC_ERROR_STA_STORE;
        jsonHeader2.needResponse = z;
        String packageName = protocolBaseModel.getPackageName();
        JsonHeader jsonHeader3 = jsonParam.jsonHeader;
        if (packageName == null) {
            packageName = "";
        }
        jsonHeader3.requestAuthor = packageName;
        if (i == 0) {
            jsonParam.jsonHeader.messageType = "request";
        } else if (1 == i) {
            jsonParam.jsonHeader.messageType = JsonHeader.MESSAGE_TYPE_RESPONSE;
        } else if (2 == i) {
            jsonParam.jsonHeader.messageType = JsonHeader.MESSAGE_TYPE_DISPATCH;
        } else if (3 == i) {
            jsonParam.jsonHeader.messageType = JsonHeader.MESSAGE_TYPE_REQUEST_SYNC;
        }
        jsonParam.jsonHeader.requestCode = String.valueOf(i2);
        jsonParam.jsonHeader.data = protocolBaseModel.toJsonObject();
        jsonParam.jsonData = jsonParam.jsonHeader.toJsonString();
        JsonResult jsonResult = new JsonResult();
        jsonParam.jsonResult = jsonResult;
        jsonResult.resultCode = 10000;
        return jsonParam;
    }

    public static Object b(Object obj) {
        if (obj == null) {
            return JSONObject.NULL;
        }
        if ((obj instanceof JSONArray) || (obj instanceof JSONObject) || obj.equals(JSONObject.NULL)) {
            return obj;
        }
        try {
        } catch (Exception e) {
            aa0.a("JsonBuilderUtils", e.getMessage(), e, new Object[0]);
        }
        if (obj instanceof Collection) {
            return new JSONArray((Collection) obj);
        }
        if (obj.getClass().isArray()) {
            return a(obj);
        }
        if (obj instanceof Map) {
            return new JSONObject((Map) obj);
        }
        if (!(obj instanceof Boolean) && !(obj instanceof Byte) && !(obj instanceof Character) && !(obj instanceof Double) && !(obj instanceof Float) && !(obj instanceof Integer) && !(obj instanceof Long) && !(obj instanceof Short) && !(obj instanceof String)) {
            if (obj.getClass().getPackage().getName().startsWith("java.")) {
                return obj.toString();
            }
            return null;
        }
        return obj;
    }

    public static NaviParkingItemData a(JSONObject jSONObject) {
        NaviParkingItemData naviParkingItemData = new NaviParkingItemData();
        naviParkingItemData.index = jSONObject.optInt("index");
        naviParkingItemData.name = jSONObject.optString(StandardProtocolKey.NAME);
        naviParkingItemData.distance = jSONObject.optInt(StandardProtocolKey.POI_DISTANCE);
        naviParkingItemData.price = jSONObject.optString(StandardProtocolKey.POIDEEPINFO_TAGINFO_PRICE);
        naviParkingItemData.latitude = jSONObject.optDouble("latitude");
        naviParkingItemData.longitude = jSONObject.optDouble("longitude");
        naviParkingItemData.entrylon = jSONObject.optDouble(StandardProtocolKey.ENTRY_LONGITUDE);
        naviParkingItemData.entrylat = jSONObject.optDouble(StandardProtocolKey.ENTRY_LATITUDE);
        naviParkingItemData.category = jSONObject.optString(StandardProtocolKey.POIDEEPINFO_CATEGORY);
        naviParkingItemData.spaceNum = jSONObject.optInt("spacenum");
        naviParkingItemData.poiid = jSONObject.optString(StandardProtocolKey.POIID);
        return naviParkingItemData;
    }

    public static DriveWayData a(String str) {
        DriveWayData driveWayData = new DriveWayData();
        JSONObject parseJsonToJsonObj = JsonHeader.parseJsonToJsonObj(str);
        driveWayData.isEnable = parseJsonToJsonObj.optBoolean("trafficLaneEnabled");
        driveWayData.size = parseJsonToJsonObj.optInt("trafficLaneSize");
        ArrayList arrayList = new ArrayList();
        JSONArray optJSONArray = parseJsonToJsonObj.optJSONArray("trafficLaneInfos");
        if (optJSONArray != null && optJSONArray.length() > 0) {
            for (int i = 0; i < optJSONArray.length(); i++) {
                JSONObject optJSONObject = optJSONArray.optJSONObject(i);
                DriveWayItemData driveWayItemData = new DriveWayItemData();
                driveWayItemData.number = optJSONObject.optInt("trafficLaneNo");
                driveWayItemData.laneBackIcon = optJSONObject.optInt("trafficLaneIcon");
                driveWayItemData.extFlag = optJSONObject.optInt("trafficLaneExtended");
                driveWayItemData.trafficLaneAdvised = optJSONObject.optBoolean(StandardProtocolKey.KEY_TRAFFIC_LANE_ADVISED);
                driveWayItemData.trafficLaneExtendedNew = optJSONObject.optInt(StandardProtocolKey.KEY_TRAFFIC_LANE_EXTENDEDNEW);
                driveWayItemData.trafficLaneType = optJSONObject.optInt(StandardProtocolKey.KEY_TRAFFIC_LANE_TYPE);
                arrayList.add(driveWayItemData);
            }
        }
        driveWayData.setDrivewayList(arrayList);
        return driveWayData;
    }

    public static JSONObject a(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (String str : bundle.keySet()) {
            try {
                jSONObject.put(str, b(bundle.get(str)));
            } catch (JSONException e) {
                aa0.a("JsonBuilderUtils", e.getMessage(), e, new Object[0]);
            }
        }
        return jSONObject;
    }

    public static JSONArray a(Object obj) {
        if (!obj.getClass().isArray()) {
            return null;
        }
        int length = Array.getLength(obj);
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < length; i++) {
            jSONArray.put(b(Array.get(obj, i)));
        }
        return jSONArray;
    }
}
