package defpackage;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.autonavi.link.connect.direct.receiver.DirectBroadcastReceiver;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/* compiled from: WifiDirectConnectUtils.java */
/* loaded from: classes.dex */
public class kp0 implements WifiP2pManager.ChannelListener, fp0 {
    public static volatile kp0 h;
    public Context a;
    public Looper b;
    public DirectBroadcastReceiver c;
    public WifiP2pManager d;
    public WifiP2pManager.Channel e;
    public boolean f = false;
    public List<fp0> g;

    /* compiled from: WifiDirectConnectUtils.java */
    /* loaded from: classes.dex */
    public class a implements WifiP2pManager.PeerListListener {
        public a() {
        }

        @Override // android.net.wifi.p2p.WifiP2pManager.PeerListListener
        public void onPeersAvailable(WifiP2pDeviceList wifiP2pDeviceList) {
            kp0.this.b(wifiP2pDeviceList);
        }
    }

    public static kp0 e() {
        if (h == null) {
            synchronized (kp0.class) {
                if (h == null) {
                    h = new kp0();
                }
            }
        }
        return h;
    }

    public void b(fp0 fp0Var) {
        List<fp0> list = this.g;
        if (list != null && list.contains(fp0Var)) {
            this.g.remove(fp0Var);
        }
    }

    public final void c(WifiP2pManager.ActionListener actionListener) {
        this.d.createGroup(this.e, actionListener);
    }

    public synchronized void d() {
        jq0.a("WifiDirectConnectUtils", "unInit with mHasInited = {?}", Boolean.valueOf(this.f));
        if (this.f) {
            this.f = false;
            if (this.c != null && this.a != null) {
                this.a.unregisterReceiver(this.c);
            }
            this.a = null;
            this.d = null;
            this.e = null;
        }
    }

    public boolean f(WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "removeGroup", new Object[0]);
        if (!a()) {
            return false;
        }
        this.d.removeGroup(this.e, actionListener);
        return true;
    }

    public boolean g(WifiP2pManager.ActionListener actionListener) {
        return a(0, 0, actionListener);
    }

    public boolean h(WifiP2pManager.ActionListener actionListener) {
        return a(0, 1, actionListener);
    }

    @TargetApi(16)
    public boolean i(WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "stopPeerDiscovery", new Object[0]);
        if (!a()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.d.stopPeerDiscovery(this.e, actionListener);
            return true;
        }
        if (actionListener == null) {
            return true;
        }
        actionListener.onSuccess();
        return true;
    }

    @Override // android.net.wifi.p2p.WifiP2pManager.ChannelListener
    public void onChannelDisconnected() {
        jq0.a("WifiDirectConnectUtils", "onChannelDisconnected and retry init channel", new Object[0]);
        this.e = null;
        if (this.d != null) {
            b();
        }
    }

    public void a(fp0 fp0Var) {
        if (this.g == null) {
            this.g = new CopyOnWriteArrayList();
        }
        if (this.g.contains(fp0Var)) {
            return;
        }
        this.g.add(fp0Var);
    }

    public void c() {
        try {
            Method declaredMethod = WifiP2pManager.class.getDeclaredMethod("deletePersistentGroup", WifiP2pManager.Channel.class, Integer.TYPE, WifiP2pManager.ActionListener.class);
            for (int i = 0; i < 32; i++) {
                declaredMethod.invoke(this.d, this.e, Integer.valueOf(i), null);
            }
            jq0.a("WifiDirectConnectUtils", "Persistent groups removed", new Object[0]);
        } catch (Exception e) {
            jq0.a("WifiDirectConnectUtils", "Failure removing persistent groups error = {?} ", e);
        }
    }

    public final boolean b() {
        try {
            this.e = this.d.initialize(this.a, this.b, this);
            return true;
        } catch (Exception e) {
            jq0.a("WifiDirectConnectUtils", "initChannel error with msg = {?}", e.getMessage());
            return false;
        }
    }

    public synchronized void a(Context context) {
        a(context, context.getMainLooper());
    }

    public boolean b(WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "createGroup", new Object[0]);
        if (!a()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            d(actionListener);
            return true;
        }
        c(actionListener);
        return true;
    }

    public boolean e(WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "discoverPeers", new Object[0]);
        if (!a()) {
            return false;
        }
        this.d.discoverPeers(this.e, actionListener);
        return true;
    }

    public synchronized void a(Context context, Looper looper) {
        jq0.a("WifiDirectConnectUtils", "init mHasInited = {?}", Boolean.valueOf(this.f));
        if (this.f) {
            return;
        }
        this.a = context;
        this.b = looper;
        this.d = (WifiP2pManager) context.getSystemService("wifip2p");
        if (b()) {
            DirectBroadcastReceiver directBroadcastReceiver = new DirectBroadcastReceiver(this);
            this.c = directBroadcastReceiver;
            this.a.registerReceiver(directBroadcastReceiver, directBroadcastReceiver.a());
            this.f = true;
        }
    }

    public final void b(WifiP2pDeviceList wifiP2pDeviceList) {
        List<fp0> list = this.g;
        if (list != null) {
            Iterator<fp0> it = list.iterator();
            while (it.hasNext()) {
                it.next().a(wifiP2pDeviceList);
            }
        }
    }

    @TargetApi(29)
    public final void d(WifiP2pManager.ActionListener actionListener) {
        this.d.createGroup(this.e, actionListener);
    }

    @Override // defpackage.fp0
    public void d(int i) {
        List<fp0> list = this.g;
        if (list != null) {
            Iterator<fp0> it = list.iterator();
            while (it.hasNext()) {
                it.next().d(i);
            }
        }
    }

    @Override // defpackage.fp0
    public void b(int i) {
        List<fp0> list = this.g;
        if (list != null) {
            Iterator<fp0> it = list.iterator();
            while (it.hasNext()) {
                it.next().b(i);
            }
        }
    }

    public boolean a() {
        boolean z = (!this.f || this.d == null || this.e == null) ? false : true;
        jq0.a("WifiDirectConnectUtils", "checkWifiState result = {?}", Boolean.valueOf(z));
        return z;
    }

    public boolean a(WifiP2pManager.PeerListListener peerListListener) {
        jq0.a("WifiDirectConnectUtils", "requestPeers ", new Object[0]);
        if (!a()) {
            return false;
        }
        this.d.requestPeers(this.e, peerListListener);
        return true;
    }

    public boolean a(WifiP2pManager.ConnectionInfoListener connectionInfoListener) {
        jq0.a("WifiDirectConnectUtils", "requestConnectionInfo ", new Object[0]);
        if (!a()) {
            return false;
        }
        this.d.requestConnectionInfo(this.e, connectionInfoListener);
        return true;
    }

    public boolean a(String str, int i, WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "connect deviceAddress {?}", str);
        if (a()) {
            if (!TextUtils.isEmpty(str)) {
                WifiP2pConfig wifiP2pConfig = new WifiP2pConfig();
                wifiP2pConfig.deviceAddress = str;
                wifiP2pConfig.wps.setup = 0;
                wifiP2pConfig.groupOwnerIntent = i;
                this.d.connect(this.e, wifiP2pConfig, actionListener);
                return true;
            }
            actionListener.onFailure(0);
        }
        return false;
    }

    public boolean a(WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "cancelConnect", new Object[0]);
        if (a()) {
            this.d.cancelConnect(this.e, actionListener);
        }
        return false;
    }

    public boolean a(WifiP2pManager.GroupInfoListener groupInfoListener) {
        jq0.a("WifiDirectConnectUtils", "requestGroupInfo ", new Object[0]);
        if (!a()) {
            return false;
        }
        this.d.requestGroupInfo(this.e, groupInfoListener);
        return true;
    }

    public boolean a(int i, int i2, WifiP2pManager.ActionListener actionListener) {
        jq0.a("WifiDirectConnectUtils", "setWifiP2pChannels", new Object[0]);
        try {
            Method declaredMethod = this.d.getClass().getDeclaredMethod("setWifiP2pChannels", this.e.getClass(), Integer.TYPE, Integer.TYPE, WifiP2pManager.ActionListener.class);
            declaredMethod.setAccessible(true);
            declaredMethod.invoke(this.d, this.e, Integer.valueOf(i), Integer.valueOf(i2), actionListener);
        } catch (Exception e) {
            jq0.a("WifiDirectConnectUtils", "setWifiP2pChannels error = {?}", e);
        }
        return false;
    }

    @Override // defpackage.fp0
    public void a(WifiP2pDeviceList wifiP2pDeviceList) {
        if (wifiP2pDeviceList != null) {
            b(wifiP2pDeviceList);
        } else {
            a(new a());
        }
    }

    @Override // defpackage.fp0
    public void a(NetworkInfo networkInfo) {
        List<fp0> list = this.g;
        if (list != null) {
            Iterator<fp0> it = list.iterator();
            while (it.hasNext()) {
                it.next().a(networkInfo);
            }
        }
    }

    @Override // defpackage.fp0
    public void a(WifiP2pDevice wifiP2pDevice) {
        List<fp0> list = this.g;
        if (list != null) {
            Iterator<fp0> it = list.iterator();
            while (it.hasNext()) {
                it.next().a(wifiP2pDevice);
            }
        }
    }

    public void a(String str, WifiP2pManager.ActionListener actionListener) {
        if (TextUtils.isEmpty(str)) {
            if (actionListener != null) {
                actionListener.onFailure(1);
                return;
            }
            return;
        }
        try {
            Method method = this.d.getClass().getMethod("setDeviceName", WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class);
            method.setAccessible(true);
            method.invoke(this.d, this.e, str, actionListener);
        } catch (Exception unused) {
            jq0.a("WifiDirectConnectUtils", "invoke setDeviceName onFailure", new Object[0]);
            if (actionListener != null) {
                actionListener.onFailure(0);
            }
        }
    }
}
