package defpackage;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.SystemClock;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/* compiled from: WifiConnectUtils.java */
/* loaded from: classes.dex */
public class kq0 {
    public static boolean a = false;
    public static boolean b = false;
    public static boolean c = false;
    public static StringBuilder d = null;
    public static long e = -1;
    public static long f = -1;
    public static String g = "";
    public static List<a> h = new ArrayList();
    public static Object i = new Object();
    public static b j;

    /* compiled from: WifiConnectUtils.java */
    /* loaded from: classes.dex */
    public interface a {
        void a(boolean z, String str);
    }

    /* compiled from: WifiConnectUtils.java */
    /* loaded from: classes.dex */
    public static class b extends BroadcastReceiver {
        public IntentFilter a() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.wifi.STATE_CHANGE");
            intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
            intentFilter.addAction("android.net.wifi.SCAN_RESULTS");
            return intentFilter;
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            List<WifiConfiguration> configuredNetworks;
            jq0.a("WifiConnectUtils", "WifiStateReceiver onReceive intent = {?}", intent);
            if (intent != null) {
                if ("android.net.wifi.STATE_CHANGE".equals(intent.getAction())) {
                    NetworkInfo networkInfo = (NetworkInfo) intent.getParcelableExtra("networkInfo");
                    if (networkInfo.getState().equals(NetworkInfo.State.DISCONNECTED)) {
                        jq0.a("WifiConnectUtils", "wifi断开", new Object[0]);
                        kq0.c(false);
                        kq0.a(false, "");
                        return;
                    } else {
                        if (networkInfo.getState().equals(NetworkInfo.State.CONNECTED)) {
                            String d = kq0.d(context);
                            jq0.a("WifiConnectUtils", "连接到网络 {?}", d);
                            boolean g = kq0.g(context);
                            kq0.c(false);
                            kq0.a(g, d);
                            return;
                        }
                        return;
                    }
                }
                if ("android.net.wifi.WIFI_STATE_CHANGED".equals(intent.getAction())) {
                    if (kq0.a && kq0.b) {
                        int intExtra = intent.getIntExtra("wifi_state", -1);
                        int intExtra2 = intent.getIntExtra("previous_wifi_state", -1);
                        StringBuilder sb = kq0.d;
                        sb.append(" preview state = ");
                        sb.append(intExtra2);
                        sb.append(" new state = ");
                        sb.append(intExtra);
                        return;
                    }
                    return;
                }
                if ("android.net.wifi.SCAN_RESULTS".equals(intent.getAction()) && kq0.a && kq0.c && (configuredNetworks = ((WifiManager) context.getSystemService("wifi")).getConfiguredNetworks()) != null) {
                    for (WifiConfiguration wifiConfiguration : configuredNetworks) {
                        if (!TextUtils.isEmpty(wifiConfiguration.SSID) && wifiConfiguration.SSID.contains(kq0.g)) {
                            boolean unused = kq0.c = false;
                            long unused2 = kq0.f = SystemClock.elapsedRealtime();
                            StringBuilder sb2 = kq0.d;
                            sb2.append("findDeviceCostTime = ");
                            sb2.append((kq0.f - kq0.e) / 1000);
                        }
                    }
                }
            }
        }
    }

    public static String h() {
        if (!a) {
            return "connectOperate failure!";
        }
        StringBuilder sb = d;
        return sb != null ? sb.toString() : "";
    }

    public static boolean i(Context context) {
        jq0.a("WifiConnectUtils", "reconnectWifi", new Object[0]);
        if (context == null) {
            return false;
        }
        try {
            WifiManager wifiManager = (WifiManager) context.getApplicationContext().getSystemService("wifi");
            if (wifiManager != null && c(context) != 0) {
                boolean startScan = wifiManager.startScan();
                jq0.a("WifiConnectUtils", "reconnectWifi startScan result = {?}", Boolean.valueOf(startScan));
                if (startScan) {
                    boolean reconnect = wifiManager.reconnect();
                    jq0.a("WifiConnectUtils", "reconnectWifi reconnect result = {?}", Boolean.valueOf(reconnect));
                    return reconnect;
                }
            }
        } catch (Exception unused) {
        }
        return false;
    }

    public static void j(Context context) {
        if (j == null) {
            b bVar = new b();
            j = bVar;
            context.registerReceiver(bVar, bVar.a());
        }
    }

    public static void k(Context context) {
        b bVar = j;
        if (bVar != null) {
            try {
                context.unregisterReceiver(bVar);
                j = null;
            } catch (Exception unused) {
            }
        }
    }

    public static void c(boolean z) {
        StringBuilder sb;
        if (z && a && (sb = d) != null) {
            sb.append(" stop by user!");
        }
        a = false;
        b = false;
        c = false;
        e = -1L;
        f = -1L;
    }

    public static String d(Context context) {
        WifiManager wifiManager;
        WifiInfo connectionInfo;
        String str = "";
        try {
            wifiManager = (WifiManager) context.getSystemService("wifi");
            connectionInfo = wifiManager.getConnectionInfo();
        } catch (Exception e2) {
            e = e2;
        }
        if (connectionInfo == null) {
            return "";
        }
        String ssid = connectionInfo.getSSID();
        try {
            jq0.a("WifiConnectUtils", "case 1 getSSID ssid = {?}", ssid);
            if (TextUtils.isEmpty(ssid)) {
                int networkId = connectionInfo.getNetworkId();
                List<WifiConfiguration> configuredNetworks = wifiManager.getConfiguredNetworks();
                if (configuredNetworks != null) {
                    Iterator<WifiConfiguration> it = configuredNetworks.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            break;
                        }
                        WifiConfiguration next = it.next();
                        if (next.networkId == networkId) {
                            ssid = next.SSID;
                            jq0.a("WifiConnectUtils", "case 2 getSSID ssid = {?},networkId = {?}", ssid, Integer.valueOf(networkId));
                            break;
                        }
                    }
                }
            }
            if (!TextUtils.isEmpty(ssid)) {
                str = ssid.startsWith("\"") ? ssid.substring(1, ssid.length()) : ssid;
                if (str.endsWith("\"")) {
                    str = str.substring(0, str.length() - 1);
                }
            }
        } catch (Exception e3) {
            e = e3;
            str = ssid;
            jq0.a("WifiConnectUtils", "get ssid error {?}", e.getMessage());
            jq0.a("WifiConnectUtils", "return getSSID ssid = {?}", str);
            return str;
        }
        jq0.a("WifiConnectUtils", "return getSSID ssid = {?}", str);
        return str;
    }

    public static boolean e(Context context) {
        int intValue;
        try {
            Method declaredMethod = WifiManager.class.getDeclaredMethod("getWifiApState", new Class[0]);
            WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
            declaredMethod.setAccessible(true);
            intValue = ((Integer) declaredMethod.invoke(wifiManager, new Object[0])).intValue();
        } catch (Exception e2) {
            jq0.a("WifiConnectUtils", "[NetworkUtil]isApEnable.Exception", e2, new Object[0]);
        }
        return (intValue == 11 || intValue == 14) ? false : true;
    }

    public static boolean f(Context context) {
        NetworkInfo activeNetworkInfo;
        if (context != null) {
            try {
                ConnectivityManager b2 = b(context);
                if (b2 != null && (activeNetworkInfo = b2.getActiveNetworkInfo()) != null) {
                    return activeNetworkInfo.isAvailable();
                }
            } catch (Exception e2) {
                jq0.a("WifiConnectUtils", "[NetworkUtil]isNetworkConnected.Exception", e2, new Object[0]);
            }
        }
        return false;
    }

    public static boolean g(Context context) {
        jq0.a("WifiConnectUtils", "isWifiConnectWithWifiDirect ssid", new Object[0]);
        String d2 = d(context);
        return !TextUtils.isEmpty(d2) && d2.startsWith("DIRECT-");
    }

    public static void b(a aVar) {
        synchronized (i) {
            h.remove(aVar);
        }
    }

    public static void a(a aVar) {
        synchronized (i) {
            h.add(aVar);
        }
    }

    public static boolean h(Context context) {
        return ((WifiManager) context.getSystemService("wifi")).isWifiEnabled();
    }

    public static final boolean j() {
        Process exec;
        try {
            exec = Runtime.getRuntime().exec("ping -c 1 -w 4 114.114.114.114");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                String readLine = bufferedReader.readLine();
                if (readLine == null) {
                    break;
                }
                stringBuffer.append(readLine);
            }
            jq0.a("WifiConnectUtils", "result content : " + stringBuffer.toString(), new Object[0]);
        } catch (IOException unused) {
            jq0.a("WifiConnectUtils", "result = IOException", new Object[0]);
        } catch (InterruptedException unused2) {
            jq0.a("WifiConnectUtils", "result = InterruptedException", new Object[0]);
        } catch (Throwable th) {
            jq0.a("WifiConnectUtils", "result = " + ((String) null), new Object[0]);
            throw th;
        }
        if (exec.waitFor() == 0) {
            jq0.a("WifiConnectUtils", "result = success", new Object[0]);
            return true;
        }
        jq0.a("WifiConnectUtils", "result = failed", new Object[0]);
        return false;
    }

    public static ConnectivityManager b(Context context) {
        jq0.a("WifiConnectUtils", "[NetworkUtil]getConnectivityService", new Object[0]);
        try {
            return (ConnectivityManager) context.getSystemService("connectivity");
        } catch (Exception e2) {
            jq0.a("WifiConnectUtils", "[NetworkUtil]getConnectivityService.Exception", e2, new Object[0]);
            return null;
        }
    }

    public static boolean a(Context context, String str, String str2) {
        jq0.a("WifiConnectUtils", "connectWifiWithSSID ssid = {?},password = {?}", str, str2);
        try {
            WifiManager wifiManager = (WifiManager) context.getApplicationContext().getSystemService("wifi");
            if (wifiManager == null) {
                a = false;
                return false;
            }
            if (!wifiManager.isWifiEnabled()) {
                a = false;
                return false;
            }
            List<WifiConfiguration> configuredNetworks = wifiManager.getConfiguredNetworks();
            if (configuredNetworks != null) {
                Iterator<WifiConfiguration> it = configuredNetworks.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        break;
                    }
                    WifiConfiguration next = it.next();
                    if (!TextUtils.isEmpty(next.SSID) && next.SSID.contains(str)) {
                        wifiManager.removeNetwork(next.networkId);
                        break;
                    }
                }
            }
            WifiConfiguration wifiConfiguration = new WifiConfiguration();
            wifiConfiguration.SSID = String.format("\"%s\"", str);
            wifiConfiguration.preSharedKey = String.format("\"%s\"", str2);
            g = str;
            i();
            wifiManager.enableNetwork(wifiManager.addNetwork(wifiConfiguration), false);
            wifiManager.startScan();
            boolean reconnect = wifiManager.reconnect();
            a = reconnect;
            return reconnect;
        } catch (Exception unused) {
            return false;
        }
    }

    public static void i() {
        d = new StringBuilder();
        b = true;
        c = true;
        e = SystemClock.elapsedRealtime();
    }

    public static int c(Context context) {
        NetworkInfo activeNetworkInfo;
        if (context == null) {
            jq0.a("WifiConnectUtils", "[getNetWorkType]context ==null, NETWORK_CLASS_UNCONNECT", new Object[0]);
            return 3;
        }
        jq0.a("WifiConnectUtils", "[NetworkUtil]getNetWorkType", new Object[0]);
        try {
            ConnectivityManager b2 = b(context);
            if (b2 != null && (activeNetworkInfo = b2.getActiveNetworkInfo()) != null && activeNetworkInfo.isConnected()) {
                jq0.a("WifiConnectUtils", "[getNetWorkType]isConnected={?}", Boolean.valueOf(activeNetworkInfo.isConnected()));
                int type = activeNetworkInfo.getType();
                jq0.a("WifiConnectUtils", "[getNetWorkType]type={?}", Integer.valueOf(type));
                if (type == 1) {
                    return 0;
                }
                if (type == 0) {
                    return 1;
                }
                jq0.a("WifiConnectUtils", "[getNetWorkType]other", new Object[0]);
                return 2;
            }
            jq0.a("WifiConnectUtils", "[getNetWorkType]NETWORK_CLASS_UNCONNECT", new Object[0]);
            return 3;
        } catch (Exception unused) {
            jq0.a("WifiConnectUtils", "[getNetWorkType]exception NETWORK_CLASS_UNCONNECT", new Object[0]);
            return 3;
        }
    }

    public static boolean a(Context context) {
        jq0.a("WifiConnectUtils", "disConnectWifiWithSSID", new Object[0]);
        c(true);
        try {
            if (!g(context)) {
                return false;
            }
            String d2 = d(context);
            WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
            List<WifiConfiguration> configuredNetworks = wifiManager.getConfiguredNetworks();
            if (configuredNetworks != null) {
                for (WifiConfiguration wifiConfiguration : configuredNetworks) {
                    if (!TextUtils.isEmpty(wifiConfiguration.SSID) && wifiConfiguration.SSID.contains(d2)) {
                        wifiManager.removeNetwork(wifiConfiguration.networkId);
                        jq0.a("WifiConnectUtils", "disConnectWifiWithSSID disconnect id = {?}", Integer.valueOf(wifiConfiguration.networkId));
                    }
                }
            }
            return wifiManager.disconnect();
        } catch (Exception unused) {
            return false;
        }
    }

    public static boolean a(Context context, String str) {
        List<WifiConfiguration> configuredNetworks;
        jq0.a("WifiConnectUtils", "disConnectWifiWithSSID", new Object[0]);
        c(true);
        try {
            WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
            if (wifiManager != null && wifiManager.isWifiEnabled() && (configuredNetworks = wifiManager.getConfiguredNetworks()) != null) {
                for (WifiConfiguration wifiConfiguration : configuredNetworks) {
                    if (!TextUtils.isEmpty(wifiConfiguration.SSID) && wifiConfiguration.SSID.contains(str)) {
                        wifiManager.removeNetwork(wifiConfiguration.networkId);
                        jq0.a("WifiConnectUtils", "disConnectWifiWithSSID disconnect", new Object[0]);
                        if (g(context)) {
                            wifiManager.disconnect();
                        }
                        return true;
                    }
                }
            }
        } catch (Exception unused) {
        }
        return false;
    }

    public static void a(boolean z, String str) {
        synchronized (i) {
            if (h.isEmpty()) {
                jq0.a("WifiConnectUtils", "notifyListener with empty", new Object[0]);
                return;
            }
            for (a aVar : (a[]) h.toArray(new a[h.size()])) {
                jq0.a("WifiConnectUtils", "notifyListener with listener", new Object[0]);
                aVar.a(z, str);
            }
        }
    }
}
