package defpackage;

import android.content.Intent;
import android.os.Bundle;
import com.autonavi.amapauto.jni.protocol.data.ALResponeData;
import com.autonavi.amapauto.jni.protocol.data.SearchData;
import com.autonavi.amapauto.jni.protocol.data.SearchResultData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.client.search.KeyWordSearchModel;

/* compiled from: KeywordSearchAction.java */
/* loaded from: classes.dex */
public class l40 extends g40 implements t50, s50 {
    public l40() {
    }

    @Override // defpackage.s50
    public ProtocolBaseModel a() {
        ALResponeData g = g();
        if (g != null && g.isNewJsonResult) {
            return o80.a(g.jsonString, this.d);
        }
        aa0.a("KeywordSearchAction", "parseToAidlModel resultCode:{?}", Integer.valueOf(this.d));
        return o80.a((SearchResultData) g);
    }

    @Override // defpackage.t50
    public Intent b() {
        b(10042);
        return o();
    }

    @Override // defpackage.ov
    public boolean j() {
        return true;
    }

    public l40(Intent intent) {
        SearchData p = p();
        p.searchType = 0;
        p.requestType = 0;
        Bundle extras = intent.getExtras();
        if (extras != null) {
            p.keyword = extras.getString(StandardProtocolKey.EXTRA_KEYWORD);
            p.lat = extras.getDouble(StandardProtocolKey.EXTRA_MYLOCLAT);
            p.lon = extras.getDouble(StandardProtocolKey.EXTRA_MYLOCLON);
            p.dev = extras.getInt("EXTRA_DEV");
            p.city = extras.getString(StandardProtocolKey.EXTRA_SEARCHCITY);
            p.maxCount = extras.getInt(StandardProtocolKey.EXTRA_MAXCOUNT);
            p.radius = extras.getInt(StandardProtocolKey.EXTRA_RANGE);
            p.centerLat = extras.getDouble(StandardProtocolKey.EXTRA_CENTERLAT);
            p.centerLon = extras.getDouble(StandardProtocolKey.EXTRA_CENTERLON);
            p.sortOrder = extras.getInt(StandardProtocolKey.EXTRA_SORTORDER);
            p.isRecommend = extras.getBoolean(StandardProtocolKey.EXTRA_RECOMMEND, false);
        }
    }

    public l40(KeyWordSearchModel keyWordSearchModel) {
        if (keyWordSearchModel == null) {
            return;
        }
        aa0.a("KeywordSearchAction", "keyWordSearchModel ={?}", keyWordSearchModel.toString());
        SearchData p = p();
        p.searchType = 0;
        int requestType = keyWordSearchModel.getRequestType();
        p.requestType = requestType;
        if (1 == requestType || 2 == requestType) {
            a(true);
        }
        p.keyword = keyWordSearchModel.getKeywords();
        p.lat = keyWordSearchModel.getMylocLat();
        p.lon = keyWordSearchModel.getMylocLon();
        p.dev = keyWordSearchModel.getDev();
        p.city = keyWordSearchModel.getCity();
        p.maxCount = keyWordSearchModel.getMaxMount();
        p.needClassify = keyWordSearchModel.getNeedClassify();
        p.needSort = keyWordSearchModel.getNeedSort();
        p.needRange = keyWordSearchModel.getNeedRange();
        p.needCharge = keyWordSearchModel.getNeedCharge();
        p.needChildPoi = keyWordSearchModel.getNeedChildPoi();
        p.classify = keyWordSearchModel.getClassify();
        p.sort = keyWordSearchModel.getSort();
        p.range = keyWordSearchModel.getRange();
        p.charge = keyWordSearchModel.getCharge();
        p.sortOrder = keyWordSearchModel.getSortrule();
        p.appname = keyWordSearchModel.getPackageName();
        p.isRecommend = keyWordSearchModel.getIsRecommend();
    }
}
