package defpackage;

import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.SystemClock;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import com.autonavi.amapauto.jni.AndroidAudioControl;
import com.autonavi.amapauto.utils.LanguageUtils;
import defpackage.rp;
import java.util.HashMap;
import java.util.Locale;

/* compiled from: AndroidTTSPlayer.java */
/* loaded from: classes.dex */
public class mf extends UtteranceProgressListener implements xf, TextToSpeech.OnInitListener {
    public final boolean a;
    public final boolean b;
    public TextToSpeech c;
    public int d;
    public boolean e;
    public int f;
    public AudioManager g;
    public AudioAttributes h;
    public String i;
    public Object j;
    public final AudioManager.OnAudioFocusChangeListener k;

    /* compiled from: AndroidTTSPlayer.java */
    /* loaded from: classes.dex */
    public class a implements AudioManager.OnAudioFocusChangeListener {
        public a() {
        }

        @Override // android.media.AudioManager.OnAudioFocusChangeListener
        public void onAudioFocusChange(int i) {
            mf.this.f = i;
            aa0.a("AndroidTTSPlayer", "onAudioFocusChange :{?}", Integer.valueOf(i));
            if (mf.this.b) {
                if (i == -1 || i == -2) {
                    boolean z = rf.r().a().isNeedContinueTtsAfterFocusLoss;
                    aa0.a("AndroidTTSPlayer", "do onAudioFocusChange isNeedContinueTtsAfterFocusLoss:{?}", Boolean.valueOf(z));
                    if (z) {
                        return;
                    }
                    mf.this.b(i != -1);
                }
            }
        }
    }

    /* compiled from: AndroidTTSPlayer.java */
    /* loaded from: classes.dex */
    public static class b {
        public static final mf a = new mf(null);
    }

    public /* synthetic */ mf(a aVar) {
        this();
    }

    public static mf i() {
        return b.a;
    }

    public static boolean j() {
        aa0.a("AndroidTTSPlayer", "VERSION.SDK_INT:", Integer.valueOf(Build.VERSION.SDK_INT));
        return Build.VERSION.SDK_INT >= 26;
    }

    public final void b(String str) {
        sa0.a(str, 0, false, false, 4, 0, 0);
    }

    public void c() {
        aa0.a("AndroidTTSPlayer", "abandomAudioFocus  mGain:{?}", Integer.valueOf(this.f));
        if (this.f != -1 && j() && rf.r().a().isUserHighVersionAudioApi) {
            AudioFocusRequest build = new AudioFocusRequest.Builder(rf.r().a().audioMode).setOnAudioFocusChangeListener(this.k).setAudioAttributes(this.h).setAcceptsDelayedFocusGain(false).build();
            if (build != null) {
                this.g.abandonAudioFocusRequest(build);
            }
            this.f = -1;
        }
    }

    public final AudioAttributes.Builder d() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        AudioAttributes.Builder builder = new AudioAttributes.Builder();
        int n = jp.I().n(30015);
        int n2 = jp.I().n(30012);
        aa0.a("AndroidTTSPlayer", "channel audioContentType:{?}, audioAttrUsage:{?}", Integer.valueOf(n), Integer.valueOf(n2));
        if (vd.i()) {
            if (n == -1) {
                n = rf.r().a().audioContentType;
            }
            if (n2 == -1) {
                n2 = rf.r().a().audioAttrUsage;
            }
        }
        if (n == -1) {
            n = 1;
        }
        if (n2 == -1) {
            n2 = 12;
        }
        builder.setContentType(n);
        builder.setUsage(n2);
        aa0.a("AndroidTTSPlayer", "attr audioContentType:{?}, audioAttrUsage:{?}", Integer.valueOf(n), Integer.valueOf(n2));
        return builder;
    }

    public void e() {
        aa0.a("AndroidTTSPlayer", "init() start", new Object[0]);
        if (jp.I().i()) {
            return;
        }
        TextToSpeech textToSpeech = new TextToSpeech(ee.A().f(), this);
        this.c = textToSpeech;
        if (Build.VERSION.SDK_INT >= 15) {
            textToSpeech.setOnUtteranceProgressListener(this);
        }
        aa0.a("AndroidTTSPlayer", "init() end", new Object[0]);
    }

    public boolean f() {
        return this.a;
    }

    public boolean g() {
        return this.e;
    }

    public void h() {
        b(true);
    }

    @Override // android.speech.tts.UtteranceProgressListener
    public void onDone(String str) {
        aa0.a("AndroidTTSPlayer", "enter onDone autoUtteranceId:{?}", str);
        AndroidAudioControl.textPlayEventTracking(201000012, "");
        if (this.b) {
            synchronized (this.j) {
                if (this.i.equals(str)) {
                    aa0.a("AndroidTTSPlayer", "onDone autoUtteranceId:{?}", this.i);
                    c();
                }
            }
        }
    }

    @Override // android.speech.tts.UtteranceProgressListener
    public void onError(String str) {
        aa0.a("AndroidTTSPlayer", "enter onError autoUtteranceId:{?}", str);
        if (this.b) {
            synchronized (this.j) {
                if (this.i.equals(str)) {
                    aa0.a("AndroidTTSPlayer", "onError autoUtteranceId:{?}", this.i);
                    c();
                }
            }
        }
    }

    @Override // android.speech.tts.TextToSpeech.OnInitListener
    public void onInit(int i) {
        if (jp.I().p(i)) {
            return;
        }
        aa0.a("AndroidTTSPlayer", "onInit() status:{?}", Integer.valueOf(i));
        if (i != 0) {
            b("TextToSpeech Engine init fail!");
            return;
        }
        if (this.c == null) {
            e();
        }
        if (vd.a(620)) {
            String curLanguage = LanguageUtils.getCurLanguage();
            aa0.a("AndroidTTSPlayer", "getCurLanguage lang:{?}", curLanguage);
            char c = 65535;
            switch (curLanguage.hashCode()) {
                case 115813226:
                    if (curLanguage.equals("zh-CN")) {
                        c = 0;
                        break;
                    }
                    break;
                case 115813378:
                    if (curLanguage.equals("zh-HK")) {
                        c = 1;
                        break;
                    }
                    break;
                case 115813537:
                    if (curLanguage.equals("zh-MO")) {
                        c = 2;
                        break;
                    }
                    break;
                case 115813762:
                    if (curLanguage.equals("zh-TW")) {
                        c = 3;
                        break;
                    }
                    break;
            }
            if (c == 0 || c == 1 || c == 2) {
                this.c.setLanguage(Locale.CHINA);
            } else if (c != 3) {
                this.c.setLanguage(Locale.ENGLISH);
            } else {
                this.c.setLanguage(Locale.TAIWAN);
            }
            this.c.setSpeechRate(1.0f);
        } else {
            this.c.setLanguage(Locale.ENGLISH);
            this.c.setSpeechRate(200.0f);
        }
        aa0.a("AndroidTTSPlayer", "createAttrBuilder, create volvo LOLLIPOP  AudioTrack", new Object[0]);
        AudioAttributes.Builder d = d();
        if (d != null) {
            this.c.setAudioAttributes(d.build());
        }
    }

    @Override // android.speech.tts.UtteranceProgressListener
    public void onStart(String str) {
        aa0.a("AndroidTTSPlayer", "enter onStart autoUtteranceId:{?}", str);
        if (this.i.equals(str)) {
            aa0.a("AndroidTTSPlayer", "onStart autoUtteranceId:{?}", this.i);
        }
    }

    public mf() {
        AudioAttributes.Builder d;
        this.d = -1;
        this.e = false;
        this.g = null;
        this.h = null;
        this.i = "T2SPId_" + SystemClock.elapsedRealtime();
        this.j = new Object();
        this.k = new a();
        this.a = jp.I().l(10014);
        if (vd.i()) {
            this.b = rf.r().a().isNeedSystemTTSFocus;
        } else {
            this.b = jp.I().l(10036);
        }
        aa0.a("AndroidTTSPlayer", "AndroidTTSPlayer() mIsNeedSystemTTS:{?} isNeedSystemTTSFocus:{?}", Boolean.valueOf(this.a), Boolean.valueOf(this.b));
        this.e = oq.i().a(oq.K, false);
        boolean a2 = oq.i().a(oq.L, false);
        if (this.e && a2) {
            e();
        }
        this.g = (AudioManager) ee.A().f().getSystemService("audio");
        if (Build.VERSION.SDK_INT < 21 || (d = d()) == null) {
            return;
        }
        this.h = d.build();
    }

    public void b(String str, int i) {
        aa0.a("AndroidTTSPlayer", "playText() text:{?}, volumPercent:{?} autoUtteranceId:{?} input mIsUseSystemTTS:{?} mIsNeedSystemTTS:{?} isNeedSystemTTSFocus:{?} ", str, Integer.valueOf(i), this.i, Boolean.valueOf(this.e), Boolean.valueOf(this.a), Boolean.valueOf(this.b));
        if (jp.I().a(str)) {
            return;
        }
        if (this.e && this.c == null) {
            e();
        }
        aa0.a("AndroidTTSPlayer", "playText mTextToSpeech:{?}", this.c);
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.b) {
                HashMap<String, String> hashMap = new HashMap<>(4);
                hashMap.put("utteranceId", this.i);
                aa0.a("AndroidTTSPlayer", "TextToSpeech.speak() textToSpeechParams", new Object[0]);
                this.c.speak(str, 1, hashMap);
                return;
            }
            aa0.a("AndroidTTSPlayer", "TextToSpeech.speak() autoUtteranceId", new Object[0]);
            this.c.speak(str, 1, null, this.i);
            return;
        }
        AndroidAudioControl.textPlayEventTracking(201006001, "isNeedSystemTTSFocus:" + this.b + "|osVersion:" + Build.VERSION.SDK_INT);
        b("TextToSpeech Fail Unspport OS Version");
    }

    public void a(String str) {
        aa0.a("AndroidTTSPlayer", "playText() text:{?} isNeedSystemTTSFocus:{?}", str, Boolean.valueOf(this.b));
        this.i = "T2SPId_" + SystemClock.elapsedRealtime();
        if (this.g != null) {
            if (!this.b) {
                b(str, this.d);
                return;
            }
            if (j() && rf.r().a().isUserHighVersionAudioApi) {
                synchronized (this.j) {
                    AudioFocusRequest.Builder acceptsDelayedFocusGain = new AudioFocusRequest.Builder(rf.r().a().audioMode).setOnAudioFocusChangeListener(this.k).setAudioAttributes(this.h).setAcceptsDelayedFocusGain(false);
                    jp.I().a(60014, new rp.a(acceptsDelayedFocusGain));
                    int requestAudioFocus = this.g.requestAudioFocus(acceptsDelayedFocusGain.build());
                    this.f = requestAudioFocus;
                    if (requestAudioFocus == 1) {
                        aa0.a("AndroidTTSPlayer", "equals AUDIOFOCUS_REQUEST_GRANTED playText!!", new Object[0]);
                        b(str, this.d);
                    } else {
                        aa0.a("AndroidTTSPlayer", "responseCode:{?} abort to playTTs", Integer.valueOf(requestAudioFocus));
                        AndroidAudioControl.textPlayEventTracking(201006003, "isUserHighVersionAudioApi:true|responseCode:" + requestAudioFocus);
                    }
                }
                return;
            }
            AndroidAudioControl.textPlayEventTracking(201006002, "isUserHighVersionAudioApi:" + rf.r().a().isUserHighVersionAudioApi + "|osVersion:" + Build.VERSION.SDK_INT);
            b("TextToSpeech Fail Unspport Version Tag");
            return;
        }
        AndroidAudioControl.textPlayEventTracking(201006000, "AudioManager instance is null");
        b("TextToSpeech Fail Unable AudioManager");
    }

    public void b(boolean z) {
        aa0.a("AndroidTTSPlayer", "stop() focusChange:{?}", Boolean.valueOf(z));
        if (jp.I().a(z)) {
            return;
        }
        this.c.stop();
        if (this.b && z) {
            synchronized (this.j) {
                c();
            }
        }
    }

    public void a(boolean z) {
        aa0.a("AndroidTTSPlayer", "setIsUseSystemTTS() isUseSystemTTS:{?}", Boolean.valueOf(z));
        this.e = z;
        if (z && this.c == null) {
            e();
        }
    }

    public void a(int i) {
        this.d = i;
    }

    @Override // defpackage.xf
    public int a() {
        aa0.a("AndroidTTSPlayer", "getPlayState() start", new Object[0]);
        int o = jp.I().o();
        if (o > 0) {
            return o;
        }
        if (this.c.isSpeaking()) {
            aa0.a("AndroidTTSPlayer", "getPlayState() PLAYSTATE_PLAYING", new Object[0]);
            return 3;
        }
        aa0.a("AndroidTTSPlayer", "getPlayState() PLAYSTATE_STOPPED", new Object[0]);
        return 1;
    }
}
