package defpackage;

import android.media.AudioRecord;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

/* compiled from: Recorder.java */
/* loaded from: classes.dex */
public class mt0 implements Runnable {
    public static String k = "[AMR]AudioRecorder";
    public AudioRecord c;
    public short[] d;
    public Thread e;
    public boolean f;
    public qt0 g;
    public DataOutputStream j;
    public int a = 1;
    public int h = 0;
    public int i = 0;

    /* compiled from: Recorder.java */
    /* loaded from: classes.dex */
    public class a implements FileFilter {
        public a(mt0 mt0Var) {
        }

        @Override // java.io.FileFilter
        public boolean accept(File file) {
            return file.getName().contains("AgroupRecord") && file.getName().contains(".pcm");
        }
    }

    /* compiled from: Recorder.java */
    /* loaded from: classes.dex */
    public class b implements Comparator<File> {
        public b(mt0 mt0Var) {
        }

        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }
    }

    public void a(qt0 qt0Var) {
        this.g = qt0Var;
        this.a = jp.I().n(30033);
        if (le.j().a("MaxStartRecordTimes", -1) > 0) {
            int a2 = le.j().a("MaxStartRecordTimes", 0);
            this.a = a2;
            aa0.a(k, "load mMaxStartRecordTimes from RecordDebugOption: {?}", Integer.valueOf(a2));
        }
    }

    public void b() {
        aa0.a(k, "stop", new Object[0]);
        if (this.f) {
            this.f = false;
            this.e.interrupt();
            this.e = null;
            this.c.release();
            if (le.j().a("savedPcmNumber", 0) > 0) {
                c();
            }
        }
    }

    public final void c() {
        if (this.j != null) {
            aa0.a(k, "stopSavePcm", new Object[0]);
            try {
                try {
                    this.j.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    aa0.a(k, "stopSavePcm exception:", e, new Object[0]);
                }
            } finally {
                this.j = null;
            }
        }
    }

    @Override // java.lang.Runnable
    public void run() {
        while (this.f) {
            int read = this.c.read(this.d, 0, 160);
            if (read != -3 && read != -2) {
                this.g.a(this.d, read);
                if (this.j != null) {
                    for (int i = 0; i < read; i++) {
                        try {
                            if (i < this.d.length) {
                                this.j.writeShort(((this.d[i] & 255) << 8) | ((this.d[i] & 65280) >> 8));
                            }
                        } catch (IOException e) {
                            e.printStackTrace();
                            aa0.a(k, "write pcm exception:", e, new Object[0]);
                        }
                    }
                }
            } else {
                String str = k;
                short[] sArr = this.d;
                aa0.a(str, "audioBuffer={?}，audioBuffer.length={?}，error={?}", sArr, Integer.valueOf(sArr.length), Integer.valueOf(read));
                if (this.h < 5) {
                    le.j().a(this.d.length, 3, read, this.a, "");
                    this.h++;
                }
            }
        }
    }

    public void a(String str) {
        if (this.f) {
            aa0.a(k, "is recoding", new Object[0]);
            return;
        }
        int minBufferSize = AudioRecord.getMinBufferSize(8000, 2, 2);
        if (minBufferSize < 160) {
            aa0.a(k, "bufferSizeInByte is less FRAME_SIZE", new Object[0]);
            this.i = 320;
        }
        if (le.j().a("MinBufferSize", -1) > 0) {
            minBufferSize = le.j().a("MinBufferSize", -1);
            aa0.a(k, "load minBufferSize from RecordDebugOption: {?}", Integer.valueOf(minBufferSize));
        }
        AudioRecord audioRecord = new AudioRecord(1, 8000, 2, 2, Math.max(minBufferSize, this.i));
        this.c = audioRecord;
        aa0.a(k, "before startRecording getRecordingState={?},mMaxStartRecordTimes={?},bufferSizeInByte={?}", Integer.valueOf(audioRecord.getRecordingState()), Integer.valueOf(this.a), Integer.valueOf(Math.max(minBufferSize, this.i)));
        this.h = 0;
        int i = 0;
        do {
            this.c.startRecording();
            int recordingState = this.c.getRecordingState();
            if (recordingState == 3) {
                break;
            }
            i++;
            if (i <= this.a) {
                try {
                    Thread.sleep(500L);
                    aa0.a(k, "sleep", new Object[0]);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                aa0.a(k, "getRecordingState is not recording!poll times out", new Object[0]);
                le.j().a(Math.max(minBufferSize, this.i), recordingState, 0, this.a, "");
                throw new IllegalArgumentException("getRecordingState is not recording!");
            }
        } while (i <= this.a);
        this.d = new short[Math.max(minBufferSize, this.i)];
        aa0.a(k, "after startRecording getRecordingState={?}", Integer.valueOf(this.c.getRecordingState()));
        String str2 = k;
        short[] sArr = this.d;
        aa0.a(str2, "audioBuffer={?},audioBuffer.length={?}", sArr, Integer.valueOf(sArr.length));
        this.f = true;
        Thread thread = new Thread(this);
        this.e = thread;
        thread.start();
        if (le.j().a("savedPcmNumber", 0) > 0) {
            a();
        }
    }

    public final void a() {
        DataOutputStream dataOutputStream = this.j;
        if (dataOutputStream != null) {
            aa0.a(k, "startSavePcm, mPcmDataOutputStream={?}", dataOutputStream);
            return;
        }
        aa0.a(k, "startSavePcm, ByteOrder:{?}", ByteOrder.nativeOrder());
        File file = new File(da0.c() + "/AudioRecord/");
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] listFiles = file.listFiles(new a(this));
        int a2 = le.j().a("savedPcmNumber", 0);
        if (listFiles != null && listFiles.length >= a2) {
            aa0.a(k, "startSavePcm, pcmFiles.length:{?}", Integer.valueOf(listFiles.length));
            Arrays.sort(listFiles, new b(this));
            for (int i = 0; i < (listFiles.length - a2) + 1; i++) {
                aa0.a(k, "startSavePcm, delete earliest file:{?}", listFiles[i].getAbsolutePath());
                listFiles[i].delete();
            }
        }
        File file2 = new File(file.getAbsolutePath() + "/AgroupRecord_" + new SimpleDateFormat("MMddHHmmss", Locale.getDefault()).format(new Date(System.currentTimeMillis())) + ".pcm");
        try {
            file2.createNewFile();
            this.j = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        } catch (Exception e) {
            e.printStackTrace();
            aa0.a(k, "startSavePcm exception:", e, new Object[0]);
            this.j = null;
        }
        aa0.a(k, "startSavePcm, file:{?}", file2.getAbsolutePath());
    }
}
