package defpackage;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.data.ChildPoiData;
import com.autonavi.amapauto.jni.protocol.data.CitysuggestionData;
import com.autonavi.amapauto.jni.protocol.data.EnteryData;
import com.autonavi.amapauto.jni.protocol.data.FrequentInfoData;
import com.autonavi.amapauto.jni.protocol.data.GuideInfoProtocolData;
import com.autonavi.amapauto.jni.protocol.data.JsonHeader;
import com.autonavi.amapauto.jni.protocol.data.PoiData;
import com.autonavi.amapauto.jni.protocol.data.RouteInfoData;
import com.autonavi.amapauto.jni.protocol.data.RouteResultData;
import com.autonavi.amapauto.jni.protocol.data.RouteViaCityInfo;
import com.autonavi.amapauto.jni.protocol.data.SearchCategoryData;
import com.autonavi.amapauto.jni.protocol.data.SearchCategoryItemData;
import com.autonavi.amapauto.jni.protocol.data.SearchResultData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.client.search.SearchResultModel;
import com.autonavi.amapauto.protocol.model.item.ProtocolCityInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolRouteInfo;
import com.autonavi.amapauto.protocol.model.item.ProtocolViaPOIInfo;
import com.autonavi.amapauto.protocol.model.service.GuideInfoModel;
import com.autonavi.amapauto.protocol.model.service.ProtocolErrorModel;
import com.autonavi.amapauto.protocol.model.service.RequestRouteResultModel;
import com.autonavi.amapauto.protocol.model.service.RouteInfoModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: ProtocolModelUtils.java */
/* loaded from: classes.dex */
public class o80 {
    public static ProtocolBaseModel a(SearchResultData searchResultData) {
        return a(searchResultData, 0);
    }

    public static int b(int i) {
        switch (i) {
            case 2:
            case 6:
            case 7:
            default:
                return 10020;
            case 3:
                return 10001;
            case 4:
            case 14:
                return 10023;
            case 5:
                return 10004;
            case 8:
                return 10019;
            case 9:
                return 10005;
            case 10:
                return 10006;
            case 11:
                return 10025;
            case 12:
                return 10026;
            case 13:
                return 10009;
        }
    }

    public static String b(SearchResultData searchResultData) {
        List<PoiData> pois = searchResultData.getPois();
        try {
            JSONObject jSONObject = new JSONObject();
            if (pois == null || pois.size() <= 0) {
                return null;
            }
            jSONObject.put("Count", pois.size());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < pois.size(); i++) {
                JSONObject jSONObject2 = new JSONObject();
                PoiData poiData = pois.get(i);
                jSONObject2.put("Poiid", poiData.getPoiid());
                jSONObject2.put("Poiname", poiData.name);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_DISTANCE, poiData.distance);
                jSONObject2.put(StandardProtocolKey.ALONG_POI_ADDR, poiData.address);
                jSONObject2.put("Longitude", String.valueOf(poiData.longitude));
                jSONObject2.put("Latitude", String.valueOf(poiData.latitude));
                JSONObject a = ja0.a(poiData.getPoideepinfo());
                if (a != null) {
                    jSONObject2.put("biz_ext", a);
                }
                a(jSONObject2, poiData.getChildPoiList());
                a(jSONObject2, poiData);
                jSONArray.put(jSONObject2);
            }
            jSONObject.put(StandardProtocolKey.ALONG_POI_INFO, jSONArray);
            b(jSONObject, searchResultData.getCategoryDataList());
            return jSONObject.toString();
        } catch (JSONException e) {
            aa0.a("ProtocolModelUtils", "JSONException searchByAlongWay={?}", e.getMessage());
            return null;
        }
    }

    public static String c(SearchResultData searchResultData) {
        List<PoiData> list;
        int i;
        JSONObject jSONObject = new JSONObject();
        if (searchResultData != null) {
            try {
                List<PoiData> pois = searchResultData.getPois();
                List<CitysuggestionData> cityList = searchResultData.getCityList();
                if (pois != null) {
                    int size = pois.size();
                    jSONObject.put("Count", size);
                    JSONArray jSONArray = new JSONArray();
                    int i2 = 0;
                    while (i2 < size) {
                        JSONObject jSONObject2 = new JSONObject();
                        PoiData poiData = pois.get(i2);
                        jSONObject2.put("Poiid", poiData.getPoiid());
                        jSONObject2.put("Name", poiData.name);
                        jSONObject2.put("Address", poiData.address);
                        jSONObject2.put("Typecode", String.valueOf(poiData.poitype));
                        int i3 = 4;
                        int i4 = 6;
                        double doubleValue = new BigDecimal(poiData.latitude).setScale(6, 4).doubleValue();
                        jSONObject2.put("longitude", new BigDecimal(poiData.longitude).setScale(6, 4).doubleValue());
                        jSONObject2.put("Latitude", doubleValue);
                        List<EnteryData> enteryList = poiData.getEnteryList();
                        if (enteryList == null || enteryList.size() <= 0) {
                            list = pois;
                            i = size;
                        } else {
                            JSONArray jSONArray2 = new JSONArray();
                            int i5 = 0;
                            while (i5 < enteryList.size()) {
                                double doubleValue2 = new BigDecimal(enteryList.get(i5).latitude).setScale(i4, i3).doubleValue();
                                double doubleValue3 = new BigDecimal(enteryList.get(i5).longitude).setScale(6, 4).doubleValue();
                                JSONObject jSONObject3 = new JSONObject();
                                jSONObject3.put(StandardProtocolKey.ENTRY_LONGITUDE, doubleValue3);
                                jSONObject3.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue2);
                                jSONArray2.put(jSONObject3);
                                aa0.a("ProtocolModelUtils", "obejctToJson j = {?},entry_longitude = {?},entry_latitude = {?}", Integer.valueOf(i5), Double.valueOf(doubleValue3), Double.valueOf(doubleValue2));
                                i5++;
                                size = size;
                                pois = pois;
                                i3 = 4;
                                i4 = 6;
                            }
                            list = pois;
                            i = size;
                            jSONObject2.put("enteryList", jSONArray2);
                        }
                        jSONObject2.put(StandardProtocolKey.POI_DISTANCE, poiData.distance);
                        jSONObject2.put("Tel", poiData.tel);
                        Object a = ja0.a(poiData.getPoideepinfo());
                        if (a != null) {
                            jSONObject2.put("biz_ext", a);
                        }
                        a(jSONObject2, poiData.getChildPoiList());
                        jSONArray.put(jSONObject2);
                        i2++;
                        size = i;
                        pois = list;
                    }
                    jSONObject.put("Pois", jSONArray);
                }
                if (cityList != null && cityList.size() > 0) {
                    JSONObject jSONObject4 = new JSONObject();
                    int size2 = cityList.size();
                    jSONObject4.put("Citycount", size2);
                    JSONArray jSONArray3 = new JSONArray();
                    for (int i6 = 0; i6 < size2; i6++) {
                        JSONObject jSONObject5 = new JSONObject();
                        CitysuggestionData citysuggestionData = cityList.get(i6);
                        jSONObject5.put("Cityname", citysuggestionData.cityname);
                        jSONObject5.put("Citynum", citysuggestionData.citynum);
                        jSONArray3.put(jSONObject5);
                    }
                    jSONObject4.put("SuggestionCityDetail", jSONArray3);
                    jSONObject.put("Citysuggestion", jSONObject4);
                }
                b(jSONObject, searchResultData.getCategoryDataList());
            } catch (Exception unused) {
                return null;
            }
        }
        return jSONObject.toString();
    }

    public static ProtocolBaseModel a(String str, int i) {
        if (TextUtils.isEmpty(str)) {
            return new ProtocolErrorModel(10020);
        }
        if (10000 == i) {
            SearchResultModel searchResultModel = new SearchResultModel();
            JSONObject parseJsonToJsonObj = JsonHeader.parseJsonToJsonObj(str);
            if (parseJsonToJsonObj != null) {
                JSONObject optJSONObject = parseJsonToJsonObj.optJSONObject("poiResult");
                searchResultModel.setPoiResult(optJSONObject == null ? null : optJSONObject.toString());
            }
            return searchResultModel;
        }
        return new ProtocolErrorModel(i);
    }

    public static ProtocolBaseModel a(SearchResultData searchResultData, int i) {
        if (searchResultData == null) {
            return new ProtocolErrorModel(10020);
        }
        if (1 == searchResultData.resultCode) {
            SearchResultModel searchResultModel = new SearchResultModel();
            if (i == 3) {
                searchResultModel.setPoiResult(b(searchResultData));
            } else {
                searchResultModel.setPoiResult(c(searchResultData));
            }
            return searchResultModel;
        }
        return new ProtocolErrorModel(b(searchResultData.resultCode));
    }

    public static void a(JSONObject jSONObject, List<ChildPoiData> list) throws JSONException {
        String str;
        String str2 = "ProtocolModelUtils";
        aa0.a("ProtocolModelUtils", "handleChildPoiList", new Object[0]);
        if (list != null && !list.isEmpty()) {
            int i = 1;
            aa0.a("ProtocolModelUtils", "handleChildPoiList childPoiData size:{?}", Integer.valueOf(list.size()));
            JSONArray jSONArray = new JSONArray();
            for (ChildPoiData childPoiData : list) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("Poiid", childPoiData.poiid);
                jSONObject2.put("Name", childPoiData.name);
                Object[] objArr = new Object[i];
                objArr[0] = childPoiData.name;
                aa0.a(str2, "handleChildPoiList childPoiData data.name:{?}", objArr);
                jSONObject2.put("Address", childPoiData.address);
                jSONObject2.put("Typecode", String.valueOf(childPoiData.poitype));
                double doubleValue = new BigDecimal(childPoiData.latitude).setScale(6, 4).doubleValue();
                jSONObject2.put("longitude", new BigDecimal(childPoiData.longitude).setScale(6, 4).doubleValue());
                jSONObject2.put("Latitude", doubleValue);
                List<EnteryData> enteryList = childPoiData.getEnteryList();
                if (enteryList == null || enteryList.size() <= 0) {
                    str = str2;
                } else {
                    JSONArray jSONArray2 = new JSONArray();
                    int i2 = 0;
                    while (i2 < enteryList.size()) {
                        double doubleValue2 = new BigDecimal(enteryList.get(i2).latitude).setScale(6, 4).doubleValue();
                        String str3 = str2;
                        double doubleValue3 = new BigDecimal(enteryList.get(i2).longitude).setScale(6, 4).doubleValue();
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put(StandardProtocolKey.ENTRY_LONGITUDE, doubleValue3);
                        jSONObject3.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue2);
                        jSONArray2.put(jSONObject3);
                        aa0.a(str3, "obejctToJson j = {?},entry_longitude = {?},entry_latitude = {?}", Integer.valueOf(i2), Double.valueOf(doubleValue3), Double.valueOf(doubleValue2));
                        i2++;
                        str2 = str3;
                    }
                    str = str2;
                    jSONObject2.put("enteryList", jSONArray2);
                }
                jSONObject2.put(StandardProtocolKey.POI_DISTANCE, childPoiData.distance);
                jSONObject2.put("Tel", childPoiData.tel);
                Object a = ja0.a(childPoiData.getPoideepinfo());
                if (a != null) {
                    jSONObject2.put("biz_ext", a);
                }
                jSONArray.put(jSONObject2);
                str2 = str;
                i = 1;
            }
            jSONObject.put("childPoiList", jSONArray);
            return;
        }
        aa0.a("ProtocolModelUtils", "handleChildPoiList childPoiData is empty.", new Object[0]);
    }

    public static void b(JSONObject jSONObject, List<SearchCategoryData> list) throws JSONException {
        if (list != null && !list.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < list.size(); i++) {
                JSONObject jSONObject2 = new JSONObject();
                SearchCategoryData searchCategoryData = list.get(i);
                jSONObject2.put(StandardProtocolKey.NAME, searchCategoryData.name);
                jSONObject2.put("ctype", searchCategoryData.ctype);
                jSONObject2.put("checkedvalue", searchCategoryData.checkedvalue);
                c(jSONObject2, searchCategoryData.itemDataList);
                jSONArray.put(jSONObject2);
            }
            jSONObject.put("categories", jSONArray);
            return;
        }
        aa0.a("ProtocolModelUtils", "handleSearchCategory() searchCategoryList is null", new Object[0]);
    }

    public static RouteInfoModel b(RouteResultData routeResultData) {
        if (routeResultData == null) {
            return null;
        }
        RouteInfoModel routeInfoModel = new RouteInfoModel();
        List<RouteInfoData> routeList = routeResultData.getRouteList();
        if (routeList != null) {
            routeInfoModel.setCount(routeList.size());
        }
        PoiData startPoi = routeResultData.getStartPoi();
        if (startPoi != null) {
            routeInfoModel.h(startPoi.name);
            routeInfoModel.g(startPoi.address);
            routeInfoModel.d(startPoi.longitude);
            routeInfoModel.c(startPoi.latitude);
            routeInfoModel.i(String.valueOf(startPoi.poitype));
        }
        PoiData endPoi = routeResultData.getEndPoi();
        if (endPoi != null) {
            routeInfoModel.d(endPoi.name);
            routeInfoModel.c(endPoi.address);
            routeInfoModel.a(endPoi.latitude);
            routeInfoModel.b(endPoi.longitude);
            routeInfoModel.e(String.valueOf(endPoi.poitype));
            List<EnteryData> enteryList = endPoi.getEnteryList();
            if (enteryList != null && enteryList.size() > 0) {
                routeInfoModel.setArrivePOILatitude(enteryList.get(0).latitude);
                routeInfoModel.setArrivePOILongitude(enteryList.get(0).longitude);
                routeInfoModel.b(String.valueOf(enteryList.get(0).poiType));
            }
        }
        List<PoiData> midPois = routeResultData.getMidPois();
        if (midPois != null && midPois.size() > 0) {
            routeInfoModel.e(midPois.size());
            ArrayList<ProtocolViaPOIInfo> arrayList = new ArrayList<>();
            for (PoiData poiData : midPois) {
                ProtocolViaPOIInfo protocolViaPOIInfo = new ProtocolViaPOIInfo();
                protocolViaPOIInfo.b(poiData.name);
                protocolViaPOIInfo.a(poiData.address);
                protocolViaPOIInfo.c(poiData.latitude);
                protocolViaPOIInfo.d(poiData.longitude);
                protocolViaPOIInfo.d(String.valueOf(poiData.poitype));
                arrayList.add(protocolViaPOIInfo);
            }
            routeInfoModel.b(arrayList);
        }
        List<RouteInfoData> routeList2 = routeResultData.getRouteList();
        routeInfoModel.d(routeResultData.getRoutePreference());
        if (routeList2 != null && routeList2.size() > 0) {
            ArrayList<ProtocolRouteInfo> arrayList2 = new ArrayList<>();
            Iterator<RouteInfoData> it = routeList2.iterator();
            while (it.hasNext()) {
                arrayList2.add(a(it.next()));
            }
            routeInfoModel.a(arrayList2);
        }
        return routeInfoModel;
    }

    public static void a(JSONObject jSONObject, PoiData poiData) {
        if (poiData != null) {
            try {
                if (poiData.getEnteryList() != null && poiData.getEnteryList().size() > 0) {
                    List<EnteryData> enteryList = poiData.getEnteryList();
                    jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, enteryList.get(0).longitude);
                    jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, enteryList.get(0).latitude);
                    return;
                }
            } catch (JSONException e) {
                e.printStackTrace();
                return;
            }
        }
        jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, 0);
        jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, 0);
    }

    public static void c(JSONObject jSONObject, List<SearchCategoryItemData> list) throws JSONException {
        if (list == null || list.isEmpty()) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < list.size(); i++) {
            JSONObject jSONObject2 = new JSONObject();
            SearchCategoryItemData searchCategoryItemData = list.get(i);
            jSONObject2.put(StandardProtocolKey.NAME, searchCategoryItemData.name);
            jSONObject2.put("value", searchCategoryItemData.value);
            c(jSONObject2, searchCategoryItemData.itemDataList);
            jSONArray.put(jSONObject2);
        }
        jSONObject.put("categoryItems", jSONArray);
    }

    public static GuideInfoModel a(GuideInfoProtocolData guideInfoProtocolData) {
        if (guideInfoProtocolData == null) {
            return null;
        }
        GuideInfoModel guideInfoModel = new GuideInfoModel();
        guideInfoModel.setCameraDist(guideInfoProtocolData.getCameraDist());
        guideInfoModel.d(guideInfoProtocolData.getCameraIndex());
        guideInfoModel.setCameraSpeed(guideInfoProtocolData.getCameraSpeed());
        guideInfoModel.setCameraType(guideInfoProtocolData.getCameraType());
        guideInfoModel.setSapaDist(guideInfoProtocolData.getSapaDist());
        guideInfoModel.setSapaName(guideInfoProtocolData.getSapaName());
        guideInfoModel.setSapaNum(guideInfoProtocolData.getSapaNum());
        guideInfoModel.setSapaType(guideInfoProtocolData.getSapaType());
        guideInfoModel.e(guideInfoProtocolData.getCarDirection());
        guideInfoModel.a(guideInfoProtocolData.getCarLatitude());
        guideInfoModel.b(guideInfoProtocolData.getCarLongitude());
        guideInfoModel.f(guideInfoProtocolData.getCurPointNum());
        guideInfoModel.setCurRoadName(guideInfoProtocolData.getCurRoadName());
        guideInfoModel.g(guideInfoProtocolData.getCurSegNum());
        guideInfoModel.h(guideInfoProtocolData.getCurSpeed());
        guideInfoModel.j(guideInfoProtocolData.getIcon());
        guideInfoModel.k(guideInfoProtocolData.getIcon());
        guideInfoModel.setLimitedSpeed(guideInfoProtocolData.getLimitedSpeed());
        guideInfoModel.m(guideInfoProtocolData.getNextRoadName());
        guideInfoModel.setType(guideInfoProtocolData.getType());
        guideInfoModel.x(guideInfoProtocolData.getRouteRemainDis());
        guideInfoModel.y(guideInfoProtocolData.getRouteRemainTime());
        guideInfoModel.C(guideInfoProtocolData.getSegRemainTime());
        guideInfoModel.B(guideInfoProtocolData.getSegRemainDis());
        guideInfoModel.s(guideInfoProtocolData.getRoundAboutNum());
        guideInfoModel.t(guideInfoProtocolData.getRoundAllNum());
        guideInfoModel.D(guideInfoProtocolData.getTrafficLightNum());
        guideInfoModel.v(guideInfoProtocolData.getRouteAllDis());
        guideInfoModel.w(guideInfoProtocolData.getRouteAllTime());
        guideInfoModel.r(guideInfoProtocolData.getRoadType());
        guideInfoModel.n(guideInfoProtocolData.getNextSapaDist());
        guideInfoModel.o(guideInfoProtocolData.getNextSapaType());
        guideInfoModel.o(guideInfoProtocolData.getNextSapaName());
        guideInfoModel.n(guideInfoProtocolData.getNextSapaDistAuto());
        guideInfoModel.j(guideInfoProtocolData.getExitNameInfo());
        guideInfoModel.i(guideInfoProtocolData.getExitDirectionInfo());
        guideInfoModel.A(guideInfoProtocolData.getSegAssistantAction());
        guideInfoModel.r(guideInfoProtocolData.getRouteRemainTimeAuto());
        guideInfoModel.q(guideInfoProtocolData.getRouteRemainDistanceAuto());
        guideInfoModel.s(guideInfoProtocolData.getSapaDistAuto());
        guideInfoModel.t(guideInfoProtocolData.getSegRemainDisAuto());
        guideInfoModel.u(guideInfoProtocolData.getRoundaboutOutAngle());
        guideInfoModel.p(guideInfoProtocolData.getNextSegRemainDis());
        guideInfoModel.q(guideInfoProtocolData.getNextSegRemainTime());
        guideInfoModel.h(guideInfoProtocolData.getEtaText());
        guideInfoModel.m(guideInfoProtocolData.getNextRoadProgressPrecent());
        guideInfoModel.l(guideInfoProtocolData.getNextNextRoadName());
        guideInfoModel.h(guideInfoProtocolData.getEtaText());
        Bitmap turnIconBitmap = guideInfoProtocolData.getTurnIconBitmap();
        if (turnIconBitmap != null && !turnIconBitmap.isRecycled()) {
            guideInfoModel.F(turnIconBitmap.getWidth());
            guideInfoModel.E(turnIconBitmap.getHeight());
            guideInfoModel.a(turnIconBitmap);
        }
        guideInfoModel.setCameraPenalty(guideInfoProtocolData.isCameraPenalty());
        guideInfoModel.b(guideInfoProtocolData.isNextRoadNOAOrNot());
        guideInfoModel.a(guideInfoProtocolData.isNewCamera());
        guideInfoModel.setCameraID(guideInfoProtocolData.getCameraID());
        guideInfoModel.f(guideInfoProtocolData.getEndPOIName());
        guideInfoModel.c(guideInfoProtocolData.getEndPOIAddr());
        guideInfoModel.g(guideInfoProtocolData.getEndPOIType());
        guideInfoModel.b(guideInfoProtocolData.getArrivePOIType());
        guideInfoModel.c(guideInfoProtocolData.getEndPOILatitude());
        guideInfoModel.d(guideInfoProtocolData.getEndPOILongitude());
        guideInfoModel.setArrivePOILatitude(guideInfoProtocolData.getArrivePOILatitude());
        guideInfoModel.setArrivePOILongitude(guideInfoProtocolData.getArrivePOILongitude());
        guideInfoModel.H(guideInfoProtocolData.getViaPOItime());
        guideInfoModel.G(guideInfoProtocolData.getViaPOIdistance());
        guideInfoModel.d(guideInfoProtocolData.getEndPOICityName());
        guideInfoModel.e(guideInfoProtocolData.getEndPOIDistrictName());
        guideInfoModel.u(guideInfoProtocolData.getViaPOIArrivalTime());
        guideInfoModel.l(guideInfoProtocolData.getNextNextTurnIcon());
        guideInfoModel.a(guideInfoProtocolData.getAddIcon());
        guideInfoModel.k(guideInfoProtocolData.getNextNextAddIcon());
        guideInfoModel.p(guideInfoProtocolData.getNextSegRemainDisAuto());
        guideInfoModel.z(guideInfoProtocolData.getRouteRemainTrafficLightNum());
        return guideInfoModel;
    }

    public static RequestRouteResultModel c(RouteResultData routeResultData) {
        if (routeResultData == null || routeResultData.getRouteList() == null) {
            return null;
        }
        List<RouteInfoData> routeList = routeResultData.getRouteList();
        RequestRouteResultModel requestRouteResultModel = new RequestRouteResultModel();
        requestRouteResultModel.setCount(routeList.size());
        ArrayList<ProtocolRouteInfo> arrayList = new ArrayList<>();
        Iterator<RouteInfoData> it = routeList.iterator();
        while (it.hasNext()) {
            arrayList.add(a(it.next()));
        }
        if (routeResultData != null) {
            PoiData startPoi = routeResultData.getStartPoi();
            if (startPoi != null) {
                requestRouteResultModel.b(startPoi.name);
                requestRouteResultModel.a(startPoi.address);
                requestRouteResultModel.b(startPoi.longitude);
                requestRouteResultModel.a(startPoi.latitude);
            }
            PoiData endPoi = routeResultData.getEndPoi();
            if (endPoi != null) {
                requestRouteResultModel.e(endPoi.name);
                requestRouteResultModel.d(endPoi.address);
                requestRouteResultModel.c(endPoi.latitude);
                requestRouteResultModel.d(endPoi.longitude);
            }
            List<PoiData> midPois = routeResultData.getMidPois();
            if (midPois != null && midPois.size() > 0) {
                requestRouteResultModel.c(midPois.size());
                ArrayList arrayList2 = new ArrayList();
                StringBuffer stringBuffer = new StringBuffer();
                for (PoiData poiData : midPois) {
                    ProtocolViaPOIInfo protocolViaPOIInfo = new ProtocolViaPOIInfo();
                    protocolViaPOIInfo.b(poiData.name);
                    protocolViaPOIInfo.a(poiData.address);
                    protocolViaPOIInfo.c(poiData.latitude);
                    protocolViaPOIInfo.d(poiData.longitude);
                    arrayList2.add(protocolViaPOIInfo);
                    stringBuffer.append(protocolViaPOIInfo.toJsonObject().toString());
                }
                requestRouteResultModel.c(stringBuffer.toString());
            }
        }
        requestRouteResultModel.a(arrayList);
        return requestRouteResultModel;
    }

    public static GuideInfoProtocolData a(GuideInfoModel guideInfoModel) {
        if (guideInfoModel == null) {
            return null;
        }
        GuideInfoProtocolData guideInfoProtocolData = new GuideInfoProtocolData();
        guideInfoProtocolData.setCameraDist(guideInfoModel.getCameraDist());
        guideInfoProtocolData.setCameraIndex(guideInfoModel.p());
        guideInfoProtocolData.setCameraSpeed(guideInfoModel.getCameraSpeed());
        guideInfoProtocolData.setCameraType(guideInfoModel.getCameraType());
        guideInfoProtocolData.setSapaDist(guideInfoModel.getSapaDist());
        guideInfoProtocolData.setSapaName(guideInfoModel.getSapaName());
        guideInfoProtocolData.setSapaNum(guideInfoModel.getSapaNum());
        guideInfoProtocolData.setSapaType(guideInfoModel.getSapaType());
        guideInfoProtocolData.setCarDirection(guideInfoModel.q());
        guideInfoProtocolData.setCarLatitude(guideInfoModel.r());
        guideInfoProtocolData.setCarLongitude(guideInfoModel.s());
        guideInfoProtocolData.setCurPointNum(guideInfoModel.t());
        guideInfoProtocolData.setCurRoadName(guideInfoModel.getCurRoadName());
        guideInfoProtocolData.setCurSegNum(guideInfoModel.u());
        guideInfoProtocolData.setCurSpeed(guideInfoModel.v());
        guideInfoProtocolData.setIcon(guideInfoModel.H());
        guideInfoProtocolData.setLimitedSpeed(guideInfoModel.getLimitedSpeed());
        guideInfoProtocolData.setNextRoadName(guideInfoModel.O());
        guideInfoProtocolData.setType(guideInfoModel.getType());
        guideInfoProtocolData.setRouteRemainDis(guideInfoModel.d0());
        guideInfoProtocolData.setRouteRemainTime(guideInfoModel.f0());
        guideInfoProtocolData.setSegRemainTime(guideInfoModel.m0());
        guideInfoProtocolData.setSegRemainDis(guideInfoModel.k0());
        guideInfoProtocolData.setRoundAboutNum(guideInfoModel.Y());
        guideInfoProtocolData.setRoundAllNum(guideInfoModel.Z());
        guideInfoProtocolData.setTrafficLightNum(guideInfoModel.n0());
        guideInfoProtocolData.setRouteAllDis(guideInfoModel.b0());
        guideInfoProtocolData.setRouteAllTime(guideInfoModel.c0());
        guideInfoProtocolData.setRoadType(guideInfoModel.X());
        guideInfoProtocolData.setNextNextRoadName(guideInfoModel.L());
        guideInfoProtocolData.setEtaText(guideInfoModel.E());
        guideInfoProtocolData.setNextSapaDist(guideInfoModel.Q());
        guideInfoProtocolData.setNextSapaType(guideInfoModel.T());
        guideInfoProtocolData.setNextSapaName(guideInfoModel.S());
        guideInfoProtocolData.setNextSapaDistAuto(guideInfoModel.R());
        guideInfoProtocolData.setExitNameInfo(guideInfoModel.G());
        guideInfoProtocolData.setExitDirectionInfo(guideInfoModel.F());
        guideInfoProtocolData.setSegAssistantAction(guideInfoModel.j0());
        guideInfoProtocolData.setRouteRemainTimeAuto(guideInfoModel.g0());
        guideInfoProtocolData.setRouteRemainDistanceAuto(guideInfoModel.e0());
        guideInfoProtocolData.setSapaDistAuto(guideInfoModel.i0());
        guideInfoProtocolData.setSegRemainDisAuto(guideInfoModel.l0());
        guideInfoProtocolData.setRoundaboutOutAngle(guideInfoModel.a0());
        guideInfoProtocolData.setNextSegRemainDis(guideInfoModel.U());
        guideInfoProtocolData.setNextSegRemainTime(guideInfoModel.W());
        guideInfoProtocolData.setNextRoadProgressPrecent(guideInfoModel.P());
        guideInfoProtocolData.setCameraPenalty(guideInfoModel.getCameraPenalty());
        guideInfoProtocolData.setNextRoadNOAOrNot(guideInfoModel.N());
        guideInfoProtocolData.setNewCamera(guideInfoModel.I());
        guideInfoProtocolData.setCameraID(guideInfoModel.getCameraID());
        guideInfoProtocolData.setEndPOIName(guideInfoModel.C());
        guideInfoProtocolData.setEndPOIAddr(guideInfoModel.x());
        guideInfoProtocolData.setEndPOIType(guideInfoModel.D());
        guideInfoProtocolData.setArrivePOIType(guideInfoModel.o());
        guideInfoProtocolData.setEndPOILatitude(guideInfoModel.A());
        guideInfoProtocolData.setEndPOILongitude(guideInfoModel.B());
        guideInfoProtocolData.setArrivePOILatitude(guideInfoModel.getArrivePOILatitude());
        guideInfoProtocolData.setArrivePOILongitude(guideInfoModel.getArrivePOILongitude());
        guideInfoProtocolData.setViaPOItime(guideInfoModel.s0());
        guideInfoProtocolData.setViaPOIdistance(guideInfoModel.r0());
        guideInfoProtocolData.setEndPOICityName(guideInfoModel.y());
        guideInfoProtocolData.setEndPOIDistrictName(guideInfoModel.z());
        guideInfoProtocolData.setViaPOIArrivalTime(guideInfoModel.q0());
        guideInfoProtocolData.setNextNextTurnIcon(guideInfoModel.M());
        guideInfoProtocolData.setAddIcon(guideInfoModel.n());
        guideInfoProtocolData.setNextNextAddIcon(guideInfoModel.K());
        guideInfoProtocolData.setNextSegRemainDisAuto(guideInfoModel.V());
        guideInfoProtocolData.setRouteRemainTrafficLightNum(guideInfoModel.h0());
        return guideInfoProtocolData;
    }

    public static ProtocolRouteInfo a(RouteInfoData routeInfoData) {
        ProtocolRouteInfo protocolRouteInfo = new ProtocolRouteInfo();
        protocolRouteInfo.a(routeInfoData.distance);
        protocolRouteInfo.a(routeInfoData.totalDistanceDes);
        protocolRouteInfo.b(routeInfoData.labelText);
        protocolRouteInfo.d(routeInfoData.routePreference);
        protocolRouteInfo.b(routeInfoData.time);
        protocolRouteInfo.c(routeInfoData.totalTimeDes);
        protocolRouteInfo.f(routeInfoData.tolls);
        protocolRouteInfo.c(routeInfoData.oddNum);
        protocolRouteInfo.e(routeInfoData.totalOddDistance);
        protocolRouteInfo.g(routeInfoData.trafficLights);
        protocolRouteInfo.e(routeInfoData.getTmcSize());
        protocolRouteInfo.d(routeInfoData.getTmcInfosJson());
        protocolRouteInfo.j(routeInfoData.viaPOItime);
        protocolRouteInfo.i(routeInfoData.viaPOIdistance);
        if (routeInfoData.getRouteViaCityInfos() != null) {
            ArrayList<ProtocolCityInfo> arrayList = new ArrayList<>();
            Iterator<RouteViaCityInfo> it = routeInfoData.getRouteViaCityInfos().iterator();
            while (it.hasNext()) {
                arrayList.add(new ProtocolCityInfo(it.next().viaCityName));
            }
            protocolRouteInfo.h(arrayList.size());
            protocolRouteInfo.a(arrayList);
        }
        return protocolRouteInfo;
    }

    public static String a(FrequentInfoData frequentInfoData) {
        JSONObject jSONObject = new JSONObject();
        if (frequentInfoData != null) {
            try {
                List<PoiData> pois = frequentInfoData.getPois();
                if (pois != null) {
                    int size = pois.size();
                    jSONObject.put("Count", size);
                    JSONArray jSONArray = new JSONArray();
                    for (int i = 0; i < size; i++) {
                        new JSONObject();
                        jSONArray.put(a(pois.get(i)));
                    }
                    jSONObject.put("Pois", jSONArray);
                }
            } catch (Exception unused) {
                return null;
            }
        }
        return jSONObject.toString();
    }

    public static JSONObject a(PoiData poiData) {
        aa0.a("ProtocolModelUtils", "[parsePoiDataToJson] start", new Object[0]);
        JSONObject jSONObject = new JSONObject();
        try {
        } catch (Exception e) {
            aa0.a("ProtocolModelUtils", "Exception", e, new Object[0]);
        }
        if (poiData == null) {
            aa0.a("ProtocolModelUtils", "[parsePoiDataToJson]poiData == null", new Object[0]);
            return null;
        }
        jSONObject.put(StandardProtocolKey.POI_ID, poiData.getPoiid());
        jSONObject.put(StandardProtocolKey.EXTRA_POINAME, poiData.name);
        jSONObject.put(StandardProtocolKey.POI_ADDRESS, poiData.address);
        jSONObject.put("Typecode", poiData.poitype);
        double doubleValue = new BigDecimal(poiData.latitude).setScale(6, 4).doubleValue();
        jSONObject.put("longitude", new BigDecimal(poiData.longitude).setScale(6, 4).doubleValue());
        jSONObject.put("latitude", doubleValue);
        jSONObject.put(StandardProtocolKey.POITYPE, poiData.homecopType);
        jSONObject.put(StandardProtocolKey.POICATEGORY, poiData.poitype);
        List<EnteryData> enteryList = poiData.getEnteryList();
        if (enteryList != null && enteryList.size() > 0) {
            double doubleValue2 = new BigDecimal(enteryList.get(0).latitude).setScale(6, 4).doubleValue();
            jSONObject.put(StandardProtocolKey.ENTRY_LONGITUDE, new BigDecimal(enteryList.get(0).longitude).setScale(6, 4).doubleValue());
            jSONObject.put(StandardProtocolKey.ENTRY_LATITUDE, doubleValue2);
        }
        jSONObject.put("Distance", poiData.distance);
        jSONObject.put("Time", poiData.time);
        jSONObject.put("Tel", poiData.tel);
        aa0.a("ProtocolModelUtils", "[parsePoiDataToJson] end json:{?}", jSONObject.toString());
        return jSONObject;
    }

    public static String a(RouteInfoModel routeInfoModel) {
        JSONObject jSONObject = new JSONObject();
        if (routeInfoModel != null) {
            try {
                jSONObject.put(StandardProtocolKey.FROM_POI_NAME, routeInfoModel.C());
                jSONObject.put(StandardProtocolKey.FROM_POI_ADDR, routeInfoModel.z());
                jSONObject.put(StandardProtocolKey.FROM_POI_LONGUTUDE, String.valueOf(routeInfoModel.B()));
                jSONObject.put(StandardProtocolKey.FROM_POI_LATITUDE, String.valueOf(routeInfoModel.A()));
                jSONObject.put(StandardProtocolKey.FROM_POI_TYPE, routeInfoModel.D());
                jSONObject.put(StandardProtocolKey.TO_POI_NAME, routeInfoModel.t());
                jSONObject.put(StandardProtocolKey.TO_POI_ADDR, routeInfoModel.q());
                jSONObject.put(StandardProtocolKey.TO_POI_LONGITUDE, String.valueOf(routeInfoModel.s()));
                jSONObject.put(StandardProtocolKey.TO_POI_LATITUDE, String.valueOf(routeInfoModel.r()));
                jSONObject.put(StandardProtocolKey.TO_POI_TYPE, routeInfoModel.u());
                jSONObject.put(StandardProtocolKey.TO_ENDPOIID, routeInfoModel.v());
                jSONObject.put(StandardProtocolKey.ARRIVE_POI_LATITUDE, routeInfoModel.getArrivePOILatitude());
                jSONObject.put(StandardProtocolKey.ARRIVE_POI_LONGITUDE, routeInfoModel.getArrivePOILongitude());
                jSONObject.put(StandardProtocolKey.ARRIVE_POI_TYPE, routeInfoModel.p());
                ArrayList<ProtocolViaPOIInfo> x = routeInfoModel.x();
                if (x != null) {
                    jSONObject.put(StandardProtocolKey.MID_POIS_NUM, x.size());
                    JSONArray jSONArray = new JSONArray();
                    for (ProtocolViaPOIInfo protocolViaPOIInfo : x) {
                        if (protocolViaPOIInfo != null) {
                            JSONObject jSONObject2 = new JSONObject();
                            jSONObject2.put(StandardProtocolKey.MID_POI_NAME, protocolViaPOIInfo.t());
                            jSONObject2.put(StandardProtocolKey.MID_POI_ADDR, protocolViaPOIInfo.p());
                            jSONObject2.put(StandardProtocolKey.MID_POI_LONGITUDE, String.valueOf(protocolViaPOIInfo.s()));
                            jSONObject2.put(StandardProtocolKey.MID_POI_LATITUDE, String.valueOf(protocolViaPOIInfo.r()));
                            jSONObject2.put(StandardProtocolKey.MID_POI_TYPE, protocolViaPOIInfo.v());
                            jSONObject2.put(StandardProtocolKey.MID_VIA_POIID, protocolViaPOIInfo.w());
                            jSONObject2.put(StandardProtocolKey.MID_VIA_ENTRYLONGITUDE, protocolViaPOIInfo.o());
                            jSONObject2.put(StandardProtocolKey.MID_VIA_ENTRYLATITUDE, protocolViaPOIInfo.n());
                            jSONArray.put(jSONObject2);
                        }
                    }
                    jSONObject.put(StandardProtocolKey.MID_POI_ARRAY, jSONArray);
                } else {
                    jSONObject.put(StandardProtocolKey.MID_POIS_NUM, 0);
                }
                ArrayList<ProtocolRouteInfo> w = routeInfoModel.w();
                if (w != null) {
                    int size = w.size();
                    jSONObject.put(StandardProtocolKey.PATH_NUM, size);
                    JSONArray jSONArray2 = new JSONArray();
                    for (int i = 0; i < size; i++) {
                        ProtocolRouteInfo protocolRouteInfo = w.get(i);
                        JSONObject jSONObject3 = new JSONObject();
                        ArrayList<String> s = protocolRouteInfo.s();
                        JSONArray jSONArray3 = new JSONArray();
                        if (s != null) {
                            Iterator<String> it = s.iterator();
                            while (it.hasNext()) {
                                jSONArray3.put(it.next());
                            }
                            jSONObject3.put(StandardProtocolKey.STREET_NAME_SIZE, s.size());
                        } else {
                            jSONObject3.put(StandardProtocolKey.STREET_NAME_SIZE, 0);
                        }
                        jSONObject3.put(StandardProtocolKey.METHOD, protocolRouteInfo.o());
                        jSONObject3.put(StandardProtocolKey.STREET_NAMES, jSONArray3);
                        jSONObject3.put(StandardProtocolKey.DITANCE, protocolRouteInfo.getDistance());
                        jSONObject3.put(StandardProtocolKey.TIME, protocolRouteInfo.t());
                        jSONObject3.put(StandardProtocolKey.ODD_NUM, protocolRouteInfo.p());
                        jSONObject3.put(StandardProtocolKey.TOTAL_ODD_DISTANCE, protocolRouteInfo.y());
                        jSONObject3.put(StandardProtocolKey.DISTANCE_AUTO, protocolRouteInfo.n());
                        jSONObject3.put(StandardProtocolKey.TIME_AUTO, protocolRouteInfo.u());
                        jSONObject3.put(StandardProtocolKey.ROUTEINFO_VIAPOITIME, protocolRouteInfo.D());
                        jSONObject3.put(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, protocolRouteInfo.C());
                        jSONArray2.put(jSONObject3);
                    }
                    jSONObject.put(StandardProtocolKey.PATH_INFO, jSONArray2);
                }
            } catch (Exception unused) {
            }
        }
        return jSONObject.toString();
    }

    public static String a(RouteResultData routeResultData) {
        JSONObject jSONObject = new JSONObject();
        try {
            PoiData startPoi = routeResultData.getStartPoi();
            if (startPoi != null) {
                jSONObject.put(StandardProtocolKey.FROM_POI_NAME, startPoi.name);
                jSONObject.put(StandardProtocolKey.FROM_POI_ADDR, startPoi.address);
                jSONObject.put(StandardProtocolKey.FROM_POI_LONGUTUDE, String.valueOf(startPoi.longitude));
                jSONObject.put(StandardProtocolKey.FROM_POI_LATITUDE, String.valueOf(startPoi.latitude));
                jSONObject.put(StandardProtocolKey.FROM_POI_TYPE, a(startPoi.poitype));
            }
            PoiData endPoi = routeResultData.getEndPoi();
            if (endPoi != null) {
                jSONObject.put(StandardProtocolKey.TO_POI_NAME, endPoi.name);
                jSONObject.put(StandardProtocolKey.TO_POI_ADDR, endPoi.address);
                jSONObject.put(StandardProtocolKey.TO_POI_LONGITUDE, String.valueOf(endPoi.longitude));
                jSONObject.put(StandardProtocolKey.TO_POI_LATITUDE, String.valueOf(endPoi.latitude));
                jSONObject.put(StandardProtocolKey.TO_POI_TYPE, a(endPoi.poitype));
                List<EnteryData> enteryList = endPoi.getEnteryList();
                if (enteryList != null && enteryList.size() > 0) {
                    jSONObject.put(StandardProtocolKey.ARRIVE_POI_LATITUDE, enteryList.get(0).latitude);
                    jSONObject.put(StandardProtocolKey.ARRIVE_POI_LONGITUDE, enteryList.get(0).longitude);
                    jSONObject.put(StandardProtocolKey.ARRIVE_POI_TYPE, a(enteryList.get(0).poiType));
                }
            }
            List<PoiData> midPois = routeResultData.getMidPois();
            if (midPois != null) {
                jSONObject.put(StandardProtocolKey.MID_POIS_NUM, midPois.size());
                JSONArray jSONArray = new JSONArray();
                for (PoiData poiData : midPois) {
                    if (poiData != null) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put(StandardProtocolKey.MID_POI_NAME, poiData.name);
                        jSONObject2.put(StandardProtocolKey.MID_POI_ADDR, poiData.address);
                        jSONObject2.put(StandardProtocolKey.MID_POI_LONGITUDE, String.valueOf(poiData.longitude));
                        jSONObject2.put(StandardProtocolKey.MID_POI_LATITUDE, String.valueOf(poiData.latitude));
                        jSONObject2.put(StandardProtocolKey.MID_POI_TYPE, a(poiData.poitype));
                        jSONArray.put(jSONObject2);
                    }
                }
                jSONObject.put(StandardProtocolKey.MID_POI_ARRAY, jSONArray);
            } else {
                jSONObject.put(StandardProtocolKey.MID_POIS_NUM, 0);
            }
            List<RouteInfoData> routeList = routeResultData.getRouteList();
            if (routeList != null) {
                int size = routeList.size();
                jSONObject.put(StandardProtocolKey.PATH_NUM, size);
                JSONArray jSONArray2 = new JSONArray();
                for (int i = 0; i < size; i++) {
                    RouteInfoData routeInfoData = routeList.get(i);
                    JSONObject jSONObject3 = new JSONObject();
                    List<String> streetNames = routeInfoData.getStreetNames();
                    JSONArray jSONArray3 = new JSONArray();
                    if (streetNames != null) {
                        Iterator<String> it = streetNames.iterator();
                        while (it.hasNext()) {
                            jSONArray3.put(it.next());
                        }
                        jSONObject3.put(StandardProtocolKey.STREET_NAME_SIZE, streetNames.size());
                    } else {
                        jSONObject3.put(StandardProtocolKey.STREET_NAME_SIZE, 0);
                    }
                    jSONObject3.put(StandardProtocolKey.METHOD, routeInfoData.labelText);
                    jSONObject3.put(StandardProtocolKey.STREET_NAMES, jSONArray3);
                    jSONObject3.put(StandardProtocolKey.DITANCE, routeInfoData.distance);
                    jSONObject3.put(StandardProtocolKey.TIME, routeInfoData.time);
                    jSONObject3.put(StandardProtocolKey.ODD_NUM, routeInfoData.oddNum);
                    jSONObject3.put(StandardProtocolKey.TOTAL_ODD_DISTANCE, routeInfoData.totalOddDistance);
                    String str = routeInfoData.totalDistanceDes;
                    String str2 = routeInfoData.totalTimeDes;
                    jSONObject3.put(StandardProtocolKey.DISTANCE_AUTO, str);
                    jSONObject3.put(StandardProtocolKey.TIME_AUTO, str2);
                    jSONObject3.put(StandardProtocolKey.ROUTEINFO_VIAPOITIME, routeInfoData.viaPOItime);
                    jSONObject3.put(StandardProtocolKey.ROUTEINFO_VIAPOIDISTANCE, routeInfoData.viaPOIdistance);
                    jSONArray2.put(jSONObject3);
                }
                jSONObject.put(StandardProtocolKey.PATH_INFO, jSONArray2);
            }
        } catch (Exception e) {
            aa0.a("ProtocolModelUtils", "sendRouteResult = " + e.toString(), new Object[0]);
        }
        return jSONObject.toString();
    }

    public static String a(int i) {
        return String.format("%06d", Integer.valueOf(i));
    }
}
