package defpackage;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import com.AutoHelper;
import com.autonavi.amapauto.adapter.internal.widget.AutoSimilarWidgetService;
import com.autonavi.amapauto.jni.ViewInfo;
import com.autonavi.extscreen.dto.PresentationConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/* compiled from: MultiScreenManager.java */
/* loaded from: classes.dex */
public class qs {
    public Context a;
    public List<Display> b;
    public List<ps> c;
    public boolean d;
    public DisplayManager e;
    public List<PresentationConfig> f;
    public List<PresentationConfig> g;
    public HashMap<Integer, PresentationConfig> h;
    public HashMap<Integer, PresentationConfig> i;
    public int j;
    public DisplayManager.DisplayListener k;

    /* compiled from: MultiScreenManager.java */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        public a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            if (Build.VERSION.SDK_INT >= 17) {
                qs.this.e.registerDisplayListener(qs.this.k, new Handler());
            }
        }
    }

    /* compiled from: MultiScreenManager.java */
    /* loaded from: classes.dex */
    public class b implements DisplayManager.DisplayListener {
        public b() {
        }

        @Override // android.hardware.display.DisplayManager.DisplayListener
        public void onDisplayAdded(int i) {
            aa0.a("MultiScreenManager", "onDisplayAdded displayId={?}", Integer.valueOf(i));
            qs.this.c();
            if (qs.this.b == null || qs.this.b.isEmpty()) {
                return;
            }
            for (PresentationConfig presentationConfig : qs.this.f) {
                if (Build.VERSION.SDK_INT >= 17) {
                    if (presentationConfig == null) {
                        continue;
                    } else if (!TextUtils.isEmpty(presentationConfig.displayName) && presentationConfig.displayName.equals(qs.this.a(i))) {
                        qs.this.a(presentationConfig);
                        return;
                    }
                }
                int i2 = presentationConfig.deviceId - 1000;
                aa0.a("MultiScreenManager", "onDisplayAdded configDisplayId={?}", Integer.valueOf(i2));
                if (i2 == i) {
                    qs.this.a(presentationConfig);
                    return;
                }
            }
        }

        @Override // android.hardware.display.DisplayManager.DisplayListener
        public void onDisplayChanged(int i) {
            aa0.a("MultiScreenManager", "onDisplayChanged displayId={?}", Integer.valueOf(i));
        }

        @Override // android.hardware.display.DisplayManager.DisplayListener
        public void onDisplayRemoved(int i) {
            PresentationConfig presentationConfig = (PresentationConfig) qs.this.h.remove(Integer.valueOf(i));
            ps b = qs.this.b(i);
            if (qs.this.c != null && b != null && b.f().i == 1) {
                ViewInfo f = b.f();
                qs.this.c.remove(b);
                aa0.a("MultiScreenManager", "extScreens remove id={?}, name={?}", Integer.valueOf(f.c), f.a);
            }
            aa0.a("MultiScreenManager", "onDisplayRemoved displayId={?}, config = {?}", Integer.valueOf(i), presentationConfig);
            if (presentationConfig == null || qs.this.f.contains(presentationConfig)) {
                return;
            }
            qs.this.f.add(presentationConfig);
        }
    }

    /* compiled from: MultiScreenManager.java */
    /* loaded from: classes.dex */
    public static class c {
        public static final qs a = new qs(null);
    }

    public /* synthetic */ qs(a aVar) {
        this();
    }

    public qs() {
        this.d = false;
        this.j = -1;
        this.k = new b();
        this.a = ee.A().f();
        this.c = new CopyOnWriteArrayList();
        this.b = new ArrayList();
        this.f = new ArrayList();
        this.g = new ArrayList();
        this.h = new HashMap<>();
        this.e = (DisplayManager) this.a.getApplicationContext().getSystemService("display");
        bb0.a(new a());
        c();
        vs.a().a(this.a);
    }

    public static qs e() {
        return c.a;
    }

    public final ps b(PresentationConfig presentationConfig) {
        aa0.a("MultiScreenManager", "initPresentationScreen(). config = {?}", presentationConfig.toString());
        return new ws(this.a);
    }

    @TargetApi(17)
    public final void c() {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        try {
            DisplayManager displayManager = (DisplayManager) this.a.getApplicationContext().getSystemService("display");
            Display[] displayArr = new Display[0];
            if (displayManager != null) {
                displayArr = displayManager.getDisplays(jp.I().b() ? null : "android.hardware.display.category.PRESENTATION");
            }
            if (displayArr != null) {
                aa0.a("MultiScreenManager", "initDisplays: size = {?}", Integer.valueOf(displayArr.length));
                if (displayArr.length > 0) {
                    List<Display> asList = Arrays.asList(displayArr);
                    this.b = asList;
                    for (Display display : asList) {
                        if (display == null) {
                            aa0.a("MultiScreenManager", "displayt is null", (Throwable) null, new Object[0]);
                        } else {
                            aa0.a("MultiScreenManager", "initDisplays: id={?},name={?}", Integer.valueOf(display.getDisplayId()), display.getName());
                        }
                    }
                }
            }
        } catch (Throwable th) {
            th.printStackTrace();
            aa0.a("MultiScreenManager", "exception in initDisplays", th, new Object[0]);
        }
        this.j = ee.A().a("VIRTUAL_DISPLAY_MOCK_OFFSET", -1);
    }

    public boolean d() {
        return this.j >= 0;
    }

    public HashMap<Integer, PresentationConfig> a() {
        if (this.i == null) {
            this.i = new HashMap<>();
        }
        return this.i;
    }

    public final ps b() {
        int onNativeGetIntValue = AutoHelper.onNativeGetIntValue(3006);
        aa0.a("MultiScreenManager", "initAidlWidgetScreen, widgetType={?}", Integer.valueOf(onNativeGetIntValue));
        if (onNativeGetIntValue == 4) {
            return new ts(this.a);
        }
        if (onNativeGetIntValue == 3) {
            return new ss(this.a);
        }
        return null;
    }

    public final String a(int i) {
        List<Display> list = this.b;
        if (list != null && !list.isEmpty() && Build.VERSION.SDK_INT >= 17) {
            for (Display display : this.b) {
                if (display == null) {
                    aa0.a("MultiScreenManager", "displayt is null", (Throwable) null, new Object[0]);
                } else if (i == display.getDisplayId()) {
                    return display.getName();
                }
            }
        }
        return null;
    }

    public void b(ps psVar) {
        if (psVar == null) {
            return;
        }
        aa0.a("MultiScreenManager", "stopRenderScreen id={?}", Integer.valueOf(psVar.b()));
        psVar.l();
    }

    public ps b(int i) {
        if (i < 1000) {
            i += 1000;
        }
        List<ps> list = this.c;
        if (list == null || list.size() <= 0) {
            return null;
        }
        for (ps psVar : this.c) {
            if (psVar.f().c == i) {
                return psVar;
            }
        }
        return null;
    }

    public void a(PresentationConfig presentationConfig) {
        aa0.a("MultiScreenManager", "createExtScreen hasInitMultiScreen:{?}", Boolean.valueOf(this.d));
        if (presentationConfig != null && !this.d) {
            int c2 = jp.I().c(presentationConfig);
            aa0.a("MultiScreenManager", "createExtScreen interruptType = {?}", Integer.valueOf(c2));
            if (c2 != 0) {
                if (c2 == 2) {
                    this.g.add(presentationConfig);
                    return;
                }
                return;
            }
            aa0.a("MultiScreenManager", "createExtScreen presentationConfig:{?}", presentationConfig.toString());
            try {
                new Rect();
                aa0.a("MultiScreenManager", "createExtScreen renderType:{?}", Integer.valueOf(presentationConfig.renderType));
                ps psVar = null;
                boolean d = d();
                aa0.a("MultiScreenManager", "needPresentationMock:{?}, virtualDisplayMockOffset:{?}", Boolean.valueOf(d), Integer.valueOf(this.j));
                boolean z = presentationConfig.renderType == 1;
                if (z && d) {
                    presentationConfig.deviceId += this.j;
                }
                if ((!z || !d) && jp.I().a(presentationConfig)) {
                    psVar = jp.I().b(presentationConfig);
                } else {
                    int i = presentationConfig.renderType;
                    if (i != 1) {
                        if (i == 2) {
                            psVar = b();
                        } else if (i == 5) {
                            if (ku.a) {
                                aa0.a("MultiScreenManager.rzc", "VIDEO_STREAM initVideoScreen", new Object[0]);
                            }
                            if (mu.SGM_NGI_2P_VEDIO.ordinal() == nu.a) {
                                pt.a();
                            }
                            psVar = c(presentationConfig);
                        } else if (i == 6) {
                            psVar = b(presentationConfig);
                        }
                    } else if (this.b != null) {
                        aa0.a("MultiScreenManager", "createExtScreen SYSTEM_PRESENTATION, extDisplays.size={?}", Integer.valueOf(this.b.size()));
                        int i2 = 0;
                        while (true) {
                            if (i2 >= this.b.size()) {
                                break;
                            }
                            Display display = this.b.get(i2);
                            if (Build.VERSION.SDK_INT >= 17 && !TextUtils.isEmpty(presentationConfig.displayName) && presentationConfig.displayName.equals(display.getName())) {
                                psVar = a(i2, presentationConfig);
                                break;
                            }
                            int i3 = presentationConfig.deviceId - 1000;
                            if (display != null && i3 == display.getDisplayId()) {
                                psVar = a(i2, presentationConfig);
                                break;
                            } else {
                                if (presentationConfig.deviceId == 9999) {
                                    psVar = a(i2, presentationConfig);
                                    break;
                                }
                                i2++;
                            }
                        }
                        if (psVar == null) {
                            this.f.add(presentationConfig);
                        }
                    }
                }
                if (psVar == null) {
                    aa0.a("MultiScreenManager", "createExtScreen extScreen is null.", new Object[0]);
                    return;
                }
                psVar.a(a(presentationConfig, (z && d) ? this.j : 0));
                psVar.a(presentationConfig.deviceId);
                psVar.g();
                this.c.add(psVar);
                if (presentationConfig.renderType != 2) {
                    if (presentationConfig.createSurfaceWhenInit == 1) {
                        a(psVar);
                    }
                } else {
                    AutoSimilarWidgetService.a(psVar);
                }
                aa0.a("MultiScreenManager", "createExtScreen end id={?}", Integer.valueOf(psVar.b()));
                return;
            } catch (Exception e) {
                e.printStackTrace();
                aa0.a("MultiScreenManager", "initExtScreen error:" + Log.getStackTraceString(e), e, new Object[0]);
                return;
            }
        }
        aa0.a("MultiScreenManager", "createExtScreen return", new Object[0]);
    }

    public final ps c(PresentationConfig presentationConfig) {
        int i = nu.a;
        aa0.a("MultiScreenManager", "initVideoScreen videoType:{?}", Integer.valueOf(i));
        if (mu.SGM_NGI_2P_VEDIO.ordinal() == i) {
            return new ct(this.a, presentationConfig);
        }
        if (mu.HAMAN_VEDIO.ordinal() == i) {
            return new bt(this.a, presentationConfig);
        }
        return new at(this.a, presentationConfig);
    }

    public void c(int i) {
        aa0.a("MultiScreenManager", "stopRenderScreen deviceId={?}", Integer.valueOf(i));
        ps b2 = b(i);
        if (b2 != null && this.c != null) {
            aa0.a("MultiScreenManager", "stopRenderScreen type={?}", Integer.valueOf(b2.f().i));
            b(b2);
            b2.a();
            this.c.remove(b2);
        }
        for (int size = this.g.size() - 1; size >= 0; size--) {
            if (i == this.g.get(size).deviceId) {
                this.g.remove(size);
                aa0.a("MultiScreenManager", "stopRenderScreen deviceId={?} removed", Integer.valueOf(i));
            }
        }
    }

    public final ViewInfo a(PresentationConfig presentationConfig, int i) {
        ViewInfo viewInfo = new ViewInfo();
        String str = presentationConfig.pluginName;
        viewInfo.b = str;
        viewInfo.a = str;
        viewInfo.c = presentationConfig.deviceId - i;
        viewInfo.f = presentationConfig.width;
        viewInfo.g = presentationConfig.height;
        viewInfo.h = presentationConfig.dpi;
        viewInfo.i = presentationConfig.renderType;
        viewInfo.j = presentationConfig.eglAlphaSize;
        viewInfo.k = presentationConfig.removeSurface;
        viewInfo.m = presentationConfig.isMainScreenForegroundStopRender;
        viewInfo.n = presentationConfig.createSurfaceWhenInit;
        viewInfo.l = presentationConfig.isSeparateRender ? 1 : 0;
        viewInfo.o = presentationConfig.isSynMultiScreenNotify;
        viewInfo.p = presentationConfig.getViewModeInfoList();
        return viewInfo;
    }

    public final ps a(int i, PresentationConfig presentationConfig) {
        List<Display> list = this.b;
        if (list != null && i < list.size()) {
            Display display = this.b.get(i);
            if (display == null) {
                aa0.a("MultiScreenManager", " display is null at index = " + i, (Throwable) null, new Object[0]);
                return null;
            }
            this.h.put(Integer.valueOf(display.getDisplayId()), presentationConfig);
            aa0.a("MultiScreenManager", "initPresentationScreen(). displayId = {?}", Integer.valueOf(display.getDisplayId()));
            return new ys(this.a, display);
        }
        Object[] objArr = new Object[2];
        objArr[0] = Integer.valueOf(i);
        List<Display> list2 = this.b;
        objArr[1] = Integer.valueOf(list2 != null ? list2.size() : 0);
        aa0.a("MultiScreenManager", "initPresentationScreen index:{?} extDisplays.size:{?}", objArr);
        return null;
    }

    public final void a(ps psVar) {
        if (psVar == null) {
            return;
        }
        psVar.k();
    }

    public void a(int i, int i2, boolean z) {
        ps b2 = b(i);
        if (b2 != null) {
            b2.a(i2, z);
        }
    }
}
