package defpackage;

import android.content.Intent;
import com.autonavi.amapauto.jni.protocol.data.DriveWayData;
import com.autonavi.amapauto.jni.protocol.data.DriveWayItemData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.base.ProtocolBaseModel;
import com.autonavi.amapauto.protocol.model.item.TrafficLaneInfo;
import com.autonavi.amapauto.protocol.model.service.DriveWayProtocolSdkModel;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: DriveWayInfoDisAction.java */
/* loaded from: classes.dex */
public class qx extends dx implements t50, s50 {
    public DriveWayData d;

    public qx(DriveWayData driveWayData) {
        this.d = driveWayData;
    }

    @Override // defpackage.s50
    public ProtocolBaseModel a() {
        if (this.d == null) {
            return null;
        }
        DriveWayProtocolSdkModel driveWayProtocolSdkModel = new DriveWayProtocolSdkModel();
        driveWayProtocolSdkModel.a(this.d.isEnable);
        driveWayProtocolSdkModel.c(this.d.size);
        if (this.d.getDrivewayList() != null) {
            ArrayList<TrafficLaneInfo> arrayList = new ArrayList<>();
            for (DriveWayItemData driveWayItemData : this.d.getDrivewayList()) {
                TrafficLaneInfo trafficLaneInfo = new TrafficLaneInfo();
                trafficLaneInfo.e(driveWayItemData.laneBackIcon);
                trafficLaneInfo.f(driveWayItemData.number);
                trafficLaneInfo.c(driveWayItemData.extFlag);
                trafficLaneInfo.a(driveWayItemData.trafficLaneAdvised);
                trafficLaneInfo.d(driveWayItemData.trafficLaneExtendedNew);
                trafficLaneInfo.g(driveWayItemData.trafficLaneType);
                arrayList.add(trafficLaneInfo);
            }
            driveWayProtocolSdkModel.a(arrayList);
            aa0.a("DriveWayInfoDisAction", "in#parseToAidlModel model :{?}", driveWayProtocolSdkModel.toString());
        }
        return driveWayProtocolSdkModel;
    }

    @Override // defpackage.t50
    public Intent b() {
        Intent intent = new Intent();
        intent.putExtra(StandardProtocolKey.KEY_TYPE, 13012);
        intent.putExtra(StandardProtocolKey.EXTRA_DRIVE_WAY, f());
        return intent;
    }

    @Override // defpackage.dx
    public boolean e() {
        return true;
    }

    public final String f() {
        String str;
        if (this.d != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(StandardProtocolKey.KEY_DRIVE_WAY_ENABLED, this.d.isEnable);
                jSONObject.put(StandardProtocolKey.KEY_DRIVE_WAY_SIZE, this.d.size);
                JSONArray jSONArray = new JSONArray();
                if (this.d.getDrivewayList() != null && this.d.getDrivewayList().size() > 0) {
                    for (DriveWayItemData driveWayItemData : this.d.getDrivewayList()) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put(StandardProtocolKey.KEY_DRIVE_WAY_NUMBER, driveWayItemData.number);
                        jSONObject2.put(StandardProtocolKey.KEY_DRIVE_WAY_LANE_BACK_ICON, String.valueOf(driveWayItemData.laneBackIcon));
                        jSONObject2.put(StandardProtocolKey.KEY_DRIVE_WAY_LANE_EXTENDED, String.valueOf(driveWayItemData.extFlag));
                        jSONObject2.put(StandardProtocolKey.KEY_TRAFFIC_LANE_ADVISED, driveWayItemData.trafficLaneAdvised);
                        jSONObject2.put(StandardProtocolKey.KEY_TRAFFIC_LANE_EXTENDEDNEW, driveWayItemData.trafficLaneExtendedNew);
                        jSONObject2.put(StandardProtocolKey.KEY_TRAFFIC_LANE_TYPE, driveWayItemData.trafficLaneType);
                        jSONArray.put(jSONObject2);
                    }
                }
                jSONObject.put(StandardProtocolKey.KEY_DRIVE_WAY_INFO, jSONArray);
            } catch (JSONException e) {
                aa0.a("DriveWayInfoDisAction", e.getMessage(), e, new Object[0]);
            }
            str = jSONObject.toString();
        } else {
            str = "";
        }
        aa0.a("DriveWayInfoDisAction", "in#getDriveWayJson json :{?}", str);
        return str;
    }
}
