package defpackage;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.text.TextUtils;
import com.autonavi.amapauto.remotecontrol.RemoteControlManager;
import java.util.Locale;
import java.util.Set;

/* compiled from: BluetoothInfoCollection.java */
/* loaded from: classes.dex */
public class r80 {
    public BroadcastReceiver a = new a();

    /* compiled from: BluetoothInfoCollection.java */
    /* loaded from: classes.dex */
    public class a extends BroadcastReceiver {
        public a() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                String action = intent.getAction();
                if (!TextUtils.isEmpty(action) && "android.bluetooth.adapter.action.STATE_CHANGED".equals(action) && intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0) == 12) {
                    r80.this.c(context);
                    r80.this.b(context);
                }
            }
        }
    }

    public void b(Context context) {
        if (context == null) {
            return;
        }
        try {
            int i = 0;
            if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                a(0, 0, 0, 0);
                return;
            }
            BluetoothAdapter defaultAdapter = BluetoothAdapter.getDefaultAdapter();
            if (defaultAdapter == null) {
                if (Build.VERSION.SDK_INT < 18) {
                    a(0, 0, 0, 0);
                    return;
                }
                defaultAdapter = ((BluetoothManager) context.getSystemService("bluetooth")).getAdapter();
                if (defaultAdapter == null) {
                    a(0, 0, 0, 0);
                    return;
                }
            }
            if (defaultAdapter.isEnabled()) {
                Set<BluetoothDevice> bondedDevices = defaultAdapter.getBondedDevices();
                int size = bondedDevices != null ? bondedDevices.size() : 0;
                String d = RemoteControlManager.u().d();
                int i2 = (TextUtils.isEmpty(d) || "02:00:00:00:00:00".equalsIgnoreCase(d)) ? 0 : 1;
                if (Build.VERSION.SDK_INT >= 18 && context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                    i = 1;
                }
                a(1, size, i, i2);
                return;
            }
            a(context);
        } catch (Exception unused) {
        }
    }

    public final void c(Context context) {
        try {
            context.unregisterReceiver(this.a);
        } catch (Exception unused) {
        }
    }

    public final void a(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            context.registerReceiver(this.a, intentFilter);
        } catch (Exception unused) {
        }
    }

    public final void a(int i, int i2, int i3, int i4) {
        String format = String.format(Locale.US, "[%s][4][%d][%d][%d][%d]", 100000001, Integer.valueOf(i), Integer.valueOf(i2), Integer.valueOf(i3), Integer.valueOf(i4));
        aa0.a("BluetoothInfoCollection", "collectionInfo = {?}", format);
        ge.b("AUTO_CONNECT", 100000001, format, 1);
    }
}
