package defpackage;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.net.InetAddress;
import java.util.List;

/* compiled from: NetStatusUtil.java */
/* loaded from: classes.dex */
public class vr0 {
    public static boolean a(int i) {
        return i == 2 || i == 5 || i == 7 || i == 3;
    }

    public static String[] a(Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", "[getDnsServers] error", th);
                return null;
            }
        }
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService("connectivity");
        if (connectivityManager == null) {
            zr0.c("bifrost.NetStatusUtil", "[getDnsServers] no connectivityManager");
            return null;
        }
        Network activeNetwork = connectivityManager.getActiveNetwork();
        if (activeNetwork == null) {
            zr0.c("bifrost.NetStatusUtil", "[getDnsServers] no activeNetwork");
            return null;
        }
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(activeNetwork);
        if (networkInfo != null && networkInfo.isConnected()) {
            LinkProperties linkProperties = connectivityManager.getLinkProperties(activeNetwork);
            if (linkProperties == null) {
                zr0.c("bifrost.NetStatusUtil", "[getDnsServers]no linkProperties");
                return null;
            }
            zr0.c("bifrost.NetStatusUtil", "iface = " + linkProperties.getInterfaceName());
            zr0.c("bifrost.NetStatusUtil", "dns = " + linkProperties.getDnsServers());
            List<InetAddress> dnsServers = linkProperties.getDnsServers();
            if (dnsServers.size() <= 0) {
                zr0.c("bifrost.NetStatusUtil", "[getDnsServers]no targetDnses");
                return null;
            }
            String[] strArr = new String[dnsServers.size()];
            for (int i = 0; i < dnsServers.size(); i++) {
                strArr[i] = dnsServers.get(i).getHostAddress();
            }
            return strArr;
        }
        zr0.c("bifrost.NetStatusUtil", "[getDnsServers]activeNetwork error");
        return null;
    }

    public static int b(Context context) {
        String simOperator;
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", "getISPCode error", th);
                return 0;
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE);
        if (telephonyManager != null && (simOperator = telephonyManager.getSimOperator()) != null && simOperator.length() >= 5) {
            StringBuilder sb = new StringBuilder();
            int length = simOperator.length();
            if (length > 6) {
                length = 6;
            }
            for (int i = 0; i < length; i++) {
                if (!Character.isDigit(simOperator.charAt(i))) {
                    if (sb.length() > 0) {
                        break;
                    }
                } else {
                    sb.append(simOperator.charAt(i));
                }
            }
            return Integer.valueOf(sb.toString()).intValue();
        }
        return 0;
    }

    public static boolean b(int i) {
        return i == 0;
    }

    public static String c(Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", "getISPName error", th);
                return "";
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE);
        if (telephonyManager == null) {
            return "";
        }
        if (telephonyManager.getSimOperatorName().length() <= 100) {
            return telephonyManager.getSimOperatorName();
        }
        return telephonyManager.getSimOperatorName().substring(0, 100);
    }

    public static int d(Context context) {
        NetworkInfo activeNetworkInfo;
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", "getNetType", th);
                return -1;
            }
        }
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService("connectivity");
        if (connectivityManager == null || (activeNetworkInfo = connectivityManager.getActiveNetworkInfo()) == null) {
            return -1;
        }
        if (activeNetworkInfo.getType() == 1) {
            return 0;
        }
        if (activeNetworkInfo.getExtraInfo() == null) {
            return 9;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("uninet")) {
            return 1;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("uniwap")) {
            return 2;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("3gwap")) {
            return 3;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("3gnet")) {
            return 4;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("cmwap")) {
            return 5;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("cmnet")) {
            return 6;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("ctwap")) {
            return 7;
        }
        if (activeNetworkInfo.getExtraInfo().equalsIgnoreCase("ctnet")) {
            return 8;
        }
        return activeNetworkInfo.getExtraInfo().equalsIgnoreCase("LTE") ? 10 : 9;
    }

    public static boolean e(Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", th);
            }
        }
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (activeNetworkInfo.getType() == 1) {
            return false;
        }
        if (activeNetworkInfo.getSubtype() != 2 && activeNetworkInfo.getSubtype() != 1) {
            if (activeNetworkInfo.getSubtype() != 4) {
                return false;
            }
        }
        return true;
    }

    public static boolean f(Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", th);
            }
        }
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (activeNetworkInfo.getType() != 1 && activeNetworkInfo.getSubtype() >= 5) {
            if (activeNetworkInfo.getSubtype() < 13) {
                return true;
            }
        }
        return false;
    }

    public static boolean g(Context context) {
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", th);
            }
        }
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (activeNetworkInfo.getType() == 1) {
            return false;
        }
        return activeNetworkInfo.getSubtype() >= 13;
    }

    public static boolean h(Context context) {
        NetworkInfo activeNetworkInfo;
        if (context == null) {
            try {
                context = tr0.a();
            } catch (Throwable th) {
                zr0.a("bifrost.NetStatusUtil", "isNetworkConnected error", th);
                return false;
            }
        }
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService("connectivity");
        if (connectivityManager == null || (activeNetworkInfo = connectivityManager.getActiveNetworkInfo()) == null) {
            return false;
        }
        return activeNetworkInfo.getState() == NetworkInfo.State.CONNECTED;
    }
}
