package defpackage;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.ActionMenuPresenter;
import androidx.appcompat.widget.ActionMenuView;

/* compiled from: AbsActionBarView.java */
/* loaded from: classes.dex */
public abstract class w1 extends ViewGroup {
    public final a a;
    public final Context c;
    public ActionMenuView d;
    public ActionMenuPresenter e;
    public int f;
    public u9 g;
    public boolean h;
    public boolean i;

    public w1(Context context) {
        this(context, null);
    }

    public static int a(int i, int i2, boolean z) {
        return z ? i - i2 : i + i2;
    }

    public int getAnimatedVisibility() {
        if (this.g != null) {
            return this.a.b;
        }
        return getVisibility();
    }

    public int getContentHeight() {
        return this.f;
    }

    @Override // android.view.View
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(null, b0.ActionBar, s.actionBarStyle, 0);
        setContentHeight(obtainStyledAttributes.getLayoutDimension(b0.ActionBar_height, 0));
        obtainStyledAttributes.recycle();
        ActionMenuPresenter actionMenuPresenter = this.e;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.a(configuration);
        }
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.i = false;
        }
        if (!this.i) {
            boolean onHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !onHoverEvent) {
                this.i = true;
            }
        }
        if (actionMasked == 10 || actionMasked == 3) {
            this.i = false;
        }
        return true;
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.h = false;
        }
        if (!this.h) {
            boolean onTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !onTouchEvent) {
                this.h = true;
            }
        }
        if (actionMasked == 1 || actionMasked == 3) {
            this.h = false;
        }
        return true;
    }

    public abstract void setContentHeight(int i);

    @Override // android.view.View
    public void setVisibility(int i) {
        if (i != getVisibility()) {
            u9 u9Var = this.g;
            if (u9Var != null) {
                u9Var.a();
            }
            super.setVisibility(i);
        }
    }

    /* compiled from: AbsActionBarView.java */
    /* loaded from: classes.dex */
    public class a implements v9 {
        public boolean a = false;
        public int b;

        public a() {
        }

        public a a(u9 u9Var, int i) {
            w1.this.g = u9Var;
            this.b = i;
            return this;
        }

        @Override // defpackage.v9
        public void b(View view) {
            if (this.a) {
                return;
            }
            w1 w1Var = w1.this;
            w1Var.g = null;
            w1.super.setVisibility(this.b);
        }

        @Override // defpackage.v9
        public void c(View view) {
            w1.super.setVisibility(0);
            this.a = false;
        }

        @Override // defpackage.v9
        public void a(View view) {
            this.a = true;
        }
    }

    public w1(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public u9 a(int i, long j) {
        u9 u9Var = this.g;
        if (u9Var != null) {
            u9Var.a();
        }
        if (i == 0) {
            if (getVisibility() != 0) {
                setAlpha(0.0f);
            }
            u9 a2 = q9.a(this);
            a2.a(1.0f);
            a2.a(j);
            a aVar = this.a;
            aVar.a(a2, i);
            a2.a(aVar);
            return a2;
        }
        u9 a3 = q9.a(this);
        a3.a(0.0f);
        a3.a(j);
        a aVar2 = this.a;
        aVar2.a(a3, i);
        a3.a(aVar2);
        return a3;
    }

    public w1(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.a = new a();
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(s.actionBarPopupTheme, typedValue, true) && typedValue.resourceId != 0) {
            this.c = new ContextThemeWrapper(context, typedValue.resourceId);
        } else {
            this.c = context;
        }
    }

    public int a(View view, int i, int i2, int i3) {
        view.measure(View.MeasureSpec.makeMeasureSpec(i, Integer.MIN_VALUE), i2);
        return Math.max(0, (i - view.getMeasuredWidth()) - i3);
    }

    public int a(View view, int i, int i2, int i3, boolean z) {
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        int i4 = i2 + ((i3 - measuredHeight) / 2);
        if (z) {
            view.layout(i - measuredWidth, i4, i, measuredHeight + i4);
        } else {
            view.layout(i, i4, i + measuredWidth, measuredHeight + i4);
        }
        return z ? -measuredWidth : measuredWidth;
    }
}
