package defpackage;

import android.app.Application;
import android.database.Cursor;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.common.tool.dumpcrash;
import defpackage.qj0;
import java.io.File;
import java.io.FileFilter;

/* compiled from: DatabaseCollector.java */
/* loaded from: classes.dex */
public class xi0 {

    /* compiled from: DatabaseCollector.java */
    /* loaded from: classes.dex */
    public class a implements qj0.a {
        public final /* synthetic */ StringBuilder a;

        public a(StringBuilder sb) {
            this.a = sb;
        }

        @Override // qj0.a
        public boolean a(String str) {
            StringBuilder sb = this.a;
            sb.append("\t");
            sb.append(str);
            sb.append("\n");
            return false;
        }
    }

    /* compiled from: DatabaseCollector.java */
    /* loaded from: classes.dex */
    public class b implements FileFilter {
        @Override // java.io.FileFilter
        public boolean accept(File file) {
            return !file.getName().endsWith("-journal");
        }
    }

    /* compiled from: DatabaseCollector.java */
    /* loaded from: classes.dex */
    public class c implements qj0.a {
        public final /* synthetic */ int[] a;

        public c(int[] iArr) {
            this.a = iArr;
        }

        @Override // qj0.a
        public boolean a(String str) {
            if (!str.contains("Max open files")) {
                return false;
            }
            String[] split = str.split("\\s+");
            if (split == null || split.length <= 4) {
                return true;
            }
            this.a[0] = Integer.valueOf(split[3]).intValue();
            return true;
        }
    }

    public static String a(Throwable th, Application application) {
        File parentFile;
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("\nAppendInfo:\n");
            File dataDirectory = Environment.getDataDirectory();
            StatFs statFs = new StatFs(dataDirectory.getAbsolutePath());
            sb.append("\t");
            sb.append("Data TotalBytes:");
            sb.append(statFs.getBlockCount() * statFs.getBlockSize());
            sb.append(" AvailableBytes:");
            sb.append(statFs.getAvailableBlocks() * statFs.getBlockSize());
            sb.append("\n");
            if (Build.VERSION.SDK_INT >= 9) {
                sb.append("\t");
                sb.append("Data TotalSpace:");
                sb.append(dataDirectory.getTotalSpace());
                sb.append(" UsableSpace:");
                sb.append(dataDirectory.getUsableSpace());
                sb.append("\n");
            }
            try {
                sb.append("\t");
                sb.append("NDK_getUsableSpace:");
                sb.append(dumpcrash.getUsableSpace(dataDirectory.getPath()));
                sb.append("\n");
            } catch (Throwable unused) {
            }
            if (cj0.a(th, (Class<?>) SQLiteCantOpenDatabaseException.class)) {
                int b2 = b();
                int a2 = a();
                sb.append("\t");
                sb.append("limitCount:");
                sb.append(b2);
                sb.append(" currentCount:");
                sb.append(a2);
                sb.append("\n");
                if (a2 <= b2 && a2 / b2 > 0.95d) {
                    zi0.f().e();
                    sb.append("FDinfo:\n");
                    for (String str : zi0.a(false)) {
                        sb.append("\t");
                        sb.append(str);
                        sb.append("\n");
                    }
                }
            }
            sb.append("Mounts:\n");
            qj0.a(new File("/proc/self/mounts"), new a(sb));
            sb.append("\nDumpDatabases:\n");
            File databasePath = application.getDatabasePath("aMap.db");
            if (databasePath == null) {
                parentFile = new File(application.getFilesDir().getParentFile(), "databases");
            } else {
                parentFile = databasePath.getParentFile();
            }
            for (File file = parentFile; file != null; file = file.getParentFile()) {
                sb.append("\t dir=");
                sb.append(file.getPath());
                sb.append(" canRead:");
                sb.append(file.canRead());
                sb.append(" canWrite:");
                sb.append(file.canWrite());
                sb.append(" canExecute:");
                sb.append(file.canExecute());
                sb.append("\n");
            }
            for (File file2 : parentFile.listFiles(new b())) {
                sb.append(a(file2));
            }
        } catch (Throwable th2) {
            try {
                sb.append("getDatabaseInfoError." + th2.toString());
            } catch (Throwable unused2) {
            }
        }
        return sb.toString();
    }

    public static int b() {
        int[] iArr = new int[1];
        qj0.a(new File("/proc/self/limits"), new c(iArr));
        return iArr[0];
    }

    public static String a(File file) {
        SQLiteDatabase sQLiteDatabase;
        SQLiteDatabase openDatabase;
        Cursor cursor;
        Cursor query;
        Cursor cursor2;
        Cursor query2;
        StringBuilder sb = new StringBuilder(file.getAbsolutePath());
        sb.append("\n");
        sb.append("\t");
        sb.append("size:");
        sb.append(file.length());
        sb.append("\n");
        sb.append("\t");
        sb.append("canRead:");
        sb.append(file.canRead());
        sb.append("\t");
        sb.append("canWrite:");
        sb.append(file.canWrite());
        sb.append("\t");
        sb.append("canExecute:");
        sb.append(file.canExecute());
        sb.append("\n");
        try {
            openDatabase = SQLiteDatabase.openDatabase(file.getAbsolutePath(), null, 17);
        } catch (Throwable th) {
            th = th;
            sQLiteDatabase = null;
        }
        try {
            if (openDatabase == null) {
                sb.append("\t");
                sb.append("cannot open database.");
                sb.append("\n");
            } else {
                sb.append("\t");
                sb.append("version:");
                sb.append(openDatabase.getVersion());
                sb.append("\n");
                try {
                    query = openDatabase.query("sqlite_master", new String[]{StandardProtocolKey.NAME}, "type='table'", null, null, null, null);
                } catch (Throwable th2) {
                    th = th2;
                    cursor = null;
                }
                try {
                    if (query.moveToFirst()) {
                        String[] strArr = {"count(*)"};
                        do {
                            String string = query.getString(0);
                            try {
                                query2 = openDatabase.query(string, strArr, null, null, null, null, null);
                            } catch (Throwable th3) {
                                th = th3;
                                cursor2 = null;
                            }
                            try {
                                if (query2.moveToFirst()) {
                                    sb.append("\t");
                                    sb.append("table:");
                                    sb.append(string);
                                    sb.append(" count:");
                                    sb.append(query2.getLong(0));
                                    sb.append("\n");
                                }
                                if (query2 != null) {
                                    query2.close();
                                }
                            } catch (Throwable th4) {
                                th = th4;
                                cursor2 = query2;
                                if (cursor2 != null) {
                                    cursor2.close();
                                }
                                throw th;
                            }
                        } while (query.moveToNext());
                    }
                    if (query != null) {
                        query.close();
                    }
                } catch (Throwable th5) {
                    th = th5;
                    cursor = query;
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw th;
                }
            }
            if (openDatabase != null) {
                openDatabase.close();
            }
        } catch (Throwable th6) {
            th = th6;
            sQLiteDatabase = openDatabase;
            try {
                sb.append("\t");
                sb.append("catch Throwable msg:");
                sb.append(th.getMessage());
                sb.append("\n");
                th.printStackTrace();
                return sb.toString();
            } finally {
                if (sQLiteDatabase != null) {
                    sQLiteDatabase.close();
                }
            }
        }
        return sb.toString();
    }

    public static int a() {
        try {
            File file = new File("/proc/self/fd");
            if (file.exists() && file.isDirectory()) {
                return file.listFiles().length;
            }
            return 0;
        } catch (Throwable unused) {
            return 0;
        }
    }
}
