package defpackage;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

/* compiled from: HttpRequest.java */
/* loaded from: classes.dex */
public abstract class xk0 {
    public volatile boolean mIsCancelled;
    public String mUrl;
    public int mMethod = 0;
    public Map<String, String> mHeaders = new HashMap();
    public Map<String, String> mParams = new HashMap();
    public int mRetryTimes = 3;
    public int mTimeout = 15000;
    public int mPriority = 250;
    public int mChannel = 0;
    public il0 requestStatistics = new il0();

    public void addHeader(String str, String str2) {
        this.mHeaders.put(str, str2);
    }

    public void addParam(String str, String str2) {
        this.mParams.put(str, str2);
    }

    public void addParams(Map<String, String> map) {
        this.mParams.putAll(map);
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Map<String, String> getParams() {
        return this.mParams;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getRetryTimes() {
        return this.mRetryTimes;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public boolean isValid() {
        return !TextUtils.isEmpty(this.mUrl);
    }

    public void setChannel(int i) {
        this.mChannel = i;
    }

    public void setPriority(int i) {
        this.mPriority = i;
    }

    public void setRetryTimes(int i) {
        this.mRetryTimes = i;
    }

    public void setTimeout(int i) {
        this.mTimeout = i;
    }

    public void setUrl(String str) {
        this.mUrl = str;
        this.requestStatistics.f = str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("method:");
        sb.append(nl0.a(this.mMethod));
        sb.append(",url:");
        sb.append(!TextUtils.isEmpty(getUrl()) ? getUrl() : "");
        sb.append(",channel:");
        sb.append(this.mChannel);
        sb.append(",retryTimes:");
        sb.append(this.mRetryTimes);
        sb.append(",timeout:");
        sb.append(this.mTimeout);
        sb.append(",priority:");
        sb.append(this.mPriority);
        sb.append(",header:");
        sb.append(getHeaders() != null ? getHeaders().toString() : "");
        sb.append("}");
        return sb.toString();
    }
}
