package defpackage;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.media.AudioAttributes;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.GAdaAndroid;
import com.autonavi.amapauto.location.model.LocDrPos;
import com.autonavi.amapauto.location.model.LocMMFeedbackInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/* compiled from: KaiwoBE11InteractionImpl.java */
/* loaded from: classes.dex */
public class xo extends tj {
    public b f;

    /* compiled from: KaiwoBE11InteractionImpl.java */
    /* loaded from: classes.dex */
    public class b extends BroadcastReceiver {
        public b(xo xoVar) {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (intent != null && !TextUtils.isEmpty(intent.getAction())) {
                String stringExtra = intent.getStringExtra("path");
                aa0.a("KaiwoBE11InteractionImpl", "onReceive: action={?},path={?}", intent.getAction(), stringExtra);
                if (TextUtils.isEmpty(stringExtra)) {
                    return;
                }
                if ("sky.car.action.usb.device.mounted".equals(intent.getAction())) {
                    try {
                        aa0.a("KaiwoBE11InteractionImpl", "onReceive: udisk MOUNT path={?}", stringExtra);
                        GAdaAndroid.nativeStorageActionChange(1, stringExtra);
                        return;
                    } catch (Throwable th) {
                        aa0.a("KaiwoBE11InteractionImpl", "Throwable", th, new Object[0]);
                        return;
                    }
                }
                if ("sky.car.action.usb.device.unmounted".equals(intent.getAction())) {
                    try {
                        aa0.a("KaiwoBE11InteractionImpl", "onReceive: udisk UNMOUNT path={?}", stringExtra);
                        GAdaAndroid.nativeStorageActionChange(-1, stringExtra);
                        return;
                    } catch (Throwable th2) {
                        aa0.a("KaiwoBE11InteractionImpl", "Throwable", th2, new Object[0]);
                        return;
                    }
                }
                return;
            }
            aa0.a("KaiwoBE11InteractionImpl", "onReceive: intent=null or intent.getAction=null", new Object[0]);
        }
    }

    public xo() {
        aa0.a("KaiwoBE11InteractionImpl", "KaiwoBE11InteractionImpl", new Object[0]);
        this.f = new b();
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("sky.car.action.usb.device.mounted");
            intentFilter.addAction("sky.car.action.usb.device.unmounted");
            ee.A().e().registerReceiver(this.f, intentFilter);
        } catch (Throwable th) {
            aa0.a("KaiwoBE11InteractionImpl", "registerReceiver Throwable:", th, new Object[0]);
        }
    }

    @Override // defpackage.sj, defpackage.kp, defpackage.cq
    public LocDrPos a(Location location) {
        return hp.a(location);
    }

    @Override // defpackage.tj, defpackage.sj, defpackage.kp, defpackage.rp
    public boolean cleanup() {
        try {
            ee.A().e().unregisterReceiver(this.f);
        } catch (Exception e) {
            aa0.a("KaiwoBE11InteractionImpl", "unregisterReceiver {?}", e);
        }
        this.f = null;
        return true;
    }

    @Override // defpackage.sj, defpackage.kp, defpackage.xp
    public List<String> getUsbUpdataPath() {
        File file = new File("/mnt/media_rw");
        ArrayList arrayList = new ArrayList();
        try {
            File[] listFiles = file.listFiles();
            if (listFiles != null && listFiles.length > 0) {
                for (File file2 : listFiles) {
                    if (file2.isDirectory() && file2.canWrite() && !"sdcard".equals(file2.getName()) && !"/".equals(file2.getName())) {
                        String path = file2.getPath();
                        arrayList.add(path);
                        aa0.a("KaiwoBE11InteractionImpl", "getUsbUpdataPath uDiskPath={?}", path);
                    }
                }
            }
        } catch (Exception e) {
            aa0.a("KaiwoBE11InteractionImpl", "getUsbUpdataPath Exception:", e, new Object[0]);
        }
        return arrayList;
    }

    @Override // defpackage.tj, defpackage.sj, defpackage.kp, defpackage.rp
    public boolean l(int i) {
        if (i != 10001) {
            return super.l(i);
        }
        try {
            Intent intent = new Intent("com.skyworth.car.systemsettings.action.WIFI");
            intent.setPackage("com.skyworth.car.systemsettings");
            intent.setFlags(268435456);
            ee.A().e().startActivity(intent);
        } catch (Exception e) {
            aa0.a("KaiwoBE11InteractionImpl", "SHOW_NETWORK_SETTING Exception ", e);
        }
        return true;
    }

    @Override // defpackage.tj, defpackage.sj, defpackage.kp, defpackage.rp
    public int n(int i) {
        if (i != 10012) {
            return super.n(i);
        }
        int i2 = Settings.System.getInt(ee.A().e().getContentResolver(), "light_mode", 0);
        aa0.a("KaiwoBE11InteractionImpl", "GET_HEAD_LAMPS_ON light_mode = {?}", Integer.valueOf(i2));
        return i2;
    }

    @Override // defpackage.tj, defpackage.kp, defpackage.rp
    public String o(int i) {
        if (i != 40003) {
            return super.o(i);
        }
        String a2 = ee.A().e() != null ? ip.a("sys.special.uuid") : "";
        aa0.a("KaiwoBE11InteractionImpl", "[getStringValue]uuid:{?}", a2);
        return a2;
    }

    @Override // defpackage.sj, defpackage.kp, defpackage.cq
    public String a(LocMMFeedbackInfo locMMFeedbackInfo) {
        return hp.a(locMMFeedbackInfo);
    }

    @Override // defpackage.sj, defpackage.kp, defpackage.tp
    public AudioAttributes a(int i, AudioAttributes audioAttributes) {
        if (Build.VERSION.SDK_INT >= 21) {
            aa0.a("KaiwoBE11InteractionImpl", "getCustomAudioAttribute setUsage:{?} setContentType:{?}", 12, 2);
            return new AudioAttributes.Builder().setUsage(12).setContentType(2).build();
        }
        return super.a(i, audioAttributes);
    }
}
