package defpackage;

import android.content.Intent;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.AndroidProtocolExe;
import com.autonavi.amapauto.jni.protocol.data.PowerInfoData;
import com.autonavi.amapauto.jni.protocol.data.PowertrainLoss;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.amapauto.protocol.model.client.RspCarEnergyInfoModel;
import com.autonavi.amapauto.protocol.model.item.PowertrainLossInfo;
import defpackage.rp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/* compiled from: PowerInfoAction.java */
/* loaded from: classes.dex */
public class z30 extends ov {
    public PowerInfoData k;
    public RspCarEnergyInfoModel l;

    public z30() {
    }

    public final ArrayList<Double> a(double[] dArr) {
        if (dArr == null) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<>(dArr.length);
        for (double d : dArr) {
            arrayList.add(Double.valueOf(d));
        }
        return arrayList;
    }

    @Override // defpackage.ov
    public void c() {
        RspCarEnergyInfoModel rspCarEnergyInfoModel;
        rp.a j = jp.I().j(60007);
        boolean booleanValue = j.b() ? ((Boolean) j.a()).booleanValue() : false;
        if (vd.j()) {
            RspCarEnergyInfoModel rspCarEnergyInfoModel2 = this.l;
            if (rspCarEnergyInfoModel2 == null) {
                aa0.a("PowerInfoAction", "mRspCarEnergyInfoModel must not be null", new Object[0]);
            } else {
                aa0.a("PowerInfoAction", "mRspCarEnergyInfoModel:{?}", rspCarEnergyInfoModel2.toString());
            }
            if (!booleanValue || (rspCarEnergyInfoModel = this.l) == null || rspCarEnergyInfoModel.getInitialHvBattenergy() >= 0.0d) {
                a(this.l);
                return;
            }
            return;
        }
        PowerInfoData powerInfoData = this.k;
        if (powerInfoData == null) {
            aa0.a("PowerInfoAction", "Received power info from system, but some key parameter is missing.", new Exception("Received power info from system, but some key parameter is missing."), new Object[0]);
            return;
        }
        aa0.a("PowerInfoAction", "setPowerInfo:{?} isFilterNegativeBatteryEnergy:{?}", powerInfoData.toString(), Boolean.valueOf(booleanValue));
        if (!booleanValue || this.k.getBatteryEnergy() >= 0.0d) {
            aa0.a("PowerInfoAction", "setPowerInfo to native", new Object[0]);
            AndroidProtocolExe.setPowerInfo(this.k);
        }
    }

    public z30(RspCarEnergyInfoModel rspCarEnergyInfoModel) {
        this.l = rspCarEnergyInfoModel;
    }

    public z30(Intent intent) {
        double doubleExtra = intent.getDoubleExtra(StandardProtocolKey.KEY_DOUBLE_CURRENT_BATTERY_AMOUNT, -1.0d);
        aa0.a("PowerInfoAction", "hvBattEnergy = {?}", Double.valueOf(doubleExtra));
        boolean booleanExtra = intent.getBooleanExtra(StandardProtocolKey.KEY_BOOLEAN_IS_CHARGING, false);
        aa0.a("PowerInfoAction", "isCharging = {?}", Boolean.valueOf(booleanExtra));
        int intExtra = intent.getIntExtra(StandardProtocolKey.KEY_INT_DRIVE_MODE, 0);
        aa0.a("PowerInfoAction", "driveMode = {?}", Integer.valueOf(intExtra));
        double doubleExtra2 = intent.getDoubleExtra(StandardProtocolKey.KEY_DOUBLE_MAX_BATTERY_AMOUNT, -1.0d);
        aa0.a("PowerInfoAction", "maxBatteryEnergy = {?}", Double.valueOf(doubleExtra2));
        int intExtra2 = intent.getIntExtra(StandardProtocolKey.KEY_INT_VEHICLE_WEIGHT, 0);
        aa0.a("PowerInfoAction", "weight = {?}", Integer.valueOf(intExtra2));
        int intExtra3 = intent.getIntExtra(StandardProtocolKey.KEY_INT_LOW_ENERGY_ALERT, 0);
        aa0.a("PowerInfoAction", "lowEnerygyAlert = {?}", Integer.valueOf(intExtra3));
        int intExtra4 = intent.getIntExtra(StandardProtocolKey.KEY_INT_RANGE_DISTANCE, 0);
        aa0.a("PowerInfoAction", "rangeDistance = {?}", Integer.valueOf(intExtra4));
        int intExtra5 = intent.getIntExtra(StandardProtocolKey.KEY_INT_ENERGY_UNIT, 1);
        aa0.a("PowerInfoAction", "enerygyUnit = {?}", Integer.valueOf(intExtra5));
        int intExtra6 = intent.getIntExtra(StandardProtocolKey.KEY_INT_TOP_SPEED, 120);
        aa0.a("PowerInfoAction", "maxSpeed = {?}", Integer.valueOf(intExtra6));
        double[] doubleArrayExtra = intent.getDoubleArrayExtra(StandardProtocolKey.KEY_DOUBLE_ARRAY_SLOPE_COSTLIST);
        aa0.a("PowerInfoAction", "slopeCostList = {?}", Arrays.toString(doubleArrayExtra));
        double[] doubleArrayExtra2 = intent.getDoubleArrayExtra(StandardProtocolKey.KEY_DOUBLE_ARRAY_SPEED_COSTLIST);
        aa0.a("PowerInfoAction", "speedCostList = {?}", Arrays.toString(doubleArrayExtra2));
        double[] doubleArrayExtra3 = intent.getDoubleArrayExtra(StandardProtocolKey.KEY_DOUBLE_ARRAY_TRANS_COSTLIST);
        aa0.a("PowerInfoAction", "transCostList = {?}", Arrays.toString(doubleArrayExtra3));
        double[] doubleArrayExtra4 = intent.getDoubleArrayExtra(StandardProtocolKey.KEY_DOUBLE_ARRAY_CURVE_COSTLIST);
        aa0.a("PowerInfoAction", "curveCostList = {?}", Arrays.toString(doubleArrayExtra4));
        double doubleExtra3 = intent.getDoubleExtra(StandardProtocolKey.KEY_DOUBLE_AUX_COST, 0.0d);
        aa0.a("PowerInfoAction", "auxCost = {?}", Double.valueOf(doubleExtra3));
        double doubleExtra4 = intent.getDoubleExtra(StandardProtocolKey.KEY_DOUBLE_FERRYRATE_COST, 0.0d);
        aa0.a("PowerInfoAction", "ferryrateCost = {?}", Double.valueOf(doubleExtra4));
        double doubleExtra5 = intent.getDoubleExtra(StandardProtocolKey.KEY_DOUBLE_PERCENT_OF_RESIDUAL_ENERGY, 0.0d);
        aa0.a("PowerInfoAction", "percentOfResidualEnergy = {?}", Double.valueOf(doubleExtra5));
        this.k = new PowerInfoData(doubleExtra, intExtra3, intExtra4, booleanExtra, intExtra, intExtra5, intExtra6, intExtra2, doubleArrayExtra, doubleArrayExtra2, doubleArrayExtra3, doubleArrayExtra4, doubleExtra3, doubleExtra4, doubleExtra2, doubleExtra5);
        boolean booleanExtra2 = intent.getBooleanExtra(StandardProtocolKey.KEY_POWER_INFO_TEST, false);
        aa0.a("PowerInfoAction", "before powerInfoTest = {?}, powerInfoData = {?}", Boolean.valueOf(booleanExtra2), this.k.toString());
        if (booleanExtra2) {
            this.k.setPowertrainLoss(a(intent));
        } else {
            PowerInfoData l = jp.I().l();
            if (l != null) {
                this.k = l;
                aa0.a("PowerInfoAction", "override  ", new Object[0]);
            } else {
                aa0.a("PowerInfoAction", "powerInfoReadData is null", new Object[0]);
            }
        }
        aa0.a("PowerInfoAction", "after powerInfoTest = {?}, powerInfoData = {?}", Boolean.valueOf(booleanExtra2), this.k.toString());
        RspCarEnergyInfoModel rspCarEnergyInfoModel = new RspCarEnergyInfoModel();
        this.l = rspCarEnergyInfoModel;
        rspCarEnergyInfoModel.setInitialHvBattenergy(this.k.getBatteryEnergy());
        this.l.setIsCharge(this.k.isCharging());
        this.l.setCurDriveMode(this.k.getDriveMode());
        this.l.setMaxBattEnergy(this.k.getMaxBatteryEnergy());
        this.l.setVehicleWeight(this.k.getWeight());
        this.l.setLowEnergyAlert(this.k.getLowEnergyAlert());
        this.l.setRangeDist(this.k.getReachableDistance());
        this.l.setEnergyUnit(this.k.getEnergyUnit());
        this.l.setTopSpeed(this.k.getTopSpeed());
        this.l.setSlopeCostlist(a(this.k.getCurveCostList()));
        this.l.setSpeedCostlist(a(this.k.getSpeedCostList()));
        this.l.setTransCostlist(a(this.k.getTransCostList()));
        this.l.setCurveCostlist(a(this.k.getCurveCostList()));
        this.l.setAuxCost(this.k.getAuxCost());
        this.l.setFerryrateCost(this.k.getFerryrateCost());
        this.l.setPercentOfResidualEnergy(this.k.getPercentOfResidualEnergy());
        if (this.k.getPowertrainLoss() != null) {
            ArrayList<PowertrainLossInfo> arrayList = new ArrayList<>();
            for (PowertrainLoss powertrainLoss : this.k.getPowertrainLoss()) {
                arrayList.add(new PowertrainLossInfo(powertrainLoss.getPowerdemand(), powertrainLoss.getCostValue()));
            }
            this.l.setPowertrainLoss(arrayList);
        }
        aa0.a("PowerInfoAction", "PowerInfoAction() powertrainLoss:{?}", this.k.getPowertrainLoss());
    }

    public final List<PowertrainLoss> a(Intent intent) {
        String stringExtra = intent.getStringExtra(StandardProtocolKey.KEY_POWERTRAIN_LOSS);
        aa0.a("PowerInfoAction", "decodePowertrainLossString() strList:{?}", stringExtra);
        if (TextUtils.isEmpty(stringExtra)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (String str : stringExtra.split(";")) {
            aa0.a("PowerInfoAction", "decodePowertrainLossString() strItem:{?}", str);
            if (!TextUtils.isEmpty(str)) {
                String[] split = str.split(",");
                if (split.length == 2) {
                    PowertrainLoss powertrainLoss = new PowertrainLoss();
                    powertrainLoss.setPowerdemand(Float.valueOf(split[0]).floatValue());
                    powertrainLoss.setCostValue(Float.valueOf(split[1]).floatValue());
                    arrayList.add(powertrainLoss);
                }
            }
        }
        aa0.a("PowerInfoAction", "decodePowertrainLossString() list.size():{?}", Integer.valueOf(arrayList.size()));
        return arrayList;
    }
}
