package defpackage;

import android.graphics.SurfaceTexture;
import android.media.Image;
import android.os.Build;
import android.util.Log;
import com.autonavi.amapauto.alink.AlinkClientManager;
import com.autonavi.amapauto.alink.EmptyAlientClientImpl;
import com.autonavi.amapauto.alink.IAlinkAVListener;
import com.autonavi.amapauto.alink.IAlinkClient;
import com.autonavi.amapauto.ar.camera.ArCameraParam;
import com.autonavi.amapauto.ar.camera.model.ImageChannel;
import com.autonavi.amapauto.ar.camera.model.ImageInfo;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

/* compiled from: AlinkCamera.java */
/* loaded from: classes.dex */
public class ze extends ye {
    public ArCameraParam a;
    public LinkedList<ImageInfo> b = new LinkedList<>();
    public Object c = new Object();
    public boolean d = false;
    public AtomicInteger e = new AtomicInteger();
    public IAlinkAVListener f = new a();

    /* compiled from: AlinkCamera.java */
    /* loaded from: classes.dex */
    public class a implements IAlinkAVListener {
        public a() {
        }

        @Override // com.autonavi.amapauto.alink.IAlinkAVListener
        public int notifyCameraState(int i) {
            aa0.a("AlinkCamera", "notifyCameraState：{?}", Integer.valueOf(i));
            if (i == 0) {
                ze.this.d = true;
            } else if (i == 1) {
                ze.this.h();
                ze.this.d = false;
            }
            return 0;
        }

        @Override // com.autonavi.amapauto.alink.IAlinkAVListener
        public int onAVDataReceived(Image image) {
            aa0.a("AlinkCamera", "decoderHandler onAVDataReceived", new Object[0]);
            synchronized (ze.this.c) {
                if (ze.this.b.size() >= 2) {
                }
                aa0.a("AlinkCamera", "onAVDataReceived image= " + image, new Object[0]);
                if (image != null && Build.VERSION.SDK_INT >= 19) {
                    ImageInfo imageInfo = new ImageInfo();
                    imageInfo.format = image.getFormat();
                    imageInfo.width = image.getWidth();
                    imageInfo.height = image.getHeight();
                    imageInfo.timestamp = System.currentTimeMillis();
                    aa0.a("AlinkCamera", "format:" + imageInfo.format + ", width:" + imageInfo.width + ", height:" + imageInfo.height + ",timestamp:" + imageInfo.timestamp, new Object[0]);
                    Image.Plane[] planes = image.getPlanes();
                    if (planes == null) {
                        image.close();
                        aa0.a("AlinkCamera", "planes is null!", new Object[0]);
                        return 0;
                    }
                    aa0.a("AlinkCamera", "readImage: planes count= " + planes.length, new Object[0]);
                    for (Image.Plane plane : planes) {
                        ImageChannel imageChannel = new ImageChannel();
                        ByteBuffer buffer = plane.getBuffer();
                        if (buffer.hasArray()) {
                            imageChannel.data = buffer.array();
                        } else {
                            byte[] bArr = new byte[buffer.remaining()];
                            imageChannel.data = bArr;
                            buffer.get(bArr);
                        }
                        imageChannel.rowStride = plane.getRowStride();
                        imageChannel.pixelStride = plane.getPixelStride();
                        imageChannel.dataSize = imageChannel.data.length;
                        imageInfo.data.add(imageChannel);
                    }
                    image.close();
                    ze.this.b.add(imageInfo);
                }
                return 0;
            }
        }
    }

    @Override // defpackage.ef
    public boolean closeCamera() {
        IAlinkClient alinkClient = AlinkClientManager.getInstance().getAlinkClient();
        aa0.a("AlinkCamera", "closeCamera. alinkClient:{?} ", alinkClient);
        AlinkClientManager.getInstance().registerVideoListener(null);
        alinkClient.closeCamera();
        h();
        this.d = false;
        return true;
    }

    @Override // defpackage.ef
    public boolean d() {
        return true;
    }

    @Override // defpackage.ef
    public ImageInfo e() {
        ImageInfo imageInfo;
        synchronized (this.c) {
            imageInfo = null;
            try {
                if (this.b.size() >= 1) {
                    imageInfo = this.b.removeFirst();
                }
            } catch (Exception e) {
                aa0.a("AlinkCamera", "exception:", e, new Object[0]);
            }
        }
        aa0.a("AlinkCamera", "requestCameraData ,isCameraOpen:{?}, image ={?}", Boolean.valueOf(this.d), imageInfo);
        return imageInfo;
    }

    public final void h() {
        try {
            synchronized (this.c) {
                this.b.size();
                this.b.clear();
            }
            aa0.a("AlinkCamera", "closeCamera end!", new Object[0]);
        } catch (Exception e) {
            aa0.a("AlinkCamera", "closeCamera: stack = " + Log.getStackTraceString(e), new Object[0]);
        }
    }

    @Override // defpackage.ef
    public boolean b(int i) {
        aa0.a("AlinkCamera", "openCamera isCameraOpen:{?},id:{?}", Boolean.valueOf(this.d), Integer.valueOf(i));
        if (this.d) {
            return true;
        }
        AlinkClientManager.getInstance().registerVideoListener(this.f);
        IAlinkClient alinkClient = AlinkClientManager.getInstance().getAlinkClient();
        if (alinkClient instanceof EmptyAlientClientImpl) {
            return false;
        }
        ArCameraParam arCameraParam = this.a;
        alinkClient.openCamera(i, arCameraParam.width, arCameraParam.height);
        return true;
    }

    @Override // defpackage.ef
    public boolean c() {
        aa0.a("AlinkCamera", "isCameraOpened:{?}", Boolean.valueOf(this.d));
        return this.d;
    }

    @Override // defpackage.ef
    public boolean a(ArCameraParam arCameraParam) {
        this.a = arCameraParam;
        aa0.a("AlinkCamera", "initCamera:{?}", arCameraParam);
        AlinkClientManager.getInstance().getAlinkClient().initCameraParam(arCameraParam.width, arCameraParam.height);
        AlinkClientManager.getInstance().registerVideoListener(this.f);
        return true;
    }

    @Override // defpackage.ye, defpackage.ef
    public void a(SurfaceTexture surfaceTexture) {
        super.a(surfaceTexture);
    }

    @Override // defpackage.ye, defpackage.ef
    public void a(int i) {
        this.e.set(i);
    }
}
