package defpackage;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

/* compiled from: DiskLruCache.java */
/* loaded from: classes.dex */
public final class zj0 implements Closeable {
    public static final Pattern r = Pattern.compile("[a-z0-9_-]{1,64}");
    public static final OutputStream s = new b();
    public final File a;
    public final File c;
    public final File d;
    public final File e;
    public final int f;
    public long g;
    public int h;
    public final int i;
    public Writer l;
    public int n;
    public long j = 0;
    public int k = 0;
    public final LinkedHashMap<String, d> m = new LinkedHashMap<>(0, 0.75f, true);
    public long o = 0;
    public final ThreadPoolExecutor p = new ThreadPoolExecutor(0, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue());
    public final Callable<Void> q = new a();

    /* compiled from: DiskLruCache.java */
    /* loaded from: classes.dex */
    public class a implements Callable<Void> {
        public a() {
        }

        @Override // java.util.concurrent.Callable
        public Void call() throws Exception {
            synchronized (zj0.this) {
                if (zj0.this.l == null) {
                    return null;
                }
                zj0.this.j();
                zj0.this.i();
                if (zj0.this.e()) {
                    zj0.this.h();
                    zj0.this.n = 0;
                }
                return null;
            }
        }
    }

    /* compiled from: DiskLruCache.java */
    /* loaded from: classes.dex */
    public static class b extends OutputStream {
        @Override // java.io.OutputStream
        public void write(int i) throws IOException {
        }
    }

    /* compiled from: DiskLruCache.java */
    /* loaded from: classes.dex */
    public final class c {
        public final d a;
        public final boolean[] b;
        public boolean c;

        /* compiled from: DiskLruCache.java */
        /* loaded from: classes.dex */
        public class a extends FilterOutputStream {
            public /* synthetic */ a(c cVar, OutputStream outputStream, a aVar) {
                this(outputStream);
            }

            @Override // java.io.FilterOutputStream, java.io.OutputStream, java.io.Closeable, java.lang.AutoCloseable
            public void close() {
                try {
                    ((FilterOutputStream) this).out.close();
                } catch (IOException unused) {
                    c.this.c = true;
                }
            }

            @Override // java.io.FilterOutputStream, java.io.OutputStream, java.io.Flushable
            public void flush() {
                try {
                    ((FilterOutputStream) this).out.flush();
                } catch (IOException unused) {
                    c.this.c = true;
                }
            }

            @Override // java.io.FilterOutputStream, java.io.OutputStream
            public void write(int i) {
                try {
                    ((FilterOutputStream) this).out.write(i);
                } catch (IOException unused) {
                    c.this.c = true;
                }
            }

            public a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override // java.io.FilterOutputStream, java.io.OutputStream
            public void write(byte[] bArr, int i, int i2) {
                try {
                    ((FilterOutputStream) this).out.write(bArr, i, i2);
                } catch (IOException unused) {
                    c.this.c = true;
                }
            }
        }

        public /* synthetic */ c(zj0 zj0Var, d dVar, a aVar) {
            this(dVar);
        }

        public c(d dVar) {
            this.a = dVar;
            this.b = dVar.c ? null : new boolean[zj0.this.i];
        }

        public void b() throws IOException {
            if (this.c) {
                zj0.this.a(this, false);
                zj0.this.c(this.a.a);
            } else {
                zj0.this.a(this, true);
            }
        }

        public OutputStream a(int i) throws IOException {
            FileOutputStream fileOutputStream;
            a aVar;
            synchronized (zj0.this) {
                if (this.a.d == this) {
                    if (!this.a.c) {
                        this.b[i] = true;
                    }
                    File b = this.a.b(i);
                    try {
                        fileOutputStream = new FileOutputStream(b);
                    } catch (FileNotFoundException unused) {
                        zj0.this.a.mkdirs();
                        try {
                            fileOutputStream = new FileOutputStream(b);
                        } catch (FileNotFoundException unused2) {
                            return zj0.s;
                        }
                    }
                    aVar = new a(this, fileOutputStream, null);
                } else {
                    throw new IllegalStateException();
                }
            }
            return aVar;
        }

        public void a() throws IOException {
            zj0.this.a(this, false);
        }
    }

    /* compiled from: DiskLruCache.java */
    /* loaded from: classes.dex */
    public final class d {
        public final String a;
        public final long[] b;
        public boolean c;
        public c d;
        public long e;

        public /* synthetic */ d(zj0 zj0Var, String str, a aVar) {
            this(str);
        }

        public d(String str) {
            this.a = str;
            this.b = new long[zj0.this.i];
        }

        public final void b(String[] strArr) throws IOException {
            if (strArr.length == zj0.this.i) {
                for (int i = 0; i < strArr.length; i++) {
                    try {
                        this.b[i] = Long.parseLong(strArr[i]);
                    } catch (NumberFormatException unused) {
                        a(strArr);
                        throw null;
                    }
                }
                return;
            }
            a(strArr);
            throw null;
        }

        public String a() throws IOException {
            StringBuilder sb = new StringBuilder();
            for (long j : this.b) {
                sb.append(' ');
                sb.append(j);
            }
            return sb.toString();
        }

        public File b(int i) {
            return new File(zj0.this.a, this.a + "" + i + ".tmp");
        }

        public final IOException a(String[] strArr) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(strArr));
        }

        public File a(int i) {
            return new File(zj0.this.a, this.a + "" + i);
        }
    }

    public zj0(File file, int i, int i2, long j, int i3) {
        this.a = file;
        this.f = i;
        this.c = new File(file, "journal");
        this.d = new File(file, "journal.tmp");
        this.e = new File(file, "journal.bkp");
        this.i = i2;
        this.g = j;
        this.h = i3;
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public synchronized void close() throws IOException {
        if (this.l == null) {
            return;
        }
        Iterator it = new ArrayList(this.m.values()).iterator();
        while (it.hasNext()) {
            d dVar = (d) it.next();
            if (dVar.d != null) {
                dVar.d.a();
            }
        }
        j();
        i();
        this.l.close();
        this.l = null;
    }

    public final synchronized void h() throws IOException {
        if (this.l != null) {
            this.l.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.d), bk0.a));
        try {
            bufferedWriter.write("libcore.io.DiskLruCache");
            bufferedWriter.write("\n");
            bufferedWriter.write("1");
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.f));
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.i));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (d dVar : this.m.values()) {
                if (dVar.d != null) {
                    bufferedWriter.write("DIRTY " + dVar.a + '\n');
                } else {
                    bufferedWriter.write("CLEAN " + dVar.a + dVar.a() + '\n');
                }
            }
            bufferedWriter.close();
            if (this.c.exists()) {
                a(this.c, this.e, true);
            }
            a(this.d, this.c, false);
            this.e.delete();
            this.l = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.c, true), bk0.a));
        } catch (Throwable th) {
            bufferedWriter.close();
            throw th;
        }
    }

    public final void i() throws IOException {
        while (this.k > this.h) {
            c(this.m.entrySet().iterator().next().getKey());
        }
    }

    public final void j() throws IOException {
        while (this.j > this.g) {
            c(this.m.entrySet().iterator().next().getKey());
        }
    }

    public final void b(String str) throws IOException {
        String substring;
        int indexOf = str.indexOf(32);
        if (indexOf != -1) {
            int i = indexOf + 1;
            int indexOf2 = str.indexOf(32, i);
            if (indexOf2 == -1) {
                substring = str.substring(i);
                if (indexOf == 6 && str.startsWith("REMOVE")) {
                    this.m.remove(substring);
                    return;
                }
            } else {
                substring = str.substring(i, indexOf2);
            }
            d dVar = this.m.get(substring);
            a aVar = null;
            if (dVar == null) {
                dVar = new d(this, substring, aVar);
                this.m.put(substring, dVar);
            }
            if (indexOf2 != -1 && indexOf == 5 && str.startsWith("CLEAN")) {
                String[] split = str.substring(indexOf2 + 1).split(" ");
                dVar.c = true;
                dVar.d = null;
                dVar.b(split);
                return;
            }
            if (indexOf2 == -1 && indexOf == 5 && str.startsWith("DIRTY")) {
                dVar.d = new c(this, dVar, aVar);
                return;
            }
            if (indexOf2 == -1 && indexOf == 4 && str.startsWith("READ")) {
                return;
            }
            throw new IOException("unexpected journal line: " + str);
        }
        throw new IOException("unexpected journal line: " + str);
    }

    public synchronized long c() {
        return this.k;
    }

    public synchronized void d() throws IOException {
        a();
        j();
        i();
        this.l.flush();
    }

    public final boolean e() {
        int i = this.n;
        return i >= 2000 && i >= this.m.size();
    }

    public final void f() throws IOException {
        a(this.d);
        Iterator<d> it = this.m.values().iterator();
        while (it.hasNext()) {
            d next = it.next();
            int i = 0;
            if (next.d != null) {
                next.d = null;
                while (i < this.i) {
                    a(next.a(i));
                    a(next.b(i));
                    i++;
                }
                it.remove();
            } else {
                while (i < this.i) {
                    this.j += next.b[i];
                    this.k++;
                    i++;
                }
            }
        }
    }

    public final void g() throws IOException {
        ak0 ak0Var = new ak0(new FileInputStream(this.c), bk0.a);
        try {
            String b2 = ak0Var.b();
            String b3 = ak0Var.b();
            String b4 = ak0Var.b();
            String b5 = ak0Var.b();
            String b6 = ak0Var.b();
            if (!"libcore.io.DiskLruCache".equals(b2) || !"1".equals(b3) || !Integer.toString(this.f).equals(b4) || !Integer.toString(this.i).equals(b5) || !"".equals(b6)) {
                throw new IOException("unexpected journal header: [" + b2 + ", " + b3 + ", " + b5 + ", " + b6 + "]");
            }
            int i = 0;
            while (true) {
                try {
                    b(ak0Var.b());
                    i++;
                } catch (EOFException unused) {
                    this.n = i - this.m.size();
                    bk0.a(ak0Var);
                    return;
                }
            }
        } catch (Throwable th) {
            bk0.a(ak0Var);
            throw th;
        }
    }

    public synchronized boolean c(String str) throws IOException {
        a();
        d(str);
        d dVar = this.m.get(str);
        if (dVar != null && dVar.d == null) {
            for (int i = 0; i < this.i; i++) {
                File a2 = dVar.a(i);
                if (a2.exists() && !a2.delete()) {
                    throw new IOException("failed to delete " + a2);
                }
                this.j -= dVar.b[i];
                this.k--;
                dVar.b[i] = 0;
            }
            this.n++;
            this.l.append((CharSequence) ("REMOVE " + str + '\n'));
            this.m.remove(str);
            if (e()) {
                this.p.submit(this.q);
            }
            return true;
        }
        return false;
    }

    public static zj0 a(File file, int i, int i2, long j, int i3) throws IOException {
        if (j <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (i3 <= 0) {
            throw new IllegalArgumentException("maxFileCount <= 0");
        }
        if (i2 > 0) {
            File file2 = new File(file, "journal.bkp");
            if (file2.exists()) {
                File file3 = new File(file, "journal");
                if (file3.exists()) {
                    file2.delete();
                } else {
                    a(file2, file3, false);
                }
            }
            zj0 zj0Var = new zj0(file, i, i2, j, i3);
            if (zj0Var.c.exists()) {
                try {
                    zj0Var.g();
                    zj0Var.f();
                    zj0Var.l = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(zj0Var.c, true), bk0.a));
                    return zj0Var;
                } catch (IOException e) {
                    System.out.println("DiskLruCache " + file + " is corrupt: " + e.getMessage() + ", removing");
                    zj0Var.b();
                }
            }
            file.mkdirs();
            zj0 zj0Var2 = new zj0(file, i, i2, j, i3);
            zj0Var2.h();
            return zj0Var2;
        }
        throw new IllegalArgumentException("valueCount <= 0");
    }

    public final void d(String str) {
        if (r.matcher(str).matches()) {
            return;
        }
        throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + str + "\"");
    }

    public void b() throws IOException {
        close();
        bk0.a(this.a);
    }

    public static void a(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public static void a(File file, File file2, boolean z) throws IOException {
        if (z) {
            a(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    public c a(String str) throws IOException {
        return a(str, -1L);
    }

    public final synchronized c a(String str, long j) throws IOException {
        a();
        d(str);
        d dVar = this.m.get(str);
        a aVar = null;
        if (j != -1 && (dVar == null || dVar.e != j)) {
            return null;
        }
        if (dVar != null) {
            if (dVar.d != null) {
                return null;
            }
        } else {
            dVar = new d(this, str, aVar);
            this.m.put(str, dVar);
        }
        c cVar = new c(this, dVar, aVar);
        dVar.d = cVar;
        this.l.write("DIRTY " + str + '\n');
        this.l.flush();
        return cVar;
    }

    public final synchronized void a(c cVar, boolean z) throws IOException {
        d dVar = cVar.a;
        if (dVar.d == cVar) {
            if (z && !dVar.c) {
                for (int i = 0; i < this.i; i++) {
                    if (cVar.b[i]) {
                        if (!dVar.b(i).exists()) {
                            cVar.a();
                            return;
                        }
                    } else {
                        cVar.a();
                        throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                    }
                }
            }
            for (int i2 = 0; i2 < this.i; i2++) {
                File b2 = dVar.b(i2);
                if (z) {
                    if (b2.exists()) {
                        File a2 = dVar.a(i2);
                        b2.renameTo(a2);
                        long j = dVar.b[i2];
                        long length = a2.length();
                        dVar.b[i2] = length;
                        this.j = (this.j - j) + length;
                        this.k++;
                    }
                } else {
                    a(b2);
                }
            }
            this.n++;
            dVar.d = null;
            if (!(dVar.c | z)) {
                this.m.remove(dVar.a);
                this.l.write("REMOVE " + dVar.a + '\n');
            } else {
                dVar.c = true;
                this.l.write("CLEAN " + dVar.a + dVar.a() + '\n');
                if (z) {
                    long j2 = this.o;
                    this.o = 1 + j2;
                    dVar.e = j2;
                }
            }
            this.l.flush();
            if (this.j > this.g || this.k > this.h || e()) {
                this.p.submit(this.q);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public final void a() {
        if (this.l == null) {
            throw new IllegalStateException("cache is closed");
        }
    }
}
