
from evaluation import evaluation_function
import numpy as np

import json
from os.path import abspath, join
import pandas as pd
def load_json(path):
    return json.load(open(path, encoding='utf-8'))


def save_json(path, data):
    with open(path, 'w', encoding='utf-8') as out:
        json.dump(data, out, ensure_ascii=False, indent=4)


def load_solution(path):
    # Loads a solution from a json file to 2 pandas DataFrames.
    solution = load_json(path)
    fleet = pd.DataFrame(solution['fleet'])
    pricing_strategy = pd.DataFrame(solution['pricing_strategy'])
    return fleet, pricing_strategy
def known_seeds():
    #随机生成50个种子
    return [2381, 5351, 6047, 6829, 9221, 9859, 8053, 1097, 8677, 2521]

def load_problem_data(path=None):
    if path is None:
        path = './data/'

    # LOAD DEMAND
    p = abspath(join(path, 'demand.csv'))
    demand = pd.read_csv(p)    
    
    # LOAD DATACENTERS DATA
    p = abspath(join(path, 'datacenters.csv'))
    datacenters = pd.read_csv(p)
    
    # LOAD SERVERS DATA
    p = abspath(join(path, 'servers.csv'))
    servers = pd.read_csv(p)
    
    # LOAD SELLING PRICES DATA
    p = abspath(join(path, 'selling_prices.csv'))
    selling_prices = pd.read_csv(p)

    # LOAD ELASTICITY DATA
    p = abspath(join(path, 'price_elasticity_of_demand.csv'))
    elasticity = pd.read_csv(p)
    return demand, datacenters, servers, selling_prices, elasticity

seeds=known_seeds()

for seed in seeds:

    # SET THE RANDOM SEED
    np.random.seed(seed)


    # CALL YOUR APPROACH HERE
    fleet, pricing_strategy = load_solution(f'./output/{seed}.json')


# LOAD PROBLEM DATA
    demand, datacenters, servers, selling_prices, elasticity = load_problem_data()

# EVALUATE THE SOLUTION
    score = evaluation_function(fleet, 
                            pricing_strategy,
                            demand,
                            datacenters,
                            servers,
                            selling_prices,
                            elasticity,
                            seed=123)

    print(f'Solution score: {score}')



